<?php

namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoAtividades as RepoAtividades;
use Illuminate\Http\Response;
use Illuminate\Http\Request;

class AtividadesController extends Natureza51Ctrl{
    public function __construct()
    {
        $this->setCodTela('ATV');
        $this->repository=new RepoAtividades();
        parent::__construct(); 


        
    } 

       
    public function listarExportar(){
        $this->podeAcessar('listar',true,$this->getCodTela());

        

        $dados = [];
        // $data = $this->getRepositoryOrModel()->all()-toArray();
        $data = $this->getRepository()->getModelEntity()->select()->get()->toArray();
        foreach ($data as $record) {
            $record['ajusta_data_texto'] = $record['ajusta_data'] == 1 ? 'Sim' : 'Não';
            $record['created_by_nome'] = $record['created_by'] != null ? $this->getNomeByUsuario($record['created_by']): ' - ';
            $record['updated_by_nome'] = $record['updated_by'] != null ? $this->getNomeByUsuario($record['updated_by']): ' - ';
            $record['description_created_at'] = $record['created_at'] != null ? $this->formataData($record, 'created_at') : '-';
            $record['description_updated_at'] = $record['updated_at'] != null ? $this->formataData($record, 'updated_at') : '-';

            array_push($dados, $record);
        }

       return new Response(json_encode($dados), 200);
    }
    // public function listarExportar(){
    //     $resp = $this->getRepository()->getModelEntity()->select()->get()->toArray();
    //     // dd("resp", $resp);
    //     return $resp;
    // }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Atividades', ['id', 'created_at', 'created_by', 'updated_at', 'updated_by', 'empresa_id', 'ajusta_data']);
    }


    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("title", "Título", $colunas[$i]);
            $colunas[$i] = str_replace("description", "Descrição", $colunas[$i]);
            $colunas[$i] = str_replace("ajusta data texto", "Ajusta data?", $colunas[$i]);
            $colunas[$i] = str_replace("created by nome", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("Descrição created at", "Criado em", $colunas[$i]);
            $colunas[$i] = str_replace("updated by nome", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("Descrição updated at", "Atualizado em", $colunas[$i]);

        }
        return $colunas;
    }

    public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }   
  
}