<?php
 
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoBeneficio as RepoBeneficio;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

 
class BeneficioController extends Natureza51Ctrl
{
    public function __construct(){
        $this->setCodTela('BEN');
        $this->repository=new RepoBeneficio();
        parent::__construct(); 
    }
         
    public function listar(){
        // $bf = new BeneficioLotacaoCargoController();
        // dd($bf->listarToCadAutc(33));
    
        $decrypted = json_decode(safeDecrypt(request()->bearerToken()),true);
 
        $dados = $this->getRepository()->listarAll();
 
        // for($i = 0; $i < count($dados); $i++){
            //unset($dados[$i]['formula']);
        // }
        // return $dados;
        $retorno = [];

        foreach ($dados as $dt) {
            $dt['empresa_id'] = $decrypted['token']['empresa_id'];
            $dt['des_exclusivo_admissao'] = $dt['exclusivo_admissao'] == 1 ? 'Sim' : 'Não';
            $dt['created_by_nome'] = $dt['created_by'] != null ? $this->getNomeByUsuario($dt['created_by']): ' - ';
            $dt['updated_by_nome'] = $dt['updated_by'] != null ? $this->getNomeByUsuario($dt['updated_by']): ' - ';
            $dt['description_created_at'] = $dt['created_at'] != null ? $this->formataData($dt, 'created_at') : '-';
            $dt['description_updated_at'] = $dt['updated_at'] != null ? $this->formataData($dt, 'updated_at') : '-';
            array_push($retorno, $dt);

            }
            // dd("data", $dados);

            return new Response(json_encode($retorno) , 200);
    }
 
    public function listarTipo(){
        return $this->getRepository()->listarBeneficio();
    }
    public function inserir(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $dados = $request->all();
        
        $retorno = $this->getArrayRetornoDefault();
 
        $resp = $this->getRepository()->inserir($dados);
 
        if(!$resp){
            $retorno['status']='error';
            $retorno['submsg']='Erro';
            $retorno['msg']= $this->getRepository()->getErrosFlatted();
            goto saida;
        }
        $retorno['status']='success';
        $retorno['msg']='Registro inserido com sucesso!';
        $retorno['submsg']='Sucesso';
 
        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function delete(Request $request){
        $this->podeAcessar('deletar',true,$this->getCodTela());
        $dados = $request->all();
        
        $retorno=$this->getArrayRetornoDefault();
 
        $resp = $this->getRepository()->deletar($dados);
 
        if(!$resp){
            $retorno['status']='error';
            $retorno['submsg']='Erro';
            $retorno['msg']= $this->getRepository()->getErrosFlatted();
            goto saida;
        }
        $retorno['status']='success';
        $retorno['msg']='Registro deletado com sucesso!';
        $retorno['submsg']='Sucesso';
 
        saida:
        return $this->retornoJsonDefault($retorno);
   }
   
 
    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'Benefícios', ['formula','description','natureza_evento_id','desc_cta_ctbl', 'cod_cta_ctbl', 'des_event', 'inc_liquido', 'cdn_event', 'ativo', 'evento_id', 'cta_ct_id', 'tipo_calc','tipo_acesso', 'exclusivo_admissao', 'origem_beneficio', 'valor_deducao', 'multiplica', 'des_origem_beneficio','valor deducao']);
    }
    
    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("description natureza", "Natureza", $colunas[$i]); 
            $colunas[$i] = str_replace("description evento", "Evento", $colunas[$i]);
            $colunas[$i] = str_replace("vlr movto", "Valor movimento", $colunas[$i]);
            $colunas[$i] = str_replace("vlr maximo", "Valor máximo", $colunas[$i]);
            $colunas[$i] = str_replace("valor deducao", "Valor dedução", $colunas[$i]);


            $colunas[$i] = str_replace("salario corte", "Salário de corte", $colunas[$i]);
            $colunas[$i] = str_replace("grade maximo", "GS máximo", $colunas[$i]);
            $colunas[$i] = str_replace("des tipo calc", "Tipo cálculo", $colunas[$i]);
            $colunas[$i] = str_replace("des tipo acesso", "Tipo acesso", $colunas[$i]);
            $colunas[$i] = str_replace("des ativo", "Ativo", $colunas[$i]);
            $colunas[$i] = str_replace("description cta", "Conta contábil", $colunas[$i]);
            $colunas[$i] = str_replace("des exclusivo admissao", "Exclusivo admissão", $colunas[$i]);
            $colunas[$i] = str_replace("created by nome", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("description created at", "Criado em", $colunas[$i]);
            $colunas[$i] = str_replace("updated by nome", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("description updated at", "Atualizado em", $colunas[$i]);

        }
        return $colunas;
    }

    
    public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }
}