<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoCadastroParametros as RepoCadastroParametros;
use App\Modules\Natureza51\Entities\CadastroParametros;
use Illuminate\Http\Request;
use DB;
use Excel;

class CadastroParametrosController extends Natureza51Ctrl
{ 


    public function __construct(){
        $this->repository=new RepoCadastroParametros();
        $this->setCodTela('PRM');
        parent::__construct();
    }
    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        // dd("aqui",$this->getRepository()->listarParametros() );
        return $this->getRepository()->listarParametros();
    }

    public function insert(Request $request){
        $this->podeAcessar('inserir', true, $this->getCodTela());
        
        $retorno = $this->getArrayRetornoDefault();
        $form_data = $request->all();
        $form_data['user_id'] = $this->obtIdUsuario();
        
        if(! $this->getRepositoryOrModel()->create($form_data)){
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg'] = 'Falha ao inserir o registro. Erro: 101220201606';
            goto saida;
        }
        $retorno['msg'] = 'Registro inserido com sucesso!';
        $retorno['submsg'] = 'Sucesso';
        $retorno['status'] = 'success';
        
        saida:
        return $this->retornoJsonDefault($retorno); 
    }
    public function getAllGroupByTipos(){
        $tipos = DB::table('tblg_param_tipo')->select('*')->get();
        $retorno = [];
        for ($i = 0; $i<count($tipos);$i++) {
            $retorno[$i]['tipo'] = $tipos[$i]->tipo;
            $retorno[$i]['parametros'] = $this->getRepository()->listarParametrosbyTipo($tipos[$i]->id);
        }
        return $retorno;

    }


    public function getTiposDados(){
       return DB::table('tblg_param_tipo_dados')->select('*')->get();

    }
    public function getTiposParametros(){
        return DB::table('tblg_param_tipo')->select('*')->get();

    }

    public function salvarParametros(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $retorno=$this->getArrayRetornoDefault();
        $form_data = $request->all();

        
        if(!$this->getRepository()->salvarParametros($form_data)){
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            $retorno['subsmg']='Falha ao inserir o registro. Erro: 270320201707';
            goto saida;
        }  

        
        $retorno["status"]="success";
        $retorno["msg"]="Configurações salvas com sucesso!";

        saida:
         return $this->retornoJsonDefault($retorno);
    }

    public function downloadExcelAux($type)
    {
        $this->podeAcessar('exportar',true,$this->getCodTela());
        $filename="Parametros";
        $array = json_decode($_POST['array_imprimir']);    

        for ($i=0; $i < count($array) ; $i++) { 
            
            //geral
            unset($array[$i]->id);
            unset($array[$i]->empresa_id);
            unset($array[$i]->usuario_dominio);
            unset($array[$i]->numero_dias_senha);
            unset($array[$i]->api_token);
            
            //comum a todos os cadastros
            // unset($array[$i]->id);
            unset($array[$i]->tipo_parametro);
            unset($array[$i]->tipo_dados);
            // unset($array[$i]->id_filial);
            // unset($array[$i]->id_grupo_acesso);
            // unset($array[$i]->id_permissao);
            // unset($array[$i]->id_grupo_empresarial);
            unset($array[$i]->created_at);
            unset($array[$i]->updated_at);
            unset($array[$i]->user_id);
            unset($array[$i]->created_by);
            unset($array[$i]->updated_by);

            //funcionario
            unset($array[$i]->status);
            unset($array[$i]->funcionario_id);




        }
        $colunas = array_keys( (array) $array[0]);

        $colunas = $this->formatHeaders($colunas);
                
        if (! in_array($type, ['xls', 'csv','xlsx'])) {
            $type = 'xlsx';
        }
        $fn = $filename.'-'.date('Y-m-d_H-i-s');

        if(is_null($array))   
        $array =  (is_null($array)) ? [] : $array;


        $export = new ExportData($array, $colunas);

        $header_file=[  "Content-Type"=>"application/vnd.ms-excel; charset=utf-8",
                        "Content-Disposition"=>"attachment; filename=abc.xls",
                        "Expires"=>"0", 
                        "Cache-Control"=>"must-revalidate, post-check=0, pre-check=0",
                        "Cache-Control"=>"private"
                     ];

        return Excel::download($export, $fn.'.'.$type ,null, $header_file );
    }
}