<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoCargo as RepoCargo;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class CargoController extends Natureza51Ctrl
{
   public function __construct(){
        $this->repository=new RepoCargo();
        $this->setCodTela('CG');
        parent::__construct();
    } 
    public function listar(){ 
        $this->podeAcessar('listar',true,$this->getCodTela());

        // $calc = new RepoOrcScriptCalculos();
        // $resp = $calc->insertToOrcParamNatureza(115);
        // dd($resp);

        $data = $this->getRepository()->listarCargos();
        $data = array_map(function($element){
            $element['gs'] = substr($element['cod_cargo_basic'], 0, 2);
            return $element;
        }, $data);

        $dados = [];

        foreach ($data as $record) {
            $record['ativo_texto'] = $record['ativo'] == 1 ? 'Sim' : 'Não';
            $record['jovem_aprendiz_texto'] = $record['cota_jovem_aprendiz'] == 1 ? 'Sim' : 'Não';
            $record['pcd_texto'] = $record['cota_pcd'] == 1 ? 'Sim' : 'Não';

            $record['des_origem'] = $record['origem'] == 1 ? 'Sistema' : 'ERP';


            $record['created_by_nome'] = $record['created_by'] != null ? $this->getNomeByUsuario($record['created_by']): ' - ';
            $record['updated_by_nome'] = $record['updated_by'] != null ? $this->getNomeByUsuario($record['updated_by']): ' - ';
            $record['description_created_at'] = $record['created_at'] != null ? $this->formataData($record, 'created_at') : '-';
            $record['description_updated_at'] = $record['updated_at'] != null ? $this->formataData($record, 'updated_at') : '-';

            array_push($dados, $record);
        }



        // return $data;
        return new Response(json_encode($dados), 200);

        // return $this->getRepository()->listarCargos();
    }
    // public function update(Request $request){
    //     $this->podeAcessar('editar',true,$this->getCodTela());
    //     $array=$request->all();
    //     // dd("request", $array);
    //     $enviar=array(
    //         'salario_max'=>$array['salario_max'],
    //         'salario_min'=>$array['salario_min'],
    //         'step'=>$array['step'],
    //         'ponto'=>$array['ponto'],
    //         'nivel'=>$array['nivel'],
    //         'ativo'=>$array['ativo']
    //     );

    //     //'salario'=>$array['salario'],
    //     //$array_repo=array_merge($array,convertDecimalEn($enviar));
    //     return $this->getRepository()->update($array,$array['id']);//$array_repo
    // }
    

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'Cargos', ['origem','description', 'salario_medio','cod_cargo_erp','nome_cargo', 'data_salario', 'nivel','ponto',
                                                       'salario', 'salario_max', 'salario_min', 'cota_jovem_aprendiz', 'cota_pcd', 'ativo' ]);
    }

    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 


            $colunas[$i] = str_replace("ativo_texto", "Ativo", $colunas[$i]);

            $colunas[$i] = str_replace("_", " ", $colunas[$i]); 
            $colunas[$i] = str_replace("_format", "", $colunas[$i]);
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            // $colunas[$i] = str_replace("des cargo basic", "Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("cod cargo basic", "Código cargo", $colunas[$i]);
            $colunas[$i] = str_replace("des cargo basic", "Descrição cargo", $colunas[$i]);

            $colunas[$i] = str_replace("step", "Step", $colunas[$i]);

            $colunas[$i] = str_replace("ativo", "Ativo", $colunas[$i]);
            $colunas[$i] = str_replace("salario medio format", "Salário médio", $colunas[$i]);
            $colunas[$i] = str_replace("salario inicial format", "Salário inicial", $colunas[$i]);
            $colunas[$i] = str_replace("salario final format", "Salário final", $colunas[$i]);
            $colunas[$i] = str_replace("nivel format", "Nível", $colunas[$i]);
            $colunas[$i] = str_replace("ponto format", "Ponto", $colunas[$i]);
            $colunas[$i] = str_replace("data salario format", "Data Salário", $colunas[$i]);
            $colunas[$i] = str_replace("salario", "Salário", $colunas[$i]);
            $colunas[$i] = str_replace("gs", "GS", $colunas[$i]);
            $colunas[$i] = str_replace("created by nome", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("description created at", "Criado em", $colunas[$i]);
            $colunas[$i] = str_replace("updated by nome", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("description updated at", "Atualizado em", $colunas[$i]);
            $colunas[$i] = str_replace("jovem aprendiz texto", "Cota jovem aprendiz", $colunas[$i]);
            $colunas[$i] = str_replace("pcd texto", "Cota PCD", $colunas[$i]);
            $colunas[$i] = str_replace("des origem", "Origem", $colunas[$i]);


            // $colunas[$i] = str_replace("origem", "origem", $colunas[$i]);

        }
        return $colunas;


    }


    public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }   

} 
