<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Entities\EstruturaPlanoLotacao;
use App\Modules\Natureza51\Repositories\RepoCcustoLotacao as RepoCcustoLotacao;
use App\Modules\Natureza51\Repositories\RepoEstruturaPlanoLotac;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

use Excel;

class CcustoLotacaoController extends Natureza51Ctrl{
    public function __construct(){
        $this->setCodTela('CCL');
        $this->repository=new RepoCcustoLotacao();
        parent::__construct();
    }
    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());

        // $data = $this->getRepositoryOrModel()->all();
        $data =  $this->getRepository()->listar();


        $dados = [];

        foreach ($data as $dt) {

            $dt['created_by_nome'] = $dt['created_by'] != null ? $this->getNomeByUsuario($dt['created_by']): ' - ';
            $dt['updated_by_nome'] = $dt['updated_by'] != null ? $this->getNomeByUsuario($dt['updated_by']): ' - ';
            $dt['description_created_at'] = $dt['created_at'] != null ? $this->formataData($dt, 'created_at') : '-';
            $dt['description_updated_at'] = $dt['updated_at'] != null ? $this->formataData($dt, 'updated_at') : '-';
            array_push($dados, $dt);

            }
            // dd("data", $dados);

            return new Response(json_encode($dados), 200);

        // dd("aaaaaaaaaaaa",$this->getRepository()->listar());

        // return $this->getRepository()->listar();
        
    } 


        
    
    public function insert(Request $request){
        $all = $request->all();
        $retorno=$this->getArrayRetornoDefault();
        $resp = $this->getRepository()->inserirCcustoLotacao($all);

        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg'] = 'Erro';
            goto saida;
        }

        $retorno['status'] = 'success';
        $retorno['msg'] = 'Registro inserido com sucesso!';
        $retorno['submsg'] = 'Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function update(Request $request){
        $all = $request->all();
        $retorno=$this->getArrayRetornoDefault();
        $resp = $this->getRepository()->updateCcustoLotacao($all);

        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg'] = 'Erro';
            goto saida;
        }

        $retorno['status'] = 'success';
        $retorno['msg'] = 'Registro atualizado com sucesso!';
        $retorno['submsg'] = 'Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function listarEstruturaPlanoLotacao(){
        $tbl_estrutura = new EstruturaPlanoLotacao();
        $select = $tbl_estrutura->select()->get()->toArray();
        return $select;
    }

    // public function downloadExcelAux($type)
    // {
    //     $this->podeAcessar('exportar',true,$this->getCodTela());
    //     $filename="ccusto-lotacao";
    //     $array = json_decode($_POST['array_imprimir']);    
    // public function downloadExcelAux($type)
    // {
    //     $filename="ccusto-lotacao";
    //     $array = json_decode($_POST['array_imprimir']);    

    //     for ($i=0; $i < count($array) ; $i++) { 
            
    //         //geral
    //         unset($array[$i]->empresa_id);
    //         unset($array[$i]->grupo_empresarial_id);
    //         unset($array[$i]->usuario_dominio);
    //         unset($array[$i]->numero_dias_senha);
    //         unset($array[$i]->api_token);
    //         unset($array[$i]->created_at);
    //         unset($array[$i]->updated_at);
    //         unset($array[$i]->user_id);
    //         unset($array[$i]->created_by);
    //         unset($array[$i]->updated_by);
            
    //         //comum a todos os cadastros
    //         unset($array[$i]->id);

    //         //ccusto lotacao
    //         unset($array[$i]->lotacao_id);
    //         unset($array[$i]->ccusto_id);
         




    //     }
    //     $colunas = array_keys( (array) $array[0]);

    //     $colunas = $this->formatHeaders($colunas);
                
    //     if (! in_array($type, ['xls', 'csv','xlsx'])) {
    //         $type = 'xlsx';
    //     }
    //     $fn = $filename.'-'.date('Y-m-d_H-i-s');

    //     if(is_null($array))   
    //     $array =  (is_null($array)) ? [] : $array;


    //     $export = new ExportData($array, $colunas);

    //     $header_file=[  "Content-Type"=>"application/vnd.ms-excel; charset=utf-8",
    //                     "Content-Disposition"=>"attachment; filename=abc.xls",
    //                     "Expires"=>"0", 
    //                     "Cache-Control"=>"must-revalidate, post-check=0, pre-check=0",
    //                     "Cache-Control"=>"private"
    //                  ];

    //     return Excel::download($export, $fn.'.'.$type ,null, $header_file );
    // }
    


    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'CentroCustoLotacao', ['unid_lotac','estrutura_plano_lotacao_id','usuario_dominio','numero_dias_senha', 'api_token','created_at','updated_at','user_id','created_by','updated_by','id','lotacao_id','ccusto_id','grupo_empresarial_id']);
    }

    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 

            $colunas[$i] = str_replace("des_unid_lotac", "Descrição unidade lotação", $colunas[$i]);

            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("estrutura plano lotac id", "Estrutura plano lotação", $colunas[$i]);
            $colunas[$i] = str_replace("des ccusto", "Descrição centro de custo", $colunas[$i]);
            $colunas[$i] = str_replace("cod ccusto", "Código centro de custo", $colunas[$i]);

            // $colunas[$i] = str_replace("des ccusto", "Descrição centro de custo", $colunas[$i]);

            $colunas[$i] = str_replace("created by nome", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("description created at", "Criado em", $colunas[$i]);
            $colunas[$i] = str_replace("updated by nome", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("description updated at", "Atualizado em", $colunas[$i]);

            // $colunas[$i] = str_replace("origem", "origem", $colunas[$i]);

        }
        return $colunas;
    }

    public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }
}