<?php

namespace App\Modules\Natureza51\Http\Controllers;

use Illuminate\Http\Response;
use App\Modules\Natureza51\Repositories\RepoCentroCusto as RepoCentroCusto;

class CentroCustoController extends Natureza51Ctrl
{
    public function __construct(){ 
        $this->setCodTela('CC');
        $this->repository=new RepoCentroCusto();
        parent::__construct();
    }
 
    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        //return new Response(json_encode($this->getRepositoryOrModel()->allWith("getEmpresa")), 200);

       $data = $this->getRepositoryOrModel()->all();
        foreach ($data as $dt) {
            $dt['description'] = $dt['cod_ccusto']. ' - ' .$dt['des_ccusto'];
            $dt['created_by_nome'] = $dt['created_by'] != null ? $this->getNomeByUsuario($dt['created_by']): ' - ';
            $dt['updated_by_nome'] = $dt['updated_by'] != null ? $this->getNomeByUsuario($dt['updated_by']): ' - ';
            $dt['description_created_at'] = $dt['created_at'] != null ? $this->formataData($dt, 'created_at') : '-';
            $dt['description_updated_at'] = $dt['updated_at'] != null ? $this->formataData($dt, 'updated_at') : '-';
            $dt['dat_fim_valid_export'] = $dt['dat_fim_valid'] != null ? $this->formataData($dt, 'dat_fim_valid') : '-';
            $dt['dat_inic_valid_export'] = $dt['dat_inic_valid'] != null ? $this->formataData($dt, 'dat_inic_valid') : '-';
            }
             
            return new Response(json_encode($data) , 200);
        
    }    

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Centro Custo', ['origem','description','ativo', 'dat_inic_valid', 'dat_fim_valid']);
    }

    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("cod ccusto", "Código", $colunas[$i]);
            $colunas[$i] = str_replace("des ccusto", "Descrição", $colunas[$i]);
            $colunas[$i] = str_replace("des ativo", "Ativo", $colunas[$i]);
            // $colunas[$i] = str_replace("dat inic valid export", "data inicio validade", $colunas[$i]);
            // $colunas[$i] = str_replace("dat inic valid export", "data fim validade", $colunas[$i]);
            
            $colunas[$i] = str_replace("dat inic valid export", "Data início validade", $colunas[$i]);
            $colunas[$i] = str_replace("dat fim valid export", "Data fim validade", $colunas[$i]);
            $colunas[$i] = str_replace("created by nome", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("description created at", "Criado em", $colunas[$i]);
            $colunas[$i] = str_replace("updated by nome", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("description updated at", "Atualizado em", $colunas[$i]);
        }
        return $colunas;
    }

    public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }
    public function formataDataEua($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $ano.'/'.$meses.'/'.$dia;
        // $dataReturn = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }
}
