<?php

namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoContaContabil as RepoContaContabil;
use Illuminate\Http\Request;
use Illuminate\Http\Response;


class ContaContabilController extends Natureza51Ctrl
{ 
     public function __construct(){
        $this->setCodTela('CTACTB');
        $this->repository=new RepoContaContabil();
        parent::__construct();
    } 
    public function listaTest(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $retorno=[];

        
    //    $data = $this->getRepositoryOrModel()->all();
       
    //    foreach ($data as $dt) {
       
    //        $dt['created_by_nome'] = $dt['created_by'] != null ? $this->getNomeByUsuario($dt['created_by']): ' - ';
    //        $dt['updated_by_nome'] = $dt['updated_by'] != null ? $this->getNomeByUsuario($dt['updated_by']): ' - ';
    //        $dt['description_created_at'] = $dt['created_at'] != null ? $this->formataData($dt, 'created_at') : '-';
    //        $dt['description_updated_at'] = $dt['updated_at'] != null ? $this->formataData($dt, 'updated_at') : '-';
        
    //        }
            
           return new Response(json_encode($data) , 200);
        // return new Response(json_encode($retorno));
    }
    public function listar($cod_tela = null){
        // dd($cod_tela);
        if(!is_null($cod_tela)){
            $this->podeAcessar('listar',true,$cod_tela);
        }
            // dd('jfndskjfnjkdsf');            
       $data = $this->getRepositoryOrModel()->all();
        
       $dados = [];
       
       foreach ($data as $dt) {
            $dt['description'] = $dt['cod_cta_ctbl'].' - '.$dt['desc_cta_ctbl'];
           $dt['des_origem'] = $dt['origem'] == 1 ? 'Sistema' : 'ERP';
           $dt['created_by_nome'] = $dt['created_by'] != null ? $this->getNomeByUsuario($dt['created_by']): ' - ';
           $dt['updated_by_nome'] = $dt['updated_by'] != null ? $this->getNomeByUsuario($dt['updated_by']): ' - ';
           $dt['description_created_at'] = $dt['created_at'] != null ? $this->formataData($dt, 'created_at') : '-';
           $dt['description_updated_at'] = $dt['updated_at'] != null ? $this->formataData($dt, 'updated_at') : '-';
           array_push($dados, $dt);

        }
        return new Response(json_encode($dados) , 200);
        // return $this->getRepository()->listarAll();
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Conta contabil', ['estrutura_plano_lotac_id', 'tipo_des', 'ccusto','description', 'origem']);
    }
    public function listarOrderBy(){
        return $this->getRepository()->listarOrderBy();
    }
    public function inserirSequencia(Request $request){
        $dados = $request->all();
        $resp = $this->getRepository()->inserirSequenciaExecucao($dados);

        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro!';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            goto saida;
        }
        $retorno['status'] = 'success';
        $retorno['submsg'] = 'Sucesso!';
        $retorno['msg'] = 'Sequências inseridas com sucesso!';

        saida:

        return $this->retornoJsonDefault($retorno);
    }
    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("unid lotac", "Unidade Lotação", $colunas[$i]);
            $colunas[$i] = str_replace("cod ccusto", "Código centro de custo ", $colunas[$i]);
            $colunas[$i] = str_replace("des unid lotac", "Descrição unidade lotação", $colunas[$i]);
            $colunas[$i] = str_replace("des ccusto", "Centro custo", $colunas[$i]);
            $colunas[$i] = str_replace("created by nome", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("description created at", "Criado em", $colunas[$i]);
            $colunas[$i] = str_replace("updated by nome", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("description updated at", "Atualizado em", $colunas[$i]);

            $colunas[$i] = str_replace("sequencia execucao", "Sequência execução", $colunas[$i]);

            $colunas[$i] = str_replace("cod cta ctbl", "Código conta contábil", $colunas[$i]);
            $colunas[$i] = str_replace("desc cta ctbl", "Descrição conta contábil", $colunas[$i]);
            $colunas[$i] = str_replace("des origem", "Origem", $colunas[$i]);
            $colunas[$i] = str_replace("des tipo des", "É despesa?", $colunas[$i]);
            $colunas[$i] = str_replace("desc ccusto", "É permitido centro de custo?", $colunas[$i]);


        }
        return $colunas;
    }
    
}
