<?php

namespace App\Modules\Natureza51\Http\Controllers;

// use App\Modules\Natureza51\Repositories\RepoHeadcount as RepoHeadcount;
use App\Modules\Natureza51\Entities\OrcamLotCargoEvento;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\OrcEventos;
use App\Modules\Natureza51\Entities\OrcHoraExtra;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\Turma; 
use App\Modules\Natureza51\Entities\OrcTurma; 
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;
use App\Modules\Natureza51\Entities\OrcDemissoesDetalhes;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcFuncionario;
use App\Modules\Natureza51\Entities\OrcHeadcountContratacoes;
use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Repositories\RepoOrcContratacoes as RepoOrcContratacoes;
use App\Modules\Natureza51\Http\Controllers\OrcamentoController;
use App\Modules\Natureza51\Entities\OrcCargo;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento as RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoHeadcount as RepoHeadcount;
use App\Modules\Natureza51\Repositories\RepoOrcamento as RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcCronograma;
use App\Modules\Natureza51\Repositories\RepoAtividades;
use App\Support\TreeTable\AtmTreeTable;
use \App\Core\Traits\ErrorTrait;
use App\Modules\Natureza51\Entities\HeadcountHraExtra;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\Usuario;
use Carbon\Carbon;

class ControleFuncionariosController extends OrcamentoController
{
    
    public function __construct(){
        $this->setCodTela('CONTFUNC');
        $this->setTimeOut(700);
        // $this->repository=new RepoControleFuncionario();
        parent::__construct();
    }
        
    public function listarControleFunc($orc_id, $lotacao_id, $periodo = null, $tipo_table = 'O'){    
        set_time_limit($this->getTimeOut());
        (!is_null($lotacao_id)) ? $this->setCodTela('CONTFUNC') : $this->setCodTela('CONSFUNC');
        $decrypted = json_decode(safeDecrypt(request()->bearerToken()),true);  
        $lot_id = $decrypted['token']['func_data']['lotacao_id'];  
        $tipo_user = $decrypted['token']['tipo_user'];    
        // $this->podeAcessar('listar',true,$this->getCodTela());       
                
        // if(!$this->getRepository()->isOwn()){
        //     dd("adicionar mensagem q não tem permissão");
        // }

        // $tb_orc_funcionario = new OrcFuncionario();
        // $tbl_funcionario = new Funcionario();
        // $tb_orc_lotacao = new OrcLotacao();
        // $tb_lotacao = new Lotacao();
        // $tb_orc_cargo = new OrcCargo();
        // $tb_cargo = new Cargo();        
        // $tb_orc_turma = new OrcTurma();
        // $tb_turma = new Turma();
        // $tb_centro_custo = new CentroCusto();        

        DB::enableQueryLog();
            
        if ($tipo_user != 3 && is_null($lotacao_id)) {
            
            $lotacao_id = DB::select("select id from tbl_orc_lotacao where lotacao_id = {$lot_id} and orcamento_id = {$orc_id}");
            
        }

        $string_lotacao = " and orc_lot.id = {$lotacao_id} ";
        $string_orc_id = " and orc_lot.orcamento_id = {$orc_id} ";

        $where_lotacao = ($lotacao_id != 0) ? $string_lotacao : "";
        $where_orc_id = (!is_null($orc_id)) ? $string_orc_id : "";

        if($tipo_user != 3 && $lotacao_id == 0){    
            
            $tbl_orc_lotacao_controller = new OrcLotacaoController();        
            $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
            $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
                
            $lotacoes_string = implode(",",$lotacoes);
            $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

            $where_lotacao = " and orc_lot.lotacao_id in ({$lotacoes_string}) ";

        }

        $where_periodo = $tipo_table == 'F' ? " and orc_func.periodo = '{$periodo}' " : "";
        // dd("testeeeeeeee----------->>>>>",$where_lotacao, $where_orc_id);                       
        $data = DB::select("SELECT
                                CONCAT(func.cdn_funcionario, ' - ', func.nome_funcionario) as nome, 
                                CONCAT(cc.cod_ccusto, ' - ', cc.des_ccusto) ccusto, 
                                CONCAT(cc.cod_ccusto, ' - ', lot.unid_lotac, ' - ', lot.des_unid_lotac) lotacao,
                                CONCAT(cargo.cod_cargo_basic, ' - ', cargo.des_cargo_basic ) cargo, 
                                CONCAT(turma.cdn_turma_trab, ' - ', turma.des_turma_trab, ' - ', turno.cdn_turno_trab, ' - ', turno.des_turno_trab) turma, 
                                orc_func.id orc_lot_id, func.id func_id, 
                                cc.id ccusto_id, 
                                cc.cod_ccusto,
                                lot.id lotacao_id, orc_lot.id orc_lot_id,  
                                orc_cargo.id orc_cargo_id, cargo.id cargo_id, orc_turma.id orc_turma_id, turma.id turma_id,
                                orc_func.salario_folha, 
                                orc_func.salario_forecast,
                                CASE func.pne WHEN 1 THEN 'Sim' ELSE 'Não' END pne
                            FROM tbl_orc_funcionario orc_func
                            INNER JOIN tbl_funcionario func ON func.id = orc_func.funcionario_id
                            INNER JOIN tbl_orc_lotacao orc_lot ON orc_lot.id = orc_func.orc_lotacao_id 
                                and orc_lot.orcamento_id = orc_func.orcamento_id
                            INNER JOIN tbl_lotacao lot ON lot.id = orc_lot.lotacao_id
                            INNER JOIN tbl_orc_cargo orc_cargo ON orc_cargo.id = orc_func.orc_cargo_id
                                and orc_cargo.orcamento_id = orc_func.orcamento_id
                            INNER JOIN tbl_cargo cargo ON cargo.id = orc_cargo.cargo_id
                            LEFT JOIN tbl_orc_turma orc_turma ON orc_turma.id = orc_func.orc_turma_id
                                and orc_turma.orc_id = orc_func.orcamento_id
                            LEFT JOIN tbl_turma turma ON turma.id = 
                            orc_turma.turma_id
                            LEFT JOIN tbl_turno as turno on turno.id = turma.turno_id
                            INNER JOIN tbl_ccusto cc ON cc.id = orc_lot.cc_custo_id
                            where func.dat_demis_func is null
                            {$where_lotacao} 
                            {$where_orc_id} and orc_func.tipo_table = '{$tipo_table}'
                            {$where_periodo}
                            order by 
                        lot.unid_lotac, func.nome_funcionario
        ");

        // dd("olha",DB::getQueryLog());
        // dd("dataaaa", $data);
        //  dd("pivooooo",$this->pivo($data));
        // return new Response(json_encode($this->montaTreetable($this->pivo($data))) , 200);

        // if (is_null($orc_id)) {
        //     return $data;
        // }    
        
        $data = json_decode(json_encode($data), true);
        return new Response(json_encode($this->montaTreetable($data)) , 200);
    }     

    public function listarControleFuncRelatorio($orc_id, $periodo = null, $tipo_table = 'O'){    
        set_time_limit($this->getTimeOut());
        
        
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

        $where = $tipo_table == 'F' ? " and orc_func.periodo = '{$periodo}' and orc_func.tipo_table = '{$tipo_table}' " : " and orc_func.tipo_table = '{$tipo_table}' ";
        $data = DB::select("SELECT
                                CONCAT(func.cdn_funcionario, ' - ', func.nome_funcionario) as nome, 
                                CONCAT(cc.cod_ccusto, ' - ', cc.des_ccusto) ccusto, 
                                CONCAT(cc.cod_ccusto, ' - ', lot.unid_lotac, ' - ', lot.des_unid_lotac) lotacao,
                                CONCAT(cargo.cod_cargo_basic, ' - ', cargo.des_cargo_basic ) cargo, 
                                CONCAT(turma.cdn_turma_trab, ' - ', turma.des_turma_trab, ' - ', turno.cdn_turno_trab, ' - ', turno.des_turno_trab) turma, 
                                orc_func.id orc_lot_id, func.id func_id, 
                                cc.id ccusto_id, 
                                cc.cod_ccusto,
                                lot.id lotacao_id, orc_lot.id orc_lot_id,  
                                orc_cargo.id orc_cargo_id, cargo.id cargo_id, orc_turma.id orc_turma_id, turma.id turma_id,
                                orc_func.salario_folha, 
                                orc_func.salario_forecast,
                                CASE func.pne WHEN 1 THEN 'Sim' ELSE 'Não' END pne
                            FROM tbl_orc_funcionario orc_func
                            INNER JOIN tbl_funcionario func ON func.id = orc_func.funcionario_id
                            INNER JOIN tbl_orc_lotacao orc_lot ON orc_lot.id = orc_func.orc_lotacao_id 
                                and orc_lot.orcamento_id = orc_func.orcamento_id
                            INNER JOIN tbl_lotacao lot ON lot.id = orc_lot.lotacao_id
                            INNER JOIN tbl_orc_cargo orc_cargo ON orc_cargo.id = orc_func.orc_cargo_id
                                and orc_cargo.orcamento_id = orc_func.orcamento_id
                            INNER JOIN tbl_cargo cargo ON cargo.id = orc_cargo.cargo_id
                            LEFT JOIN tbl_orc_turma orc_turma ON orc_turma.id = orc_func.orc_turma_id
                                and orc_turma.orc_id = orc_func.orcamento_id
                            LEFT JOIN tbl_turma turma ON turma.id = 
                            orc_turma.turma_id
                            LEFT JOIN tbl_turno as turno on turno.id = turma.turno_id
                            INNER JOIN tbl_ccusto cc ON cc.id = orc_lot.cc_custo_id
                            where func.dat_demis_func is null
                            and lot.id in ($lotacoes_string) and orc_func.orcamento_id = $orc_id {$where}
                            order by 
                        lot.unid_lotac, func.nome_funcionario
        ");

        $data = json_decode(json_encode($data), true);
        return new Response(json_encode($this->montaTreetable($data)) , 200);
    }

    public function pivo($dados){
        // $meses_orcado=$this->getColumMeses();        
        // $eventos_meses = [13,14,15,16];
        $retorno=[];
        $primary_key=['ccusto_id','cargo_id','orc_turma_id', 'lotacao_id'];
       
        $merge_meses_evento=[];
        $meses_orcados_clear=[];        
        
        $dados_rest = [];
        foreach($dados as $key => $value){
            
            $value=(array)$value;
            $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
            $ja_foi=array_keys($retorno);
            
            if(in_array($keys_values, $ja_foi)===false){                
                $aux=Arr::except($value,$meses_orcado);   
                $retorno[$keys_values]=$aux;

            }
            foreach($meses_orcado as $j=>$w){                     
                $retorno[$keys_values][$w]=$value[$w];
            }
        }
        // dd("pivooo", $retorno);
        return $retorno;
    }

    public function montaTreetable($data){
                
        $column_fixeds=[ 
            ["field_out"=>"nome", "from"=>"nome", "render_value"=>null,],
            ["field_out"=>"lotacao", "from"=>"lotacao", "render_value"=>null,],
            ["field_out"=>"ccusto", "from"=>"ccusto", "render_value"=>null,],
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null,],
            ["field_out"=>"turma", "from"=>"turma", "render_value"=>function($data, $value){
                if($value == ' -  -  - '){
                    return '-';
                }
                return $value;
            }],
            ["field_out"=>"salario_folha", "from"=>"salario_folha", "render_value"=>function($data, $value){
                return number_format($value, '2', ',', '.');
            }],
            ["field_out"=>"salario_forecast", "from"=>"salario_forecast", "render_value"=>function($data, $value){
                return number_format($value, '2', ',', '.');
            }],
            ["field_out"=>"pne", "from"=>"pne", "render_value"=>null,],
            ["field_out"=>"orc_lot_id", "from"=>"orc_lot_id", "render_value"=>null,],
            ["field_out"=>"func_id", "from"=>"func_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"turma_id", "from"=>"turma_id", "render_value"=>null,],
            ["field_out"=>"informativo", "from"=>"informativo", "render_value"=>null,]
            
        ];

        $column_fixeds_children=[             

        ];

        // $columns_base=array_merge($column_fixeds, $col_meses_parent); 
        // $columns_children=array_merge($column_fixeds_children, $col_set_meses); 
        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
            "keys"=>['ccusto_id', 'cargo_id', 'lotacao_id', 'func_id', ''],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children"=>["columns"=>$columns_children,
                    "keys"=>['ccusto_id', 'cargo_id','orc_turma_id', 'lotacao_id'],
                    "filter_data"=>['cod_ccusto'=>function($value){
                        return !is_null($value);
                    }],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result= false;
                            // ($value['ccusto_id']== $parent_data['ccusto_id'] && 
                            // $value['cargo_id']== $parent_data['cargo_id']&&
                            // // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                            // $value['lotacao_id']== $parent_data['lotacao_id']);
                        
                            return $result;
                    },
                    // "children"=>["is_recursive"=>true]

                ]
            ];
                 
        $controller=new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
        
    }

    public function updatecontFunc(Request $request, $orc_id) {
        
        $this->setCodTela('CONTFUNC');
        $this->podeAcessar('editar',true,$this->getCodTela());

        $form_data = $request->all();
        $tipo_table = "O";
        $periodo = null;
        if(array_key_exists('tipo_table', $form_data)){
            $tipo_table = $form_data['tipo_table'];
            $periodo = $form_data['periodo'];
        }
        
        $where_periodo[0] = $tipo_table == 'F' ? " and c.periodo = '{$periodo}' " : "";
        $where_periodo[1] = $tipo_table == 'F' ? " and a.periodo = '{$periodo}' " : "";

        
        monetarioVirgula($form_data['salario_forecast']);
        //dd($form_data);
        DB::enableQueryLog();
        // dd("orc_lot", $form_data); 
        $data_orc_lot = DB::select("SELECT * FROM tbl_orc_lotacao c where c.id = {$form_data['orc_lotacao_id']} and c.tipo_table = '{$tipo_table}' {$where_periodo[0]}");
    
                                    
        $data_func_atual = DB::select("SELECT LEFT(c.cod_cargo_basic,2) cod_cargo FROM tbl_orc_funcionario a
            INNER JOIN tbl_orc_cargo b ON b.id = a.orc_cargo_id
            INNER JOIN tbl_cargo c ON c.id = b.cargo_id
            where a.orcamento_id = {$orc_id} and funcionario_id = {$form_data['func_id']} and a.tipo_table = '{$tipo_table}' {$where_periodo[1]}
        ");

        $data_update = DB::select("SELECT LEFT(c.cod_cargo_basic,2) cod_cargo FROM tbl_cargo c where c.id = {$form_data['cargo_id']}");
        
        if (intval($data_func_atual[0]->cod_cargo) > intval($data_update[0]->cod_cargo)) {
            $retorno['msg']='O grade do Cargo escolhido deve ser maior ou igual ao Grade do Cargo atual. Erro: 171120201844';
            $retorno['submsg']='Erro';
            goto saida;   
        }
        
        DB::beginTransaction();

        try {
            
            $OrcFuncionario = new OrcFuncionario();

            // $form_data['salario_forecast'] = str_replace('.', '', $form_data['salario_forecast']);
            // $form_data['salario_forecast'] = str_replace(',', '.', $form_data['salario_forecast']);


            $data_up = [
            'orc_lotacao_id' => intval($form_data['orc_lotacao_id']),
            'orc_cargo_id' => intval($form_data['orc_cargo_id']),
            'orc_turma_id' => intval($form_data['orc_turma_id']),
            'ccusto_id'=> intval($data_orc_lot[0]->cc_custo_id),
            'salario_forecast' => $form_data['salario_forecast'],
            'cargo_atualizado' => 1,
            'updated_at' => $this->fillModificadoEm(),
            'updated_by' => $this->fillModificadoPor(),
            ];            
        
            $retorno_up = null;

            if($tipo_table == 'F'){
                $retorno_up = $OrcFuncionario->where([
                    ['orcamento_id','=', $orc_id],
                    ['funcionario_id','=', $form_data['func_id']],
                    ['tipo_table','=',$tipo_table],
                    ['periodo','=',$periodo]
                ])->update($data_up);
            }
            else{
                $retorno_up = $OrcFuncionario->where([
                    ['orcamento_id','=', $orc_id],
                    ['funcionario_id','=', $form_data['func_id']],
                    ['tipo_table','=',$tipo_table]
                ])->update($data_up);
            }

            if(!$retorno_up){                
                $retorno['status'] = "error";
                $retorno['submsg'] = "Erro";
                $retorno['msg'] = "Falha ao atualizar registro. Erro: 171120201943";
                goto saida;
            }
            
            DB::commit();
            $retorno["status"] = "success";
            $retorno["msg"] = "Registro atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"] = "error";
            $retorno['msg'] = $e->getMessage();
            $retorno['submsg'] = 'Falha ao atualizar registro. Erro: 171120201943';
        }
                
        saida:
        return $this->retornoJsonDefault($retorno);      
        
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, $filename,['cargo_id','ccusto_id','func_id','lotacao_id','orc_cargo_id','orc_lot_id','orc_turma_id','turma_id']);
    }
    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            
            $colunas[$i] = str_replace("turma", "Turma", $colunas[$i]);
            $colunas[$i] = str_replace("salario forecast", "Salário Forecast", $colunas[$i]);
            $colunas[$i] = str_replace("salario folha", "Salário Folha", $colunas[$i]);
            $colunas[$i] = str_replace("pne", "PCD", $colunas[$i]);
            $colunas[$i] = str_replace("nome", "Funcionário", $colunas[$i]);
            $colunas[$i] = str_replace("lotacao", "Lotação", $colunas[$i]);
            $colunas[$i] = str_replace("ccusto", "Centro de Custo", $colunas[$i]);
            $colunas[$i] = str_replace("cargo", "Cargo", $colunas[$i]);
        }
        return $colunas;
    }
}
 