<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoHeadcount as RepoHeadcount;
use App\Modules\Natureza51\Repositories\RepoOrcNotificacoes;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\OrcTurma; 
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\OrcHeadcountContratacoes;
use App\Modules\Natureza51\Entities\OrcDiarioBordo;
use App\Modules\Natureza51\Entities\OrcPromocao;
use App\Modules\Natureza51\Entities\OrcContratacoes;
use App\Modules\Natureza51\Repositories\RepoOrcDiarioBordo;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcParamNatureza;




//use DB;
use Illuminate\Http\Response;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use App\Support\TreeTable\AtmTreeTable;
use \App\Core\Traits\ErrorTrait;
use Illuminate\Support\Facades\DB;

class DashboardGestorController extends OrcamentoController
{
    private $colum_meses=['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado',
    'jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];
    private $colum_meses_tot_orc=['jan_val_total','fev_val_total','mar_val_total','abr_val_total','mai_val_total','jun_val_total',
    'jul_val_total','ago_val_total','set_val_total','out_val_total','nov_val_total','dez_val_total'];

    private $t;
    public $qtd;
    public function __construct(){
        $this->setCodTela('HOME');
        $this->repository=new RepoHeadcount();
        $this->t=new RepoOrcNotificacoes();
        parent::__construct();
        $this->setTimeOut(700);
    } 
    function getColumMeses(){ return $this->colum_meses; }
    function getColumMesesTotOrc(){ return $this->colum_meses_tot_orc; }

    function getEventosList(){ 
        return $this->getEventOfHour(); 
    }
 
    public function arrumaPeriodo($periodo){
        if(strlen($periodo) == 1){
            return '0'.$periodo;
        }
        else{
            return $periodo;
        }
    }

    
    public function montaTreetable($data){
        /*$pivot_colunas=$this->pivotColumns();
        $col_meses=$pivot_colunas->merged;
        $col_set_meses=[];
        $col_meses_parent=[];


        foreach($col_meses as $j=>$mes){
            $col_set_meses[]= ["field_out"=>$j,"from"=>$j, "render_value"=>null,];
            $col_meses_parent[]=["field_out"=>$j,  "from"=>'t_event-'.$j, 
            "field_out_render_func"=>function($row_data,$value, $matrix){

            }];
        }*/
        // dd('ddhdgdg',$data);
        $column_fixeds=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>function(){ return "-";},],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>function(){ return "-";},],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"qtd_func_lot", "from"=>"qtd_func_lot", "render_value"=>null,],
            ["field_out"=>"turno", "render_value"=>function(){ return "-";},],
            ["field_out"=>"turma", "render_value"=>function(){ return "-";},],
            ["field_out"=>"cargo", "render_value"=>function(){ return "-";},],
            
            // ["field_out"=>"lotacao", "from"=>"unid_lotac","render_value"=>function($rowData, $value){
             // return $rowData['unid_lotac'].' - '. $rowData['des_unid_lotac'];
                
            // }],
            ["field_out"=>"lotacao", "from"=>"lotacao", "render_value"=>null,],

            ["field_out"=>"tot_contratacoes", "from"=>"tot_tot_contratacoes", "render_value"=>function($row_data, $value){ return intval($value);}],
            ["field_out"=>"tot_demissoes", "from"=>"tot_tot_demissoes", "render_value"=>function($row_data, $value){ return intval($value);}],
            ["field_out"=>"tot_promocoes", "from"=>"tot_tot_promocoes", "render_value"=>function($row_data, $value){ return intval($value);}],
            ["field_out"=>"nro_pcd_cargo", "from"=>"tot_nro_pcd_cargo", "render_value"=>function($row_data, $value){ return number_format(is_null($value) ? 0 : $value, 2, ',', '.');}],
            ["field_out"=>"nro_jovem_aprendiz_cargo", "from"=>"tot_nro_jovem_aprendiz_cargo", "render_value"=>function($row_data, $value){ return number_format(is_null($value) ? 0 : $value, 2, ',', '.');}],
            // ["field_out"=>"nro_pcd_cargo", "from"=>"tot_pcd", "render_value"=>function($row_data, $value){ return number_format(is_null($value) ? 0 : $value);}],


        
            ["field_out"=>"jan", "from"=>"t_headcount_jan", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"fev", "from"=>"t_headcount_fev", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"mar", "from"=>"t_headcount_mar","render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"abr", "from"=>"t_headcount_abr", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"mai", "from"=>"t_headcount_mai", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"jun", "from"=>"t_headcount_jun","render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"jul", "from"=>"t_headcount_jul", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"ago", "from"=>"t_headcount_ago", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"set", "from"=>"t_headcount_set", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"out", "from"=>"t_headcount_out", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"nov", "from"=>"t_headcount_nov", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"dez", "from"=>"t_headcount_dez","render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"can_send_hc", "from"=>"can_send_hc", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_fill_hc", "from"=>"can_fill_hc", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_calc_hc", "from"=>"can_calc_hc", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_release_hc", "from"=>"can_release_hc", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
         
            ["field_out"=>"can_reopen_hc", "from"=>"can_reopen_hc", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_confer_hc", "from"=>"can_confer_hc", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_aprovar_hc", "from"=>"can_aprovar_hc", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],

            ["field_out"=>"can_send_fcst", "from"=>"can_send_fcst", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_fill_fcst", "from"=>"can_fill_fcst", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_calc_fcst", "from"=>"can_calc_fcst", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_release_fcst", "from"=>"can_release_fcst", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
         
            ["field_out"=>"can_reopen_fcst", "from"=>"can_reopen_fcst", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_confer_fcst", "from"=>"can_confer_fcst", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_aprovar_fcst", "from"=>"can_aprovar_fcst", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],

            ["field_out"=>"status", "from"=>"status", "render_value"=>null,],
            ["field_out"=>"status_aprov", "from"=>"status_aprov", "render_value"=>null,],
            ["field_out"=>"cargo_ativo", "from"=>"cargo_ativo", "render_value"=>function($value){
                return '-';
            }],
            ["field_out"=>"lotacao_ativa", "from"=>"lotacao_ativa", "render_value"=>null]


        ];

        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "render_value"=>function(){ return "";},],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"atual", "render_value"=>function(){ return "";},],
            ["field_out"=>"turno", "from"=>"des_turno_trab", "render_value"=>null,],
            ["field_out"=>"turma", "from"=>"turma", "render_value"=>null,],
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null,],
            ["field_out"=>"tot_contratacoes", "from"=>"tot_contratacoes", "render_value"=>function($row_data, $value){ return intval($value);}],
            ["field_out"=>"tot_demissoes", "from"=>"tot_demissoes", "render_value"=>function($row_data, $value){ return intval($value);}],
            ["field_out"=>"tot_promocoes", "from"=>"tot_promocoes", "render_value"=>function($row_data, $value){ return intval($value);}],
          
            ["field_out"=>"nro_jovem_aprendiz_cargo", "from"=>"nro_jovem_aprendiz_cargo", "render_value"=>function($row_data, $value){ return number_format(is_null($value) ? 0 : $value, 2, ',', '.');}],
            ["field_out"=>"nro_pcd_cargo", "from"=>"nro_pcd_cargo", "render_value"=>function($row_data, $value){ return number_format(is_null($value) ? 0 : $value, 2, ',', '.');}],

                    
            ["field_out"=>"jan", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"fev", "from"=>"fev_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"mar", "from"=>"mar_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"abr", "from"=>"abr_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"mai", "from"=>"mai_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"jun", "from"=>"jun_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"jul", "from"=>"jul_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"ago", "from"=>"ago_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"set", "from"=>"set_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"out", "from"=>"out_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"nov", "from"=>"nov_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"dez", "from"=>"dez_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"lotacao", "from"=>"lotacao", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"status", "from"=>"status", "render_value"=>null,],
            ["field_out"=>"status_aprov", "from"=>"status_aprov", "render_value"=>null,],

            ["field_out"=>"justificativa_cont", "from"=>"justificativa_cont", "render_value"=>null,],
            ["field_out"=>"justificativa_dem", "from"=>"justificativa_dem", "render_value"=>null,],
            ["field_out"=>"justificativa_pro", "from"=>"justificativa_pro", "render_value"=>null,],
            ["field_out"=>"justificativa_pro2", "from"=>"justificativa_pro2", "render_value"=>null,],

            ["field_out"=>"cargo_ativo", "from"=>"cargo_ativo", "render_value"=>null],
            ["field_out"=>"lotacao_ativa", "from"=>"lotacao_ativa", "render_value"=>function($value){
                return '-';
            }]


        ];

        
        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
            "keys"=>['ccusto_id', 'lotacao_id'],
                
            "children"=>["columns"=>$columns_children,
                    "keys"=>['ccusto_id', 'lotacao_id', 'cargo_id', 'orc_turma_id'],
                    "filter_data"=>['cod_ccusto'=>function($value){
                        return !is_null($value);
                    },
                    'lotacao_id'=>function($value){
                        return !is_null($value);
                    },
                    'cargo_id'=>function($value){
                        return !is_null($value);
                    },
                    'orc_turma_id'=>function($value){
                        return !is_null($value);
                    }
                    // 'tot_contratacoes'=>function($value){
                    //     return $value!=0;
                    // },
                    // 'tot_demissoes'=>function($value){
                    //     return $value!=0;
                    // },
                    // 'tot_promocoes'=>function($value){
                    //     return $value!=0;
                    // }
                    ],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result=($value['ccusto_id']== $parent_data['ccusto_id'] && 
                            // $value['cargo_id']== $parent_data['cargo_id']&&
                            $value['lotacao_id']== $parent_data['lotacao_id']);
                        
                            return $result;
                    },
                
 
                ]
            ];
                
        $controller=new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
    }



    public function listarHeadcount($orc_id, $periodo, $tipo_table){    
        set_time_limit($this->getTimeOut());
        $this->setCodTela('HOME');
        $this->podeAcessar('listar',true,$this->getCodTela());

        $data = '';
        $periodo_original = $periodo != 0 ? $periodo."-01" : null;
        
        if(strlen($periodo) > 2){
            $data = date("{$this->arrumaPeriodo($periodo)}-01");
            $periodo = substr($periodo, 5, 2);
        }
        else{
            $data = date("2020-".$periodo."-01");
        }
        
        $msg = '';
        if($tipo_table == 'F'){
            $repo = $this->getRepository()->getModelEntity()::with([
                'getOrcamento'=>function($query){                    
                } 
            ])->where([
                ['orc_id', '=', $orc_id],
                ['tipo_table', '=', $tipo_table],
                ['periodo', '=', $data]
            ])
            ->first();

            $msg = "Forecast não Encontrado!";
        }
        else{
            $repo = $this->getRepository()->getModelEntity()::with([
                'getOrcamento'=>function($query){                    
                } 
            ])->where([
                ['orc_id', '=', $orc_id],
                ['tipo_table', '=', $tipo_table]
            ])
            ->first();
            $msg = "Headcount não Encontrado!";
        }

        $where_periodo = ' and month(tbl_orc_lot_carg_headcount.periodo) = ' . $periodo;  
        ($periodo == 0) ? $where_periodo = ' and tbl_orc_lot_carg_headcount.periodo is null' : $where_periodo;

       
        $where_lotacao = $tipo_table == 'F' ? " and ( (month(tbl_orc_lotacao.periodo) = {$periodo} and tbl_orc_lotacao.tipo_table = 'F') or tbl_orc_lotacao.tipo_table = 'O') " : " and tbl_orc_lotacao.tipo_table = 'O' ";
        
        
        
        $tbl_orc_lotacao_controller = new OrcLotacaoController();

        $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo_original, $tipo_table);
        $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
             
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

        $tipo_user = $this->getUserFromCurrentGuard()->tipo;
    
        if(!$repo){
            $msg = array('msg'=>$msg, 'submsg'=>'Atenção', 'status'=>'warning');
            return new Response(json_encode($msg), 500);
        }
    
        $set_orcamento = $this->getRepository()->setOrcamento($repo->getOrcamento);
        if(!$this->getRepository()->isOwn()){
            $msg = array('msg'=>'Acesso negado! Você não possui permissão.', 'submsg'=>'Atenção', 'status'=>'warning');
            return new Response(json_encode($msg), 500);
            // dd("adicionar mensagem q não tem permissão");
        }
    
        $periodo_just = $tipo_table == 'F' ? " and month(op.periodo) = {$periodo} " : "";
        /*$tb_orcamLot_cargo_headcount = new OrcamLotCargoHeadcount();        
        $tb_calc_orcamento = new CalcOrcamento();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tb_lotacao = new OrcLotacao();
        $tb_orc_cargo = new OrcCargo(); 
        $tb_orc_headcount_contratacoes = new OrcContratacoes();
        $tbl_orc_headcount_demissoes = new OrcHeadcountDemissoes();*/

        
        // $entity_contratacoes = $repo_contratacoes->getModelEntity();
        // $repo_contratacoes = new RepoOrcContratacoes();

        $param_id = DB::select("SELECT * FROM tblg_parametros where cod_parametro in('CTPCD', 'CTJAP')");
        $PCD = 0; $JA = 0;
        if($param_id[0]->cod_parametro == 'CTPCD'){
            $PCD = $param_id[0]->id;
            $JA = $param_id[1]->id;
        }
        else{
            $PCD = $param_id[1]->id;
            $JA = $param_id[0]->id;
        }
        DB::enableQueryLog();

        (strlen($lotacoes_string) == 0) ? $lotacoes_string = 0 : $lotacoes_string;             

        $data = DB::select("SELECT distinct  tbl_calc_orcamento.id, 
            tbl_orc_lot_carg_headcount.id as id_princ, 
            [tbl_orc_lot_carg_headcount].[orc_id], 
            [tbl_orc_lot_carg_headcount].[qtd_func_lot], 
            [tbl_orc_lot_carg_headcount].[lotacao_id], 
            [tbl_orc_cargo].[cargo_id], 
            [tbl_cargo].[cod_cargo_basic], 
            [tbl_cargo].[des_cargo_basic],
            concat(tbl_cargo.cod_cargo_basic, ' - ', tbl_cargo.des_cargo_basic) as cargo, 
            [tbl_orc_lot_carg_headcount].[ccusto_id], 
            [tbl_ccusto].[cod_ccusto], 
            [tbl_orc_turma].[cdn_turma_trab], 
            [tbl_orc_turma].[des_turma_trab], 
            [tbl_turno].[des_turno_trab],
            tbl_orc_lot_carg_headcount.periodo,
            concat(tbl_orc_turma.des_turma_trab, ' - ', tbl_turno.des_turno_trab) as turma, 
            [tbl_orc_lot_carg_headcount].[orc_turma_id], 
            CONCAT(cc.cod_ccusto, ' - ', tbl_lotac.unid_lotac, ' - ', tbl_lotac.des_unid_lotac) as lotacao,

            CASE WHEN tbl_cargo.ativo = 1 THEN 'Sim' ELSE 'Não' END as cargo_ativo,
			CASE WHEN [tbl_orc_lotacao].ativo = 1 THEN 'Sim' ELSE 'Não' END as lotacao_ativa,

            SUM(tbl_calc_orcamento.jan_orcado) OVER(partition by    
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id
                                                    ) t_headcount_jan, 
            SUM([tbl_calc_orcamento].[jan_orcado]) OVER(partition by    
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                                        tbl_orc_lot_carg_headcount.orc_cargo_id,
                                                        tbl_orc_lot_carg_headcount.orc_turma_id
                                                    ) as jan_orcado, 

            SUM(tbl_calc_orcamento.fev_orcado) OVER(partition by 
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id
                                                    ) t_headcount_fev, 
            sum([tbl_calc_orcamento].[fev_orcado]) OVER(partition by    
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                                        tbl_orc_lot_carg_headcount.orc_cargo_id,
                                                        tbl_orc_lot_carg_headcount.orc_turma_id
                                                    ) as fev_orcado, 

            SUM(tbl_calc_orcamento.mar_orcado) OVER(partition by 
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id
                                                    ) t_headcount_mar, 
            sum(tbl_calc_orcamento.mar_orcado) OVER(partition by    
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                                        tbl_orc_lot_carg_headcount.orc_cargo_id,
                                                        tbl_orc_lot_carg_headcount.orc_turma_id
                                                    ) as mar_orcado, 

            SUM(tbl_calc_orcamento.abr_orcado) OVER(partition by 
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id
                                                    ) t_headcount_abr, 
            sum(tbl_calc_orcamento.abr_orcado) OVER(partition by    
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                                        tbl_orc_lot_carg_headcount.orc_cargo_id,
                                                        tbl_orc_lot_carg_headcount.orc_turma_id
                                                    ) as abr_orcado, 

            SUM(tbl_calc_orcamento.mai_orcado) OVER(partition by 
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id
                                                    ) t_headcount_mai, 
            sum(tbl_calc_orcamento.mai_orcado) OVER(partition by    
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                                        tbl_orc_lot_carg_headcount.orc_cargo_id,
                                                        tbl_orc_lot_carg_headcount.orc_turma_id
                                                    ) as mai_orcado, 

            SUM(tbl_calc_orcamento.jun_orcado) OVER(partition by 
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id
                                                    ) t_headcount_jun, 
            sum(tbl_calc_orcamento.jun_orcado) OVER(partition by    
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                                        tbl_orc_lot_carg_headcount.orc_cargo_id,
                                                        tbl_orc_lot_carg_headcount.orc_turma_id
                                                    ) as jun_orcado,
                                                    
            SUM(tbl_calc_orcamento.jul_orcado) OVER(partition by 
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id
                                                    ) t_headcount_jul, 
            sum(tbl_calc_orcamento.jul_orcado) OVER(partition by    
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                                        tbl_orc_lot_carg_headcount.orc_cargo_id,
                                                        tbl_orc_lot_carg_headcount.orc_turma_id
                                                    ) as jul_orcado,

            SUM(tbl_calc_orcamento.ago_orcado) OVER(partition by 
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id
                                                    ) t_headcount_ago, 
            sum(tbl_calc_orcamento.ago_orcado) OVER(partition by    
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                                        tbl_orc_lot_carg_headcount.orc_cargo_id,
                                                        tbl_orc_lot_carg_headcount.orc_turma_id
                                                    ) as ago_orcado,

            SUM(tbl_calc_orcamento.set_orcado) OVER(partition by 
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id
                                                    ) t_headcount_set, 
            sum(tbl_calc_orcamento.set_orcado) OVER(partition by    
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                                        tbl_orc_lot_carg_headcount.orc_cargo_id,
                                                        tbl_orc_lot_carg_headcount.orc_turma_id
                                                    ) as set_orcado,

            SUM(tbl_calc_orcamento.out_orcado) OVER(partition by 
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id
                                                    ) t_headcount_out, 
            sum(tbl_calc_orcamento.out_orcado) OVER(partition by    
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                                        tbl_orc_lot_carg_headcount.orc_cargo_id,
                                                        tbl_orc_lot_carg_headcount.orc_turma_id
                                                    ) as out_orcado,

            SUM(tbl_calc_orcamento.nov_orcado) OVER(partition by 
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id
                                                    ) t_headcount_nov, 
            sum(tbl_calc_orcamento.nov_orcado) OVER(partition by    
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                                        tbl_orc_lot_carg_headcount.orc_cargo_id,
                                                        tbl_orc_lot_carg_headcount.orc_turma_id
                                                    ) as nov_orcado,

            SUM(tbl_calc_orcamento.dez_orcado) OVER(partition by 
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id
                                                    ) t_headcount_dez, 
            sum(tbl_calc_orcamento.dez_orcado) OVER(partition by    
                                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                                        tbl_orc_lot_carg_headcount.orc_cargo_id,
                                                        tbl_orc_lot_carg_headcount.orc_turma_id
                                                    ) as dez_orcado,
            tbl_lotac.des_unid_lotac,
            tbl_lotac.unid_lotac,

        
            sum(COALESCE(CalcOrcContrat.jan_orcado,0) + COALESCE(CalcOrcContrat.fev_orcado,0) + COALESCE(CalcOrcContrat.mar_orcado,0) + COALESCE(CalcOrcContrat.abr_orcado,0) +
            COALESCE(CalcOrcContrat.mai_orcado,0) + COALESCE(CalcOrcContrat.jun_orcado,0) + COALESCE(CalcOrcContrat.jul_orcado,0) + COALESCE(CalcOrcContrat.ago_orcado,0) +
            COALESCE(CalcOrcContrat.set_orcado,0) + COALESCE(CalcOrcContrat.out_orcado,0) + COALESCE(CalcOrcContrat.nov_orcado,0) + COALESCE(CalcOrcContrat.dez_orcado,0))
            OVER(partition by    
                tbl_orc_lot_carg_headcount.ccusto_id, 
                tbl_orc_lot_carg_headcount.lotacao_id,
                tbl_orc_lot_carg_headcount.orc_cargo_id,
                tbl_orc_lot_carg_headcount.orc_turma_id
            )
            as tot_contratacoes,
            
            
            SUM(COALESCE(CalcOrcContrat.jan_orcado,0) + COALESCE(CalcOrcContrat.fev_orcado,0) + COALESCE(CalcOrcContrat.mar_orcado,0) + COALESCE(CalcOrcContrat.abr_orcado,0) +
                COALESCE(CalcOrcContrat.mai_orcado,0) + COALESCE(CalcOrcContrat.jun_orcado,0) + COALESCE(CalcOrcContrat.jul_orcado,0) + COALESCE(CalcOrcContrat.ago_orcado,0) +
                COALESCE(CalcOrcContrat.set_orcado,0) + COALESCE(CalcOrcContrat.out_orcado,0) + COALESCE(CalcOrcContrat.nov_orcado,0) + COALESCE(CalcOrcContrat.dez_orcado,0))
                OVER(partition by 
                tbl_orc_lot_carg_headcount.ccusto_id, 
                tbl_orc_lot_carg_headcount.lotacao_id) tot_tot_contratacoes,
            
            
            (select count(*) from tbl_orc_diario_bordo as db where db.registro_id = [tbl_orc_headcount_contratacoes].id and db.tbl_origem = 'tbl_orc_headcount_contratacoes') justificativa_cont,
			(select count(*) from tbl_orc_diario_bordo as db2 where (db2.registro_id = tb_orc_dem_meses.id or db2.registro_id = tb_orc_dem_func.id or db2.registro_id = tb_orc_dem_temp.id) and db2.tbl_origem = 'tbl_orc_headcount_demissoes') justificativa_dem,
            /* (select count(*) from tbl_orc_diario_bordo as db3 where db3.registro_id in(tb_orc_prom_ent.id) and db3.tbl_origem = 'tbl_orc_promocao') 0 justificativa_pro,*/
			/* (select count(*) from tbl_orc_diario_bordo as db4 where db4.registro_id in(tb_orc_prom_saida.id) and db4.tbl_origem = 'tbl_orc_promocao') 0 justificativa_pro2,*/

            (select count(*) from tbl_orc_promocao as op
				inner join tbl_orc_diario_bordo as od on od.registro_id = op.id and od.tbl_origem = 'tbl_orc_promocao'

				where op.lotacao_id = tbl_orc_lot_carg_headcount.lotacao_id and op.turma_atual_id = tbl_orc_lot_carg_headcount.orc_turma_id
				and op.cargo_atual_id = tbl_orc_lot_carg_headcount.orc_cargo_id and op.tipo_table = '{$tipo_table}' $periodo_just and (op.cargo_atual_id <> op.cargo_promovido_id)
			) as 'justificativa_pro2',

			(select count(*) from tbl_orc_promocao as op
				inner join tbl_orc_diario_bordo as od on od.registro_id = op.id and od.tbl_origem = 'tbl_orc_promocao'

				where op.lotacao_promovida_id = tbl_orc_lot_carg_headcount.lotacao_id and op.turma_promovida_id = tbl_orc_lot_carg_headcount.orc_turma_id
				and op.cargo_promovido_id = tbl_orc_lot_carg_headcount.orc_cargo_id and op.tipo_table = '{$tipo_table}' $periodo_just and (op.cargo_atual_id <> op.cargo_promovido_id)
			) as 'justificativa_pro',
            
            sum(COALESCE(CalcOrcDem.jan_orcado,0) + COALESCE(CalcOrcDem.fev_orcado,0) + COALESCE(CalcOrcDem.mar_orcado,0) + COALESCE(CalcOrcDem.abr_orcado,0) +
            COALESCE(CalcOrcDem.mai_orcado,0) + COALESCE(CalcOrcDem.jun_orcado,0) + COALESCE(CalcOrcDem.jul_orcado,0) + COALESCE(CalcOrcDem.ago_orcado,0) +
            COALESCE(CalcOrcDem.set_orcado,0) + COALESCE(CalcOrcDem.out_orcado,0) + COALESCE(CalcOrcDem.nov_orcado,0) + COALESCE(CalcOrcDem.dez_orcado,0))
            OVER(partition by    
                tbl_orc_lot_carg_headcount.ccusto_id, 
                tbl_orc_lot_carg_headcount.lotacao_id,
                tbl_orc_lot_carg_headcount.orc_cargo_id,
                tbl_orc_lot_carg_headcount.orc_turma_id
            )
            + 
            count(tb_orc_dem_func.func_id) OVER(partition by    
                tbl_orc_lot_carg_headcount.ccusto_id, 
                tbl_orc_lot_carg_headcount.lotacao_id,
                tbl_orc_lot_carg_headcount.orc_cargo_id,
                tbl_orc_lot_carg_headcount.orc_turma_id
            ) + sum(isnull(tb_orc_dem_temp.qtde_pessoas, 0)) OVER(partition by    
                    tbl_orc_lot_carg_headcount.ccusto_id, 
                    tbl_orc_lot_carg_headcount.lotacao_id,
                    tbl_orc_lot_carg_headcount.orc_cargo_id,
                    tbl_orc_lot_carg_headcount.orc_turma_id
                )
            as tot_demissoes,
            
            
            SUM( COALESCE(CalcOrcDem.jan_orcado,0) + COALESCE(CalcOrcDem.fev_orcado,0) + COALESCE(CalcOrcDem.mar_orcado,0) + COALESCE(CalcOrcDem.abr_orcado,0) +
                COALESCE(CalcOrcDem.mai_orcado,0) + COALESCE(CalcOrcDem.jun_orcado,0) + COALESCE(CalcOrcDem.jul_orcado,0) + COALESCE(CalcOrcDem.ago_orcado,0) +
                COALESCE(CalcOrcDem.set_orcado,0) + COALESCE(CalcOrcDem.out_orcado,0) + COALESCE(CalcOrcDem.nov_orcado,0) + COALESCE(CalcOrcDem.dez_orcado,0)) OVER(partition by 
                    tbl_orc_lot_carg_headcount.ccusto_id, 
                    tbl_orc_lot_carg_headcount.lotacao_id) + 
                count(tb_orc_dem_func.func_id) OVER(partition by 
                    tbl_orc_lot_carg_headcount.ccusto_id, 
                    tbl_orc_lot_carg_headcount.lotacao_id) + sum(isnull(tb_orc_dem_temp.qtde_pessoas, 0)) OVER(partition by 
                    tbl_orc_lot_carg_headcount.ccusto_id, 
                    tbl_orc_lot_carg_headcount.lotacao_id)
                as tot_tot_demissoes, 

        
            
            /*COALESCE(sum(
            CASE
                WHEN tb_orc_prom_ent.funcionario_id IS NULL THEN 0
                ELSE 1 END
            )OVER(partition by tbl_orc_lot_carg_headcount.ccusto_id, tbl_orc_lot_carg_headcount.lotacao_id, tbl_orc_lot_carg_headcount.orc_turma_id, tbl_orc_lot_carg_headcount.orc_cargo_id),0) - COALESCE(SUM(
            CASE
                WHEN tb_orc_prom_saida.funcionario_id IS NULL THEN 0
                ELSE 1 END
            )OVER(partition by tbl_orc_lot_carg_headcount.ccusto_id, tbl_orc_lot_carg_headcount.lotacao_id, tbl_orc_lot_carg_headcount.orc_turma_id, tbl_orc_lot_carg_headcount.orc_cargo_id),0)  as tot_promocoes,
        
            
            COALESCE(
            (sum( IIF(tb_orc_prom_ent.funcionario_id IS NULL, 0, 1))OVER(partition by tbl_orc_lot_carg_headcount.ccusto_id, tbl_orc_lot_carg_headcount.lotacao_id, tbl_orc_lot_carg_headcount.orc_turma_id, tbl_orc_lot_carg_headcount.orc_cargo_id)) --as tot_tot_promocoes_1,
            -
            (SUM( IIF(tb_orc_prom_saida.funcionario_id IS NULL, 0, 1))OVER(partition by tbl_orc_lot_carg_headcount.ccusto_id, tbl_orc_lot_carg_headcount.lotacao_id, tbl_orc_lot_carg_headcount.orc_turma_id, tbl_orc_lot_carg_headcount.orc_cargo_id)) --as tot_tot_promocoes_2,
            ,0) as tot_tot_promocoes,*/

            (
				(SELECT isnull(count(*), 0) from tbl_orc_promocao as ent where ent.cargo_promovido_id = [tbl_orc_lot_carg_headcount].[orc_cargo_id] 
                and ent.turma_promovida_id = tbl_orc_lot_carg_headcount.orc_turma_id
                and ent.lotacao_promovida_id = tbl_orc_lot_carg_headcount.lotacao_id
                and ent.tipo_table = 'F'
				and ent.cargo_atual_id = ent.cargo_promovido_id
                and (ent.periodo = [tbl_orc_lot_carg_headcount].periodo or (ent.periodo is null and [tbl_orc_lot_carg_headcount].periodo is null))) -

				(SELECT isnull(count(*),0) from tbl_orc_promocao as sai where sai.cargo_atual_id = [tbl_orc_lot_carg_headcount].[orc_cargo_id] 
                and sai.turma_atual_id = tbl_orc_lot_carg_headcount.orc_turma_id
                and sai.lotacao_id = tbl_orc_lot_carg_headcount.lotacao_id
                and sai.tipo_table = 'F'
				and sai.cargo_atual_id = sai.cargo_promovido_id
                and (sai.periodo = [tbl_orc_lot_carg_headcount].periodo or (sai.periodo is null and [tbl_orc_lot_carg_headcount].periodo is null)))
			) as tot_promocoes,

			(
				(SELECT isnull(count(*), 0) from tbl_orc_promocao as ent where /*ent.cargo_promovido_id = [tbl_orc_lot_carg_headcount].[orc_cargo_id] 
                and ent.turma_promovida_id = tbl_orc_lot_carg_headcount.orc_turma_id*/
                ent.lotacao_promovida_id = tbl_orc_lot_carg_headcount.lotacao_id
                and ent.tipo_table = 'F'
				and ent.cargo_atual_id = ent.cargo_promovido_id
                and (ent.periodo = [tbl_orc_lot_carg_headcount].periodo or (ent.periodo is null and [tbl_orc_lot_carg_headcount].periodo is null))) -

				(SELECT isnull(count(*),0) from tbl_orc_promocao as sai where /*sai.cargo_atual_id = [tbl_orc_lot_carg_headcount].[orc_cargo_id] 
                and sai.turma_atual_id = tbl_orc_lot_carg_headcount.orc_turma_id*/
                sai.lotacao_id = tbl_orc_lot_carg_headcount.lotacao_id
                and sai.tipo_table = 'F'
				and sai.cargo_atual_id = sai.cargo_promovido_id
                and (sai.periodo = [tbl_orc_lot_carg_headcount].periodo or (sai.periodo is null and [tbl_orc_lot_carg_headcount].periodo is null)))
			) as tot_tot_promocoes,
            

            CASE tbl_orc_lotacao.status
                when 1 then 1
                when 2 then 1
                else 0
            end as can_fill_hc,        
            
            CASE tbl_orc_lotacao.status 
                when 1 then IIF(tbl_orc_lotacao.hc_iniciado = 0, 0, 1)
                when 2 then 1
                else 0
            end as can_send_hc,

            CASE tbl_orc_lotacao.status
                when 9 then 1
                when 10 then 1
                else 0
            end as can_fill_fcst,        
            
            CASE tbl_orc_lotacao.status 
                when 9 then IIF(tbl_orc_lotacao.hc_iniciado = 0, 0, 1)
                when 10 then 1
                else 0
            end as can_send_fcst,

            (select top 1
                IIF(tbl_orc_lotacao.status = 3, IIF(tbl_notificacao.situacao = 1, 1, 0), 0)
                from  
                    tbl_notificacao where tbl_notificacao.orc_lotacao_id = tbl_orc_lotacao.id and tbl_notificacao.orc_id = tbl_orc_lotacao.orcamento_id and tbl_notificacao.tipo_aprovacao = 1 order by tbl_notificacao.data_hora desc , tbl_notificacao.id desc  ) as can_aprovar_hc,
            (select top 1
            IIF(tbl_orc_lotacao.status = 11, IIF(tbl_notificacao.situacao = 4, 1, 0), 0)
            from  
                tbl_notificacao where tbl_notificacao.orc_lotacao_id = tbl_orc_lotacao.id and tbl_notificacao.orc_id = tbl_orc_lotacao.orcamento_id and tbl_notificacao.tipo_aprovacao = 3 order by tbl_notificacao.data_hora desc, tbl_notificacao.id desc  ) as can_aprovar_fcst,
            
            (select top 1
                IIF(tbl_orc_lotacao.status = 3, IIF(tbl_notificacao.situacao = 2, 1, 0), 0)
                from  
                        tbl_notificacao where tbl_notificacao.orc_lotacao_id = tbl_orc_lotacao.id and tbl_notificacao.orc_id = tbl_orc_lotacao.orcamento_id and tbl_notificacao.tipo_aprovacao = 1 order by tbl_notificacao.data_hora desc , tbl_notificacao.id desc ) as can_confer_hc,
        (select top 1
                IIF(tbl_orc_lotacao.status = 11, IIF(tbl_notificacao.situacao = 5, 1, 0), 0)
                from  
                    tbl_notificacao where tbl_notificacao.orc_lotacao_id = tbl_orc_lotacao.id and tbl_notificacao.orc_id = tbl_orc_lotacao.orcamento_id and tbl_notificacao.tipo_aprovacao = 3 order by tbl_notificacao.data_hora desc, tbl_notificacao.id desc  ) as can_confer_fcst,

                    
        
            CASE tbl_orc_lotacao.status
                when 3 then IIF({$tipo_user} = 3, 1, 0) --Validando se o tipo dousuário é 3 (técnico)
                when 4 then IIF({$tipo_user} = 3, 1, 0) 
                when 5 then IIF({$tipo_user} = 3, 1, 0) 
                when 6 then IIF({$tipo_user} = 3, 1, 0) 
                --when 7 then IIF(3 = 3, 1, 0)                     
                else 0
            end as can_reopen_hc,  
            
            CASE tbl_orc_lotacao.status                   
                when 11 then IIF({$tipo_user} = 3, 1, 0) --Validando se o tipo dousuário é 3 (técnico)
                when 12 then IIF({$tipo_user} = 3, 1, 0) 
                when 13 then IIF({$tipo_user} = 3, 1, 0) 
                when 14 then IIF({$tipo_user} = 3, 1, 0) 
                else 0
            end as can_reopen_fcst, 
            
            CASE tbl_orc_lotacao.status
                when 3 then IIF({$tipo_user} = 3, 1, 0) --Validando se o tipo do usuário é 3 (técnico)
                when 4 then IIF({$tipo_user} = 3, 1, 0)
                when 5 then IIF({$tipo_user} = 3, 1, 0)
                when 6 then IIF({$tipo_user} = 3, 1, 0)
                --when 7 then IIF(3 = 3, 1, 0)                   
                else 0
            end as can_calc_hc, 
            
            CASE tbl_orc_lotacao.status                    
                when 11 then IIF({$tipo_user} = 3, 1, 0) --Validando se o tipo dousuário é 3 (técnico)
                when 12 then IIF({$tipo_user} = 3, 1, 0) 
                when 13 then IIF({$tipo_user} = 3, 1, 0) 
                when 14 then IIF({$tipo_user} = 3, 1, 0)
                else 0
            end as can_calc_fcst,


            isnull((select top 1

            CASE tbl_notificacao.situacao 
                WHEN   1 THEN 'Pendente'
                WHEN   2 THEN 'Aprovado'
                WHEN   3 THEN 'Rejeitado'
                WHEN   4 THEN 'FCST Pendente'
                WHEN   5 THEN 'FCST Aprovado'
                WHEN   6 THEN 'FCST Rejeitado'             
            END 
            from    tbl_notificacao 

            where tbl_notificacao.orc_lotacao_id = tbl_orc_lotacao.id 
            and tbl_notificacao.orc_id = tbl_orc_lotacao.orcamento_id 
            and ((tbl_notificacao.tipo_aprovacao = 1 and tbl_orc_lotacao.status <9) or (tbl_notificacao.tipo_aprovacao = 3 and tbl_orc_lotacao.status >=9))
            order by tbl_notificacao.data_hora desc , tbl_notificacao.id desc ),' - ') as status_aprov,

            CASE tbl_orc_lotacao.status 
                WHEN   1 THEN IIF(tbl_orc_lotacao.hc_iniciado = 0,'Pendente de digitação','Em digitação')
                WHEN   2 THEN 'Reaberto'
                WHEN   3 THEN 'Enviado'
                WHEN   4 THEN 'Conferido'
                WHEN   5 THEN 'Calculado'
                WHEN   6 THEN 'Calculado e liberado'
                WHEN   7 THEN 'Aprovado '
            -- WHEN   8 THEN 'Aprovado pelo diretor'
                WHEN   9 THEN IIF('$tipo_table' = 'O', 'Finalizado', IIF(tbl_orc_lotacao.hc_iniciado = 0,'FCST Pendente de digitação','FCST Em digitação'))
                WHEN   10 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Reaberto')
                WHEN   11 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Enviado')
                WHEN   12 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Conferido')
                WHEN   13 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Calculado')
                WHEN   14 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Calculado e liberado')
                WHEN   15 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Aprovado')
            END  as status,

        
            

            SUM(
            CASE tbl_cargo.cota_jovem_aprendiz
                WHEN    0 THEN 0
                WHEN    1 THEN  CONVERT(DECIMAL,tbl_orc_param_ja.valor_parametro)/100 * (
            select count(*)from tbl_funcionario as func
            inner join tbl_orc_lotacao as olot on olot.id = [tbl_orc_lot_carg_headcount].lotacao_id and olot.lotacao_id = func.lotacao_id
            inner join tbl_cargo as cargo on cargo.id = [tbl_orc_cargo].cargo_id
            inner join tbl_orc_turma as ot on ot.id = [tbl_orc_lot_carg_headcount].[orc_turma_id]
            where cargo.id = func.cargo_id and ot.turma_id = func.turma_id
            )
            
            END) over(partition by tbl_orc_lot_carg_headcount.ccusto_id, tbl_orc_lot_carg_headcount.lotacao_id) as tot_nro_jovem_aprendiz_cargo,

        
            CASE tbl_cargo.cota_jovem_aprendiz
            WHEN    0 THEN 0
            WHEN    1 THEN  CONVERT(DECIMAL,tbl_orc_param_ja.valor_parametro)/100 * (
            select count(*)from tbl_funcionario as func
            inner join tbl_orc_lotacao as olot on olot.id = [tbl_orc_lot_carg_headcount].lotacao_id and olot.lotacao_id = func.lotacao_id
            inner join tbl_cargo as cargo on cargo.id = [tbl_orc_cargo].cargo_id
            inner join tbl_orc_turma as ot on ot.id = [tbl_orc_lot_carg_headcount].[orc_turma_id]
            where cargo.id = func.cargo_id and ot.turma_id = func.turma_id
            )
            
            END as nro_jovem_aprendiz_cargo,

            
            SUM(CASE tbl_cargo.cota_pcd
            WHEN    0 THEN 0
            WHEN    1 THEN CONVERT(DECIMAL,tbl_orc_param_pcd.valor_parametro)/100 * (select 
                count(*) as pcd
                from tbl_funcionario func
                inner join tbl_orc_lotacao as olot on olot.lotacao_id = func.lotacao_id and olot.id = [tbl_orc_lotacao].id
                inner join tbl_orc_turma as ot on ot.turma_id = func.turma_id and ot.id = tbl_orc_lot_carg_headcount.orc_turma_id
                where pne = 1 and dat_demis_func is null and [tbl_orc_cargo].cargo_id = func.cargo_id and ot.turma_id = func.turma_id
            )

            END) over(partition by tbl_orc_lot_carg_headcount.ccusto_id, tbl_orc_lot_carg_headcount.lotacao_id, tbl_orc_lot_carg_headcount.orc_cargo_id, tbl_orc_lot_carg_headcount.orc_turma_id) as nro_pcd_cargo,

            
            SUM(CASE tbl_cargo.cota_pcd
            WHEN    0 THEN 0
            WHEN    1 THEN CONVERT(DECIMAL,tbl_orc_param_pcd.valor_parametro)/100 * (select 
                count(*) as pcd
                from tbl_funcionario func
                inner join tbl_orc_lotacao as olot on olot.lotacao_id = func.lotacao_id and olot.id = [tbl_orc_lotacao].id
                inner join tbl_orc_turma as ot on ot.turma_id = func.turma_id and ot.id = tbl_orc_lot_carg_headcount.orc_turma_id
                where pne = 1 and dat_demis_func is null and [tbl_orc_cargo].cargo_id = func.cargo_id and ot.turma_id = func.turma_id
            )

            END) over(partition by tbl_orc_lot_carg_headcount.ccusto_id, tbl_orc_lot_carg_headcount.lotacao_id) as tot_nro_pcd_cargo,
            /*AQUI*/
            tbl_cargo.cota_pcd, tbl_cargo.cota_jovem_aprendiz, tbl_orc_param_ja.valor_parametro, tbl_orc_param_pcd.valor_parametro, tbl_calc_orcamento.dez_orcado,

        
            sum(CASE tbl_cargo.cota_jovem_aprendiz
            WHEN    0 THEN 0
            WHEN    1 THEN   CONVERT(DECIMAL,tbl_orc_param_ja.valor_parametro)/100 * tbl_calc_orcamento.dez_orcado 
            WHEN    1 THEN   CONVERT(DECIMAL,tbl_orc_param_ja.valor_parametro)/100 * tbl_calc_orcamento.dez_orcado 
            WHEN    1 THEN   CONVERT(DECIMAL,tbl_orc_param_ja.valor_parametro)/100 * tbl_calc_orcamento.dez_orcado 
    
            END) OVER(partition by 
            tbl_orc_lot_carg_headcount.ccusto_id, 
            tbl_orc_lot_carg_headcount.lotacao_id,
            tbl_orc_lot_carg_headcount.orc_cargo_id,
            tbl_orc_lot_carg_headcount.orc_turma_id
            ) tot_jovem_aprendiz/*,
    
            CASE tbl_cargo.cota_pcd
            WHEN    0 THEN 0
            WHEN    1 THEN  CONVERT(DECIMAL,tbl_orc_param_pcd.valor_parametro)/100 * count(tbl_funcionario.id) OVER(partition by 
                tbl_orc_lot_carg_headcount.ccusto_id, 
                tbl_orc_lot_carg_headcount.lotacao_id,
                tbl_orc_lot_carg_headcount.orc_cargo_id,
                tbl_orc_lot_carg_headcount.orc_turma_id)

            END AS tot_pcd*/

            from [tbl_orc_lotacao]

                                                    
            inner join [tbl_orc_lot_carg_headcount] on [tbl_orc_lot_carg_headcount].[lotacao_id] = [tbl_orc_lotacao].[id]
            inner join [tbl_calc_orcamento] on [tbl_orc_lot_carg_headcount].[id] = tbl_calc_orcamento.origem_id and 
            tbl_calc_orcamento.tbl_origem = 'tbl_orc_lot_carg_headcount' 

            inner join [tbl_orc_cargo] on [tbl_orc_lot_carg_headcount].[orc_cargo_id] = [tbl_orc_cargo].[id] 
            inner join [tbl_cargo] on [tbl_orc_cargo].[cargo_id] = [tbl_cargo].[id] 
            inner join [tbl_ccusto] on [tbl_orc_lot_carg_headcount].[ccusto_id] = [tbl_ccusto].[id] 

            inner join [tbl_orc_turma] on [tbl_orc_lot_carg_headcount].[orc_turma_id] = [tbl_orc_turma].[id] 
            inner join [tbl_turno] on [tbl_orc_turma].[turno_id] = [tbl_turno].[id] 

            left join [tbl_orc_headcount_contratacoes] on [tbl_orc_headcount_contratacoes].[lotacao_id] = [tbl_orc_lot_carg_headcount].[lotacao_id] 
                and [tbl_orc_headcount_contratacoes].[orc_cargo_id] = [tbl_orc_lot_carg_headcount].[orc_cargo_id] 
                and [tbl_orc_headcount_contratacoes].[orc_turma_id] = [tbl_orc_lot_carg_headcount].[orc_turma_id] 
                and [tbl_orc_headcount_contratacoes].[tipo_table] = '$tipo_table'
                and ([tbl_orc_headcount_contratacoes].periodo = [tbl_orc_lot_carg_headcount].periodo or ([tbl_orc_headcount_contratacoes].periodo is null and [tbl_orc_lot_carg_headcount].periodo is null))
            left join [tbl_calc_orcamento] as [CalcOrcContrat] on CalcOrcContrat.origem_id = [tbl_orc_headcount_contratacoes].[id] 
                and CalcOrcContrat.tbl_origem = 'tbl_orc_headcount_contratacoes' 
            
            left join [tbl_orc_headcount_demissoes] as tb_orc_dem_meses on tb_orc_dem_meses.[lotacao_id] = [tbl_orc_lot_carg_headcount].[lotacao_id] 
                and tb_orc_dem_meses.[orc_cargo_id] = [tbl_orc_lot_carg_headcount].[orc_cargo_id] 
                and tb_orc_dem_meses.[orc_turma_id] = [tbl_orc_lot_carg_headcount].[orc_turma_id] 
                and tb_orc_dem_meses.tipo_table = '$tipo_table'
                and (tb_orc_dem_meses.periodo = [tbl_orc_lot_carg_headcount].periodo or (tb_orc_dem_meses.periodo is null and [tbl_orc_lot_carg_headcount].periodo is null))
                and tb_orc_dem_meses.tipo = 1

            left join [tbl_calc_orcamento] as [CalcOrcDem] on CalcOrcDem.origem_id = tb_orc_dem_meses.[id] 
                and CalcOrcDem.tbl_origem = 'tbl_orc_headcount_demissoes' 

            left join [tbl_orc_headcount_demissoes] as tb_orc_dem_func on tb_orc_dem_func.[lotacao_id] = [tbl_orc_lot_carg_headcount].[lotacao_id] 
                and tb_orc_dem_func.[orc_cargo_id] = [tbl_orc_lot_carg_headcount].[orc_cargo_id] 
                and tb_orc_dem_func.[orc_turma_id] = [tbl_orc_lot_carg_headcount].[orc_turma_id] 
                and tb_orc_dem_func.tipo_table = '$tipo_table'
                and (tb_orc_dem_func.periodo = [tbl_orc_lot_carg_headcount].periodo or (tb_orc_dem_func.periodo is null and [tbl_orc_lot_carg_headcount].periodo is null))
                and tb_orc_dem_func.tipo = 2

            left join [tbl_orc_headcount_demissoes] as tb_orc_dem_temp on tb_orc_dem_temp.[lotacao_id] = [tbl_orc_lot_carg_headcount].[lotacao_id] 
                and tb_orc_dem_temp.[orc_cargo_id] = [tbl_orc_lot_carg_headcount].[orc_cargo_id] 
                and tb_orc_dem_temp.[orc_turma_id] = [tbl_orc_lot_carg_headcount].[orc_turma_id] 
                and tb_orc_dem_temp.tipo_table = '$tipo_table'
                and (tb_orc_dem_temp.periodo = [tbl_orc_lot_carg_headcount].periodo or (tb_orc_dem_temp.periodo is null and [tbl_orc_lot_carg_headcount].periodo is null))
                and tb_orc_dem_temp.tipo = 3

            -- left join [tbl_orc_promocao] as tb_orc_prom_ent on tb_orc_prom_ent.cargo_promovido_id = [tbl_orc_lot_carg_headcount].[orc_cargo_id] 
            --     and tb_orc_prom_ent.turma_promovida_id = tbl_orc_lot_carg_headcount.orc_turma_id
            --     and tb_orc_prom_ent.lotacao_promovida_id = tbl_orc_lot_carg_headcount.lotacao_id
            --     and tb_orc_prom_ent.tipo_table = '$tipo_table'
            --     and (tb_orc_prom_ent.periodo = [tbl_orc_lot_carg_headcount].periodo or (tb_orc_prom_ent.periodo is null and [tbl_orc_lot_carg_headcount].periodo is null))
            --     --and (tb_orc_prom_ent.cargo_promovido_id <> tb_orc_prom_ent.cargo_atual_id)

            -- left join [tbl_orc_promocao] as tb_orc_prom_saida on tb_orc_prom_saida.cargo_atual_id = [tbl_orc_lot_carg_headcount].[orc_cargo_id] 
            --     and tb_orc_prom_saida.turma_atual_id = tbl_orc_lot_carg_headcount.orc_turma_id
            --     and tb_orc_prom_saida.lotacao_id = tbl_orc_lot_carg_headcount.lotacao_id
            --     and tb_orc_prom_saida.tipo_table = '$tipo_table'
            --     and (tb_orc_prom_saida.periodo = [tbl_orc_lot_carg_headcount].periodo or (tb_orc_prom_saida.periodo is null and [tbl_orc_lot_carg_headcount].periodo is null))
            --     /*and (tb_orc_prom_saida.cargo_promovido_id <> tb_orc_prom_saida.cargo_atual_id)*/

            left join [tbl_orc_parametros] as tbl_orc_param_pcd on tbl_orc_lot_carg_headcount.orc_id = tbl_orc_param_pcd.orcamento_id
                and tbl_orc_param_pcd.parametro_id = {$PCD}

            left join [tbl_orc_parametros] as tbl_orc_param_ja on tbl_orc_lot_carg_headcount.orc_id = tbl_orc_param_ja.orcamento_id
                and tbl_orc_param_ja.parametro_id = {$JA}

            inner join [tbl_lotacao] as tbl_lotac on tbl_orc_lotacao.lotacao_id = tbl_lotac.id
            inner join tbl_ccusto as cc on cc.id = tbl_orc_lotacao.cc_custo_id

            -- TALVEZ PRECISE RELACIONAR TURMA TAMBÉM
            --left join tbl_funcionario on tbl_funcionario.lotacao_id = tbl_orc_lotacao.lotacao_id and tbl_funcionario.cargo_id = tbl_orc_cargo.cargo_id and tbl_funcionario.pne = 0 and tbl_funcionario.ccusto_id = tbl_orc_lotacao.cc_custo_id and tbl_funcionario.turma_id = tbl_orc_turma.turma_id

            --left join tbl_notificacao on tbl_notificacao.[orc_lotacao_id] = [tbl_orc_lotacao].[id] and tbl_notificacao.[orc_id] = 444/**/

            where ([tbl_orc_lot_carg_headcount].[orc_id] = $orc_id and [tbl_orc_lotacao].[lotacao_id] in ({$lotacoes_string}) $where_periodo
            and [tbl_orc_lot_carg_headcount].[tipo_table] = '$tipo_table') {$where_lotacao}

            and (tbl_orc_lot_carg_headcount.qtd_func_lot != 0 or tbl_orc_lot_carg_headcount.forecast_anterior != 0 or (tbl_calc_orcamento.jan_orcado != 0 or tbl_calc_orcamento.fev_orcado != 0 or tbl_calc_orcamento.mar_orcado != 0 or tbl_calc_orcamento.abr_orcado != 0
            or tbl_calc_orcamento.mai_orcado != 0 or tbl_calc_orcamento.jun_orcado != 0 or tbl_calc_orcamento.jul_orcado != 0 or tbl_calc_orcamento.ago_orcado != 0 or tbl_calc_orcamento.set_orcado != 0
            or tbl_calc_orcamento.out_orcado != 0 or tbl_calc_orcamento.nov_orcado != 0 or tbl_calc_orcamento.dez_orcado != 0))
        ");
        
            
        
        $dados = [];
        for($i = 0; $i < count($data); $i++){
            $dados[$i] = (array)$data[$i];
        }
        /* TALVEZ PRECISE COMENTAR A QUERY OU ESSA FUNÇÃO, PARA NÃO REPETIR AÇÕES(CALCULAR O TOTAL DAS PROMOÇÕES) */
        $ja_foi = [];
        $calc = 0;
        for($i = 0; $i < count($dados); $i++){
            $result = array_filter($ja_foi, function($element)use($dados, $i){
                return $element == $dados[$i]['lotacao_id'];
            });
            if(count($result) == 0){
                $calc = $this->calculaTotalPromocao($dados[$i]['lotacao_id'], $dados);
                array_push($ja_foi, $dados[$i]['lotacao_id']);
                
            }
            $dados[$i]['tot_tot_promocoes'] = $calc;
        }
        //dd($dados);
        //dd($this->montaTreetable($dados));
        return new Response(json_encode($this->montaTreetable($dados)) , 200);
    }


    public function calculaTotalPromocao($lotacao_id, $dados){
        $soma = 0;
        foreach($dados as $dado){
            if($dado['lotacao_id'] == $lotacao_id){
                $soma = $soma + $dado['tot_promocoes']; // tot_tot_promocoes - ESTAVA SOMANDO O PAI, MAS DEVERIA SOMAR OS FILHOS
            }
        }
        return $soma;
    }


   
    public function pivo($dados){
        $meses_orcado=$this->getColumMeses();        
        // $eventos_meses = [13,14,15,16];
        $retorno=[];
        $primary_key=['ccusto_id','cargo_id','orc_turma_id', 'lotacao_id'];
    
        $merge_meses_evento=[];
        $meses_orcados_clear=[];        
        
        $dados_rest = [];
        foreach($dados as $key => $value){
            
            $value=(array)$value;
            $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
            $ja_foi=array_keys($retorno);
            
            if(in_array($keys_values, $ja_foi)===false){                
                $aux=Arr::except($value,$meses_orcado);   
                $retorno[$keys_values]=$aux;

            }
            foreach($meses_orcado as $j=>$w){                     
                $retorno[$keys_values][$w]=$value[$w];
            }
        }
        // dd("pivooo", $retorno);
        return $retorno;
    }

    function pivotColumns(){
        $meses_orcado =$this->getColumMeses() ;
        $eventos_meses = $this->getEventosList();        
        $retorno=[];
        
        $merge_meses_evento=[];
        $meses_orcados_clear=[];
        foreach($meses_orcado as $key => $value){
            
            $var = explode("_",$value);
            $meses_orcados_clear[]=$var[0];

            foreach($eventos_meses as $key_ev =>$value_ev){
                $merge_meses_evento[$var[0]."-".$value_ev->evento_id] = "";
            }
        }
        return  (object)['merged'=>$merge_meses_evento, 'mes_abreviado'=>$meses_orcados_clear];
    }

    public function obtStatusByDesc($desc, $tipo_table){
        if($tipo_table == 'F'){
            $status = ['fcst pendente de digitação','fcst reaberto','fcst enviado','fcst conferido','fcst calculado','fcst calculado e liberado','fcst aprovado'];    
        }
        else{
            $status = ['pendente de digitação', 'reaberto', 'enviado', 'conferido', 'calculado', 'calculado e liberado', 'aprovado'];
        }
        
        for($i = 0; $i < count($status); $i++){
            if(strrpos($status[$i], strtolower($desc)) !== false){
                return $i+1;
                break;
            }
        }
        return false;
    }

    public function listarTotOrc(Request $request, $orc_id, $ind, $qtd, $tipo_table){ // TALVEZ ESTE METODO ESTEJA DESATIVADO
        // dd("listarTotOrc------------>>>>>>>>>");
        set_time_limit(700);
        $this->setCodTela('HOME');
		$this->podeAcessar('listar',true,$this->getCodTela());
        
        $pesquisa = $request->all();
        unset($pesquisa['_token']);
        $query = "";
        if(array_key_exists('lotac_cod', $pesquisa) && $pesquisa['lotac_cod'] != null){
            $query = " and lotac.unid_lotac like('%{$pesquisa['lotac_cod']}%') ";
        }
        if(array_key_exists('cod_ccusto', $pesquisa) && $pesquisa['cod_ccusto'] != null){
            $query = $query."and centro_custo.cod_ccusto like('%'{$pesquisa['cod_ccusto']}&') ";
        }
        if(array_key_exists('natureza', $pesquisa) && $pesquisa['natureza'] != null){
            $query = $query."and valores_calc.natureza_hash_id like('%{$pesquisa['natureza']}%') ";
        }
        if(array_key_exists('cargo_desc', $pesquisa) && $pesquisa['cargo_desc'] != null){
            $query = $query."and cargo.des_cargo_basic like('%{$pesquisa['cargo_desc']}%') ";
        }
        if(array_key_exists('status_desc', $pesquisa) && $pesquisa['status_desc'] != null){
            if( $this->obtStatusByDesc($pesquisa['status_desc'], $tipo_table) !== false ){
                $query = $query."and orc_lotac.status = {$this->obtStatusByDesc($pesquisa['status_desc'], $tipo_table)} ";
            }    
        }
        
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

        $tipo_user = $this->getUserFromCurrentGuard()->tipo;

        $repo = $this->getRepository()->getModelEntity()::with([
                'getOrcamento'=>function($query){                    
                } 
            ])->where('orc_id', '=', $orc_id)            
            ->first();
        if(!$repo){
            return "Orçamento não encontrado!";
        }

        $set_orcamento = $this->getRepository()->setOrcamento($repo->getOrcamento);
        if(!$this->getRepository()->isOwn()){
            dd("adicionar mensagem q não tem permissão");
        }
        DB::enableQueryLog();

        
        $pag = true;
        $off_set = 0;
        if($qtd != 0){
            $off_set = $qtd * ($ind);// onde vai começar
            //$quantidade = (qtd * ($ind+1)) + 1;
        }
        
        $paginacao = $pag == false ? "" : " order by orc_lotac.id asc OFFSET {$off_set} ROWS FETCH NEXT {$qtd} ROWS ONLY";

        $user = $this->getUserFromCurrentGuard();
        $mostrar_calculo_nao_liberado = '';
        if($user->tipo != 3){
            $mostrar_calculo_nao_liberado = 'orc_lotac.status >= '.$tbl_orc_lotacao_controller->getRepository()->getStatusLotCalculadoLiberado().' and ';
        }


        $data =  DB::select ("SELECT   
                            orc_lotac.orcamento_id,
                            orc_lotac.id as orc_lot_id,
                            orc_lotac.lotacao_id,
                            orc_lotac.cc_custo_id,
                            lotac.unid_lotac as lotac_cod,
                            centro_custo.cod_ccusto,
                            valores_calc.natureza_hash_id as natureza,
                            cargo.id as cargo_id,
                            cargo.des_cargo_basic as cargo_desc,
                            orc_lotac.status as status_id,
                         CASE orc_lotac.status 
                                    WHEN   1 THEN 'Pendente de c'
                                    WHEN   2 THEN 'Reaberto'
                                    WHEN   3 THEN 'Enviado'
                                    WHEN   4 THEN 'Conferido'
                                    WHEN   5 THEN 'Calculado'
                                    WHEN   6 THEN 'Calculado e liberado'
                                    WHEN   7 THEN 'Aprovado'
                                    -- WHEN   8 THEN 'Aprovado pelo diretor'
                                    WHEN   9 THEN  IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Pendente de digitação')
                                    WHEN   10 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Reaberto')
                                    WHEN   11 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Enviado')
                                    WHEN   12 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Conferido')
                                    WHEN   13 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Calculado')
                                    WHEN   14 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Calculado e liberado')
                                    WHEN   15 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Aprovado')
                                END  as status_desc,


                    -- valores_calc.jan_val_total,valores_calc.fev_val_total,valores_calc.mar_val_total,
                    -- valores_calc.abr_val_total,valores_calc.mai_val_total,valores_calc.jun_val_total,
                    -- valores_calc.jul_val_total,valores_calc.ago_val_total,valores_calc.set_val_total,
                    -- valores_calc.out_val_total,valores_calc.nov_val_total,valores_calc.dez_val_total,

                    
                    SUM ( COALESCE(valores_calc.jan_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as jan_val_total,
                    SUM ( COALESCE(valores_calc.fev_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as fev_val_total,
                    SUM ( COALESCE(valores_calc.mar_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as mar_val_total,
                    SUM ( COALESCE(valores_calc.abr_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as abr_val_total,
                    SUM ( COALESCE(valores_calc.mai_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as mai_val_total,
                    SUM ( COALESCE(valores_calc.jun_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as jun_val_total,

                    SUM ( COALESCE(valores_calc.jul_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as jul_val_total,
                    SUM ( COALESCE(valores_calc.ago_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as ago_val_total,
                    SUM ( COALESCE(valores_calc.set_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as set_val_total,
                    SUM ( COALESCE(valores_calc.out_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as out_val_total,
                    SUM ( COALESCE(valores_calc.nov_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as nov_val_total,
                    SUM ( COALESCE(valores_calc.dez_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as dez_val_total,
                    
     
                    --orc_head.id,
                    SUM ( COALESCE(valores_calc.jan_val_total,0) + COALESCE(valores_calc.fev_val_total,0) + COALESCE(valores_calc.mar_val_total,0) +
                          COALESCE(valores_calc.abr_val_total,0) + COALESCE(valores_calc.mai_val_total,0) + COALESCE(valores_calc.jun_val_total,0) +
                          COALESCE(valores_calc.jul_val_total,0) + COALESCE(valores_calc.ago_val_total,0) + COALESCE(valores_calc.set_val_total,0) +
                          COALESCE(valores_calc.out_val_total,0) + COALESCE(valores_calc.nov_val_total,0) + COALESCE(valores_calc.dez_val_total,0)
                           )  OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) AS total_orc,
     
                    valores_calc.l_sec as secreto,

                    SUM ( COALESCE(valores_calc.jan_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_jan,
                    SUM ( COALESCE(valores_calc.fev_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_fev,
                    SUM ( COALESCE(valores_calc.mar_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_mar,
                    SUM ( COALESCE(valores_calc.abr_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_abr,
                    SUM ( COALESCE(valores_calc.mai_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_mai,
                    SUM ( COALESCE(valores_calc.jun_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_jun,

                    SUM ( COALESCE(valores_calc.jul_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_jul,
                    SUM ( COALESCE(valores_calc.ago_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_ago,
                    SUM ( COALESCE(valores_calc.set_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_set,
                    SUM ( COALESCE(valores_calc.out_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_out,
                    SUM ( COALESCE(valores_calc.nov_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_nov,
                    SUM ( COALESCE(valores_calc.dez_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_dez,
                   
        
                    SUM ( COALESCE(valores_calc.jan_val_total,0) + COALESCE(valores_calc.fev_val_total,0) + COALESCE(valores_calc.mar_val_total,0) +
                          COALESCE(valores_calc.abr_val_total,0) + COALESCE(valores_calc.mai_val_total,0) + COALESCE(valores_calc.jun_val_total,0) +
                          COALESCE(valores_calc.jul_val_total,0) + COALESCE(valores_calc.ago_val_total,0) + COALESCE(valores_calc.set_val_total,0) +
                          COALESCE(valores_calc.out_val_total,0) + COALESCE(valores_calc.nov_val_total,0) + COALESCE(valores_calc.dez_val_total,0)
                           )  OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) AS soma_tot,
						   
					CASE orc_lotac.status
                        when 3 then IIF({$tipo_user} = 3, 1, 0) --Validando se o tipo do usuÃ¡rio Ã© 3 (tÃ©cnico)
                        when 4 then IIF({$tipo_user} = 3, 1, 0) 
                        when 5 then IIF({$tipo_user} = 3, 1, 0) 
                        when 6 then IIF({$tipo_user} = 3, 1, 0) 
                        -- when 7 then IIF({$tipo_user} = 3, 1, 0) 
                        else 0
                    end as can_reopen_hc,
                    CASE orc_lotac.status
                        when 11 then IIF({$tipo_user} = 3, 1, 0) --Validando se o tipo do usuÃ¡rio Ã© 3 (tÃ©cnico)
                        when 12 then IIF({$tipo_user} = 3, 1, 0) 
                        when 13 then IIF({$tipo_user} = 3, 1, 0) 
                        when 14 then IIF({$tipo_user} = 3, 1, 0) 
                        -- when 7 then IIF({$tipo_user} = 3, 1, 0) 
                        else 0
                    end as can_reopen_fcst,
					CASE orc_lotac.status
                        when 3 then IIF({$tipo_user} = 3, 1, 0) --Validando se o tipo do usuÃ¡rio Ã© 3 (tÃ©cnico)
                        when 4 then IIF({$tipo_user} = 3, 1, 0)
                        when 5 then IIF({$tipo_user} = 3, 1, 0)
                        when 6 then IIF({$tipo_user} = 3, 1, 0)
                        -- when 7 then IIF({$tipo_user} = 3, 1, 0)
                        else 0
                    end as can_calc_hc,		
                    CASE orc_lotac.status
                        when 11 then IIF({$tipo_user} = 3, 1, 0) --Validando se o tipo do usuÃ¡rio Ã© 3 (tÃ©cnico)
                        when 12 then IIF({$tipo_user} = 3, 1, 0)
                        when 13 then IIF({$tipo_user} = 3, 1, 0)
                        when 14 then IIF({$tipo_user} = 3, 1, 0)
                        -- when 7 then IIF({$tipo_user} = 3, 1, 0)
                        else 0
                    end as can_calc_fcst,				
					
					CASE orc_lotac.status
                        when 5 then 1
                        else 0
                    end as can_release_hc,

                    CASE orc_lotac.status
                        when 13 then 1
                        else 0
                    end as can_release_fcst,
					
					CASE orc_lotac.status
                        when 6 then 1
                        else 0
                    end as can_approve_gestor_hc,

                    CASE orc_lotac.status
                        when 14 then 1
                        else 0
                    end as can_approve_gestor_fcst,
                    
                    -- CASE orc_lotac.status
                    --     when 7 then 1
                    --     else 0
                    -- end as can_approve_gestor_diretor,
					    
					CASE orc_lotac.status 
                        WHEN   1 THEN IIF(orc_lotac.hc_iniciado = 0,'Pendente de digitaÃ§Ã£o','Em digitaÃ§Ã£o')
                        WHEN   2 THEN 'Reaberto'
                        WHEN   3 THEN 'Enviado'
                        WHEN   4 THEN 'Conferido'
                        WHEN   5 THEN 'Calculado'
                        WHEN   6 THEN 'Calculado e liberado'
                        WHEN   7 THEN 'Aprovado'
                        -- WHEN   8 THEN 'Aprovado pelo diretor'
                        WHEN   9 THEN IIF(orc_lotac.hc_iniciado = 0,'Pendente de digitaÃ§Ã£o','Em digitaÃ§Ã£o')
                        WHEN   10 THEN 'FCST Reaberto'
                        WHEN   11 THEN 'FCST Enviado'
                        WHEN   12 THEN 'FCST Conferido'
                        WHEN   13 THEN 'FCST Calculado'
                        WHEN   14 THEN 'FCST Calculado e liberado'
                        WHEN   15 THEN 'FCST Aprovado'
                    END  as status

                    

                    from tbl_orc_resultados_calc as valores_calc

                    inner join tbl_orc_lotacao as orc_lotac
                    on orc_lotac.id = valores_calc.orc_lotacao_id

                    -- inner join tbl_orc_lot_carg_headcount as orc_head
                    -- on orc_head.lotacao_id = orc_lotac.id 
                    -- and orc_head.tipo_table = '$tipo_table' 
                    -- and orc_head.orc_cargo_id = valores_calc.orc_cargo_id

                    left join tbl_orc_cargo as orc_cargo
                    on orc_cargo.id = valores_calc.orc_cargo_id

                    left join tbl_cargo as cargo
                    on cargo.id = orc_cargo.cargo_id

                    left join tbl_lotacao as lotac
                    on orc_lotac.lotacao_id = lotac.id

                    left join tbl_ccusto as centro_custo
                    on orc_lotac.cc_custo_id = centro_custo.id

                   

                    where $mostrar_calculo_nao_liberado orc_lotac.orcamento_id = $orc_id and orc_lotac.lotacao_id in ($lotacoes_string) 
                    and valores_calc.tipo_table = '$tipo_table'"
                    .$query.$paginacao 

                    
                );

            // dd("olhaaaaaaaaaaaaaaaaaaaaaa",DB::getQueryLog());
            // dd("data pivo tree",$this->montaTreetableTotOrc($this->pivoTotOrc($data)));
            // dd("daaataaaaaaaaaa", $data);
            return new Response(json_encode($this->montaTreetableTotOrc($this->pivoTotOrc($data))) , 200);

    }

    public function pivoTotOrc($dados){
        $meses_tot=$this->getColumMesesTotOrc();        
        $retorno=[];
        $primary_key=['cc_custo_id', 'lotacao_id', 'cargo_id'];
    
        $merge_meses_evento=[];
        $meses_tot_clear=[];        
        
        $dados_rest = [];
        foreach($dados as $key => $value){
            
            $value=(array)$value;
            $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
            $ja_foi=array_keys($retorno);
            
            if(in_array($keys_values, $ja_foi)===false){                
                $aux=Arr::except($value,$meses_tot);   
                $retorno[$keys_values]=$aux;

            }
            foreach($meses_tot as $j=>$w){                     
                $retorno[$keys_values][$w]=$value[$w];
            }
        }
    //   dd("dadoss", $retorno);
        return $retorno;
    }

    function pivotColumnsTotOrc(){
        $meses_tot =$this->getColumMesesTotOrc() ;
        $eventos_meses = $this->getEventosList();        
        $retorno=[];
        
        $merge_meses_evento=[];
        $meses_tot_clear=[];
        foreach($meses_tot as $key => $value){
            
            $var = explode("_",$value);
            $meses_tot_clear[]=$var[0];

            foreach($eventos_meses as $key_ev =>$value_ev){
                $merge_meses_evento[$var[0]."-".$value_ev->evento_id] = "";
            }
        }
        return  (object)['merged'=>$merge_meses_evento, 'mes_abreviado'=>$meses_tot_clear];
    }



    public function montaTreetableTotOrc($data){
      
        $pivot_colunas=$this->pivotColumnsTotOrc();
        $col_meses=$pivot_colunas->merged;
        $col_set_meses=[];
        $col_meses_parent=[];


        foreach($col_meses as $j=>$mes){
            $col_set_meses[]= ["field_out"=>$j,"from"=>$j, "render_value"=>null,];
            $col_meses_parent[]=["field_out"=>$j,  "from"=>'t_event-'.$j, 
            "field_out_render_func"=>function($row_data,$value, $matrix){

            }];
        }

        $column_fixeds=[ 
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id", "render_value"=>null,],
            ["field_out"=>"orc_lot_id", "from"=>"orc_lot_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"cc_custo_id", "from"=>"cc_custo_id", "render_value"=>null,],
            ["field_out"=>"lotac_cod", "from"=>"lotacao_des", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            // ["field_out"=>"natureza", "from"=>"natureza", "render_value"=>null,],
            // ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            // ["field_out"=>"cargo_desc", "from"=>"cargo_desc", "render_value"=>null,],
            ["field_out"=>"status_id", "from"=>"status_id", "render_value"=>null,],
            ["field_out"=>"status_desc", "from"=>"status_desc", "render_value"=>null,],
            // ["field_out"=>"soma_tot", "from"=>"soma_tot", "render_value"=>null,],
            ["field_out"=>"secreto", "from"=>"secreto", "render_value"=>null,],
            ["field_out"=>"ccontabil_id", "from"=>"ccontabil_id", "render_value"=>null,],
       
            ["field_out"=>"jan", "from"=>"tot_jan", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"fev", "from"=>"tot_fev", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"mar", "from"=>"tot_mar","render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"abr", "from"=>"tot_abr", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"mai", "from"=>"tot_mai", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"jun", "from"=>"tot_jun","render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"jul", "from"=>"tot_jul", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"ago", "from"=>"tot_ago", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"set", "from"=>"tot_set", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"out", "from"=>"tot_out", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"nov", "from"=>"tot_nov", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"dez", "from"=>"tot_dez","render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"total_orc", "from"=>"soma_tot","render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
			 ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"can_fill_hc", "from"=>"can_fill_hc", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_fill_fcst", "from"=>"can_fill_fcst", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_calc_hc", "from"=>"can_calc_hc", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_calc_fcst", "from"=>"can_calc_fcst", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_release_hc", "from"=>"can_release_hc", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_release_fcst", "from"=>"can_release_fcst", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_approve_gestor_hc", "from"=>"can_approve_gestor_hc", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_approve_gestor_fcst", "from"=>"can_approve_gestor_fcst", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_approve_gestor_diretor", "from"=>"can_approve_gestor_diretor", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_approve_gestor_diretor_fcst", "from"=>"can_approve_gestor_diretor", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_reopen_hc", "from"=>"can_reopen_hc", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_reopen_hc", "from"=>"can_reopen_hc", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_reopen_fcst", "from"=>"can_reopen_fcst", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_aprovar_hc", "from"=>"can_aprovar_hc", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
            ["field_out"=>"can_aprovar_fcst", "from"=>"can_aprovar_fcst", "render_value"=>function($row_data, $value){
                return boolval($value);
            },],
     
            ["field_out"=>"status", "from"=>"status", "render_value"=>null,]

           
           

        ];

        $column_fixeds_children=[ 
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id", "render_value"=>null,],
            ["field_out"=>"orc_lot_id", "from"=>"orc_lot_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"cc_custo_id", "from"=>"cc_custo_id", "render_value"=>null,],
            ["field_out"=>"lotac_cod", "from"=>"lotac_cod", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"natureza", "from"=>"natureza", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"cargo_desc", "from"=>"cargo_desc", "render_value"=>null,],

            ["field_out"=>"ccontabil_id", "from"=>"ccontabil_id", "render_value"=>null,],
            // ["field_out"=>"status_id", "from"=>"status_id", "render_value"=>null,],
            // ["field_out"=>"status_desc", "from"=>"status_desc", "render_value"=>null,],
            ["field_out"=>"total_orc", "from"=>"total_orc", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value, 4, ',', '.'));
            },],
            ["field_out"=>"secreto", "from"=>"secreto", "render_value"=>null,],

		    ["field_out"=>"jan", "from"=>"jan_val_total", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value, 4, ',', '.'));
            },],
            ["field_out"=>"fev", "from"=>"fev_val_total", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value, 4, ',', '.'));
            },],
            ["field_out"=>"mar", "from"=>"mar_val_total","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value, 4, ',', '.'));
            },],
            ["field_out"=>"abr", "from"=>"abr_val_total", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value, 4, ',', '.'));
            },],
            ["field_out"=>"mai", "from"=>"mai_val_total", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value, 4, ',', '.'));
            },],
            ["field_out"=>"jun", "from"=>"jun_val_total","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value, 4, ',', '.'));
            },],
            ["field_out"=>"jul", "from"=>"jul_val_total", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value, 4, ',', '.'));
            },],
            ["field_out"=>"ago", "from"=>"ago_val_total", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value, 4, ',', '.'));
            },],
            ["field_out"=>"set", "from"=>"set_val_total", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value, 4, ',', '.'));
            },],
            ["field_out"=>"out", "from"=>"out_val_total", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value, 4, ',', '.'));
            },],
            ["field_out"=>"nov", "from"=>"nov_val_total", "render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value, 4, ',', '.'));
            },],
            ["field_out"=>"dez", "from"=>"dez_val_total","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro(number_format($value, 4, ',', '.'));
            },],
		   

        ];

        
        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        // dd("dataaaaaaaaaaaaaaaaaaa", $data);
        $settings=["columns"=>$columns_base,
		"keys"=>['cc_custo_id', 'orc_lot_id'],
                
             "children"=>["columns"=>$columns_children,
                    "keys"=>['cc_custo_id', 'cod_ccusto', 'orc_lot_id', 'lotac_cod', 'cargo_id', 'ccontabil_id'],
                    "filter_data"=>[
                        'cc_custo_id'=>function($value){
                            return !is_null($value);
                        },
                        'cod_ccusto'=>function($value){
                            return !is_null($value);
                        },
                        'lotacao_id'=>function($value){
                            return !is_null($value);
                        },
                        'lotac_cod'=>function($value){
                            return !is_null($value);
                        },
                        'cargo_id'=>function($value){
                            return !is_null($value);
                        },
                        'ccontabil_id'=>function($value){
                            return !is_null($value);
                        }
                    ],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result = ($value['cc_custo_id'] == $parent_data['cc_custo_id'] && 
                            $value['lotacao_id'] == $parent_data['lotacao_id'] 
                        );
                        
                        return $result;
                    },
                

                ]
            ];
            // dd("entrou aaaaaaa");
        $controller=new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
    }


  
    public function getJustificativaHc($orc_id, $lotacao_id, $cargo_id, $coluna, $periodo, $tipo_table){
        $justificativa = new OrcDiarioBordo();
        $contratacao = new OrcHeadcountContratacoes();
        $demissao = new OrcHeadcountDemissoes();
        $promocao = new OrcPromocao();
        $orc_cargo =  new OrcCargo();
        $demissao = new OrcHeadcountDemissoes();
        $promocao = new OrcPromocao();
        
        $orc_cargo_id  = $orc_cargo->select($orc_cargo->getColunaAlias('id'))->where([
            [$orc_cargo->getColunaAlias('orcamento_id'),'=', $orc_id],
            [$orc_cargo->getColunaAlias('cargo_id'),'=', $cargo_id],
            [$orc_cargo->getColunaAlias('tipo_table'),'=', $tipo_table]
        ]);

        if($tipo_table == 'F'){
            $orc_cargo_id = $orc_cargo_id->where([
                [$orc_cargo->getColunaAlias('periodo'), $periodo]
            ])->first();
        }
        else{
            $orc_cargo_id = $orc_cargo_id->whereNull($orc_cargo->getColunaAlias('periodo'))->first();
        }
        
        //$tipo_table = $tipo_table != "F" ? "O" : $tipo_table;
        //dd($orc_cargo_id->id);
        if($coluna == 'tot_contratacoes'){

            $contratacoes = $contratacao->select()->where([
                [$contratacao->getColunaAlias('orcamento_id'),'=', $orc_id],
                [$contratacao->getColunaAlias('lotacao_id'),'=', $lotacao_id],
                [$contratacao->getColunaAlias('orc_cargo_id'),'=', $orc_cargo_id->id],
                //[$contratacao->getColunaAlias('periodo'), '=', $periodo == 0 ? null : $periodo],
                [$contratacao->getColunaAlias('tipo_table'), '=', $tipo_table]
            ])->get()->toArray();
            
            $all_justifificativas = $justificativa->select()->where([
                [$justificativa->getColunaAlias('orcamento_id'),'=', $orc_id],
                [$justificativa->getColunaAlias('tbl_origem'),'=', 'tbl_orc_headcount_contratacoes'],
            ])
            ->where([
                ['periodo', '=', $periodo == 0 ? null : $periodo],
                ['tipo_table', '=', $tipo_table]
            ])
            ->whereIn($justificativa->getColunaAlias('registro_id'),array_column($contratacoes,'id'))->get();

        }

        if($coluna == 'tot_demissoes'){

            $demissoes = $demissao->select()->where([
                [$demissao->getColunaAlias('orcamento_id'),'=', $orc_id],
                [$demissao->getColunaAlias('lotacao_id'),'=', $lotacao_id],
                [$demissao->getColunaAlias('orc_cargo_id'),'=', $orc_cargo_id->id]
            ])->where([
                ['periodo', '=', $periodo == 0 ? null : $periodo],
                ['tipo_table', '=', $tipo_table]
            ])->get()->toArray();

            $all_justifificativas =$justificativa->select()->where([
                [$justificativa->getColunaAlias('orcamento_id'),'=', $orc_id],
                [$justificativa->getColunaAlias('tbl_origem'),'=', 'tbl_orc_headcount_demissoes'],
            ])
            ->where([
                ['periodo', '=', $periodo == 0 ? null : $periodo],
                ['tipo_table', '=', $tipo_table]
            ])
            ->whereIn($justificativa->getColunaAlias('registro_id'),array_column($demissoes,'id'))->get();
        }

        if($coluna == 'tot_promocoes'){
            
            $promocoes = $promocao->select()->where([
                [$promocao->getColunaAlias('orc_id'),'=', $orc_id],
                [$promocao->getColunaAlias('lotacao_id'),'=', $lotacao_id],
                [$promocao->getColunaAlias('cargo_atual_id'),'=', $orc_cargo_id->id]
            ])
            ->orWhere([
                [$promocao->getColunaAlias('orc_id'),'=', $orc_id],
                [$promocao->getColunaAlias('lotacao_promovida_id'),'=', $lotacao_id],
                [$promocao->getColunaAlias('cargo_promovido_id'),'=', $orc_cargo_id->id]
            ])
            ->where([
                ['periodo', '=', $periodo == 0 ? null : $periodo],
                ['tipo_table', '=', $tipo_table]
            ])->get()->toArray();
            
            $ids = array_column($promocoes,'id');
            //$id_string = implode(', ', $ids);
            
            $all_justifificativas =$justificativa->select()->where([
                [$justificativa->getColunaAlias('orcamento_id'),'=', $orc_id],
                [$justificativa->getColunaAlias('tbl_origem'),'=', 'tbl_orc_promocao'],
            ])
            ->where([
                ['periodo', '=', $periodo == 0 ? null : $periodo],
                ['tipo_table', '=', $tipo_table]
            ])
            ->whereIn($justificativa->getColunaAlias('registro_id'), $ids )->get();
        }
        return $all_justifificativas; 

    }
    
    public function getJustificativasExport($orc_id, $periodo = null, $tipo_table = 'O'){
        $tbl_orc_lotacao_controller = new OrcLotacaoController();

        $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
        $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        $diario_bordo = new OrcDiarioBordo;
        $orc_lotacao = new OrcLotacao;
        $dado = null;// AQUI
        $lotacao = new Lotacao;
        $ccusto = new CentroCusto;

        $dadosExport = $diario_bordo
        ->join($orc_lotacao->getTable(),$orc_lotacao->getColunaAlias('id'), $diario_bordo->getColunaAlias('lotacao_id'))
        ->join($lotacao->getTable(),$lotacao->getColunaAlias('id'), $orc_lotacao->getColunaAlias('lotacao_id'))
        ->join($ccusto->getTable(), $ccusto->getColunaAlias('id'), $orc_lotacao->getColunaAlias('cc_custo_id'))
        ->whereIn($orc_lotacao->getColunaAlias('lotacao_id'),$lotacoes)
        ->where($diario_bordo->getColunaAlias('orcamento_id'), $orc_id)
        ->where($diario_bordo->getColunaAlias('tipo_table'), $tipo_table);
        
        if($tipo_table == 'F'){
            $periodo_desc = $this->getRepository()->montaPeriodo($periodo, $orc_id);
            $dadosExport = $dadosExport->where($diario_bordo->getColunaAlias('periodo'), $periodo_desc)->get()->toArray();
        }
        else{
            $dadosExport = $dadosExport->whereNull($diario_bordo->getColunaAlias('periodo'))->get()->toArray();
        }
        $dadosReturn=[];

        for($i = 0; $i < count($dadosExport); $i++){
            
            DB::enableQueryLog();
        
          
            if($dadosExport[$i]['tbl_origem'] == 'tbl_orc_ferias'){
                $dados = DB::select("
                select * from 
                ". $dadosExport[$i]['tbl_origem'] . " tbl 
                
                join tbl_orc_cargo as orc_cargo on orc_cargo.id = tbl.cargo_id
                join tbl_cargo as cargo on cargo.id = orc_cargo.cargo_id
                
                where tbl.id =" . $dadosExport[$i]['registro_id']);
    
                if(empty($dados)){
                    unset($dadosExport[$i]);
                    continue;
                }
    
                $dadosExport[$i]['cargo']=$dados[0]->cod_cargo_basic. ' - '. $dados[0]->des_cargo_basic;
                $dadosExport[$i]['tbl_origem'] = 'Férias';
           }
           else if($dadosExport[$i]['tbl_origem'] == 'tbl_orc_headcount_demissoes'){
            $dados = DB::select("
            select * from 
            ". $dadosExport[$i]['tbl_origem'] . " tbl 
            
            join tbl_orc_cargo as orc_cargo on orc_cargo.id = tbl.orc_cargo_id
            join tbl_cargo as cargo on cargo.id = orc_cargo.cargo_id
            
            where tbl.id =" . $dadosExport[$i]['registro_id']);

            if(empty($dados)){
                unset($dadosExport[$i]);
                continue;
            }

            $dadosExport[$i]['cargo']=$dados[0]->cod_cargo_basic. ' - '. $dados[0]->des_cargo_basic;
                $dadosExport[$i]['tbl_origem'] = 'Demissões';
           }
           else if($dadosExport[$i]['tbl_origem'] == 'tbl_orc_promocao'){
            $dados = DB::select("
            select * from 
            ". $dadosExport[$i]['tbl_origem'] . " tbl 
            
            join tbl_orc_cargo as orc_cargo on orc_cargo.id = tbl.cargo_atual_id
            join tbl_cargo as cargo on cargo.id = orc_cargo.cargo_id
            
            where tbl.id =" . $dadosExport[$i]['registro_id']);

            if(empty($dados)){
                unset($dadosExport[$i]);
                continue;
            }

            $dadosExport[$i]['cargo']=$dados[0]->cod_cargo_basic. ' - '. $dados[0]->des_cargo_basic;
                $dadosExport[$i]['tbl_origem'] = 'Promoções/Transferências';
           }
           else if($dadosExport[$i]['tbl_origem'] == 'tbl_orc_salario_funcionario'){
            $dados = DB::select("
            select * from 
            ". $dadosExport[$i]['tbl_origem'] . " tbl 
            
            join tbl_orc_cargo as orc_cargo on orc_cargo.id = tbl.orc_cargo_id
            join tbl_cargo as cargo on cargo.id = orc_cargo.cargo_id
            
            where tbl.id =" . $dadosExport[$i]['registro_id']);

            if(empty($dados)){
                unset($dadosExport[$i]);
                continue;
            }

            $dadosExport[$i]['cargo']=$dados[0]->cod_cargo_basic. ' - '. $dados[0]->des_cargo_basic;
                $dadosExport[$i]['tbl_origem'] = 'Aumento salarial';
           }
           else if($dadosExport[$i]['tbl_origem'] == 'tbl_headcount_hra_extra'){
            $dados = DB::select("
            select * from 
            ". $dadosExport[$i]['tbl_origem'] . " tbl 
            
            join tbl_orc_cargo as orc_cargo on orc_cargo.id = tbl.orc_cargo_id
            join tbl_cargo as cargo on cargo.id = orc_cargo.cargo_id
            
            where tbl.id =" . $dadosExport[$i]['registro_id']);

            if(empty($dados)){
                unset($dadosExport[$i]);
                continue;
            }

            $dadosExport[$i]['cargo']=$dados[0]->cod_cargo_basic. ' - '. $dados[0]->des_cargo_basic;

                $dadosExport[$i]['tbl_origem'] = 'Horas extras gerenciáveis';
           } 
           else if($dadosExport[$i]['tbl_origem'] == 'tbl_orc_headcount_contratacoes'){
            $dados = DB::select("
            select * from 
            ". $dadosExport[$i]['tbl_origem'] . " tbl 
            
            join tbl_orc_cargo as orc_cargo on orc_cargo.id = tbl.orc_cargo_id
            join tbl_cargo as cargo on cargo.id = orc_cargo.cargo_id
            
            where tbl.id =" . $dadosExport[$i]['registro_id']);

            if(empty($dados)){
                unset($dadosExport[$i]);
                continue;
            }

            $dadosExport[$i]['cargo']=$dados[0]->cod_cargo_basic. ' - '. $dados[0]->des_cargo_basic;

                $dadosExport[$i]['tbl_origem'] = 'Contratações';
           }

           array_push($dadosReturn,$dadosExport[$i]);
      
         }

       return $dadosReturn;
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'Notificacoes',['l_ok', 'metodo_origem', 'observacao']);
    }

    public function downloadExcelJustificativa($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'Justificativas',['orc_lotacao_id_origem','tipo_table','periodo','cc_custo_id_origem','lotacao_id_origem','has_transf','status_forecast','origem','quadro_atual','ativo','substituto','dat_inic_valid','dat_fim_valid','lotacao_id', 'usuario_id', 'registro_id', 'coluna_origem','responder_orc', 'cc_custo_id', 'Status', 'hc_iniciado', 'has_error_calc', 'status']);
    }

    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("unid_lotac", "Código Lotação", $colunas[$i]);

            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("orc id", "Orçamento", $colunas[$i]);
            $colunas[$i] = str_replace("mensagem", "Notificação", $colunas[$i]);
            $colunas[$i] = str_replace("tipo", "Tipo", $colunas[$i]);
            $colunas[$i] = str_replace("tot demissoes", "Total demissões", $colunas[$i]);
            $colunas[$i] = str_replace("tot promocoes", "Total promoções", $colunas[$i]);
            $colunas[$i] = str_replace("vlr maximo", "valor maximo", $colunas[$i]);
            $colunas[$i] = str_replace("status", "Status", $colunas[$i]);
            $colunas[$i] = str_replace("cod ccusto", "Código Centro de custo", $colunas[$i]);
            $colunas[$i] = str_replace("des unid lotac", "Lotação", $colunas[$i]);
            $colunas[$i] = str_replace("des ccusto", "Centro de custo", $colunas[$i]);
            $colunas[$i] = str_replace("cargo", "Cargo", $colunas[$i]);

            //$colunas[$i] = str_replace("descricao", "Descrição", $colunas[$i]);
            
            $colunas[$i] = str_replace("descricao", "Mensagem", $colunas[$i]);
            $colunas[$i] = str_replace("desc", "", $colunas[$i]);
            $colunas[$i] = str_replace("des", "", $colunas[$i]);
            $colunas[$i] = str_replace("exibicao", "descrição", $colunas[$i]);

            $colunas[$i] = str_replace("jan", "Janeiro", $colunas[$i]);
            $colunas[$i] = str_replace("fev", "Fevereiro", $colunas[$i]);
            $colunas[$i] = str_replace("mar", "Março", $colunas[$i]);
            $colunas[$i] = str_replace("abr", "Abril", $colunas[$i]);
            $colunas[$i] = str_replace("mai", "Maio", $colunas[$i]);
            $colunas[$i] = str_replace("jun", "Junho", $colunas[$i]);
            $colunas[$i] = str_replace("jul", "Julho", $colunas[$i]);
            $colunas[$i] = str_replace("ago", "Agosto", $colunas[$i]);
            $colunas[$i] = str_replace("set", "Setembro", $colunas[$i]);
            $colunas[$i] = str_replace("out", "Outubro", $colunas[$i]);
            $colunas[$i] = str_replace("nov", "Novembro", $colunas[$i]);
            $colunas[$i] = str_replace("dez", "Dezembro", $colunas[$i]);

            $colunas[$i] = str_replace("orcamento id", "Orçamento", $colunas[$i]);
            $colunas[$i] = str_replace("tbl origem", "Origem", $colunas[$i]);
            $colunas[$i] = str_replace("titulo", "Título", $colunas[$i]);
            $colunas[$i] = str_replace("lotac cod", "Código Lotação", $colunas[$i]);
            $colunas[$i] = str_replace("total orc", "Total", $colunas[$i]);




        }
        return $colunas;
    }

    public function downloadExcelValOrc($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'historicoOrcamento', ['orc_lot_id', 'lotacao_id', 'ccontabil_id', 'cc_custo_id','Status_id', 'secreto', 'orc_turma_id', 'ccusto_id','cargo_id', 'can_fill_hc', 'can_calc_hc', 'can_release_hc', 'can_approve_gestor_hc', 'can_approva_gestor_diretor', 'can_reopen_hc', 'Status' ]);
    }// Valores_Orcamento
    public function downloadExcelValForecast($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'historicoForecast', ['orc_lot_id', 'lotacao_id', 'ccontabil_id', 'cc_custo_id','Status_id', 'secreto', 'orc_turma_id', 'ccusto_id','cargo_id', 'can_fill_hc', 'can_calc_hc', 'can_release_hc', 'can_approve_gestor_hc', 'can_approva_gestor_diretor', 'can_reopen_hc', 'Status' ]);
    }// Valores_Forecast

    public function getNaturezasHC($orc_id){
        $param_natureza = new OrcParamNatureza();

        
        $naturezas = $param_natureza
        ->where('orcamento_id', $orc_id)
        ->orderBy('ordem_execucao')
        ->get()->toArray();
        $naturezas =  $this->getNaturezaUnique($naturezas);
        // dd($naturezas[0]);
        array_push($naturezas,  [
            "hash_id" => "DESPESAS_ADICIONAIS",
            "handle_sql" => "sp_hnd_despesas_adicionais",
            "handle_arguments" => "despesas_adicionais"
          ]);
        

        return $naturezas;
          
    }

    public function getNaturezaUnique($naturezas){
        $hashs = array_column($naturezas, 'hash_id');
        $hashs_unicas = array_unique($hashs);
        $array_unico = [];
        foreach ($hashs_unicas as $hash) {
            foreach ($naturezas as $natureza) {
                if($natureza['hash_id'] == $hash){
                    array_push($array_unico, $natureza);
                    break;
                }
            }
        }
        return $array_unico;

    }
    public function listarNotificacoesHeadcount($orc_id, $periodo, $tipo_table){
        // NÃO É TREETABLE
        $resp = $this->getRepository()->listarNotificacoesHeadcount($orc_id, $periodo, $tipo_table);
        return $resp;
    }
    public function downloadExcelNotificacaoHeadcount($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'Notificacao_headcount', ['id','orc_lotacao_id','orc_id','tipo_aprovacao','situacao','user_aprovador_id','user_pendencia_id','data_hora','unid_lotac','des_unid_lotac']);
    }

    public function listarTotOrcDois(Request $request, $orc_id, $ind, $qtd, $periodo, $tipo_table){
        
        set_time_limit($this->getTimeOut());
        $this->setCodTela('HOME');
		$this->podeAcessar('listar',true,$this->getCodTela());

        $pesquisa = $request->all();
        $data = "{$periodo}-01";
        if($tipo_table != null && $tipo_table == 'F'){
            $periodo = substr($periodo, 5, 2);
        }
        
        $msg = '';
        $where_periodo = ($periodo == null || $periodo == 'null' || $periodo == 0) ? '' : ' and month(valores_calc.periodo) = ' . $periodo;  
        
        $repo = null;
        if($tipo_table == 'F'){
            $repo = $this->getRepository()->getModelEntity()::with([
                'getOrcamento'=>function($query){                    
                } 
            ])->where([
                ['orc_id', '=', $orc_id],
                ['tipo_table', '=', $tipo_table],
                ['periodo', '=', $data]
            ])
            ->first();
            $msg = 'Forecast não encontrado!';
        }
        else{
            $repo = $this->getRepository()->getModelEntity()::with([
                'getOrcamento'=>function($query){                    
                } 
            ])->where([
                ['orc_id', '=', $orc_id],
                ['tipo_table', '=', $tipo_table]
            ])
            ->first();
            $msg = 'Headcount não encontrado!';
        }

        if(!$repo){
            $msg = array('msg'=>$msg, 'submsg'=>'Atenção', 'status'=>'warning');
            return new Response(json_encode($msg), 500);
        }

        $set_orcamento = $this->getRepository()->setOrcamento($repo->getOrcamento);
        if(!$this->getRepository()->isOwn()){
            $msg = array('msg'=>'Acesso negado! Você não possui permissão.', 'submsg'=>'Atenção', 'status'=>'warning');
            return new Response(json_encode($msg), 500);
        }

        // ($periodo == 0) ? $where_periodo = '' : $where_periodo;
        
        unset($pesquisa['_token']);
        $query = "";
        
        if(array_key_exists('lotac_cod', $pesquisa) && $pesquisa['lotac_cod'] != null){
            $query = " and lotac.unid_lotac like('%{$pesquisa['lotac_cod']}%') or lotac.des_unid_lotac like('%{$pesquisa['lotac_cod']}%') ";
        }
        if(array_key_exists('cod_ccusto', $pesquisa) && $pesquisa['cod_ccusto'] != null){
            $query = $query."and centro_custo.cod_ccusto like('%{$pesquisa['cod_ccusto']}%') ";
        }
        if(array_key_exists('natureza', $pesquisa) && $pesquisa['natureza'] != null){
            $query = $query."and valores_calc.natureza_hash_id = cast({$pesquisa['natureza']} as varchar) ";
        }
        if(array_key_exists('cargo_desc', $pesquisa) && $pesquisa['cargo_desc'] != null){
            $query = $query."and cargo.des_cargo_basic like('%{$pesquisa['cargo_desc']}%') or cargo.cod_cargo_basic like('%{$pesquisa['cargo_desc']}%')";
        }
        if(array_key_exists('status_desc', $pesquisa) && $pesquisa['status_desc'] != null){
            if( $this->obtStatusByDesc($pesquisa['status_desc'],$tipo_table) !== false ){
                $query = $query."and orc_lotac.status = {$this->obtStatusByDesc($pesquisa['status_desc'],$tipo_table)} ";
            }    
        }
        
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $data, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

        $tipo_user = $this->getUserFromCurrentGuard()->tipo;

        
        DB::enableQueryLog();

        
        $pag = true;
        $off_set = 0;
        if($qtd != 0){
            $off_set = $qtd * ($ind);// onde vai começar
            //$quantidade = (qtd * ($ind+1)) + 1;
        }
                
        $user = $this->getUserFromCurrentGuard();
        $mostrar_calculo_nao_liberado = '';
        if($user->tipo != 3){
            $mostrar_calculo_nao_liberado = 'orc_lotac.status >= '.$tbl_orc_lotacao_controller->getRepository()->getStatusLotCalculadoLiberado().' and ';
        }

        $paginacao = $pag == false ? "" : " order by orc_lotac.id asc OFFSET {$off_set} ROWS FETCH NEXT {$qtd} ROWS ONLY";

        $data =  DB::select ("SELECT distinct
                            orc_lotac.orcamento_id,
                            orc_lotac.id as orc_lot_id,
                            --orc_lotac.lotacao_id,
                            orc_lotac.cc_custo_id,
                            concat(lotac.unid_lotac,' - ', lotac.des_unid_lotac) as lotacao_des,
                            lotac.unid_lotac as unid_lotac,
                            --concat(centro_custo.cod_ccusto, ' - ', centro_custo.des_ccusto) as ccusto
                            centro_custo.cod_ccusto as ccusto,
                            valores_calc.periodo,
                            orc_lotac.status as aaaaaaaaaaaa,
                            CASE orc_lotac.status 
                                    WHEN   1 THEN 'Pendente de digitação'
                                    WHEN   2 THEN 'Reaberto'
                                    WHEN   3 THEN 'Enviado'
                                    WHEN   4 THEN 'Conferido'
                                    WHEN   5 THEN 'Calculado'
                                    WHEN   6 THEN 'Calculado e liberado'
                                    WHEN   7 THEN 'Aprovado'
                                    -- WHEN   8 THEN 'Aprovado pelo diretor'
                                    WHEN   9 THEN  IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Pendente de digitação')
                                    WHEN   10 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Reaberto')
                                    WHEN   11 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Enviado')
                                    WHEN   12 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Conferido')
                                    WHEN   13 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Calculado')
                                    WHEN   14 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Calculado e liberado')
                                    WHEN   15 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Aprovado')
                            END  as status_desc,


                            CASE orc_lotac.status
                                when 3 then IIF({$tipo_user} = 3, 1, 0) --Validando se o tipo do usuÃ¡rio Ã© 3 (tÃ©cnico)
                                when 4 then IIF({$tipo_user} = 3, 1, 0) 
                                when 5 then IIF({$tipo_user} = 3, 1, 0) 
                                when 6 then IIF({$tipo_user} = 3, 1, 0) 
                                -- when 7 then IIF({$tipo_user} = 3, 1, 0) 
                                else 0
                            end as can_reopen_hc,

                            CASE orc_lotac.status
                                -- when 9 then IIF({$tipo_user} = 3, 1, 0) --Validando se o tipo do usuÃ¡rio Ã© 3 (tÃ©cnico)
                                -- when 10 then IIF({$tipo_user} = 3, 1, 0) 
                                when 11 then IIF({$tipo_user} = 3, 1, 0) 
                                when 12 then IIF({$tipo_user} = 3, 1, 0) 
                                when 13 then IIF({$tipo_user} = 3, 1, 0) 
                                when 14 then IIF({$tipo_user} = 3, 1, 0) 
                                -- when 7 then IIF({$tipo_user} = 3, 1, 0) 
                                else 0
                            end as can_reopen_fcst,

                            CASE orc_lotac.status
                                when 3 then IIF({$tipo_user} = 3, 1, 0) --Validando se o tipo do usuÃ¡rio Ã© 3 (tÃ©cnico)
                                when 4 then IIF({$tipo_user} = 3, 1, 0)
                                when 5 then IIF({$tipo_user} = 3, 1, 0)
                                when 6 then IIF({$tipo_user} = 3, 1, 0)
                                -- when 7 then IIF({$tipo_user} = 3, 1, 0)
                                else 0
                            end as can_calc_hc,		

                            CASE orc_lotac.status
                                when 11 then IIF({$tipo_user} = 3, 1, 0) --Validando se o tipo do usuÃ¡rio Ã© 3 (tÃ©cnico)
                                when 12 then IIF({$tipo_user} = 3, 1, 0)
                                when 13 then IIF({$tipo_user} = 3, 1, 0)
                                when 14 then IIF({$tipo_user} = 3, 1, 0)
                                -- when 7 then IIF({$tipo_user} = 3, 1, 0)
                                else 0
                            end as can_calc_fcst,				

                            CASE orc_lotac.status
                                when 5 then 1
                                else 0
                            end as can_release_hc,

                            CASE orc_lotac.status
                                when 13 then 1
                                else 0
                            end as can_release_fcst,

                            CASE orc_lotac.status
                                when 6 then 1
                                else 0
                            end as can_approve_gestor_hc,

                            CASE orc_lotac.status
                                when 14 then 1
                                else 0
                            end as can_approve_gestor_fcst,

                    -- CASE orc_lotac.status
                    --     when 7 then 1
                    --     else 0
                    -- end as can_approve_gestor_diretor,

                    (select top 1
                                IIF(orc_lotac.status = 6, IIF(tbl_notificacao.situacao = 1, 1, 0), 0)
                                from		  
                                    tbl_notificacao where tbl_notificacao.orc_lotacao_id = orc_lotac.id and tbl_notificacao.orc_id = orc_lotac.orcamento_id and tbl_notificacao.tipo_aprovacao = 2 order by tbl_notificacao.data_hora desc , tbl_notificacao.id desc  ) as can_aprovar_hc,

                    (select top 1
                    IIF(orc_lotac.status = 14, IIF(tbl_notificacao.situacao = 4, 1, 0), 0)
                    from		  
                        tbl_notificacao where tbl_notificacao.orc_lotacao_id = orc_lotac.id and tbl_notificacao.orc_id = orc_lotac.orcamento_id and tbl_notificacao.tipo_aprovacao = 4 order by tbl_notificacao.data_hora desc , tbl_notificacao.id desc ) as can_aprovar_fcst,

                    
                    CASE orc_lotac.status 
                                WHEN   1 THEN 'Pendente de digitação'
                                WHEN   2 THEN 'Reaberto'
                                WHEN   3 THEN 'Enviado'
                                WHEN   4 THEN 'Conferido'
                                WHEN   5 THEN 'Calculado'
                                WHEN   6 THEN 'Calculado e liberado'
                                WHEN   7 THEN 'Aprovado'
                                -- WHEN   8 THEN 'Aprovado pelo diretor'
                                WHEN   9 THEN  IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Pendente de digitação')
                                WHEN   10 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Reaberto')
                                WHEN   11 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Enviado')
                                WHEN   12 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Conferido')
                                WHEN   13 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Calculado')
                                WHEN   14 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Calculado e liberado')
                                WHEN   15 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Aprovado')
                        END  as status,           

                        isnull((select top 1

                        CASE tbl_notificacao.situacao 
                            WHEN   1 THEN 'Pendente'
                            WHEN   2 THEN 'Aprovado'
                            WHEN   3 THEN 'Rejeitado'
                            WHEN   4 THEN 'FCST Pendente'
                            WHEN   5 THEN 'FCST Aprovado'
                            WHEN   6 THEN 'FCST Rejeitado'             
                        END 
                        from    tbl_notificacao 

                        where tbl_notificacao.orc_lotacao_id = orc_lotac.id 
                        and tbl_notificacao.orc_id = orc_lotac.orcamento_id 
                        and ((tbl_notificacao.tipo_aprovacao = 2 and orc_lotac.status <9) or (tbl_notificacao.tipo_aprovacao = 4 and orc_lotac.status >=9))
                        order by tbl_notificacao.data_hora desc , tbl_notificacao.id desc ),' - ') as status_aprov,


            --(select SUM(jan_val_total) from tbl_orc_resultados_calc as res_calc where res_calc.orc_lotacao_id = orc_lotac.id )as tot_jan,
            SUM ( COALESCE(valores_calc.jan_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_jan,
            SUM ( COALESCE(valores_calc.fev_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_fev,
            SUM ( COALESCE(valores_calc.mar_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_mar,
            SUM ( COALESCE(valores_calc.abr_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_abr,
            SUM ( COALESCE(valores_calc.mai_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_mai,
            SUM ( COALESCE(valores_calc.jun_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_jun,

            SUM ( COALESCE(valores_calc.jul_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_jul,
            SUM ( COALESCE(valores_calc.ago_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_ago,
            SUM ( COALESCE(valores_calc.set_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_set,
            SUM ( COALESCE(valores_calc.out_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_out,
            SUM ( COALESCE(valores_calc.nov_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_nov,
            SUM ( COALESCE(valores_calc.dez_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_dez,


            SUM ( COALESCE(valores_calc.jan_val_total,0) + COALESCE(valores_calc.fev_val_total,0) + COALESCE(valores_calc.mar_val_total,0) +
                    COALESCE(valores_calc.abr_val_total,0) + COALESCE(valores_calc.mai_val_total,0) + COALESCE(valores_calc.jun_val_total,0) +
                    COALESCE(valores_calc.jul_val_total,0) + COALESCE(valores_calc.ago_val_total,0) + COALESCE(valores_calc.set_val_total,0) +
                    COALESCE(valores_calc.out_val_total,0) + COALESCE(valores_calc.nov_val_total,0) + COALESCE(valores_calc.dez_val_total,0)
                )  OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) AS soma_tot                      

                    from tbl_orc_resultados_calc as valores_calc
                    inner join tbl_orc_lotacao as orc_lotac
                    on orc_lotac.id = valores_calc.orc_lotacao_id and orc_lotac.orcamento_id = {$orc_id}

                    -- inner join tbl_orc_lot_carg_headcount as orc_head
                    -- on orc_head.lotacao_id = orc_lotac.id 
                    -- and orc_head.tipo_table = '{$tipo_table}' 
                    -- and orc_head.orc_cargo_id = valores_calc.orc_cargo_id

                    left join tbl_orc_cargo as orc_cargo
                    on orc_cargo.id = valores_calc.orc_cargo_id and orc_cargo.orcamento_id = {$orc_id}

                    left join tbl_cargo as cargo
                    on cargo.id = orc_cargo.cargo_id

                    left join tbl_lotacao as lotac
                    on orc_lotac.lotacao_id = lotac.id

                    left join tbl_ccusto as centro_custo
                    on orc_lotac.cc_custo_id = centro_custo.id

                    -- left join tbl_notificacao on tbl_notificacao.[orc_lotacao_id] = orc_lotac.[id] and tbl_notificacao.[orc_id] = $orc_id                   

                    where $mostrar_calculo_nao_liberado valores_calc.orcamento_id = $orc_id and valores_calc.tipo_table = '{$tipo_table}' 
                    $where_periodo
                    and orc_lotac.lotacao_id in ($lotacoes_string) ".$query.$paginacao
                );
                // dd("olha",DB::getQueryLog());
            $formatado = [];
            for($i = 0; $i < count($data); $i++){
                $formatado[$i] = (array)$data[$i];
            }
            //return new Response(json_encode($this->montaTreetableTotOrc($this->pivoTotOrc($data))) , 200); antigo
            return new Response(json_encode($this->treetableValores($formatado)) , 200);
    }

    public function listarTotOrcFilhosDois(Request $request, $periodo = null, $tipo_table){
        // dd("listarTotOrcFilhosDois-------->>>>>>");
        set_time_limit($this->getTimeOut());
        $this->setCodTela('HOME');
		$this->podeAcessar('listar',true,$this->getCodTela());
        
        $filhos = $request->all();
        $orc_id = $filhos['orcamento_id'];

        $where = " and valores_calc.orc_lotacao_id = {$filhos['orc_lot_id']} and valores_calc.ccusto_id = {$filhos['cc_custo_id']} and valores_calc.tipo_table = '{$tipo_table}'";
        $where_periodo = $tipo_table == "F" ? " and month(valores_calc.periodo) = $periodo" : "";
        
        $periodo_desc = $tipo_table == 'O' ? null : $this->getRepository()->montaPeriodo($periodo, $orc_id);
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo_desc, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;
        
        $tipo_user = $this->getUserFromCurrentGuard()->tipo;

        $repo = $this->getRepository()->getModelEntity()::with([
                'getOrcamento'=>function($query){                    
                } 
            ])->where('orc_id', '=', $orc_id)            
            ->first();
        if(!$repo){
            return "Orçamento não encontrado!";
        }

        $set_orcamento = $this->getRepository()->setOrcamento($repo->getOrcamento);
        if(!$this->getRepository()->isOwn()){
            dd("adicionar mensagem q não tem permissão");
        }
        DB::enableQueryLog();

        
        $data =  DB::select ("SELECT
            orc_lotac.orcamento_id,
            orc_lotac.id as orc_lot_id,
            orc_lotac.lotacao_id,
            orc_lotac.cc_custo_id,
            lotac.unid_lotac as lotac_cod,
            centro_custo.cod_ccusto,
            valores_calc.natureza_hash_id as natureza,
            cargo.id as cargo_id,
            cargo.des_cargo_basic as cargo_desc,
            orc_lotac.status as status_id,
            concat(lotac.unid_lotac,' - ', lotac.des_unid_lotac) as lotacao_des,

            valores_calc.ccontabil_id as ccontabil_id,

            CASE orc_lotac.status 
                    WHEN   1 THEN 'Pendente de digitação'
                    WHEN   2 THEN 'Reaberto'
                    WHEN   3 THEN 'Enviado'
                    WHEN   4 THEN 'Conferido'
                    WHEN   5 THEN 'Calculado'
                    WHEN   6 THEN 'Calculado e liberado'
                    WHEN   7 THEN 'Aprovado'
                    -- WHEN   8 THEN 'Aprovado pelo diretor'
                    WHEN   9 THEN  IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Pendente de digitação')
                    WHEN   10 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Reaberto')
                    WHEN   11 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Enviado')
                    WHEN   12 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Conferido')
                    WHEN   13 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Calculado')
                    WHEN   14 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Calculado e liberado')
                    WHEN   15 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Aprovado')
            END  as status_desc,
            
            SUM ( COALESCE(valores_calc.jan_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as jan_val_total,
            SUM ( COALESCE(valores_calc.fev_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as fev_val_total,
            SUM ( COALESCE(valores_calc.mar_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as mar_val_total,
            SUM ( COALESCE(valores_calc.abr_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as abr_val_total,
            SUM ( COALESCE(valores_calc.mai_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as mai_val_total,
            SUM ( COALESCE(valores_calc.jun_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as jun_val_total,

            SUM ( COALESCE(valores_calc.jul_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as jul_val_total,
            SUM ( COALESCE(valores_calc.ago_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as ago_val_total,
            SUM ( COALESCE(valores_calc.set_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as set_val_total,
            SUM ( COALESCE(valores_calc.out_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as out_val_total,
            SUM ( COALESCE(valores_calc.nov_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as nov_val_total,
            SUM ( COALESCE(valores_calc.dez_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as dez_val_total,

            --orc_head.id,
            /*sum(jan_val_total + fev_val_total + mar_val_total + abr_val_total + mai_val_total + jun_val_total +
                jul_val_total + ago_val_total + set_val_total + out_val_total + nov_val_total + dez_val_total ) over(partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as total_orc,
            */
            SUM ( COALESCE(valores_calc.jan_val_total,0) + COALESCE(valores_calc.fev_val_total,0) + COALESCE(valores_calc.mar_val_total,0) +
                COALESCE(valores_calc.abr_val_total,0) + COALESCE(valores_calc.mai_val_total,0) + COALESCE(valores_calc.jun_val_total,0) +
                COALESCE(valores_calc.jul_val_total,0) + COALESCE(valores_calc.ago_val_total,0) + COALESCE(valores_calc.set_val_total,0) +
                COALESCE(valores_calc.out_val_total,0) + COALESCE(valores_calc.nov_val_total,0) + COALESCE(valores_calc.dez_val_total,0)
            )  OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id, valores_calc.ccontabil_id, valores_calc.orc_cargo_id) as total_orc,

            --valores_calc.l_sec as secreto,

            SUM ( COALESCE(valores_calc.jan_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_jan,
            SUM ( COALESCE(valores_calc.fev_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_fev,
            SUM ( COALESCE(valores_calc.mar_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_mar,
            SUM ( COALESCE(valores_calc.abr_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_abr,
            SUM ( COALESCE(valores_calc.mai_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_mai,
            SUM ( COALESCE(valores_calc.jun_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_jun,

            SUM ( COALESCE(valores_calc.jul_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_jul,
            SUM ( COALESCE(valores_calc.ago_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_ago,
            SUM ( COALESCE(valores_calc.set_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_set,
            SUM ( COALESCE(valores_calc.out_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_out,
            SUM ( COALESCE(valores_calc.nov_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_nov,
            SUM ( COALESCE(valores_calc.dez_val_total,0) ) OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) as tot_dez,


            SUM ( COALESCE(valores_calc.jan_val_total,0) + COALESCE(valores_calc.fev_val_total,0) + COALESCE(valores_calc.mar_val_total,0) +
                    COALESCE(valores_calc.abr_val_total,0) + COALESCE(valores_calc.mai_val_total,0) + COALESCE(valores_calc.jun_val_total,0) +
                    COALESCE(valores_calc.jul_val_total,0) + COALESCE(valores_calc.ago_val_total,0) + COALESCE(valores_calc.set_val_total,0) +
                    COALESCE(valores_calc.out_val_total,0) + COALESCE(valores_calc.nov_val_total,0) + COALESCE(valores_calc.dez_val_total,0)
                )  OVER( partition by valores_calc.orc_lotacao_id, valores_calc.ccusto_id) AS soma_tot,
            
            CASE orc_lotac.status
                when 3 then IIF({$tipo_user} = 3, 1, 0) --Validando se o tipo do usuÃ¡rio Ã© 3 (tÃ©cnico)
                when 4 then IIF({$tipo_user} = 3, 1, 0) 
                when 5 then IIF({$tipo_user} = 3, 1, 0) 
                when 6 then IIF({$tipo_user} = 3, 1, 0) 
                -- when 7 then IIF({$tipo_user} = 3, 1, 0) 
                else 0
            end as can_reopen_hc,

            CASE orc_lotac.status
                when 9 then IIF({$tipo_user} = 3, 1, 0) --Validando se o tipo do usuÃ¡rio Ã© 3 (tÃ©cnico)
                when 10 then IIF({$tipo_user} = 3, 1, 0) 
                when 11 then IIF({$tipo_user} = 3, 1, 0) 
                when 12 then IIF({$tipo_user} = 3, 1, 0) 
                -- when 7 then IIF({$tipo_user} = 3, 1, 0) 
                else 0
            end as can_reopen_fcst,

            CASE orc_lotac.status
                when 3 then IIF({$tipo_user} = 3, 1, 0) --Validando se o tipo do usuÃ¡rio Ã© 3 (tÃ©cnico)
                when 4 then IIF({$tipo_user} = 3, 1, 0)
                when 5 then IIF({$tipo_user} = 3, 1, 0)
                when 6 then IIF({$tipo_user} = 3, 1, 0)
                -- when 7 then IIF({$tipo_user} = 3, 1, 0)
                else 0
            end as can_calc_hc,		

            CASE orc_lotac.status
                when 11 then IIF({$tipo_user} = 3, 1, 0) --Validando se o tipo do usuÃ¡rio Ã© 3 (tÃ©cnico)
                when 12 then IIF({$tipo_user} = 3, 1, 0)
                when 13 then IIF({$tipo_user} = 3, 1, 0)
                when 14 then IIF({$tipo_user} = 3, 1, 0)
                -- when 7 then IIF({$tipo_user} = 3, 1, 0)
                else 0
            end as can_calc_fcst,				

            CASE orc_lotac.status
                when 5 then 1
                else 0
            end as can_release_hc,

            CASE orc_lotac.status
                when 13 then 1
                else 0
            end as can_release_fcst,

            CASE orc_lotac.status
                when 6 then 1
                else 0
            end as can_approve_gestor_hc,

            CASE orc_lotac.status
                when 14 then 1
                else 0
            end as can_approve_gestor_fcst,

            -- CASE orc_lotac.status
            --     when 7 then 1
            --     else 0
            -- end as can_approve_gestor_diretor,

            (select top 1
					 IIF(orc_lotac.status = 6, IIF(tbl_notificacao.situacao = 1, 1, 0), 0)
					 from		  
                          tbl_notificacao where tbl_notificacao.orc_lotacao_id = orc_lotac.id and tbl_notificacao.orc_id = orc_lotac.orcamento_id and tbl_notificacao.tipo_aprovacao = 2 order by tbl_notificacao.data_hora desc , tbl_notificacao.id desc  ) as can_aprovar_hc,

            (select top 1
            IIF(orc_lotac.status = 14, IIF(tbl_notificacao.situacao = 4, 1, 0), 0)
            from		  
                tbl_notificacao where tbl_notificacao.orc_lotacao_id = orc_lotac.id and tbl_notificacao.orc_id = orc_lotac.orcamento_id and tbl_notificacao.tipo_aprovacao = 4 order by tbl_notificacao.data_hora desc , tbl_notificacao.id desc ) as can_aprovar_fcst,

            
            CASE orc_lotac.status 
                    WHEN   1 THEN 'Pendente de digitação'
                    WHEN   2 THEN 'Reaberto'
                    WHEN   3 THEN 'Enviado'
                    WHEN   4 THEN 'Conferido'
                    WHEN   5 THEN 'Calculado'
                    WHEN   6 THEN 'Calculado e liberado'
                    WHEN   7 THEN 'Aprovado'
                    -- WHEN   8 THEN 'Aprovado pelo diretor'
                    WHEN   9 THEN  IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Pendente de digitação')
                    WHEN   10 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Reaberto')
                    WHEN   11 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Enviado')
                    WHEN   12 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Conferido')
                    WHEN   13 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Calculado')
                    WHEN   14 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Calculado e liberado')
                    WHEN   15 THEN IIF('$tipo_table' = 'O', 'Finalizado', 'FCST Aprovado')
            END  as status

            -- CASE tbl_notificacao.situacao 
            --     WHEN   1 THEN 'Pendente'
            --     WHEN   2 THEN 'Aprovado'
            --     WHEN   3 THEN 'Rejeitado'
            --     WHEN   4 THEN 'FCST Pendente'
            --     WHEN   5 THEN 'FCST Aprovado'
            --     WHEN   6 THEN 'FCST Rejeitado'
            --     ELSE 'Não enviado para aprovação'
              
            -- END  as status_aprov,

            -- isnull((select top 1

	        -- CASE tbl_notificacao.situacao 
            --     WHEN   1 THEN 'Pendente'
            --     WHEN   2 THEN 'Aprovado'
            --     WHEN   3 THEN 'Rejeitado'
            --     WHEN   4 THEN 'FCST Pendente'
            --     WHEN   5 THEN 'FCST Aprovado'
            --     WHEN   6 THEN 'FCST Rejeitado'             
            -- END 
            -- from    tbl_notificacao 
			
            -- where tbl_notificacao.orc_lotacao_id = orc_lotac.id 
			-- and tbl_notificacao.orc_id = orc_lotac.orcamento_id 
			-- and ((tbl_notificacao.tipo_aprovacao = 2 and orc_lotac.status <9) or (tbl_notificacao.tipo_aprovacao = 4 and orc_lotac.status >=9))
			-- order by tbl_notificacao.data_hora desc , tbl_notificacao.id desc ),' - ') as status_aprov,


            from tbl_orc_resultados_calc as valores_calc
            inner join tbl_orc_lotacao as orc_lotac
            on orc_lotac.id = valores_calc.orc_lotacao_id and orc_lotac.orcamento_id = {$orc_id}

            -- inner join tbl_orc_lot_carg_headcount as orc_head
            -- on orc_head.lotacao_id = orc_lotac.id 
            -- and orc_head.tipo_table = 'O' 
            -- and orc_head.orc_cargo_id = valores_calc.orc_cargo_id

            left join tbl_orc_cargo as orc_cargo
            on orc_cargo.id = valores_calc.orc_cargo_id and orc_cargo.orcamento_id = {$orc_id}

            left join tbl_cargo as cargo
            on cargo.id = orc_cargo.cargo_id

            left join tbl_lotacao as lotac
            on orc_lotac.lotacao_id = lotac.id

            left join tbl_ccusto as centro_custo
            on orc_lotac.cc_custo_id = centro_custo.id

            -- left join tbl_notificacao on tbl_notificacao.[orc_lotacao_id] = orc_lotac.[id] and tbl_notificacao.[orc_id] = $orc_id




            where valores_calc.orcamento_id = $orc_id
            --and valores_calc.orc_lotacao_id = 26325 and valores_calc.natureza_hash_id = '13º_SALARIO' and valores_calc.orc_cargo_id = 84022
            --and valores_calc.tipo_table = '{$tipo_table}' já esta na variavel $where
            and orc_lotac.lotacao_id in ($lotacoes_string) ".$where.$where_periodo
        );
        
        // dd("olha",DB::getQueryLog());
        $formatado = [];
        for($i = 0; $i < count($data); $i++){
            $formatado[$i] = (array)$data[$i];
        }
        return new Response(json_encode($this->montaTreetableTotOrc($formatado)) , 200);
    }

    public function treetableValores($data){
        $pivot_colunas=$this->pivotColumnsTotOrc();
        $col_meses=$pivot_colunas->merged;
        $col_set_meses=[];
        $col_meses_parent=[];


        foreach($col_meses as $j=>$mes){
            $col_set_meses[]= ["field_out"=>$j,"from"=>$j, "render_value"=>null,];
            $col_meses_parent[]=["field_out"=>$j,  "from"=>'t_event-'.$j, 
            "field_out_render_func"=>function($row_data,$value, $matrix){

            }];
        }

        $column_fixeds=[ 
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id", "render_value"=>null,],
            ["field_out"=>"orc_lot_id", "from"=>"orc_lot_id", "render_value"=>null,],
            // ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"cc_custo_id", "from"=>"cc_custo_id", "render_value"=>null,],
            ["field_out"=>"lotac_cod", "from"=>"lotacao_des", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"ccusto", "render_value"=>null,],
        //     ["field_out"=>"lotac_cod", "from"=>"lotac_cod", "render_value"=>null,],
        //     ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
        //     // ["field_out"=>"natureza", "from"=>"natureza", "render_value"=>null,],
        //     // ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>0,],
        //     // ["field_out"=>"cargo_desc", "from"=>"cargo_desc", "render_value"=>null,],
        //     ["field_out"=>"status_id", "from"=>"status_id", "render_value"=>null,],
            ["field_out"=>"status_desc", "from"=>"status_desc", "render_value"=>null,],
            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>null,],
        //     ["field_out"=>"secreto", "from"=>"secreto", "render_value"=>null,],
            
       
            ["field_out"=>"jan", "from"=>"tot_jan", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"fev", "from"=>"tot_fev", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"mar", "from"=>"tot_mar","render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"abr", "from"=>"tot_abr", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"mai", "from"=>"tot_mai", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"jun", "from"=>"tot_jun","render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"jul", "from"=>"tot_jul", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"ago", "from"=>"tot_ago", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"set", "from"=>"tot_set", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"out", "from"=>"tot_out", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"nov", "from"=>"tot_nov", "render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"dez", "from"=>"tot_dez","render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],
            ["field_out"=>"total_orc", "from"=>"soma_tot","render_value"=>function($row_data, $value){
                return (number_format($value, 2, ',', '.'));
            },],

            
		// 	 ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
        //     ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
        //     ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
        //     ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
        ["field_out"=>"can_fill_hc", "from"=>"can_fill_hc", "render_value"=>function($row_data, $value){
            return boolval($value);
        },],
        ["field_out"=>"can_fill_fcst", "from"=>"can_fill_fcst", "render_value"=>function($row_data, $value){
            return boolval($value);
        },],
        ["field_out"=>"can_calc_hc", "from"=>"can_calc_hc", "render_value"=>function($row_data, $value){
            return boolval($value);
        },],
        ["field_out"=>"can_calc_fcst", "from"=>"can_calc_fcst", "render_value"=>function($row_data, $value){
            return boolval($value);
        },],
        ["field_out"=>"can_release_hc", "from"=>"can_release_hc", "render_value"=>function($row_data, $value){
            return boolval($value);
        },],
        ["field_out"=>"can_release_fcst", "from"=>"can_release_fcst", "render_value"=>function($row_data, $value){
            return boolval($value);
        },],
        ["field_out"=>"can_approve_gestor_hc", "from"=>"can_approve_gestor_hc", "render_value"=>function($row_data, $value){
            return boolval($value);
        },],
        ["field_out"=>"can_approve_gestor_fcst", "from"=>"can_approve_gestor_fcst", "render_value"=>function($row_data, $value){
            return boolval($value);
        },],
        ["field_out"=>"can_approve_gestor_diretor", "from"=>"can_approve_gestor_diretor", "render_value"=>function($row_data, $value){
            return boolval($value);
        },],
        ["field_out"=>"can_approve_gestor_diretor_fcst", "from"=>"can_approve_gestor_diretor", "render_value"=>function($row_data, $value){
            return boolval($value);
        },],
        ["field_out"=>"can_reopen_hc", "from"=>"can_reopen_hc", "render_value"=>function($row_data, $value){
            return boolval($value);
        },],
        ["field_out"=>"can_reopen_hc", "from"=>"can_reopen_hc", "render_value"=>function($row_data, $value){
            return boolval($value);
        },],
        ["field_out"=>"can_reopen_fcst", "from"=>"can_reopen_fcst", "render_value"=>function($row_data, $value){
            return boolval($value);
        },],
        ["field_out"=>"can_aprovar_hc", "from"=>"can_aprovar_hc", "render_value"=>function($row_data, $value){
            return boolval($value);
        },],
        ["field_out"=>"can_aprovar_fcst", "from"=>"can_aprovar_fcst", "render_value"=>function($row_data, $value){
            return boolval($value);
        },],
 
        ["field_out"=>"status", "from"=>"status", "render_value"=>null,],

        ["field_out"=>"status_aprov", "from"=>"status_aprov", "render_value"=>null,]


           
           

        ];

        $column_fixeds_children=[ 
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id", "render_value"=>null,],
            ["field_out"=>"orc_lot_id", "from"=>"orc_lot_id", "render_value"=>null,],
            // ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"cc_custo_id", "from"=>"cc_custo_id", "render_value"=>null,],
            ["field_out"=>"lotac_cod", "from"=>"unid_lotac", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"ccusto", "render_value"=>null,],
            // ["field_out"=>"lotac_cod", "from"=>"lotac_cod", "render_value"=>null,],
            // ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            // ["field_out"=>"natureza", "from"=>"natureza", "render_value"=>null,],
            //["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>0,],
            // ["field_out"=>"cargo_desc", "from"=>"cargo_desc", "render_value"=>null,],
            // // ["field_out"=>"status_id", "from"=>"status_id", "render_value"=>null,],
            // // ["field_out"=>"status_desc", "from"=>"status_desc", "render_value"=>null,],
            // ["field_out"=>"total_orc", "from"=>"total_orc", "render_value"=>null,],
            // ["field_out"=>"secreto", "from"=>"secreto", "render_value"=>null,],

		    // ["field_out"=>"jan", "from"=>"jan_val_total", "render_value"=>function($row_data, $value){
            //     return ($value);
            // },],
            // ["field_out"=>"fev", "from"=>"fev_val_total", "render_value"=>function($row_data, $value){
            //     return ($value);
            // },],
            // ["field_out"=>"mar", "from"=>"mar_val_total","render_value"=>function($row_data, $value){
            //     return ($value);
            // },],
            // ["field_out"=>"abr", "from"=>"abr_val_total", "render_value"=>function($row_data, $value){
            //     return ($value);
            // },],
            // ["field_out"=>"mai", "from"=>"mai_val_total", "render_value"=>function($row_data, $value){
            //     return ($value);
            // },],
            // ["field_out"=>"jun", "from"=>"jun_val_total","render_value"=>function($row_data, $value){
            //     return ($value);
            // },],
            // ["field_out"=>"jul", "from"=>"jul_val_total", "render_value"=>function($row_data, $value){
            //     return ($value);
            // },],
            // ["field_out"=>"ago", "from"=>"ago_val_total", "render_value"=>function($row_data, $value){
            //     return ($value);
            // },],
            // ["field_out"=>"set", "from"=>"set_val_total", "render_value"=>function($row_data, $value){
            //     return ($value);
            // },],
            // ["field_out"=>"out", "from"=>"out_val_total", "render_value"=>function($row_data, $value){
            //     return ($value);
            // },],
            // ["field_out"=>"nov", "from"=>"nov_val_total", "render_value"=>function($row_data, $value){
            //     return ($value);
            // },],
            // ["field_out"=>"dez", "from"=>"dez_val_total","render_value"=>function($row_data, $value){
            //     return ($value);
            // },],
		   

        ];

        
        $columns_base = $column_fixeds; 
        $columns_children = $column_fixeds_children; 
        // dd("dataaaaaaaaaaaaaaaaaaa", $data);
        $settings=["columns"=>$columns_base,
		"keys"=>['orcamento_id','cc_custo_id', 'orc_lot_id'],
                
              "children"=>["columns"=>$columns_children,
                    "keys"=>['cc_custo_id', 'orc_lot_id'],
                    "filter_data"=>[
                        'cc_custo_id'=>function($value){
                            return !is_null($value);
                        },
                        'orc_lot_id'=>function($value){
                            return !is_null($value);
                        },
                        // 'cargo_id'=>function($value){
                        //     return !is_null($value);
                        // }
                    ],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result = ($value['cc_custo_id'] == $parent_data['cc_custo_id'] && 
                            $value['orc_lot_id'] == $parent_data['orc_lot_id'] 
                        );
                        
                        return $result;
                    },
                

                ]
            ];
            // dd("entrou aaaaaaa");
        $controller=new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
    }
    public function listarUltimoPeriodo($orc_id){
        $select = DB::select("SELECT distinct top(1) movto.periodo from tbl_orc_movto_status_ccusto as movto
            inner join tbl_orc_lotacao as olot on olot.id = movto.orc_lotacao_id
            where movto.tipo_table = 'F' and olot.orcamento_id = ? order by movto.periodo desc
        ", [$orc_id]);
        
        return count($select) == 0 ? [['periodo'=>date('Y-m-01')]] : $select;
    }

    public function listarDiarioBordoHome($orc_id, Request $request){
        $dados = $request->all();
        $periodo = $dados['periodo'];
        $tipo_table = $dados['tipo_table'];

        $where_periodo = $periodo == null ? "" : " and periodo = {$periodo}";
        $select = DB::select("SELECT registro_id, lotacao_id, tbl_origem from tbl_orc_diario_bordo where orcamento_id = {$orc_id} and tipo_table = '{$tipo_table}' and 
            tbl_origem in ('tbl_orc_promocao', 'tbl_orc_headcount_demissoes', 'tbl_orc_headcount_contratacoes')".$where_periodo);
        return $select;
    }
}
