<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoDefinirSenha as RepoDefinirSenha;
use App\Modules\Natureza51\Repositories\RepoUsuario;
use Illuminate\Http\Request;
use Carbon\Carbon;
use DB;

class DefinirSenhaController extends Natureza51Ctrl
{
    public function __construct(){
        $this->repository=new RepoDefinirSenha();
        $this->setCodTela('DEF_SENHA');
        parent::__construct(); 
    }
    
    public function definirSenha(Request $request){
        $retorno = $this->getArrayRetornoDefault();
        $data_request = $request->all();
        $data = $this->getRepository()->getModelEntity()->where('hash', $data_request['hash'])->get();
        if(count($data) <= 0){
            $retorno['msg']="Não foi encontrada sua solicitação de alteração de senha!";
            $retorno['submsg']='Falha ao definir a senha. Erro: 221020201648.';
            goto saida;
        }
        $data = $data[0]->toArray();
        
        $repoUsuario = new RepoUsuario();

        $data_user = $repoUsuario->getModelEntity()->where('email', $data['email'])->get();
        
        if(count($data_user) <= 0){
            $retorno['msg']="Não foi encontrado nenhum usuário com o email de sua solicitação!";
            $retorno['submsg']='Falha ao definir a senha. Erro: 221020201711.';
            goto saida;
        }

        $data_user = $data_user[0]->toArray();

        if($data['senha_definida'] == 1){
            $retorno['msg']="Essa solicitação de alteração de senha foi expirada!";
            $retorno['submsg']='Falha ao definir a senha. Erro: 221020201651.';
            goto saida;
        }

        $data_validade = Carbon::parse($data['data_vencimento']);
        $data_atual = Carbon::now();

        if($data_atual->gt($data_validade)){
            $retorno['msg']="Essa solicitação de alteração de senha foi expirada!";
            $retorno['submsg']='Falha ao definir a senha. Erro: 221020201658.';
            goto saida;
        }

        if($data_request['password'] != $data_request['confirm_password']){
            $retorno['msg']="As senhas não correspondem!";
            $retorno['submsg']='Falha ao definir a senha. Erro: 221020201702.';
            goto saida;
        }

        $encrypted_password = safeEncrypt($data_request['password']);

        $data['senha_definida'] = 1;

        DB::beginTransaction();

        if(!$this->getRepository()->updateSituacao($data['senha_definida'], $data['email'])){
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao definir a senha. Erro: 221020201702.';
            DB::rollback();
            goto saida;
        }

        if(!$repoUsuario->updatePassword($encrypted_password, $data_user['id'])){
            $retorno['msg']=$repoUsuario->getErrosFlatted();
            $retorno['submsg']='Falha ao definir a senha. Erro: 221020201713.';
            DB::rollback();
            goto saida;
        }
        
        DB::commit();
        $retorno["status"]="success";
        $retorno["msg"]="Senha atualizada com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);

    }    
   
    public function update(Request $request){
        $this->podeAcessar('editar',true,$this->getCodTela());
        $retorno = $this->getArrayRetornoDefault();
        $form_data = $request->all(); 

        // $form_data['updated_by'] = $this->obtIdUsuario();
        $id=$form_data['id'];
        if(! $this->getRepositoryOrModel()->update($form_data, $id)){
                $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg']='Falha ao atualizar o registro. Erro: 260820191038.';
                goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }
    
    public function alterarSenha(Request $request){
        $data_request = $request->all();
        $user = $this->getUserFromCurrentGuard();
        $retorno = $this->getArrayRetornoDefault();
        $repoUsuario = new RepoUsuario();
        
        if(!$user){
            $retorno['msg']="Usuário não encontrado!";
            $retorno['submsg']='Falha ao alterar a senha. Erro: 231020200942.';
            goto saida;
        }       

        if($data_request['new_password'] == $data_request['password']){
            $retorno['msg']="A nova senha não deve ser igual à anterior!";
            $retorno['submsg']='Falha ao alterar a senha. Erro: 231020200947.';
            goto saida;
        }       

        if($data_request['new_password'] != $data_request['confirm_new_password']){
            $retorno['msg']="As senhas não correspondem!";
            $retorno['submsg']='Falha ao alterar a senha. Erro: 231020200943.';
            goto saida;
        }

        $senha_atual = safeDecrypt($user->senha);  

        if($data_request['password'] != $senha_atual){
            $retorno['msg']="Senha atual incorreta!";
            $retorno['submsg']='Falha ao alterar a senha. Erro: 231020200944.';
            goto saida;
        }        

        $encrypted_password = safeEncrypt($data_request['new_password']);

        if(!$repoUsuario->updatePassword($encrypted_password, $user->id)){
            $retorno['msg']=$repoUsuario->getErrosFlatted();
            $retorno['submsg']='Falha ao definir a senha. Erro: 231020200946.';
            goto saida;
        }        
        
        $retorno["status"]="success";
        $retorno["msg"]="Senha atualizada com sucesso!";
        $retorno["submsg"]="Sucesso";
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }
}