<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoDespesas as RepoDespesas;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class DespesasController extends Natureza51Ctrl
{
    public function __construct(){
        $this->repository=new RepoDespesas();
        $this->setCodTela('DESP');
        parent::__construct(); 
    }
    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $data = $this->getRepository()->listar();
        /*$retorno = [];

        foreach ($data as $dt) {
       
            $dt['created_by_nome'] = $dt['created_by'] != null ? $this->getNomeByUsuario($dt['created_by']): ' - ';
            $dt['updated_by_nome'] = $dt['updated_by'] != null ? $this->getNomeByUsuario($dt['updated_by']): ' - ';
            $dt['description_created_at'] = $dt['created_at'] != null ? $this->formataData($dt, 'created_at') : '-';
            $dt['description_updated_at'] = $dt['updated_at'] != null ? $this->formataData($dt, 'updated_at') : '-';
            array_push($retorno, $dt);

            }*/
            // dd("data", $data);

            return new Response(json_encode($data) , 200);
        // return $this->getRepository()->listar();
    }
    public function update(Request $request){

        $this->podeAcessar('editar',true,$this->getCodTela());
        $array=$request->all();
        // $novo_valor=array('valor_referencia'=>$array['valor_referencia']);
        // $array_referencia=array_merge($array,convertDecimalEn($novo_valor));
        $retorno=$this->getArrayRetornoDefault();
        if(!$this->getRepository()->update($array,$array['id'])){
            $this->getRepository()->getErrosFlatted();
            $retorno['status']='warning';
            $retorno['submsg']=$this->getRepository()->getErrosFlatted();
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            goto saida;
        }
        
        $retorno['status']='success';
        $retorno['msg']='Registro atualizado com sucesso!';
        $retorno['submsg']='Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function insert(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $retorno=$this->getArrayRetornoDefault();
        $obj=$this->getRepository()->insert($request);
        
        if(!$obj){
            //dd("caiu",$obj);
            $retorno['status']='error';
            $retorno['submsg']='Erro';
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            goto saida;
        }
        $retorno['status']='success';
        $retorno['msg']='Registro inserido com sucesso!';
        $retorno['submsg']='Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno);
    }

    

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Despesas', ['cdn_event', 'cod_cta_ctbl', 'created_at', 'created_by', 'cta_contabil_id', 'des_cta_ctb', 'des_event', 'desc_cta_ctbl', 'description', 'empresa_id', 'evento', 'evento_id', 'id', 'origem_despesa', 'updated_at', 'updated_by', 'user_id']);
    }



    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            
            $colunas[$i] = str_replace("des_origem_despesa", "Origem da despesa", $colunas[$i]);
            $colunas[$i] = str_replace("conta_contabil", "Conta contábil", $colunas[$i]);
            $colunas[$i] = str_replace("desc_evento", "Evento", $colunas[$i]);
            $colunas[$i] = str_replace("valor_referencia", "Valor de referência", $colunas[$i]);
            $colunas[$i] = str_replace("descricao", "Descrição", $colunas[$i]);
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);

            
            $colunas[$i] = str_replace("created by nome", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("description created at", "Criado em", $colunas[$i]);
            $colunas[$i] = str_replace("updated by nome", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("description updated at", "Atualizado em", $colunas[$i]);
        }
        return $colunas;
    }

    public function delete(Request $request){
        // dd("aquiii delete", $request->all());
        $this->podeAcessar('deletar',true,$this->getCodTela());


       $retorno=$this->getArrayRetornoDefault();
       $form_data=$request->all(); 
       
       if(!isset($form_data['id'])){
            $retorno['msg']='Registro não encontrado';
            $retorno['submsg']='Falha ao deletar o registro. Erro: 190920191839';
            goto saida;
       }

       if(!$this->getRepositoryOrModel()->delete($form_data['id'])){
            $retorno['msg']= $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Atualize a página e tente novamente. Erro: 260820191038.';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro excluído com sucesso!";
        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }
}