<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoEmailConfig as RepoEmailConfig;
use App\Modules\Natureza51\Entities\EmailConfig;
use Illuminate\Http\Request;



class EmailConfigController extends Natureza51Ctrl
{
    public function __construct(){
        $this->repository=new RepoEmailConfig();
        parent::__construct();
    }

    public function listar(){
        $retorno=$this->getArrayRetornoDefault();
        $dados = $this->getRepository()->listar();
        if(!$dados){
            $retorno['msg'] = $dados !== null ? 'Não foi possível encontrar a configuração de email' : 'Nenhuma configuração de email encontrada';
            $retorno['subsmg']='Falha ao encontrar o registro. Erro: 010420201551';
            return $this->retornoJsonDefault($retorno);
        }
        return $dados;
    }

}