<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoEmpresa as RepoEmpresa;
use Illuminate\Http\Request;
use Excel;

class EmpresaController extends Natureza51Ctrl
{
    public function __construct(){
        $this->setCodTela('EMP');
        $this->repository=new RepoEmpresa();
        parent::__construct();
    }
    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        return $this->getRepository()->listarAll();
    }
    public function insert(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $dados = $request->all();
        $retorno = $this->getArrayRetornoDefault();

        if(!$this->getRepository()->inserir($dados)){
            $retorno['status'] = 'error';
            $retorno['submsg'] = $this->getRepository()->getErrosFlatted();
            $retorno['msg'] = 'Erro';
            goto saida;
        }

        $retorno['msg']='Registro inserido com sucesso!';
        $retorno['submsg']='Sucesso';
        $retorno['status']='success';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function update(Request $request){
        $this->podeAcessar('editar',true,$this->getCodTela());
        $dados = $request->all();
        $retorno = $this->getArrayRetornoDefault();

        if(!$this->getRepository()->updateEmpresa($dados)){
            $retorno['status'] = 'error';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg'] = 'Erro';
            goto saida;
        }

        $retorno['msg']='Registro atualizado com sucesso!';
        $retorno['submsg']='Sucesso';
        $retorno['status']='success';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function listarPorCnpj($cnpj){
        return $this->getRepository()->listarPorCnpj($cnpj);
    }
    // public function delete(Request $request){
    //     $dados = $request->all();

    //     $retorno = $this->getArrayRetornoDefault();

    //     if(!$this->getRepository()->deleteEmpresa($dados)){
    //         $retorno['status'] = 'error';
    //         $retorno['msg'] = $this->getRepository()->getErrosFlatted();
    //         $retorno['submsg'] = 'Erro';
    //         goto saida;
    //     }

    //     $retorno['msg']='Registro excluído com sucesso!';
    //     $retorno['submsg']='Sucesso';
    //     $retorno['status']='success';

    //     saida:
    //     return $this->retornoJsonDefault($retorno);
    // }


    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Empresas', ['tipo_pessoa', 'is_matriz_filial', 'id_matriz', 'grupo_empresarial_id', 'endereco_id','description', 'cod_estabel_erp', 'value']);
    }


    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("cdn empresa", "codigo", $colunas[$i]);
        }
        return $colunas;
    }

}