<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoEventos as RepoEventos;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\HeadcountHraExtra;
use App\Modules\Natureza51\Entities\OrcHoraExtra;
use App\Modules\Natureza51\Entities\OrcamLotCargoEvento;
use App\Modules\Natureza51\Repositories\RepoHoraExtra;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Arr;

class EventosController extends Natureza51Ctrl
{
    
   public function __construct(){
        $this->repository=new RepoEventos(); 
        $this->setCodTela('EVT');
        parent::__construct();
    }
    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        // return 
        $data = $this->getRepository()->listarEventos();
        // dd($data);
        $dados = [];
        // $data = $this->getRepository()->getModelEntity()->select()->get()->toArray();
        foreach ($data as $record) {
            //$record['tipo_acesso_texto'] = $record['tipo_acesso'] == 1 ? 'Global' : ($record['tipo_acesso'] == 2 ? 'Lotação/Cargo' : '-');
            if($record['tipo_acesso'] == 1) $record['tipo_acesso_texto'] = 'Global';
            else if($record['tipo_acesso'] == 2) $record['tipo_acesso_texto'] = 'Lotação/Cargo';
            else $record['tipo_acesso_texto'] = '-';

            
            $record['created_by_nome'] = $record['created_by'] != null ? $this->getNomeByUsuario($record['created_by']): ' - ';
            $record['updated_by_nome'] = $record['updated_by'] != null ? $this->getNomeByUsuario($record['updated_by']): ' - ';
            $record['description_created_at'] = $record['created_at'] != null ? $this->formataData($record, 'created_at') : '-';
            $record['description_updated_at'] = $record['updated_at'] != null ? $this->formataData($record, 'updated_at') : '-';
            $record['origem_reg'] = $record['origem'] == 1 ? 'Sistema' : 'ERP';

          
          // $record['des_origem_evento'] = $record['origem_evento'] == 0 ? 'Evento' : 'Conta contábil';
            
            // $record['base_orc'] = $record['base_orc'] == 1 ? 'Sim' : 'Não';
            array_push($dados, $record);
        }
        // dd($dados);
       return new Response(json_encode($dados), 200);
    }

    public function colunaEventosHE($orc_id, $periodo = null, $tipo_table = 'O'){
        // $tb_eventos = new Eventos();

        // $hra_extra = new RepoHoraExtra();
        // $orcHoraExtra = new HeadcountHraExtra();
        $orcHoraExtra = new OrcHoraExtra();
        // $hcd = new HeadcountController();
        
        // $hra = $hra_extra->getModelEntity()->select('evento_id')->where('orcamento_id',$orc_id)->get()->toArray();        
        // $a = [];
        
        // for ($i=0; $i <count($hra) ; $i++) { 
        //     $a[$i]=$hra[$i]['evento_id'];
        // }

        // $data = $tb_eventos->select('id', 'des_event', 'cdn_event')->whereIn('id',$a)
        // ->get()->toArray();
        // $dados = [];
        // for($i=0;$i<count($data);$i++){
        //     $dados[$i]=array_merge($data[$i],array("description"=>$data[$i]['cdn_event'].' - '.$data[$i]['des_event']));
        // }
        
        // return new Response(json_encode($dados) , 200);
        // dd('sdnasjdnjaks', $orc_id);
        // $orcamento = $orcHoraExtra
        // ::with([
        //     'getEventos'=>function($query){
                
        //     } 
        // ])->where('orc_id', $orc_id)
        // ->get();
        
        $query = $orcHoraExtra
        ::with([
            'getEventos'=>function($query){
                
            } 
        ])->where('orcamento_id', $orc_id)->where('tipo_table',$tipo_table);
        

        $orcamento = null;
        if($tipo_table == 'F'){
            $orcamento = $query->where('periodo', $periodo)->get();
        }
        else{
            $orcamento = $query->whereNull('periodo')->get();
        }
        
        for ($i=0; $i < count($orcamento); $i++) { 
            // dd("testeeee",$orcamento[$i]->getEventos->des_event );  
            $orcamento[$i]['evento_id'] = $orcamento[$i]->getEventos->id;
            $orcamento[$i]['cdn_event'] = $orcamento[$i]->getEventos->cdn_event;
            $orcamento[$i]['des_event'] = $orcamento[$i]->getEventos->des_event; 
            $orcamento[$i]['description'] = $orcamento[$i]->getEventos->cdn_event.' - '.$orcamento[$i]->getEventos->des_event;

            Arr::forget($orcamento[$i], 'getEventos');
        }
      
        return !$orcamento ? [] : $orcamento;
    }

    public function eventosInsert($orc_id){
        
        $tb_orc_lot_carg_evento= new HeadcountHraExtra();

        $tb_eventos = new Eventos();
        $tb_orc_hora_extra = new OrcHoraExtra();
        
        $select = $tb_orc_lot_carg_evento
        // ->join($tb_orc_hora_extra->getTable(),
        // $tb_orc_lot_carg_evento->getColunaAlias('evento_id'),$tb_orc_hora_extra->getColunaAlias('id'))
        ->join($tb_eventos->getTable(),
        $tb_orc_lot_carg_evento->getColunaAlias('evento_id'),$tb_eventos->getColunaAlias('id'))
        ->select($tb_eventos->getColunaAlias('id'),
        $tb_eventos->getColunaAlias('des_event'))
        ->distinct()
        ->where($tb_orc_lot_carg_evento->getColunaAlias('orc_id'),$orc_id)
        ->get()->toArray();

        return new Response(json_encode($select) , 200);
    }
    
    public function update(Request $request){
        $this->podeAcessar('editar',true,$this->getCodTela());
        $array = $request->all();
        // $array['updated_at'] = $this->horaAtual();
        // $array['updated_by'] = $this->obtIdUsuario();
        $enviar = array('multiplica'=>$array['multiplica']);
        //dd("sxasx",$enviar);
        //$array_repo=array_merge($array,convertDecimalEn($enviar));
        return $this->getRepository()->update($array,$array['id']);//$array_repo
    }
    public function listarTipo($tipo_evento){
        $dados=$this->getRepository()->listarEventos();
        $i=0;
        $y=0;
        //dd($tipo_evento);
        $data=null;
        for($i=0;$i<count($dados);$i++){
            if($dados[$i]['tipo_evento_id']==$tipo_evento){
               $data[$y]=$dados[$i];
               $y=$y+1;
            }
        }
        return $data;
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Eventos', ['inc_liquido','base_orc','multiplica','dt_base_admissao_ini','dt_base_admissao_fim', 'ativo', 'description', 'formula', 'impr_envel', 'origem', 'origem_evento','tipo_evento_id', 'tipo_acesso']);
    }


    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("des ativo", "Ativo", $colunas[$i]);
            $colunas[$i] = str_replace("cdn event", "Código evento", $colunas[$i]);
            $colunas[$i] = str_replace("des origem evento", "Origem evento", $colunas[$i]);
            $colunas[$i] = str_replace("des event", "Descrição", $colunas[$i]);
            $colunas[$i] = str_replace("des impr envel", "Impr. Envel.", $colunas[$i]); 
            $colunas[$i] = str_replace("des data ini", "Data admissão final", $colunas[$i]);
            $colunas[$i] = str_replace("des data fim", "Data admissão inicial", $colunas[$i]);
            $colunas[$i] = str_replace("des tipo evento", "Tipo evento", $colunas[$i]);
            $colunas[$i] = str_replace("multiplica", "Multiplica", $colunas[$i]);
            // $colunas[$i] = str_replace("base orc", "Base orçamento", $colunas[$i]);
            $colunas[$i] = str_replace("tipo acesso texto", "Tipo acesso", $colunas[$i]);
            $colunas[$i] = str_replace("created by nome", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("description created at", "Criado em", $colunas[$i]);
            $colunas[$i] = str_replace("updated by nome", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("description updated at", "Atualizado em", $colunas[$i]);
            $colunas[$i] = str_replace("origem reg", "Origem registro", $colunas[$i]);


        }
        return $colunas;
    }
    public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }   
}
