<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoFgts as RepoFgts;
use App\Modules\Natureza51\Entities\Fgts;
use Illuminate\Http\Response;

use Excel;

class FgtsController extends Natureza51Ctrl
{ 
     public function __construct(){
        $this->repository=new RepoFgts();
        $this->setCodTela('FGTS');
        parent::__construct();
    }

    public function listar(){
        $dados = $this->getRepository()->listar();
        $data = [];

        foreach ($dados as $dt) {

            $dt['created_by_nome'] = $dt['created_by'] != null ? $this->getNomeByUsuario($dt['created_by']): ' - ';
            $dt['updated_by_nome'] = $dt['updated_by'] != null ? $this->getNomeByUsuario($dt['updated_by']): ' - ';
            $dt['description_created_at'] = $dt['created_at'] != null ? $this->formataData($dt, 'created_at') : '-';
            $dt['description_updated_at'] = $dt['updated_at'] != null ? $this->formataData($dt, 'updated_at') : '-';
            array_push($data, $dt);

            }
            // dd("data", $dados);

            return new Response(json_encode($data), 200);


        // return $retorno;
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        // dd("njksjnfjksd");
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'FGTS', ['func_id','cdn_func','dta_base_valor','id','valor', 'nome_funcionario', 'corrigido', 'cdn_funcionario']);
    }


    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("funcionario", "Funcionário", $colunas[$i]);
            $colunas[$i] = str_replace("data base formatada", "Data base", $colunas[$i]);
            $colunas[$i] = str_replace("valor format", "Valor", $colunas[$i]);
            $colunas[$i] = str_replace("created by nome", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("description created at", "Criado em", $colunas[$i]);
            $colunas[$i] = str_replace("updated by nome", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("description updated at", "Atualizado em", $colunas[$i]);
        }
        return $colunas;
    }

    
    public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }
    
    
} 