<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcContratacoes as RepoOrcContratacoes;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento as RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoHeadcount as RepoHeadcount;
use App\Modules\Natureza51\Entities\OrcFerias;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcContratacoes;
use App\Modules\Natureza51\Repositories\RepoForecast;
use App\Modules\Natureza51\Repositories\RepoForecastContratacoes;
use Illuminate\Http\Request as Request;
use Illuminate\Http\Response;
use Illuminate\Support\Arr;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Facades\DB;

class ForecastContratacoesController extends OrcamentoController
{

    use \App\Core\Traits\ErrorTrait;
    
    public function __construct(){
        //$this->setCodTela('CONT');
        parent::__construct();
        $this->repository = new RepoForecastContratacoes();
    }

    public function insert(Request $request){
        set_time_limit(120);
        $this->setCodTela('FCONT');
        $this->podeAcessar('inserir',true,$this->getCodTela());

        $dados = $request->all();

        if($this->canCRUDForecast($dados['lotacao_id'], $dados['orcamento_id'], $dados['periodo'], $dados['tipo_table']) === false){
            $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201503';
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            return $this->retornoJsonDefault($retorno);
        }

        $a = $this->getRepository()->createContratacoes($request->all());
        return $this->retornoJsonDefault($a);
    }


    public function update(Request $request){
        set_time_limit(120);
        //$this->podeAcessar('editar',true,$this->getCodTela());
        $repo_calc_orcamento = new RepoCalcOrcamento();
        $form_data = $request->all();        
        $id = $form_data['id'];
        $meses = $this->dataFilterMesesCalcOrcamento($form_data); 
        $data = $this->dataFilterPromocao($form_data);
        // dd($data);

        if(!$repo_calc_orcamento->update($meses,['id'=>$id,'tbl_origem'=>'tbl_orc_ferias'])){                  
                $retorno["status"] = "error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg'] = 'Falha ao fazer update do registro. Erro: 140920201016';
                goto saida;               
        } 

        if(!$this->getRepository()->update($data, ['id'=>$id])){                  
            $retorno["status"] = "error";
            $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
            $retorno['submsg'] = 'Falha ao fazer update do registro. Erro: 140920201029';
            goto saida;               
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        saida:       
     
        return $this->retornoJsonDefault($retorno); 
    }
    public function delete(Request $request){  
        set_time_limit(120);
        $this->setCodTela('FCONT');
        $this->podeAcessar('deletar',true,$this->getCodTela());
        
        $form_data = $request->all();
        
        if($this->canCRUDForecast($form_data['lotacao_id'], $form_data['orc_id'], $form_data['periodo'], 'F') === false){
            $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201527';
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            return $this->retornoJsonDefault($retorno);
        }

        $repo_calc_orcamento = new RepoCalcOrcamento();
                
        $id=$form_data['id'];
        // dd($id);

        DB::beginTransaction();
        $calcOrcamento = $repo_calc_orcamento->getModelInstance()->where('id',$id)->first();

        if(!$calcOrcamento->delete()){                  
                $retorno["status"] = "error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg'] = 'Erro: 140920201408';
                goto saida;               
        } 

        if(!$this->getRepository()->delete($calcOrcamento['origem_id'])){                  
            $retorno["status"] = "error";
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg'] = 'Erro: 140920201408b';
            goto saida;               
        }
        if($this->deleteDiarioBordo($calcOrcamento['origem_id'], 'tbl_orc_headcount_contratacoes') === false){
            $retorno["status"] = "error";
            $retorno['msg'] = "Falha ao deletar Diário de Bordo. Erro: 230320211012";
            $retorno['submsg'] = 'Erro';
            goto saida;
        }
        $repoForecast = new RepoForecast();
        $mes_ini = 1;//intval(substr($form_data['periodo'], 5, 2), 10);
        // if($mes_ini == 13){
        //     $mes_ini = 1;
        // }
        if(!$repoForecast->calcHeadcount($form_data['orc_id'], $form_data['lotacao_id'], $mes_ini, $form_data['periodo'])){
            $retorno['status'] = "error";
            $retorno['msg'] = $repoForecast->getErrosFlatted();
            $retorno['submsg'] = 'Erro: 140920201408c';
            DB::rollBack();
            goto saida;               
        }  
        
        /*$dados = array('lotacao_id'=>$form_data['lotacao_id'], 'orc_id'=>$form_data['orc_id'], 'id_princ'=>null);
        for($i = 1; $i <= 12; $i++){
            $result = $repoForecast->validaDistribuicao($i, $form_data['periodo'], $dados);

            if( $result === false){
                $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
                $retorno['status'] = 'error';
                $retorno['submsg'] = 'Erro';
                DB::rollBack();
                goto saida;
            }
        }*/
        $dados = $this->validaValoresNegativos($form_data['orc_id'], $form_data['lotacao_id'], $form_data['periodo'], 'F');
        if(count($dados) > 0){
            $retorno['msg'] = "Impossível concluir a operação. A distribuição dos valores irá assumir um valor negativo.";
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            DB::rollBack();
            goto saida; 
        }
        DB::commit();
        $retorno['submsg'] = 'Sucesso!';
        $retorno["status"] = "success";
        $retorno["msg"] = "Registro deletado com sucesso!";
        saida:       
      
        return $this->retornoJsonDefault($retorno); 
    } 
    public function pivo($dados){
        $meses_orcado = ['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado',
        'jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];
        $eventos_meses = [13,14,15,16];
        $retorno=[];
        $primary_key=['id','lotacao_id','orc_turma_id',];
       
        $merge_meses_evento=[];
        $meses_orcados_clear=[];        
        
        $dados_rest = [];
        foreach($dados as $key => $value){
            
            $value=(array)$value;
            $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
            $ja_foi=array_keys($retorno);
            
            if(in_array($keys_values, $ja_foi)===false){                
                $aux=Arr::except($value,$meses_orcado);   
                $retorno[$keys_values]=$aux;

            }
            foreach($meses_orcado as $j=>$w){                     
                $retorno[$keys_values][$w]=$value[$w];
            }
        }
        return $retorno;
    }
    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['meses', 'funcionario_id', 'orc_id', 'lotacao_id','cargo_id','orc_turma_id', 'lotacao_responsavel','orcamento_id','type', 'orc_cargo_id', 'ccusto_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }
    public function dataFilterContratacoes($data){
        $array_orcamento=['meses','tbl_origem','cargo_id','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','origem_id','id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }
    public function getCargoContratacao($orc_id, $lotacao_id){
        $this->setCodTela('CONT');
        // $this->podeAcessar('inserir',true,$this->getCodTela());
         $a = $this->getRepository()->getCargoContratacao($orc_id, $lotacao_id);
         return $a;
    }
}
