<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\HeadcountHraExtra;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcContratacoes;
use App\Modules\Natureza51\Entities\OrcHeadcountContratacoes;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;
use App\Modules\Natureza51\Entities\OrcHoraExtra;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\Turma;
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Repositories\RepoAtividades;
use App\Modules\Natureza51\Repositories\RepoForecast as RepoForecast;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoForecastContratacoes;
use App\Modules\Natureza51\Repositories\RepoForecastFuncoes;
use App\Modules\Natureza51\Repositories\RepoOrcCronograma;
use App\Modules\Natureza51\Repositories\RepoScriptsLiberaParamForecast;
use App\Support\TreeTable\AtmTreeTable;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB; 

class ForecastController extends OrcamentoController
{
    private $colum_meses = ['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado',
    'jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];
    public function __construct(){
        $this->repository = new RepoForecast();
        //$this->setCodTela('CG');
        parent::__construct();
    }

    public function listarOrcamento(){
        return $this->repository->listarOrc();
    }
    public function listarLotacaoByPeriodo($orc_id){
        return $this->repository->loadLotacoesByPeriodo($orc_id);
    }

    public function listarForecast($orc_id, $lotacao_id, $periodo, $tipo_table){        
        
        // $data = $this->listajson();
        // dd($orc_id,$lotacao_id); 
        // return new Response($data , 200); 

        $this->setCodTela('FI');
        $this->podeAcessar('listar',true,$this->getCodTela());
        
 
        $repo = $this->getRepository()->getModelEntity()::with([
                'getOrcamento'=>function($query){                    
                } 
            ])->where('orc_id', '=', $orc_id)            
            ->first();
        
        $orc_lotacao = OrcLotacao::find($lotacao_id);
        $orc_lotacao->hc_iniciado = 1;
        $orc_lotacao->save();
        if(!$repo){
            return "Orçamento não encontrado";
        }

        $set_orcamento = $this->getRepository()->setOrcamento($repo->getOrcamento);
        
        if(!$this->getRepository()->isOwn()){
            dd("adicionar mensagem q não tem permissão");
        }


        $tb_orcamLot_cargo_headcount = new OrcamLotCargoHeadcount();        
        $tb_calc_orcamento = new CalcOrcamento();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tb_lotacao = new OrcLotacao();
        $tb_orc_cargo = new OrcCargo(); 
        $tbl_usuario = new Usuario();
        
        // $forecast_dez_anterior = $this->getForecastAnterior($repo->getOrcamento->id, $orc_lotacao->lotacao_id);


        $data = 
        
        $tb_lotacao->join($tb_orcamLot_cargo_headcount->getTable(),
        $tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'), $tb_lotacao->getColunaAlias('id'))   

        ->join($tb_calc_orcamento->getTable(), $tb_orcamLot_cargo_headcount->getColunaAlias('id'), '=', 
            DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and 
            {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orcamLot_cargo_headcount->getTable()}'"))
        ->join($tb_orc_cargo->getTable(),
            $tb_orcamLot_cargo_headcount->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
        ->join($tb_cargo->getTable(),
            $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))    
        ->join($tb_centro_custo->getTable(),
            $tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id')) 
        ->join($tb_turma->getTable(),
            $tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id'), $tb_turma->getColunaAlias('id'))  
        ->join($tb_turno->getTable(),
                $tb_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('id'))  
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$tb_orcamLot_cargo_headcount->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $tb_calc_orcamento->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )
        ->select(
            DB::raw($tb_calc_orcamento->getColunaAlias('id')),
            DB::raw($tb_orcamLot_cargo_headcount->getColunaAlias('id').' as id_princ'), 
            $tb_orcamLot_cargo_headcount->getColunaAlias('orc_id'), 
            $tb_orcamLot_cargo_headcount->getColunaAlias('qtd_func_lot'), 
            $tb_orcamLot_cargo_headcount->getColunaAlias('atual_total'), 
            $tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'),
            $tb_orcamLot_cargo_headcount->getColunaAlias('periodo'),

            $tb_orcamLot_cargo_headcount->getColunaAlias('orcado_anterior'),
            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('orcado_anterior')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_orcado_anterior"),

            $tb_orcamLot_cargo_headcount->getColunaAlias('origem_sistema'),
            $tb_orc_cargo->getColunaAlias('cargo_id'), 
            $tb_cargo->getColunaAlias('cod_cargo_basic'), 
            $tb_cargo->getColunaAlias('des_cargo_basic'),
            $tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id'), 
            $tb_centro_custo->getColunaAlias('cod_ccusto'), 
            $tb_turma->getColunaAlias('cdn_turma_trab'), 
            $tb_turma->getColunaAlias('des_turma_trab'), 
            $tb_turno->getColunaAlias('cdn_turno_trab'),
            $tb_turno->getColunaAlias('des_turno_trab'),
            $tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id'),

            // DB::raw($forecast_dez_anterior.' as forecast_anterior'), 
            $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_anterior'),
            $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_total'),

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jan_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')}) t_headcount_jan"),
            $tb_calc_orcamento->getColunaAlias('jan_orcado'),

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('fev_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')}) t_headcount_fev"),
            $tb_calc_orcamento->getColunaAlias('fev_orcado'), 

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mar_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')}) t_headcount_mar, 
            {$tb_calc_orcamento->getColunaAlias('mar_orcado')}"), 

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('abr_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')}) t_headcount_abr, 
            {$tb_calc_orcamento->getColunaAlias('abr_orcado')}"), 

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mai_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')}) t_headcount_mai, 
            {$tb_calc_orcamento->getColunaAlias('mai_orcado')}"), 

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jun_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')}) t_headcount_jun, 
            {$tb_calc_orcamento->getColunaAlias('jun_orcado')}"), 

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jul_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')}) t_headcount_jul, 
            {$tb_calc_orcamento->getColunaAlias('jul_orcado')}"), 

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('ago_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')}) t_headcount_ago, 
            {$tb_calc_orcamento->getColunaAlias('ago_orcado')}"), 

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('set_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')}) t_headcount_set, 
            {$tb_calc_orcamento->getColunaAlias('set_orcado')}"), 

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('out_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')}) t_headcount_out, 
            {$tb_calc_orcamento->getColunaAlias('out_orcado')}"),

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('nov_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')}) t_headcount_nov, 
            {$tb_calc_orcamento->getColunaAlias('nov_orcado')}"), 
            
            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('dez_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')}) t_headcount_dez, 
            {$tb_calc_orcamento->getColunaAlias('dez_orcado')}"),

            DB::raw("CASE WHEN {$tb_orcamLot_cargo_headcount->getColunaAlias('created_at')} IS NOT NULL THEN format({$tb_orcamLot_cargo_headcount->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

            DB::raw("CASE WHEN {$tb_calc_orcamento->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tb_calc_orcamento->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
        )
        ->orderByRaw("{$tb_centro_custo->getColunaAlias('cod_ccusto')}, {$tb_cargo->getColunaAlias('cod_cargo_basic')}, 
                        {$tb_turma->getColunaAlias('cdn_turma_trab')}")   
        ->where([
            [$tb_orcamLot_cargo_headcount->getColunaAlias('orc_id'),$orc_id],
            [$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'),$lotacao_id],
            [$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table'),$tipo_table],
            [$tb_orcamLot_cargo_headcount->getColunaAlias('periodo'),$periodo]
        ])
        ->get()
        ->toArray();
        
        return new Response(json_encode($this->montaTreetable($this->pivo($data))) , 200);
    }

    public function montaTreetable($data){
        
        $pivot_colunas = $this->pivotColumns();
        $col_meses = $pivot_colunas->merged;
        $col_set_meses = [];
        $col_meses_parent = [];
        // $row_data: Valores da linha atual
        // * $value: valor da coluna atual ou um valor informado pelo usuario, 
        // * matrix: matriz com todas as linhas(Nao processadas ainda)
        foreach($col_meses as $j=>$mes){
            $col_set_meses[] = ["field_out"=>$j,"from"=>$j, "render_value"=>null,];
            $col_meses_parent[] =["field_out"=>$j,  "from"=>'t_event-'.$j, 
            "field_out_render_func"=>function($row_data,$value, $matrix){

            }];
        }
        $column_fixeds=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"qtd_func_lot", "from"=>"atual_total", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],
            // ["field_out"=>"atual_total", "from"=>"atual_total", "render_value"=>null,],
            ["field_out"=>"turno", "render_value"=>function(){ return "-";},],
            ["field_out"=>"turma", "render_value"=>function(){ return "-";},],
            ["field_out"=>"origem_sistema", "from"=>"origem_sistema", "render_value"=>null,],
            ["field_out"=>"orcado_anterior", "from"=>"t_orcado_anterior", "render_value"=>function($row_data, $value){
                // return ($value) ? intval($value) : $value;
                return is_null($value) ? 0 : $value;
            },],
            ["field_out"=>"forecast_anterior", "from"=>"forecast_total", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"jan", "from"=>"t_headcount_jan", "render_value"=>function($row_data, $value){

                return intval($value);
                //  number_format($value,2,',', '.');
            },],
            ["field_out"=>"fev", "from"=>"t_headcount_fev", "render_value"=>function($row_data, $value){
                return intval($value);
                // number_format($value,2,',', '.');
            },],
            ["field_out"=>"mar", "from"=>"t_headcount_mar","render_value"=>function($row_data, $value){
                return intval($value);
                // return number_format($value,2,',', '.');
            },],
            ["field_out"=>"abr", "from"=>"t_headcount_abr", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"mai", "from"=>"t_headcount_mai", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"jun", "from"=>"t_headcount_jun","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"jul", "from"=>"t_headcount_jul", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"ago", "from"=>"t_headcount_ago", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"set", "from"=>"t_headcount_set", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"out", "from"=>"t_headcount_out", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"nov", "from"=>"t_headcount_nov", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"dez", "from"=>"t_headcount_dez","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,]
            
        ];

        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "render_value"=>function(){ return "";},],
            ["field_out"=>"cod_cargo_basic","render_value"=>function(){ return "";},],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "render_value"=>function(){ return "";},],
            ["field_out"=>"atual", "render_value"=>function(){ return "";},],
            ["field_out"=>"qtd_func_lot", "from"=>"qtd_func_lot", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],
            // ["field_out"=>"atual_total", "from"=>"atual_total", "render_value"=>function($row_data, $value){
            //     return '-';
            // },],

            ["field_out"=>"periodo", "from"=>"periodo", "render_value"=>null,],
            ["field_out"=>"turno", "from"=>"des_turno_trab", "render_value"=>function($row_data, $value){
                return $row_data['cdn_turno_trab'].' - '.$row_data['des_turno_trab'];
            },],

            ["field_out"=>"criado_por", "from"=>"criado_por", "render_value"=>null],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por", "render_value"=>null],
            ["field_out"=>"criado_em", "from"=>"criado_em", "render_value"=>null],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em", "render_value"=>null],

            ["field_out"=>"criado_por", "from"=>"criado_por", "render_value"=>null],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por", "render_value"=>null],
            ["field_out"=>"criado_em", "from"=>"criado_em", "render_value"=>null],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em", "render_value"=>null],

            ["field_out"=>"turma", "from"=>"des_turma_trab", "render_value"=>function($row_data, $value){
                return $row_data['cdn_turma_trab'].' - '.$row_data['des_turma_trab'];
            },],
            ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                return '';//($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"forecast_anterior", "from"=>"forecast_anterior", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },],            
            ["field_out"=>"jan", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"fev", "from"=>"fev_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"mar", "from"=>"mar_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"abr", "from"=>"abr_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"mai", "from"=>"mai_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"jun", "from"=>"jun_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"jul", "from"=>"jul_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"ago", "from"=>"ago_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"set", "from"=>"set_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"out", "from"=>"out_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"nov", "from"=>"nov_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"dez", "from"=>"dez_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"origem_sistema", "from"=>"origem_sistema", "render_value"=>null,]

        ];

        // $columns_base=array_merge($column_fixeds, $col_meses_parent); 
        // $columns_children=array_merge($column_fixeds_children, $col_set_meses); 
        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
            "keys"=>['ccusto_id', 'cargo_id', 'lotacao_id'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children"=>["columns"=>$columns_children,
                    "keys"=>['ccusto_id', 'cargo_id','orc_turma_id', 'lotacao_id'],
                    "filter_data"=>['cod_ccusto'=>function($value){
                        return !is_null($value);
                    }],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result=($value['ccusto_id']== $parent_data['ccusto_id'] && 
                            $value['cargo_id']== $parent_data['cargo_id']&&
                            // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                            $value['lotacao_id']== $parent_data['lotacao_id']);
                        
                            return $result;
                    },
                ]
            ];
                 
        $controller = new AtmTreeTable($settings, $data);
        return ['data'=>$controller->render()];    
    }

    public function pivo($dados){
        $meses_orcado = $this->colum_meses;        
        // $eventos_meses = [13,14,15,16];
        $retorno = [];
        $primary_key = ['ccusto_id','cargo_id','orc_turma_id', 'lotacao_id'];
       
        foreach($dados as $key => $value){
            
            $value = (array)$value;
            $keys_values = implode("-", array_values(Arr::only($value, $primary_key)));
            $ja_foi = array_keys($retorno);
            
            if(in_array($keys_values, $ja_foi) === false){                
                $aux = Arr::except($value,$meses_orcado);   
                $retorno[$keys_values] = $aux;

            }
            foreach($meses_orcado as $j=>$w){                     
                $retorno[$keys_values][$w] = $value[$w];
            }
        }
        return $retorno;
    }
    function pivotColumns(){
        $meses_orcado = $this->colum_meses;
        $eventos_meses = $this->getEventosList();        
        
        $merge_meses_evento = [];
        $meses_orcados_clear = [];
        foreach($meses_orcado as $key => $value){
            
            $var = explode("_",$value);
            $meses_orcados_clear[] = $var[0];
            foreach($eventos_meses as $key_ev =>$value_ev){
                // $merge_meses_evento[$var[0]."-".$value_ev->evento_id] = "";
                $merge_meses_evento[$var[0]."-".$value_ev->getEventos->cdn_event] = "";
            }
        }
        return  (object)['merged'=>$merge_meses_evento, 'mes_abreviado'=>$meses_orcados_clear];
    }
    function getEventosList(){ 
        return $this->getEventOfHour(); 
    }

    public function insert(Request $request){
        
        $this->setCodTela('FI');
        $this->podeAcessar('inserir',true,$this->getCodTela());

        $data_request = $request->all();

        return $this->retornoJsonDefault($this->getRepository()->createForecast($data_request));
    }

    public function updateDistribution(Request $request){        
        set_time_limit(120);
        $this->setCodTela('FI');
        $this->podeAcessar('distribuicao',true,$this->getCodTela());
        $data_request = $request->all();
        
        if( $this->canCRUDForecast($data_request['itens'][0]['lotacao_id'], $data_request['itens'][0]['orc_id'], $data_request['periodo'], 'F') === false){
            $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201411';
            $retorno['submsg'] = 'Erro';
            $retorno['status'] = 'error';
            goto saida;
        }

        $retorno = $this->getArrayRetornoDefault();

        $mes_ini = 1;//intval(substr($data_request['periodo'], 5, 2), 10);
        // if($mes_ini == 13){
        //     $mes_ini = 1;
        // }
        DB::beginTransaction();
        if(!$this->getRepository()->updateValues($data_request['itens'], $data_request['field'], $mes_ini, $data_request['periodo'])){
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg'] = 'Falha ao atualizar o registro. Erro: 0409202015171';
            DB::rollBack();
            goto saida;
        }
        
        if(!$this->getRepository()->calcHeadcount($data_request['itens'][0]['orc_id'], $data_request['itens'][0]['lotacao_id'], $mes_ini, $data_request['periodo'])){
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao calcular o headcount. Erro: 0409202015172';
            DB::rollBack();
            goto saida;
        }
        
        /*$result = null;
        foreach($data_request['itens'] as $value){
            for ($i = $mes_ini; $i <= 12 ; $i++) { 
                $result = $this->getRepository()->validaDistribuicao($i, $data_request['periodo'], $value);
                
                if( $result === false){
                    $retorno['msg'] = "Forecast Inicial incorreto. A distribuição dos valores iria assumir um valor negativo. Por favor, verifique as Transferências/Promoções e Demissões";
                    $retorno['status'] = 'error';
                    DB::rollBack();
                    goto saida;
                }
            }
        }*/

        $dados = $this->validaValoresNegativos($data_request['itens'][0]['orc_id'], $data_request['itens'][0]['lotacao_id'], $data_request['periodo'], 'F');

        if(count($dados) > 0){
            $retorno['msg'] = "Forecast Inicial incorreto. A distribuição dos valores iria assumir um valor negativo. Por favor, verifique as Transferências/Promoções e Demissões";
            $retorno['status'] = 'error';
            DB::rollBack();
            goto saida;
        }

        $retorno['msg'] = 'Distribuição realizada com sucesso!';
        $retorno['status'] = 'success';
        DB::commit();
        saida:
        return $this->retornoJsonDefault($retorno); 
    }
    public function updateForecastTotal(Request $request){
        $this->setCodTela('FI');
        $this->podeAcessar('editar',true,$this->getCodTela());

        $retorno = $this->getArrayRetornoDefault();
        $form_data = $request->all();
        
        if( $this->canCRUDForecast($form_data['lotacao_id'], $form_data['orc_id'], $form_data['periodo'], $form_data['tipo_table']) === false){
            $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201440';
            $retorno['submsg'] = 'Erro';
            $retorno['status'] = 'error';
            goto saida;
        }
        
        if(!$this->getRepository()->updateForecastTotal($form_data)){
            $retorno['msg'] = 'Falha ao atualizar o registro. Erro: 040520201505';
            $retorno['submsg'] = $this->getRepository()->getErrosFlatted();
            goto saida;
        }

        $retorno['msg'] = 'Registro atualizado com sucesso!';
        $retorno['submsg'] = 'Sucesso';
        $retorno['status'] = 'success';
            
        saida:
        return $this->retornoJsonDefault($retorno); 
    }
    public function listarContratacoes($orcamento_id , $lotacao_id , $ccusto_id, $periodo, $tipo_table){
        
        $this->setCodTela('FCONT');
        $this->podeAcessar('listar',true,$this->getCodTela());
        $repo = $this->getRepository()->getModelEntity()::with([
                'getOrcamento'=>function($query){                    
            } 
        ])->where('orc_id', '=', $orcamento_id)            
        ->first();

        if(!$repo){
            return "Orçamento não encontrado";
        }

        $set_orcamento = $this->getRepository()->setOrcamento($repo->getOrcamento);
        
        if(!$this->getRepository()->isOwn()){
            dd("adicionar mensagem q não tem permissão");
        }

        $tb_orcamLot_cargo_headcount = new OrcamLotCargoHeadcount();

        // $data = $this->listajson();
        // return new Response($data , 200);        
        $tb_orcam_headcount_contratacoes = new OrcHeadcountContratacoes();
        $tb_calc_orcamento = new CalcOrcamento();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tb_lotacao = new OrcLotacao();
        $tb_orc_cargo = new OrcCargo();
        $tbl_usuario = new Usuario();

        $query = $tb_lotacao->join($tb_orcam_headcount_contratacoes->getTable(),
        $tb_orcam_headcount_contratacoes->getColunaAlias('lotacao_id'), $tb_lotacao->getColunaAlias('id'))                            
        ->leftJoin($tb_calc_orcamento->getTable(), $tb_orcam_headcount_contratacoes->getColunaAlias('id'), '=', 
            DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and 
            {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orcam_headcount_contratacoes->getTable()}'"))
        ->join($tb_orc_cargo->getTable(),
            $tb_orcam_headcount_contratacoes->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
        ->join($tb_cargo->getTable(),
            $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))    
        ->join($tb_centro_custo->getTable(),
            $tb_orcam_headcount_contratacoes->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id')) 
        ->join($tb_turma->getTable(),
            $tb_orcam_headcount_contratacoes->getColunaAlias('orc_turma_id'), $tb_turma->getColunaAlias('id'))  
        ->join($tb_turno->getTable(),
            $tb_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('id'))  

        ->leftJoin(
            $tb_orcamLot_cargo_headcount->getTable(),
            $tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'),'=',

            DB::raw("{$tb_orcam_headcount_contratacoes->getColunaAlias('lotacao_id')} 
            and {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_cargo_id')} = {$tb_orcam_headcount_contratacoes->getColunaAlias('orc_cargo_id')}
            and {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id')} = {$tb_orcam_headcount_contratacoes->getColunaAlias('orc_turma_id')}
            and {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')} = {$tb_orcam_headcount_contratacoes->getColunaAlias('tipo_table')}
            and {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')} = {$tb_orcam_headcount_contratacoes->getColunaAlias('periodo')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$tb_orcam_headcount_contratacoes->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $tb_calc_orcamento->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )
        ->select(
            $tb_calc_orcamento->getColunaAlias('id'),
            $tb_orcam_headcount_contratacoes->getColunaAlias('orcamento_id'), $tb_orcam_headcount_contratacoes->getColunaAlias('lotacao_id'),
            $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('cod_cargo_basic'), 
            $tb_cargo->getColunaAlias('des_cargo_basic'),$tb_orcam_headcount_contratacoes->getColunaAlias('ccusto_id'), 
            $tb_centro_custo->getColunaAlias('cod_ccusto'), 
            $tb_turma->getColunaAlias('cdn_turma_trab'),
            $tb_turma->getColunaAlias('des_turma_trab'),
            $tb_turno->getColunaAlias('des_turno_trab'),
            $tb_turno->getColunaAlias('cdn_turma_trab'),
            $tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id'),
            $tb_orcamLot_cargo_headcount->getColunaAlias('qtd_func_lot'),
            $tb_orcamLot_cargo_headcount->getColunaAlias('atual_total'),
            $tb_orcamLot_cargo_headcount->getColunaAlias('orcado_anterior'),

            DB::raw("SUM({$tb_orcamLot_cargo_headcount->getColunaAlias('orcado_anterior')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_orcado_anterior"),

            $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_anterior'),
            $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_total'),
            $tb_calc_orcamento->getColunaAlias('jan_orcado'),                                    
            $tb_calc_orcamento->getColunaAlias('fev_orcado'), 
            $tb_calc_orcamento->getColunaAlias('mar_orcado'),                                    
            $tb_calc_orcamento->getColunaAlias('abr_orcado'),                                    
            $tb_calc_orcamento->getColunaAlias('mai_orcado'), 
            $tb_calc_orcamento->getColunaAlias('jun_orcado'),                                    
            $tb_calc_orcamento->getColunaAlias('jul_orcado'), 
            $tb_calc_orcamento->getColunaAlias('ago_orcado'), 
            $tb_calc_orcamento->getColunaAlias('set_orcado'),                                   
            $tb_calc_orcamento->getColunaAlias('out_orcado'),                                   
            $tb_calc_orcamento->getColunaAlias('nov_orcado'), 
            $tb_calc_orcamento->getColunaAlias('dez_orcado'),
            DB::raw("{$tb_orcam_headcount_contratacoes->getColunaAlias('id')} as id_princ"),


            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jan_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_jan"),

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('fev_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_fev"),

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mar_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_mar"), 

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('abr_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_abr"), 

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mai_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_mai"), 

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jun_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_jun"), 

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jul_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_jul"), 

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('ago_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_ago"), 

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('set_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_set"), 

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('out_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_out"),

            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('nov_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_nov"), 
            
            DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('dez_orcado')}) OVER(partition by 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
            {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
            {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')},
            {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_dez"),

            DB::raw("CASE WHEN {$tb_orcam_headcount_contratacoes->getColunaAlias('created_at')} IS NOT NULL THEN format({$tb_orcam_headcount_contratacoes->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

            DB::raw("CASE WHEN {$tb_calc_orcamento->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tb_calc_orcamento->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
        )
        ->orderByRaw("{$tb_centro_custo->getColunaAlias('cod_ccusto')}, {$tb_cargo->getColunaAlias('cod_cargo_basic')}, 
                        {$tb_turma->getColunaAlias('cdn_turma_trab')}");

        
        if(!is_null($orcamento_id)){
            $query->where($tb_orcam_headcount_contratacoes->getTable().'.orcamento_id', $orcamento_id);
        }

        if(!is_null($lotacao_id)){
            $query->where($tb_orcam_headcount_contratacoes->getTable().'.lotacao_id', $lotacao_id);
        }
        /** DESCOMENTAR MAIS PRA FRENTE 08/04/2020 */
        // if(!is_null($ccusto_id)){
        //     $query->where($tb_orcam_headcount_contratacoes->getTable().'.ccusto_id', $ccusto_id);
        // }

        if(!is_null($tipo_table)){
            $query->where($tb_orcam_headcount_contratacoes->getColunaAlias('tipo_table'), $tipo_table);
        }
        if(!is_null($periodo)){
            $query->where($tb_orcam_headcount_contratacoes->getColunaAlias('periodo'), $periodo);
        }

        $data = $query->get()
        ->toArray();
        
        return new Response(json_encode($this->montaTreetableContratacoes($data)) , 200);// $this->pivoContratacoes($data)
    }
    public function montaTreetableContratacoes($data){
        
        $pivot_colunas = $this->pivotColumns();
        $col_meses = $pivot_colunas->merged;
        $col_set_meses = [];
        $col_meses_parent = [];
        // $row_data: Valores da linha atual
        // * $value: valor da coluna atual ou um valor informado pelo usuario, 
        // * matrix: matriz com todas as linhas(Nao processadas ainda)
        foreach($col_meses as $j=>$mes){
            $col_set_meses[] = ["field_out"=>$j,"from"=>$j, "render_value"=>null,];
            $col_meses_parent[] = ["field_out"=>$j,  "from"=>'t_event-'.$j, 
            "field_out_render_func"=>function($row_data,$value, $matrix){

            }];
        }
        
        $column_fixeds=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"atual", "from"=>"atual_total", "render_value"=>null,],
            ["field_out"=>"turno", "render_value"=>function(){ return "-";},],
            ["field_out"=>"turma", "render_value"=>function(){ return "-";},],
            ["field_out"=>"orcado_anterior", "from"=>"t_orcado_anterior", "render_value"=>function($row_data, $value){
                return $value;//'0';//($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"forecast_anterior", "from"=>"forecast_total", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"jan", "from"=>"t_headcount_jan", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"fev", "from"=>"t_headcount_fev", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"mar", "from"=>"t_headcount_mar","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"abr", "from"=>"t_headcount_abr", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"mai", "from"=>"t_headcount_mai", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"jun", "from"=>"t_headcount_jun","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"jul", "from"=>"t_headcount_jul", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"ago", "from"=>"t_headcount_ago", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"set", "from"=>"t_headcount_set", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"out", "from"=>"t_headcount_out", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"nov", "from"=>"t_headcount_nov", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"dez", "from"=>"t_headcount_dez","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,]
            
        ];

        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "render_value"=>function(){ return "";},],
            ["field_out"=>"cod_cargo_basic","render_value"=>function(){ return "";},],
            ["field_out"=>"des_cargo_basic", "render_value"=>function(){ return "";},],
            ["field_out"=>"atual", "from"=>"qtd_func_lot", "render_value"=>null],
            ["field_out"=>"turno", "from"=>"des_turno_trab", "render_value"=>null,],
            ["field_out"=>"turma", "from"=>"des_turma_trab", "render_value"=>null,],

            ["field_out"=>"criado_por", "from"=>"criado_por", "render_value"=>null],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por", "render_value"=>null],
            ["field_out"=>"criado_em", "from"=>"criado_em", "render_value"=>null],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em", "render_value"=>null],

            ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"forecast_anterior", "from"=>"forecast_anterior", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },], 
            ["field_out"=>"jan", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"fev", "from"=>"fev_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"mar", "from"=>"mar_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"abr", "from"=>"abr_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"mai", "from"=>"mai_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"jun", "from"=>"jun_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"jul", "from"=>"jul_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"ago", "from"=>"ago_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"set", "from"=>"set_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"out", "from"=>"out_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"nov", "from"=>"nov_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"dez", "from"=>"dez_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,]
        ];

        // $columns_base=array_merge($column_fixeds, $col_meses_parent); 
        // $columns_children=array_merge($column_fixeds_children, $col_set_meses); 
        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
            "keys"=>['ccusto_id', 'cargo_id', 'lotacao_id'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children"=>["columns"=>$columns_children,
                    "keys"=>['ccusto_id', 'cargo_id', 'lotacao_id', 'orc_turma_id'],
                    "filter_data"=>['cod_ccusto'=>function($value){
                        return !is_null($value);
                    }],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result=($value['ccusto_id']== $parent_data['ccusto_id'] && 
                            $value['cargo_id']== $parent_data['cargo_id']&&
                            // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                            $value['lotacao_id']== $parent_data['lotacao_id']);
                        
                            return $result;
                    },
                    // "children"=>["is_recursive"=>true]

                ]
            ];
                 
        $controller = new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
        
    }
    public function pivoContratacoes($dados){
        $meses_orcado = $this->colum_meses;        
        // $eventos_meses = [13,14,15,16];
        $retorno = [];
        $primary_key = ['ccusto_id','cargo_id','orc_turma_id', 'lotacao_id'];
       
        $merge_meses_evento = [];
        $meses_orcados_clear = [];        
        
        $dados_rest = [];
        foreach($dados as $key => $value){
            
            $value = (array)$value;
            $keys_values = implode("-", array_values(Arr::only($value, $primary_key)));
            $ja_foi = array_keys($retorno);
            
            if(in_array($keys_values, $ja_foi)===false){                
                $aux = Arr::except($value,$meses_orcado);   
                $retorno[$keys_values] = $aux;

            } 
            foreach($meses_orcado as $j=>$w){                     
                $retorno[$keys_values][$w] = $value[$w];
            }
        }
        return $retorno;
    }
    public function liberarForecastNovo(Request $request, $orc_id){
        $ret = [];
        if( $this->isSuspenso($orc_id) == true ){
            $ret['status'] = 'error';
            $ret['submsg'] = 'Erro';
            $ret['msg'] = 'Orçamento Suspenso. Erro: 151020201630';
        }
        else{

            $dados = $request->all();
            unset($dados['_token']);
            $periodo = $dados[array_key_last($dados)];
            unset($dados[array_key_last($dados)]);

            //$this->getRepository()->liberarInsert($dados, $orc_id);
            $resp = $this->getRepository()->liberarInsert($dados, $orc_id, $periodo);

            if(Carbon::parse($periodo)->format('m') == '01'){
                $repo_orcamento = new RepoOrcamento();
                $retorno = $repo_orcamento->inExecutionStatus($orc_id,null);
                // if($retorno['status']!='success'){
                //     return false;
                // }
            }

            //$this->getRepository()->liberarForecast($dados, $orc_id);
            /*$ret = [];
            
            

            if(!$resp){
                $ret['status'] = 'error';
                $ret['submsg'] = 'Erro';
                $ret['msg'] = !$this->getRepository()->getErrosFlatted() ? 'Falha ao liberar...' : $this->getRepository()->getErrosFlatted();
            }else{
                $ret['status'] = 'success';
                $ret['submsg'] = 'Sucesso!';
                $ret['msg'] = 'Liberação feita com sucesso!';
            }
            */
        }
        return $this->retornoJsonDefault($resp);
    }
   
    public function deletarLiberacao(Request $request){
        $dados = $request->all();
        $resp = $this->getRepository()->deletarLiberacao($dados);

        if(!$resp){
            $ret['status'] = 'error';
            $ret['submsg'] = 'Erro';
            $ret['msg'] = $this->getRepository()->getErrosFlatted();
        }else{
            $ret['status'] = 'success';
            $ret['submsg'] = 'Sucesso!';
            $ret['msg'] = 'Liberação excluída com sucesso!';
        }

        return $this->retornoJsonDefault($ret);
    }
    public function listarUltimoPeriodo($orc_id){
        return $this->getRepository()->periodosDisponiveis($orc_id);
    }
    public function listarLotacaoCentroCustoForecast($orc_id, $periodo){
        return $this->getRepository()->listarToPreencherForecast($orc_id, $periodo);
    }
    public function desfazerForecast(Request $request, $orc_id){

        if( $this->isSuspenso($orc_id) == true ){
            $ret['status'] = 'error';
            $ret['submsg'] = 'Erro';
            $ret['msg'] = "Orçamento Suspenso. Erro: 151020201633";
        }
        else{
            $dados = $request->all();
            $resp = $this->getRepository()->desfazerForecast($dados, $orc_id);

            if(!$resp){
                $ret['status'] = 'error';
                $ret['submsg'] = 'Erro';
                $ret['msg'] = $this->getRepository()->getErrosFlatted();
            }else{
                $ret['status'] = 'success';
                $ret['submsg'] = 'Sucesso!';
                $ret['msg'] = 'Liberação Desfeita com sucesso!';
            }
        }
        
        return $this->retornoJsonDefault($ret);
    }
    public function finalizarForecast(Request $request, $orc_id){
        $dados = $request->all();
        if( $this->isSuspenso($orc_id) == true ){
            $ret['status'] = 'error';
            $ret['submsg'] = 'Erro';
            $ret['msg'] = 'Orçamento Suspenso. Erro: 151020201647';
        }
        else{
            $resp = $this->getRepository()->finalizarForecast($dados, $orc_id);
            
            if(Carbon::parse($dados[0])->format('m') == '12'){
                $repo_orcamento = new RepoOrcamento();
                $retorno = $repo_orcamento->finischedStatus($orc_id,null);
                // if($retorno['status']!='success'){
                //     return false;
                // }
            }

            if(!$resp){
                $ret['status'] = 'error';
                $ret['submsg'] = 'Erro';
                $ret['msg'] = $this->getRepository()->getErrosFlatted();
            }else{
                $ret['status'] = 'success';
                $ret['submsg'] = 'Sucesso!';
                $ret['msg'] = 'Período Finalizado com sucesso!';
            }
        }
        return $this->retornoJsonDefault($ret);
    }
    public function updateDados(Request $request, $tipo_table){
        $form_data = $request->all();
        //$this->validaInsertUpdateNegativo();
        if($this->canCRUDForecast($form_data['lotacao_id'], $form_data['orc_id'], $form_data['periodo'], $tipo_table) === false){
            $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201513';
            $retorno['submsg'] = 'Erro';
            $retorno['status'] = 'error';
            return $this->retornoJsonDefault($retorno);
        }
        $forecast_contratacoes = new RepoForecastContratacoes();

        $meses = convertDecimalEn(Arr::only($form_data,['jan', 'fev', 'mar',
        'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez']));

        $form_data['jan'] = $meses['jan'];
        $form_data['fev'] = $meses['fev'];
        $form_data['mar'] = $meses['mar'];
        $form_data['abr'] = $meses['abr'];
        $form_data['mai'] = $meses['mai'];
        $form_data['jun'] = $meses['jun'];
        $form_data['jul'] = $meses['jul'];
        $form_data['ago'] = $meses['ago'];
        $form_data['set'] = $meses['set'];
        $form_data['out'] = $meses['out'];
        $form_data['nov'] = $meses['nov'];
        $form_data['dez'] = $meses['dez'];

        if($form_data['tb'] == 'contratacoes'){
            $this->setCodTela('FCONT');
            $this->podeAcessar('editar',true,$this->getCodTela());
            return $this->retornoJsonDefault($forecast_contratacoes->updateContratacoes($form_data));
        }
    }

    /*public function validaInsertUpdateNegativo(){
        $headcount = $this->getRepositoryOrModel();
        $calc = new CalcOrcamento();

        $select_hd = $headcount->getModelEntity()
        ->join($calc->getTable(), $headcount->getModelEntity()->getColunaAlias('id'), $calc->getColunaAlias('origem_id'))
        ->select()
        ->where($calc->getColunaAlias('tbl_origem'), 'tbl_orc_lot_carg_headcount')
        ->get()->toArray();

        dd($select_hd);
    }*/
    
    public function loadTotalFuncCargoTurmaForecast($lotacao_id, $cargo_id,$turma_id){
        return $this->getRepository()->loadTotalFuncCargoTurma($lotacao_id, $cargo_id,$turma_id);
    }

    public function listarHeadcountHE($orc_id, $lotacao_id, $tipo_table, $periodo){        
        
        $this->setCodTela('FHE');
        $this->podeAcessar('listar',true,$this->getCodTela());
        
        $repo = $this->getRepository()->getModelEntity()::with([
                'getOrcamento'=>function($query){                    
                } 
            ])->where('orc_id', '=', $orc_id)            
            ->first();

        if(!$repo){
            return "Orçamento não encontrado";
        }

        $set_orcamento = $this->getRepository()->setOrcamento($repo->getOrcamento);
        
        if(!$this->getRepository()->isOwn()){
            dd("adicionar mensagem q não tem permissão");
        }
               
       
        $tb_orcam_lot_cargo_evento = new HeadcountHraExtra();
        // $tb_orcamLot_cargo_headcount = new OrcamLotCargoHeadcount();
        $tb_orc_hora_extra = new OrcHoraExtra();
        $tb_calc_orcamento = new CalcOrcamento();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_orc_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tb_turma = new Turma();
        $tb_evento = new Eventos();
        $tb_lotacao = new OrcLotacao();
        $tb_orc_cargo = new OrcCargo();
        $tbl_usuario = new Usuario();

        $alias_calc_orcamento = 'coh';
        $tb_alias = $tb_calc_orcamento->getTable();       
        $tb_alias = $tb_alias . " AS {$alias_calc_orcamento}";
        // DB::enableQueryLog();
        $data = $tb_lotacao->join($tb_orcam_lot_cargo_evento->getTable(),
        $tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id'), $tb_lotacao->getColunaAlias('id'))
                            // ->join($tb_orc_hora_extra->getTable(),$tb_orc_hora_extra->getColunaAlias('id'), '=' ,
                            // DB::raw("{$tb_orcam_lot_cargo_evento->getColunaAlias('evento_id')} and 
                            // {$tb_orc_hora_extra->getColunaAlias('orcamento_id')} = {$tb_orcam_lot_cargo_evento->getColunaAlias('orc_id')}"))                            
            ->leftJoin($tb_calc_orcamento->getTable(), $tb_orcam_lot_cargo_evento->getColunaAlias('id'), '=',                            
            DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and 
            {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orcam_lot_cargo_evento->getTable()}'"))                           
            ->join($tb_orc_cargo->getTable(),
                $tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
            ->join($tb_cargo->getTable(),
                $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))    
            ->join($tb_centro_custo->getTable(),
                $tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id')) 
            ->join($tb_orc_turma->getTable(),
                $tb_orcam_lot_cargo_evento->getColunaAlias('orc_turma_id'), $tb_orc_turma->getColunaAlias('id'))
            ->join($tb_turno->getTable(),
                $tb_orc_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('id'))  
            ->join($tb_turma->getTable(),
                $tb_orc_turma->getColunaAlias('turma_id'), $tb_turma->getColunaAlias('id'))   
            ->join($tb_orc_hora_extra->getTable(),
                $tb_orcam_lot_cargo_evento->getColunaAlias('evento_id'), $tb_orc_hora_extra->getColunaAlias('id')) 
            ->join($tb_evento->getTable(),
                $tb_orc_hora_extra->getColunaAlias('evento_id'), $tb_evento->getColunaAlias('id')) 

            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario1"),
                DB::raw("usuario1.id"),
                DB::raw("{$tb_orcam_lot_cargo_evento->getColunaAlias('created_by')}")
            )
            ->leftJoin(
                DB::raw("{$tbl_usuario->getTable()} as usuario2"),
                $tb_calc_orcamento->getColunaAlias('updated_by'),
                DB::raw("usuario2.id")
            )
            ->select(
                $tb_orcam_lot_cargo_evento->getColunaAlias('id'),
                DB::raw("{$tb_calc_orcamento->getColunaAlias('id')} as calc_orc_id"),
                DB::raw("{$tb_orcam_lot_cargo_evento->getColunaAlias('evento_id')}"),
                DB::raw("{$tb_evento->getColunaAlias('cdn_event')}"),
                $tb_orcam_lot_cargo_evento->getColunaAlias('orc_id'),$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id'),
                $tb_orcam_lot_cargo_evento->getColunaAlias('evento_id'), $tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id'), 
                $tb_cargo->getColunaAlias('cod_cargo_basic'), $tb_cargo->getColunaAlias('des_cargo_basic'),
                $tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('cod_ccusto'),
                $tb_orcam_lot_cargo_evento->getColunaAlias('orc_turma_id'),  
                $tb_turma->getColunaAlias('cdn_turma_trab'),                              
                $tb_turma->getColunaAlias('des_turma_trab'),  
                $tb_turno->getColunaAlias('cdn_turno_trab'),
                $tb_turno->getColunaAlias('des_turno_trab'),
                DB::raw("CONCAT({$tb_turma->getColunaAlias('cdn_turma_trab')}, ' - ', {$tb_turma->getColunaAlias('des_turma_trab')}) turma"),
                DB::raw("CONCAT({$tb_turno->getColunaAlias('cdn_turno_trab')}, ' - ', {$tb_turno->getColunaAlias('des_turno_trab')}) turno"),
                DB::raw("CONCAT({$tb_evento->getColunaAlias('cdn_event')}, ' - ', {$tb_evento->getColunaAlias('des_event')}) evento"),


                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jan_orcado')}) 
                OVER(
                    partition by    {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')},
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('periodo')}) t_event_jan, 
                {$tb_calc_orcamento->getColunaAlias('jan_orcado')}") ,

                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('fev_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')},
                {$tb_orcam_lot_cargo_evento->getColunaAlias('periodo')}) t_event_fev, 
                {$tb_calc_orcamento->getColunaAlias('fev_orcado')}"), 

                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mar_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')},  
                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')},
                {$tb_orcam_lot_cargo_evento->getColunaAlias('periodo')}) t_event_mar, 
                {$tb_calc_orcamento->getColunaAlias('mar_orcado')}"), 

                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('abr_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')},
                {$tb_orcam_lot_cargo_evento->getColunaAlias('periodo')}) t_event_abr, 
                {$tb_calc_orcamento->getColunaAlias('abr_orcado')}"), 

                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mai_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')},
                {$tb_orcam_lot_cargo_evento->getColunaAlias('periodo')}) t_event_mai, 
                {$tb_calc_orcamento->getColunaAlias('mai_orcado')}"), 

                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jun_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')},
                {$tb_orcam_lot_cargo_evento->getColunaAlias('periodo')}) t_event_jun, 
                {$tb_calc_orcamento->getColunaAlias('jun_orcado')}"), 

                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jul_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')},
                {$tb_orcam_lot_cargo_evento->getColunaAlias('periodo')}) t_event_jul, 
                {$tb_calc_orcamento->getColunaAlias('jul_orcado')}"), 

                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('ago_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')},
                {$tb_orcam_lot_cargo_evento->getColunaAlias('periodo')}) t_event_ago, 
                {$tb_calc_orcamento->getColunaAlias('ago_orcado')}"), 

                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('set_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')},
                {$tb_orcam_lot_cargo_evento->getColunaAlias('periodo')}) t_event_set, 
                {$tb_calc_orcamento->getColunaAlias('set_orcado')}"), 

                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('out_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')},
                {$tb_orcam_lot_cargo_evento->getColunaAlias('periodo')}) t_event_out, 
                {$tb_calc_orcamento->getColunaAlias('out_orcado')}"),

                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('nov_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')},
                {$tb_orcam_lot_cargo_evento->getColunaAlias('periodo')}) t_event_nov, 
                {$tb_calc_orcamento->getColunaAlias('nov_orcado')}"), 

                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('dez_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')},
                {$tb_orcam_lot_cargo_evento->getColunaAlias('periodo')}) t_event_dez, 
                {$tb_calc_orcamento->getColunaAlias('dez_orcado')}"),

                DB::raw("CASE WHEN {$tb_orcam_lot_cargo_evento->getColunaAlias('created_at')} IS NOT NULL THEN format({$tb_orcam_lot_cargo_evento->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
                DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

                DB::raw("CASE WHEN {$tb_calc_orcamento->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tb_calc_orcamento->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
                DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
            )
            ->orderByRaw("{$tb_centro_custo->getColunaAlias('cod_ccusto')}, {$tb_cargo->getColunaAlias('cod_cargo_basic')}")//, {$tb_turma->getColunaAlias('cdn_turma_trab')}
            ->where(
                [
                    [$tb_orcam_lot_cargo_evento->getColunaAlias('orc_id'),$orc_id],
                    [$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id'),$lotacao_id],
                    [$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table'),$tipo_table],
                    [$tb_orcam_lot_cargo_evento->getColunaAlias('periodo'),$periodo]
                ]
            ) ->get()
            ->toArray();

        $hd = new HeadcountController();                                    
        return new Response(json_encode($hd->montaTreetableHE($hd->pivoHE($data))) , 200);
    }
    public function listarDemissoes($orc_id, $lotacao_id, $periodo, $tipo_table){
        
        // $this->getTagByTb('demissoes');
        $this->setCodTela('FDEM');
        $this->podeAcessar('listar',true,$this->getCodTela());

        $repo = $this->getRepository()->getModelEntity()::with([
            'getOrcamento'=>function($query){                    
            } 
        ])->where('orc_id', '=', $orc_id)            
        ->first();

        if(!$repo){
            return "Orçamento não encontrado";
        }

        $set_orcamento = $this->getRepository()->setOrcamento($repo->getOrcamento);
        
        if(!$this->getRepository()->isOwn()){
            dd("adicionar mensagem q não tem permissão");
        }
        // dd('sikdnsinsidns',$orc_id,$lotacao_id,$ccusto_id);
        $tb_orcamLot_cargo_headcount = new OrcamLotCargoHeadcount();
        $tb_orc_headcount_demissoes = new OrcHeadcountDemissoes();
        $tb_funcionario = new Funcionario();
        $tb_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_orc_cargo = new OrcCargo();
        $tb_calc_orcamento = new CalcOrcamento();
        $tbl_usuario = new Usuario();

        // DB::enableQueryLog();

        
        $data = $tb_orc_headcount_demissoes->leftJoin($tb_funcionario->getTable(),
                                $tb_funcionario->getColunaAlias('id'), $tb_orc_headcount_demissoes->getColunaAlias('func_id')) 
                            ->leftJoin($tb_turma->getTable(),
                                $tb_orc_headcount_demissoes->getColunaAlias('orc_turma_id'), $tb_turma->getColunaAlias('id'))
                            ->leftJoin($tb_turno->getTable(),
                                    $tb_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('id'))  
                            ->leftJoin($tb_orc_cargo->getTable(),
                                $tb_orc_headcount_demissoes->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
                            ->leftJoin($tb_cargo->getTable(),
                                $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))    
                            ->leftJoin($tb_centro_custo->getTable(),
                                $tb_orc_headcount_demissoes->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id')) 
                            ->leftJoin($tb_calc_orcamento->getTable(), $tb_orc_headcount_demissoes->getColunaAlias('id'), '=',                            
                                DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} 
                                and {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orc_headcount_demissoes->getTable()}' 
                                and {$tb_orc_headcount_demissoes->getColunaAlias('tipo')} = 1
                            "))                            
                            ->leftJoin(
                                $tb_orcamLot_cargo_headcount->getTable(),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'),'=',
    
                                DB::raw("{$tb_orc_headcount_demissoes->getColunaAlias('lotacao_id')} 
                                and {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_cargo_id')} = {$tb_orc_headcount_demissoes->getColunaAlias('orc_cargo_id')}
                                and {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id')} = {$tb_orc_headcount_demissoes->getColunaAlias('orc_turma_id')}
                                and {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')} = {$tb_orc_headcount_demissoes->getColunaAlias('ccusto_id')}
                                and {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')} = {$tb_orc_headcount_demissoes->getColunaAlias('tipo_table')}
                                and {$tb_orcamLot_cargo_headcount->getColunaAlias('periodo')} = {$tb_orc_headcount_demissoes->getColunaAlias('periodo')}")
                            )
                            ->leftJoin( 
                                DB::raw("
                                (select		
                                    orc_d.orc_cargo_id ,
                                    SUM(CASE 		 
                                        WHEN orc_d.tipo = 2 and orc_d.mes = 1 THEN 1
                                        WHEN orc_d.tipo = 3 and orc_d.mes = 1 THEN ISNULL(orc_d.qtde_pessoas, 0)
                                        WHEN orc_d.tipo = 1 THEN ISNULL(co.jan_orcado, 0)
                                        ELSE 0
                                    END) t_headcount_jan,
                                    SUM(CASE 		  
                                        WHEN orc_d.tipo = 2 and orc_d.mes = 2 THEN 1
                                        WHEN orc_d.tipo = 3 and orc_d.mes = 2 THEN ISNULL(orc_d.qtde_pessoas, 0)
                                        WHEN orc_d.tipo = 1 THEN ISNULL(co.fev_orcado, 0)
                                        ELSE 0		  
                                    END) t_headcount_fev,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 3 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 3 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN ISNULL(co.mar_orcado, 0)
                                    ELSE 0
                                    END) t_headcount_mar,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 4 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 4 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN ISNULL(co.abr_orcado, 0)
                                    ELSE 0 
                                    END) t_headcount_abr,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 5 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 5 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN ISNULL(co.mai_orcado, 0)
                                    ELSE 0 
                                    END) t_headcount_mai,
                                SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 6 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 6 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN ISNULL(co.jun_orcado, 0)
                                    ELSE 0 
                                    END) t_headcount_jun,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 7 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 7 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN ISNULL(co.jul_orcado, 0)
                                    ELSE 0 
                                    END) t_headcount_jul,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 8 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 8 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN ISNULL(co.ago_orcado, 0)
                                    ELSE 0 
                                    END) t_headcount_ago,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 9 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 9 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN ISNULL(co.set_orcado, 0)
                                    ELSE 0 
                                    END) t_headcount_set,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 10 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 10 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN ISNULL(co.out_orcado, 0)
                                    ELSE 0 
                                    END) t_headcount_out,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 11 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 11 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN co.nov_orcado
                                    ELSE 0
                                    END) t_headcount_nov,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 12 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 12 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN co.dez_orcado
                                    ELSE 0
                                    END) t_headcount_dez	
                                FROM [tbl_orc_headcount_demissoes] orc_d
                                left join tbl_funcionario f on f.id = orc_d.func_id
                                left join tbl_orc_turma t on t.id = orc_d.orc_turma_id
                                left join tbl_turno tu on tu.id = t.turno_id 
                                left join tbl_orc_cargo oc on oc.id = orc_d.orc_cargo_id
                                left join tbl_cargo c on c.id = oc.cargo_id
                                left join tbl_ccusto cc on cc.id = orc_d.ccusto_id
                                left join tbl_calc_orcamento co on co.origem_id = orc_d.id and co.tbl_origem = 'tbl_orc_headcount_demissoes'
                                left join tbl_orc_lot_carg_headcount hc on hc.lotacao_id = orc_d.lotacao_id and hc.orc_cargo_id = orc_d.orc_cargo_id
                                and hc.orc_turma_id = orc_d.orc_turma_id and hc.ccusto_id = orc_d.ccusto_id and hc.tipo_table = orc_d.tipo_table and hc.periodo = orc_d.periodo
                                where orc_d.orcamento_id = {$orc_id}
                                and orc_d.lotacao_id = {$lotacao_id}
                                and orc_d.tipo_table = '{$tipo_table}'
                                and orc_d.periodo = '{$periodo}'
                                group by orc_d.orc_cargo_id
                                ) totais
                                "), 'totais.orc_cargo_id', '=' ,"{$tb_orc_headcount_demissoes->getColunaAlias('orc_cargo_id')}"
                            )
                            ->leftJoin(
                                DB::raw("{$tbl_usuario->getTable()} as usuario1"),
                                DB::raw("usuario1.id"),
                                DB::raw("{$tb_orc_headcount_demissoes->getColunaAlias('created_by')}")
                             )
                             ->leftJoin(
                                DB::raw("{$tbl_usuario->getTable()} as usuario2"),
                                $tb_calc_orcamento->getColunaAlias('updated_by'),
                                DB::raw("usuario2.id")
                             )
                            ->select(                                
                                DB::raw("{$tb_orc_headcount_demissoes->getColunaAlias('id')} as headcount_demissoes_id"),
                                $tb_calc_orcamento->getColunaAlias('origem_id'),
                                $tb_orc_headcount_demissoes->getColunaAlias('orcamento_id'),
                                $tb_centro_custo->getColunaAlias('cod_ccusto'),
                                $tb_cargo->getColunaAlias('cod_cargo_basic'),
                                $tb_turma->getColunaAlias('cdn_turma_trab'), 
                                $tb_turma->getColunaAlias('des_turma_trab'), 
                                $tb_turno->getColunaAlias('cdn_turno_trab'),
                                $tb_turno->getColunaAlias('des_turno_trab'),
                                $tb_orc_headcount_demissoes->getColunaAlias('ccusto_id'),                                    
                                $tb_orc_cargo->getColunaAlias('cargo_id'),                                    
                                $tb_cargo->getColunaAlias('des_cargo_basic'),
                                
                                $tb_orcamLot_cargo_headcount->getColunaAlias('qtd_func_lot'), 
                                $tb_orcamLot_cargo_headcount->getColunaAlias('atual_total'),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('orcado_anterior'),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_anterior'),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_total'),

                                $tb_orc_headcount_demissoes->getColunaAlias('lotacao_id'),
                                $tb_orc_headcount_demissoes->getColunaAlias('orc_turma_id'),
                                $tb_orc_headcount_demissoes->getColunaAlias('func_id'), 
                                $tb_orc_headcount_demissoes->getColunaAlias('orc_cargo_id'), 
                                $tb_orc_headcount_demissoes->getColunaAlias('qtde_pessoas'), 
                                $tb_orc_headcount_demissoes->getColunaAlias('tempo_casa'),                                    
                                $tb_funcionario->getColunaAlias('cdn_funcionario'), 
                                $tb_funcionario->getColunaAlias('nome_funcionario'), 
                                $tb_orc_headcount_demissoes->getColunaAlias('tipo'),                                   
                                $tb_orc_headcount_demissoes->getColunaAlias('mes'),
                                $tb_calc_orcamento->getColunaAlias('jan_orcado'),
                                $tb_calc_orcamento->getColunaAlias('fev_orcado'),
                                $tb_calc_orcamento->getColunaAlias('mar_orcado'),
                                $tb_calc_orcamento->getColunaAlias('abr_orcado'),
                                $tb_calc_orcamento->getColunaAlias('mai_orcado'),
                                $tb_calc_orcamento->getColunaAlias('jun_orcado'),
                                $tb_calc_orcamento->getColunaAlias('jul_orcado'),
                                $tb_calc_orcamento->getColunaAlias('ago_orcado'),
                                $tb_calc_orcamento->getColunaAlias('set_orcado'),
                                $tb_calc_orcamento->getColunaAlias('out_orcado'),
                                $tb_calc_orcamento->getColunaAlias('nov_orcado'),
                                $tb_calc_orcamento->getColunaAlias('dez_orcado'),
                                DB::raw("totais.t_headcount_jan,
                                totais.t_headcount_fev,
                                totais.t_headcount_mar,
                                totais.t_headcount_abr,
                                totais.t_headcount_mai,
                                totais.t_headcount_jun,
                                totais.t_headcount_jul,
                                totais.t_headcount_ago,
                                totais.t_headcount_set,
                                totais.t_headcount_out,
                                totais.t_headcount_nov,
                                totais.t_headcount_dez"),
                                DB::raw("CASE WHEN {$tb_orc_headcount_demissoes->getColunaAlias('created_at')} IS NOT NULL THEN format({$tb_orc_headcount_demissoes->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
                                DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

                                DB::raw("CASE WHEN {$tb_calc_orcamento->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tb_calc_orcamento->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
                                DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")

                            ) 
                            ->where([
                                [$tb_orc_headcount_demissoes->getColunaAlias('orcamento_id'),$orc_id],
                                [$tb_orc_headcount_demissoes->getColunaAlias('lotacao_id'),$lotacao_id],
                                [$tb_orc_headcount_demissoes->getColunaAlias('tipo_table'),$tipo_table],
                                [$tb_orc_headcount_demissoes->getColunaAlias('periodo'),$periodo]
                            ])
                            ->get()
                            ->toArray();
        $hd = new HeadcountController(); 
        return new Response(json_encode($hd->montaTreetableDemissoes($hd->pivoDemissoes($data))) , 200);
    }


    public function canFillForecast($orc_id, $lotac_id, $periodo){

        if($this->getUserFromCurrentGuard()->tipo == 3){
            return 'true';
        }
        
        $repo_orc_cronograma = new RepoOrcCronograma();
        $repo_atividades = new RepoAtividades();
        
        $cronogramas = $repo_orc_cronograma->getModelEntity()->with([
            'getAtividade'=>function($query){
                return $query->where('title','Preenchimento do Forecast');
            }
        ])->where('orcamento_id', $orc_id)->get()->toArray();
        if(!$cronogramas){
            return 'false';
        }
        if(count($cronogramas)==0){
            return 'false';
        }
        
        $today = Carbon::now();
        $default_orc = null;

        foreach ($cronogramas as $cronograma){            
            if(is_null($cronograma['get_atividade'])){
                continue;
            }

            // if(is_null($cronograma['orc_lotacao_id']) && ($today->between(Carbon::parse($default_orc['start_date'])->startOfDay(), Carbon::parse($default_orc['end_date'])->endOfDay())) ? 'true' : 'false' == true){
            //     $default_orc = $cronograma;
            //     continue;
            // }
            // if($cronograma['orc_lotacao_id'] == $lotac_id){
            //     return ($today->between(Carbon::parse($cronograma['start_date'])->startOfDay(), Carbon::parse($cronograma['end_date'])->endOfDay())) ? 'true' : 'false';
            // }

            if(is_null($cronograma['orc_lotacao_id']) && ($today->between(Carbon::parse($cronograma['start_date'])->startOfDay(), Carbon::parse($cronograma['end_date'])->endOfDay()))){
                return 'true';
            }
            if($cronograma['orc_lotacao_id'] == $lotac_id && $cronograma['periodo'] == $periodo && $cronograma['tipo_table'] == 'F' && ($today->between(Carbon::parse($cronograma['start_date'])->startOfDay(), Carbon::parse($cronograma['end_date'])->endOfDay()))){
                return 'true';
            }

        }

        

        if(!$default_orc){
            return 'false';
        }

        return ($today->between(Carbon::parse($default_orc['start_date'])->startOfDay(), Carbon::parse($default_orc['end_date'])->endOfDay())) ? 'true' : 'false';
    }
    public function listarForecastAba($orc_id, $lotacao_id, $periodo, $tipo_table){
        $tipo_table == 'O' ? $this->setCodTela('RHC') : $this->setCodTela('FRES');
        $this->podeAcessar('listar',true,$this->getCodTela());
        $data = db::select("
            select tbl_calc_orcamento.id, tbl_orc_lot_carg_headcount.id as id_princ, [tbl_orc_lot_carg_headcount].[orc_id], [tbl_orc_lot_carg_headcount].[qtd_func_lot], [tbl_orc_lot_carg_headcount].[atual_total], [tbl_orc_lot_carg_headcount].[lotacao_id], [tbl_orc_lot_carg_headcount].[orcado_anterior], SUM(orcado_anterior) OVER(partition by 
            tbl_orc_lot_carg_headcount.ccusto_id, 
            tbl_orc_lot_carg_headcount.lotacao_id,
            tbl_orc_cargo.cargo_id) t_orcado_anterior, [tbl_orc_lot_carg_headcount].[origem_sistema], [tbl_orc_cargo].[cargo_id], [tbl_cargo].[cod_cargo_basic], [tbl_cargo].[des_cargo_basic], [tbl_orc_lot_carg_headcount].[ccusto_id], [tbl_ccusto].[cod_ccusto], [tbl_orc_turma].[cdn_turma_trab], [tbl_orc_turma].[des_turma_trab], [tbl_turno].[cdn_turno_trab], [tbl_turno].[des_turno_trab], [tbl_orc_lot_carg_headcount].[orc_turma_id], [tbl_orc_lot_carg_headcount].[forecast_anterior], [tbl_orc_lot_carg_headcount].[forecast_total], SUM(tbl_calc_orcamento.jan_orcado) OVER(partition by 
            tbl_orc_lot_carg_headcount.ccusto_id, 
            tbl_orc_lot_carg_headcount.lotacao_id,
            tbl_orc_cargo.cargo_id) t_headcount_jan, [tbl_calc_orcamento].[jan_orcado], SUM(tbl_calc_orcamento.fev_orcado) OVER(partition by 
            tbl_orc_lot_carg_headcount.ccusto_id, 
            tbl_orc_lot_carg_headcount.lotacao_id,
            tbl_orc_cargo.cargo_id,
            tbl_orc_lot_carg_headcount.tipo_table,
            tbl_orc_lot_carg_headcount.periodo) t_headcount_fev, [tbl_calc_orcamento].[fev_orcado], SUM(tbl_calc_orcamento.mar_orcado) OVER(partition by 
            tbl_orc_lot_carg_headcount.ccusto_id, 
            tbl_orc_lot_carg_headcount.lotacao_id,
            tbl_orc_cargo.cargo_id,
            tbl_orc_lot_carg_headcount.tipo_table,
            tbl_orc_lot_carg_headcount.periodo) t_headcount_mar, 
            tbl_calc_orcamento.mar_orcado, SUM(tbl_calc_orcamento.abr_orcado) OVER(partition by 
            tbl_orc_lot_carg_headcount.ccusto_id, 
            tbl_orc_lot_carg_headcount.lotacao_id,
            tbl_orc_cargo.cargo_id,
            tbl_orc_lot_carg_headcount.tipo_table,
            tbl_orc_lot_carg_headcount.periodo) t_headcount_abr, 
            tbl_calc_orcamento.abr_orcado, SUM(tbl_calc_orcamento.mai_orcado) OVER(partition by 
            tbl_orc_lot_carg_headcount.ccusto_id, 
            tbl_orc_lot_carg_headcount.lotacao_id,
            tbl_orc_cargo.cargo_id,
            tbl_orc_lot_carg_headcount.tipo_table,
            tbl_orc_lot_carg_headcount.periodo) t_headcount_mai, 
            tbl_calc_orcamento.mai_orcado, SUM(tbl_calc_orcamento.jun_orcado) OVER(partition by 
            tbl_orc_lot_carg_headcount.ccusto_id, 
            tbl_orc_lot_carg_headcount.lotacao_id,
            tbl_orc_cargo.cargo_id,
            tbl_orc_lot_carg_headcount.tipo_table,
            tbl_orc_lot_carg_headcount.periodo) t_headcount_jun, 
            tbl_calc_orcamento.jun_orcado, SUM(tbl_calc_orcamento.jul_orcado) OVER(partition by 
            tbl_orc_lot_carg_headcount.ccusto_id, 
            tbl_orc_lot_carg_headcount.lotacao_id,
            tbl_orc_cargo.cargo_id,
            tbl_orc_lot_carg_headcount.tipo_table,
            tbl_orc_lot_carg_headcount.periodo) t_headcount_jul, 
            tbl_calc_orcamento.jul_orcado, SUM(tbl_calc_orcamento.ago_orcado) OVER(partition by 
            tbl_orc_lot_carg_headcount.ccusto_id, 
            tbl_orc_lot_carg_headcount.lotacao_id,
            tbl_orc_cargo.cargo_id,
            tbl_orc_lot_carg_headcount.tipo_table,
            tbl_orc_lot_carg_headcount.periodo) t_headcount_ago, 
            tbl_calc_orcamento.ago_orcado, SUM(tbl_calc_orcamento.set_orcado) OVER(partition by 
            tbl_orc_lot_carg_headcount.ccusto_id, 
            tbl_orc_lot_carg_headcount.lotacao_id,
            tbl_orc_cargo.cargo_id,
            tbl_orc_lot_carg_headcount.tipo_table,
            tbl_orc_lot_carg_headcount.periodo) t_headcount_set, 
            tbl_calc_orcamento.set_orcado, SUM(tbl_calc_orcamento.out_orcado) OVER(partition by 
            tbl_orc_lot_carg_headcount.ccusto_id, 
            tbl_orc_lot_carg_headcount.lotacao_id,
            tbl_orc_cargo.cargo_id,
            tbl_orc_lot_carg_headcount.tipo_table,
            tbl_orc_lot_carg_headcount.periodo) t_headcount_out, 
            tbl_calc_orcamento.out_orcado, SUM(tbl_calc_orcamento.nov_orcado) OVER(partition by 
            tbl_orc_lot_carg_headcount.ccusto_id, 
            tbl_orc_lot_carg_headcount.lotacao_id,
            tbl_orc_cargo.cargo_id,
            tbl_orc_lot_carg_headcount.tipo_table,
            tbl_orc_lot_carg_headcount.periodo) t_headcount_nov, 
            tbl_calc_orcamento.nov_orcado, SUM(tbl_calc_orcamento.dez_orcado) OVER(partition by 
            tbl_orc_lot_carg_headcount.ccusto_id, 
            tbl_orc_lot_carg_headcount.lotacao_id,
            tbl_orc_cargo.cargo_id,
            tbl_orc_lot_carg_headcount.tipo_table,
            tbl_orc_lot_carg_headcount.periodo) t_headcount_dez, 
            tbl_calc_orcamento.dez_orcado,

            CASE WHEN [tbl_orc_lot_carg_headcount].created_at IS NOT NULL THEN format([tbl_orc_lot_carg_headcount].created_at, 'dd/MM/yyyy') ELSE '-' END as criado_em,
            CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por,

            CASE WHEN [tbl_calc_orcamento].updated_at IS NOT NULL THEN format([tbl_calc_orcamento].updated_at, 'dd/MM/yyyy') ELSE '-' END as atualizado_em,
            CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por
            
            
            from [tbl_orc_lotacao] 
            
            inner join [tbl_orc_lot_carg_headcount] on [tbl_orc_lot_carg_headcount].[lotacao_id] = [tbl_orc_lotacao].[id] 
            
            inner join [tbl_calc_orcamento] on [tbl_orc_lot_carg_headcount].[id] = tbl_calc_orcamento.origem_id and tbl_calc_orcamento.tbl_origem = 'tbl_orc_lot_carg_headcount' 
            inner join [tbl_orc_cargo] on [tbl_orc_lot_carg_headcount].[orc_cargo_id] = [tbl_orc_cargo].[id] 
            inner join [tbl_cargo] on [tbl_orc_cargo].[cargo_id] = [tbl_cargo].[id] inner join [tbl_ccusto] on [tbl_orc_lot_carg_headcount].[ccusto_id] = [tbl_ccusto].[id] 
            
            inner join [tbl_orc_turma] on [tbl_orc_lot_carg_headcount].[orc_turma_id] = [tbl_orc_turma].[id] 
            inner join [tbl_turno] on [tbl_orc_turma].[turno_id] = [tbl_turno].[id] 

            left join institb_usuario as usuario1 on usuario1.id = [tbl_orc_lot_carg_headcount].created_by
            left join institb_usuario as usuario2 on usuario2.id = [tbl_calc_orcamento].updated_by
            
            where ([tbl_orc_lot_carg_headcount].[orc_id] = ? and
            [tbl_orc_lot_carg_headcount].[lotacao_id] = ? and
            [tbl_orc_lot_carg_headcount].[tipo_table] = ? and
            [tbl_orc_lot_carg_headcount].[periodo] = ? and
            ([tbl_orc_lot_carg_headcount].qtd_func_lot != 0 or [tbl_orc_lot_carg_headcount].forecast_anterior != 0 or 
            tbl_calc_orcamento.jan_orcado != 0 or tbl_calc_orcamento.fev_orcado != 0 or tbl_calc_orcamento.mar_orcado != 0 or 
            tbl_calc_orcamento.abr_orcado != 0 or tbl_calc_orcamento.mai_orcado != 0 or tbl_calc_orcamento.jun_orcado != 0 or 
            tbl_calc_orcamento.jul_orcado != 0 or tbl_calc_orcamento.ago_orcado != 0 or tbl_calc_orcamento.set_orcado != 0 or 
            tbl_calc_orcamento.out_orcado != 0 or tbl_calc_orcamento.nov_orcado != 0 or tbl_calc_orcamento.dez_orcado != 0)) 
            
            order by tbl_ccusto.cod_ccusto, tbl_cargo.cod_cargo_basic, tbl_orc_turma.cdn_turma_trab
        ", [$orc_id, $lotacao_id, $tipo_table, $periodo]);

        $dados = [];
        for($i = 0; $i < count($data); $i++){
            $dados[$i] = (array)$data[$i];
        }

        return new Response(json_encode($this->montaTreetable($this->pivo($data))) , 200);
    }

    public function sendRhForecast($orc_id, Request $request){

        if( $this->isSuspenso($orc_id) == true ){
            $ret['msg'] = "Orçamento Suspenso. Erro: 151020201704";
            $ret['status'] = 'error';
            $ret['submsg'] = 'Erro';
        }
        else{
            $orc_lotacao = new OrcLotacaoController();
            $dados = $request->all();
            // $notificacao = $orc_lotacao->insertNotificacao( $dados['id'], $orc_id );
            $ret = [];
            /*if(!$notificacao){
                $ret['msg'] = $orc_lotacao->getRepository()->getErrosFlatted();
                $ret['status'] = 'error';
                $ret['submsg'] = 'Erro';
            }*/

            $enviar = $orc_lotacao->getRepository()->sendRhForecast($dados['id'], $dados['periodo'], $orc_id);
            if(!$enviar){
                $ret['msg'] = $orc_lotacao->getRepository()->getErrosFlatted();
                $ret['status'] = 'error';
                $ret['submsg'] = 'Erro';
            }
            else{
                $ret['msg'] = "Forecast enviado com sucesso!";
                $ret['status'] = 'success';
                $ret['submsg'] = 'Sucesso!';
            }
        }
        return $this->retornoJsonDefault($ret);
    }

    public function reabrirForecast($orc_id, $lotacao_id, $periodo){
        
        if( $this->isSuspenso($orc_id) == true ){
            $ret['msg'] = "Orçamento Suspenso. Erro: 151020201702";
            $ret['status'] = 'error';
            $ret['submsg'] = 'Erro';
        }
        else{
            // pegar ultimo periodo e ver se ele esta pendente, se houver não reabre
            $resp = $this->getRepository()->reabrirForecastGestor($orc_id, $lotacao_id, $periodo);
            if(!$resp){
                $ret['msg'] = $this->getRepository()->getErrosFlatted();
                $ret['status'] = 'error';
                $ret['submsg'] = 'Erro';
            }
            else{
                $ret['msg'] = "Último período reaberto com sucesso!";
                $ret['status'] = 'success';
                $ret['submsg'] = 'Sucesso!';
            }
        }
        return $this->retornoJsonDefault($ret);
    }

    public function liberarPorTela($orc_id, $tela, Request $request){
        $insert_tudo = new RepoForecastFuncoes($this->fillCodEmpresa(), $this->fillCriadoPor(), $this->fillCriadoEm());
        dd("breka ae");
        $dados = $request->all();
        unset($dados['_token']);
        $periodo = $dados[array_key_last($dados)];
        unset($dados[array_key_last($dados)]);
        //dd($this->getRepositoryOrModel()->notificacaoEmail($orc_id, $periodo));
        $retorno = [];
        $retorno['msg'] = "Forecast liberado com sucesso!";
        $retorno['status'] = 'success';
        $retorno['submsg'] = 'Sucesso!';

        $retorno2 = [];
        $retorno2['msg'] = "Falha ao liberar Forecast!";
        $retorno2['status'] = 'error';
        $retorno2['submsg'] = 'Erro!';

        if($tela == "demissoes"){
            $result = $insert_tudo->inserirDemissoes($dados, $orc_id, $periodo);
            $retorno2['msg'] = $retorno2['msg'].$insert_tudo->getErrosFlatted();
            return $result == true ? $this->retornoJsonDefault($retorno) : $this->retornoJsonDefault($retorno2);
        }
        else if($tela == "contratacoes"){
            $result = $insert_tudo->inserirContratacoes($dados, $orc_id, $periodo);
            $retorno2['msg'] = $retorno2['msg'].$insert_tudo->getErrosFlatted();
            return $result == true ? $this->retornoJsonDefault($retorno) : $this->retornoJsonDefault($retorno2);
        }
        else if($tela == "promocoes"){
            $result = $insert_tudo->inserirPromocoes($dados, $orc_id, $periodo);
            $retorno2['msg'] = $retorno2['msg'].$insert_tudo->getErrosFlatted();
            return $result == true ? $this->retornoJsonDefault($retorno) : $this->retornoJsonDefault($retorno2);
        }
        else if($tela == "aumento_salarial"){
            $result = $insert_tudo->inserirAumentoSalarial($dados, $orc_id, $periodo);
            $retorno2['msg'] = $retorno2['msg'].$insert_tudo->getErrosFlatted();
            return $result == true ? $this->retornoJsonDefault($retorno) : $this->retornoJsonDefault($retorno2);
        }
        else if($tela == "hora_extra"){
            $result = $insert_tudo->inserirHorasExtras($dados, $orc_id, $periodo);
            $retorno2['msg'] = $retorno2['msg'].$insert_tudo->getErrosFlatted();
            return $result == true ? $this->retornoJsonDefault($retorno) : $this->retornoJsonDefault($retorno2);
        }
        else if($tela == "ferias"){
            $result = $insert_tudo->inserirFerias($dados, $orc_id, $periodo);
            $result = $insert_tudo->inserirMovto($dados, $periodo);
            $result = $this->getRepositoryOrModel()->notificacaoEmail($orc_id, $periodo);

            if($result === true){
                return $this->retornoJsonDefault($retorno);
            }
            else{
                $retorno2['msg'] = $retorno2['msg'].$insert_tudo->getErrosFlatted();
                return $this->retornoJsonDefault($retorno2);
            }  
            //return $result == true ? $this->retornoJsonDefault($retorno) : $this->retornoJsonDefault($retorno2);
        }
        else{
            $retorno2['msg'] = 'Tela não encontrada. Erro: 261220201738';
            $retorno2['status'] = 'error';
            $retorno2['submsg'] = 'Erro';
            return $this->retornoJsonDefault($retorno2);
        }
    }

    public function deleteForecast(Request $request){
        $dados = $request->all();
        // $meses = ['jan', 'fev', 'mar', 'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez'];
        
        $resp = $this->getRepository()->deleteForecast($dados);
        return $this->retornoJsonDefault($resp);
    }

    public function liberarParametrizacao($orc_id, $periodo){
        $retorno = [];
        set_time_limit(720); 
        goto teste;
        if( $this->isSuspenso($orc_id) == true ){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            $retorno['msg'] = 'Orçamento Suspenso. Erro: 190220210902';
        }

        $cargo = DB::select("SELECT * FROM tbl_orc_cargo where orcamento_id = $orc_id and periodo = '{$periodo}' and tipo_table = 'F' ");
        if(count($cargo) > 0){
            $retorno['status'] = 'error';
            $retorno['msg'] = 'O período selecionado já foi liberado. Para que o próximo período esteja disponível, faça o preenchimento do Forecast<br>Erro: 020220211635';
            $retorno['submsg'] = 'Erro';

            goto saida;
        }

        $lotacoes = DB::select("SELECT * FROM tbl_orc_lotacao where orcamento_id = $orc_id and periodo = '{$periodo}' and tipo_table = 'F' ");
        if(count($lotacoes) > 0){
            $retorno['status'] = 'error';
            $retorno['msg'] = 'O período selecionado já foi liberado. Para que o próximo período esteja disponível, faça o preenchimento do Forecast<br>Erro: 020220211635';
            $retorno['submsg'] = 'Erro';

            goto saida;
        }

        $preenchimento_liberado = DB::select("SELECT cron.*, ac.id from tbl_activities as ac
            inner join tbl_orc_cronograma as cron on cron.activity_id = ac.id
            where title like ('%orecast%') and title like ('%reenchimento%') and (cron.end_date >= GETDATE()) and cron.orcamento_id = $orc_id
            order by cron.start_date asc
        ");// cron.start_date <= GETDATE()

        if(count($preenchimento_liberado) == 0){
            $retorno['status'] = 'error';
            $retorno['msg'] = "Não existe uma atividade cadastrada para o preenchimento do forecast com data válida. Erro: 040220210935";
            $retorno['submsg'] = 'Erro';
            
            goto saida;
        }
        
        $status_erro_msg = 14;
        // $select_periodo = DB::select("SELECT * from tbl_orc_movto_status_ccusto as st
        //     inner join tbl_orc_lotacao as lot on lot.id = st.orc_lotacao_id and lot.orcamento_id = $orc_id
        //         and lot.tipo_table = 'F' and lot.periodo is not null
        //     where (lot.status <= $status_erro_msg and st.status_atual <= $status_erro_msg) and lot.periodo = DATEADD(month, -1, cast('{$periodo}' as date))"
        // );

        /*$select_periodo = DB::select("SELECT * from tbl_orc_lotacao
            where orcamento_id = $orc_id and tipo_table = 'F' and periodo = DATEADD(month, -1, cast('{$periodo}' as date)) and status <= {$status_erro_msg}
        ");

        if( count($select_periodo) > 0){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            $retorno['msg'] = "Finalize o(s) Forecast(s) existente(s) para liberar o atual. Erro: 040220210936";
            goto saida;
        }*/
        $select_periodo = DB::select("SELECT concat(cc.cod_ccusto, ' - ', lot.unid_lotac, ' - ', lot.des_unid_lotac) as 'desc' from tbl_orc_lotacao as olot
            inner join tbl_lotacao as lot on lot.id = olot.lotacao_id
            inner join tbl_ccusto as cc on cc.id = olot.cc_custo_id
            where orcamento_id = $orc_id and tipo_table = 'F' and periodo = DATEADD(month, -1, cast('{$periodo}' as date)) and status <= {$status_erro_msg} and olot.ativo = 1
            
        ");

        if( count($select_periodo) > 0){
            $desc = "";
            for($i = 0; $i < count($select_periodo); $i++){
                $desc = ($i == count($select_periodo)-1) ? $desc = $desc.$select_periodo[$i]->desc : $desc.$select_periodo[$i]->desc."; ";
            }
            $retorno['submsg'] = 'Atenção';
            $retorno['status'] = 'warning';
            $retorno['msg'] = "Finalize a(s) Lotação(ões) existente(s) para liberar um novo período. <br>Lotação(ões): {$desc}.<br>Erro: 310320211324";
            return $retorno;
        } 
        
        
        /*$status_orcamento = DB::select("SELECT id from tbl_orcamento where id = $orc_id and status_aprovacao <> 7");
        
        if(count($status_orcamento) > 0){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            $retorno['msg'] = "O orçamento deve ser aprovado antes de liberar o forecast. Erro: 040220210937";
            goto saida;
        }*/

        teste:
        $repo_param = new RepoScriptsLiberaParamForecast($periodo, $orc_id);
        $retorno = [];

        DB::beginTransaction();
        if($repo_param->inserirTudo() === false){
            $retorno['status'] = 'error'; 
            $retorno['msg'] = 'Falha ao inserir parametrizações. Erro: 020220211626 - '.$repo_param->msg;
            $retorno['submsg'] = 'Erro';
            DB::rollBack();
            goto saida;
        }
        $retorno = $this->getRepository()->liberarOrcFuncionario($orc_id, $periodo);
        if($retorno['status'] == 'error'){
            DB::rollBack();
            goto saida;
        }

        DB::commit();
        $retorno['status'] = 'success';
        $retorno['msg'] = 'Parametrização liberada com sucesso!';
        $retorno['submsg'] = 'Sucesso!';
        saida:
        return $this->retornoJsonDefault($retorno);
    }

    
    public function getPeriodoCalcular($orc_id, $tipo_table = 'F'){
        // $orc_id = 168156;

        $meses = ['01' => 'Janeiro', '02' => 'Fevereiro', '03' => 'Março', '04' => 'Abril', '05' => 'Maio', '06' => 'Junho', 
        '07' => 'Julho', '08' => 'Agosto', '09' => 'Setembro', '10' => 'Outubro', '11' => 'Novembro', '12' => 'Dezembro'];

        if($tipo_table == 'F'){
            $periodo = $this->getRepository()->getModelEntity()->where('orc_id', $orc_id)->where('tipo_table', 'F')->max('periodo');
        }
        else{
            $periodo = Carbon::now()->day(1)->subMonth()->format('Y-m-d');
        }        

        $retorno['periodo'] = $periodo;
        $retorno['periodo_format'] = is_null($periodo) ? NULL : Carbon::parse($periodo)->format('d/m/Y');

        $mes = is_null($periodo) ? NULL : Carbon::parse($periodo)->format('m');

        if(!is_null($mes)){
            $mes = $meses[$mes];
        }

        $retorno['mes'] = $mes;        

        return new Response($retorno, 200);
    }

}