<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Http\Controllers\OrcamentoController;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoForecastDemissoes as RepoForecastDemissoes;
use App\Support\TreeTable\AtmTreeTable;
use App\Modules\Natureza51\Entities\OrcFuncionario;


class ForecastDemissoesController extends OrcamentoController
{
    use \App\Core\Traits\ErrorTrait;
    
    public function __construct(){
        
        $this->repository=new RepoForecastDemissoes();
        $this->setCodTela('FDEM');
        parent::__construct();
    }

    public function insert(Request $data){
		set_time_limit(120);
        $this->setCodTela('FDEM');
        $this->podeAcessar('inserir',true,$this->getCodTela());

        $dados = $data->all();
        
        if( $this->canCRUDForecast($dados['lotacao_id'], $dados['orcamento_id'], $dados['periodo'], $dados['tipo_table']) === false){
            $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201442';
            $retorno['submsg'] = 'Erro';
            $retorno['status'] = 'error';
            return $this->retornoJsonDefault($retorno);    
        }

        $a = $this->retornoJsonDefault($this->getRepository()->created($data->all()));
        return $a;
     
    }

    public function deleteAll(Request $request){
        set_time_limit(120);
        $this->setCodTela('FDEM');
        $this->podeAcessar('deletar',true,$this->getCodTela());
        $rqst = $request->all();
        
        if($this->canCRUDForecast($rqst['lotacao_id'], $rqst['orcamento_id'], $rqst['periodo'], 'F') === false){
            $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201451';
            $retorno['submsg'] = 'Erro';
            $retorno['status'] = 'status';
            return $retorno;
        }

        unset($rqst['_token']);       
        return $this->getRepository()->deleteAll($rqst);
    }

    
    public function orcFuncCargo($orcamento_id, $func_id, $periodo = null, $tipo_table = 'O'){
        set_time_limit(120);
        $orc_func = new OrcFuncionario();

        $query = OrcFuncionario::where('orcamento_id', $orc_func['orcamento_id'] = $orcamento_id)
        ->where('funcionario_id', $orc_func['funcionario_id'] = $func_id)
        ->where('tipo_table', $tipo_table);
        
        $orc_func = null;
        if($tipo_table == 'F'){
            $orc_func = $query->where('periodo', $periodo)->first();
        }
        else{
            $orc_func = $query->whereNull('periodo', $periodo)->first();
        }
        
       // $cargo = $orc_func['orc_cargo_id'];
       // $turma = $orc_func['orc_turma_id'];
       // $lotacao = $orc_func['orc_lotacao_id'];
        
        $funcionario = json_encode($orc_func);

        return $funcionario;
    }
} 