<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoForecastFerias as RepoForecastFerias;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento as RepoCalcOrcamento;
use Illuminate\Http\Request as Request;
use Illuminate\Http\Response;
use Illuminate\Support\Arr;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Facades\DB;

class ForecastFeriasController extends OrcamentoController
{
    
    public function __construct(){
        parent::__construct();
        $this->repository = new RepoForecastFerias();
    } 
    public function listarAll($orc_id){ 
        // DB::enableQueryLog();
        $dd=$this->getRepository()->listAll($orc_id);
    } 
    public function listarByTurma($orc_id, $lotacao, $periodo, $tipo_table){
        $this->setCodTela('FFERIAS');
        $this->podeAcessar('listar',true,$this->getCodTela());

        $data = $this->repository->listarByTurma($orc_id, $lotacao, $periodo, $tipo_table);
        $columns_base= $this->getColumnsBase();
        $columns_children= $this->getColumnsChildren();

        $settings=["columns"=>$columns_base,
            "keys"=>['cargo_id','lotacao_id'],
            "filter_data"=>['parent'=>function($value){
                    return is_null($value);
            }    
            ],                                  
            "children"=>["columns"=>$columns_children,
                "keys"=>['id'], 
                "filter_data"=>['parent'=>function($value){
                    return is_null($value);
                }],
                'parent_filter'=> function($value, $parent_data){                            
                        return $value['cargo_id']== $parent_data['cargo_id'] ;
                },
            ] 
        ]; 

        // for($i=0;$i<count($data);$i++){
        //     $data[$i]['jan_orcado'] = number_format($data[$i]['jan_orcado'],2,',', '.');
        // }
        
        $controller=new AtmTreeTable($settings,  $data);
        //dd($controller);
        return new Response(json_encode($controller->render(),200));

    } 

    public function listarByFuncionario($orc_id, $lotacao, $periodo, $tipo_table){
        $this->setCodTela('FFERIAS');
        $this->podeAcessar('listar',true,$this->getCodTela());

        $data = $this->repository->listarByFuncionario($orc_id, $lotacao, $periodo, $tipo_table);         
       
        $settings=["columns"=>$this->getColumnsBaseFuncionario(),
            "keys"=>['cargo_id','lotacao_id'],
            "filter_data"=>['parent'=>function($value){
                    return is_null($value);
            }    
            ],                                  
            "children"=>["columns"=>$this->getColumnsChildrenFuncionario(),
                "keys"=>['id'], 
                "filter_data"=>['parent'=>function($value){
                    return is_null($value);
                }],
                'parent_filter'=> function($value, $parent_data){                            
                        return $value['cargo_id']== $parent_data['cargo_id'] ;
                },
            ] 
        ]; 

        $controller=new AtmTreeTable($settings,  $data);
        
        return new Response(json_encode($controller->render(),200));

    }

    public function insertFerias(Request $request){
        $this->setCodTela('FFERIAS');
        $this->podeAcessar('inserir',true,$this->getCodTela());

        $dados = $request->all();

        if($this->canCRUDForecast($dados['lotacao_id'], $dados['orcamento_id'], $dados['periodo'], $dados['tipo_table']) === false){
            $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201611';
            $retorno['submsg'] = 'Erro';
            $retorno['status'] = 'error';
            return $this->retornoJsonDefault($retorno);
        }

        $meses_arr = ['jan_orcado', 'fev_orcado', 'mar_orcado','abr_orcado','mai_orcado', 'jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];
        $meses = $this->dataFilterMesesCalcOrcamento($request->all());
        $data = $this->dataFilterFerias($request->all());
        
        if($dados['type'] == 0){
            $orc_cargo = DB::select("SELECT id from tbl_orc_cargo where cargo_id = ? and orcamento_id = ? and periodo = ? and tipo_table = 'F' ", [$dados['cargo_id'], $dados['orcamento_id'], $dados['periodo']]);
            if(count($orc_cargo) > 0){
                $ret = $this->analisaTipoCargoTurma($orc_cargo[0]->id, $dados['orc_turma_id'], $dados['periodo'], $dados['tipo_table'], $dados['orcamento_id'], $dados['lotacao_id'], $meses);
                if($ret !== true){
                    return $this->retornoJsonDefault($ret);
                }
            }
        }
        
        for($i = 0; $i < count($meses_arr); $i++){
            if(!array_key_exists($meses_arr[$i], $meses)){
                $meses[$meses_arr[$i]] = 0;
            }
        }
        
        return $this->retornoJsonDefault($this->getRepository()->insertFerias($data,$meses));
    } 

    public function analisaTipoCargoTurma($cargo_id, $orc_turma_id, $periodo, $tipo_table, $orc_id, $lotacao_id, $meses_calc){
        $select = DB::select("SELECT calc.* from tbl_orc_lot_carg_headcount as hd
            left join tbl_calc_orcamento as calc on calc.origem_id = hd.id and calc.tbl_origem = 'tbl_orc_lot_carg_headcount'
            inner join tbl_orc_cargo as oc on oc.id = hd.orc_cargo_id and oc.periodo = '{$periodo}' and oc.tipo_table = '{$tipo_table}'
            
            where oc.id = $cargo_id  and hd.tipo_table = '{$tipo_table}' and hd.periodo = '{$periodo}' and hd.orc_turma_id = {$orc_turma_id} and hd.lotacao_id = $lotacao_id and hd.orc_id = $orc_id"
        );

        $meses = ['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];
        $meses_desc = ['Janeiro','Fevereiro','Março','Abril','Maio','Junho','Julho','Agosto','Setembro','Outubro','Novembro','Dezembro'];
        
        if(count($select) == 0){
            return false;
        }
        $select = (array) $select[0];
        $retorno = [];

        if(count($select) > 0){
            for($i = 0; $i < 12; $i++){
                if(array_key_exists($meses[$i], $meses_calc)){
                    if($meses_calc[$meses[$i]] > $select[$meses[$i]]){
                        $retorno['msg'] = 'O número de pessoas no mês de '.$meses_desc[$i].' não pode ser maior do que a quantidade digitada em Cargo/Turma. Erro: 261220201400';
                        $retorno['submsg'] = 'Erro';
                        $retorno['status'] = 'error';
                        return $retorno;
                    }
                }
                
            }
            return true;
        }
    }
    public function update(Request $request){
        $this->setCodTela('FFERIAS');
        $this->podeAcessar('editar',true,$this->getCodTela());

        $dados = $request->all();
        
        if($this->canCRUDForecast($dados['lotacao_id'], $dados['orcamento_id'], $dados['periodo'], $dados['tipo_table']) === false){
            $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201513';
            $retorno['submsg'] = 'Erro';
            $retorno['status'] = 'error';
            return $this->retornoJsonDefault($retorno);
        }

        $form_data = Arr::except($dados, ['criado_em','criado_por','atualizado_em','atualizado_por']);
        $meses = $this->dataFilterMesesCalcOrcamento($form_data);
        // $cargo_id = DB::select("SELECT cargo_id from tbl_orc_cargo where id = {$dados['cargo_id']}");

        // if(count($cargo_id) < 1){
        //     $retorno['msg'] = 'Cargo não encontrado. Erro: 261220201409';
        //     $retorno['submsg'] = 'Erro';
        //     $retorno['status'] = 'error';
        //     return $this->retornoJsonDefault($retorno);
        // }
        if($dados['type'] == 0){
            $ret = $this->analisaTipoCargoTurma($dados['cargo_id'], $dados['orc_turma_id'], $dados['periodo'], $dados['tipo_table'], $dados['orcamento_id'], $dados['lotacao_id'], $meses);
            if($ret !== true){
                return $this->retornoJsonDefault($ret);
            }
        }

        $data = $this->dataFilterFerias($form_data);
        // dd($meses, $data, $request->all());
        $retorno = $this->getRepository()->editarFerias($form_data['id'],$data,$meses);

        return $this->retornoJsonDefault($retorno); 
    } 
    public function delete(Request $request){
        $this->setCodTela('FFERIAS');
        $this->podeAcessar('deletar',true,$this->getCodTela());

        $form_data = $request->all();
        
        if($this->canCRUDForecast($form_data['lotacao_id'], $form_data['orcamento_id'], $form_data['periodo'], $form_data['tipo_table']) === false){
            $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201513';
            $retorno['submsg'] = 'Erro';
            $retorno['status'] = 'error';
            return $this->retornoJsonDefault($retorno);
        }

        $retorno = $this->getRepository()->deleteFerias($form_data);
        return  $this->retornoJsonDefault($retorno);
    } 
    public function pivo($dados){
        $meses_orcado = ['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado',
        'jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];
        $eventos_meses = [13,14,15,16];
        $retorno=[];
        $primary_key=['id','lotacao_id','cargo_id',];
       
        $merge_meses_evento=[];
        $meses_orcados_clear=[];        
        
        $dados_rest = [];
        foreach($dados as $key => $value){
            
            $value=(array)$value;
            $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
            $ja_foi=array_keys($retorno);
            
            if(in_array($keys_values, $ja_foi)===false){                
                $aux=Arr::except($value,$meses_orcado);   
                $retorno[$keys_values]=$aux;

            }
            foreach($meses_orcado as $j=>$w){                     
                $retorno[$keys_values][$w]=$value[$w];
            }
        }
        return $retorno;
    }

    public function getColumnsBase(){
        return $columns_base=[
            ["field_out"=>"parent", "from"=>"turma_id", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null],
            ["field_out"=>"des_turma_trab", "from"=>"des_turma_trab", "render_value"=>function() { return "-"; } ],
            ["field_out"=>"des_turno_trab", "from"=>"des_turno_trab", "render_value"=>function() { return "-"; } ],
            ["field_out"=>"nome_funcionario", "from"=>"nome_funcionario", "render_value"=>null],
            ["field_out"=>"description_funcionario", "from"=>"description_funcionario", "render_value"=>null],//
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null],["field_out"=>"qtd_func_lot", "from"=>"atual_total", "render_value"=>null,],
            ["field_out"=>"forecast_anterior", "from"=>"forecast_total", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },], 
            ["field_out"=>"jan_orcado", "from"=>"t_event_jan", "render_value"=>function($row_data, $value){
                
                return intval($value);
                //  number_format($value,2,',', '.');
            },],
            ["field_out"=>"fev_orcado", "from"=>"t_event_fev", "render_value"=>function($row_data, $value){
                return intval($value);
                // number_format($value,2,',', '.');
            },],
            ["field_out"=>"mar_orcado", "from"=>"t_event_mar","render_value"=>function($row_data, $value){
                return intval($value);
                // return number_format($value,2,',', '.');
            },],
            ["field_out"=>"abr_orcado", "from"=>"t_event_abr", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"mai_orcado", "from"=>"t_event_mai", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"jun_orcado", "from"=>"t_event_jun","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"jul_orcado", "from"=>"t_event_jul", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"ago_orcado", "from"=>"t_event_ago", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"set_orcado", "from"=>"t_event_set", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"out_orcado", "from"=>"t_event_out", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"nov_orcado", "from"=>"t_event_nov", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"dez_orcado", "from"=>"t_event_dez","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
        ];     
    }
    public function getColumnsChildren(){
        return $columns_children=[
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id", "render_value"=>null],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"type", "from"=>"type", "render_value"=>null],
            ["field_out"=>"des_turma_trab", "from"=>"des_turma_trab", "render_value"=>function($row_data,$value,$matrix){
                return (is_null($value))? $row_data['nome_funcionario'] : $row_data['des_turma_trab'];
            }],
            ["field_out"=>"funcionario", "from"=>"nome_funcionario", "render_value"=>null],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null],//
            // ["field_out"=>"description_funcionario", "from"=>"description_funcionario", "render_value"=>null],//
            // ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null],//
            ["field_out"=>"des_turno_trab", "from"=>"des_turno_trab", "render_value"=>null],
            ["field_out"=>"lotacao_responsavel", "from"=>"lotacao_responsavel", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],
            ["field_out"=>"func_id", "from"=>"func_id", "render_value"=>null],
            ["field_out"=>"parent","from"=>"parent","render_value"=>null],
            ["field_out"=>"qtd_func_lot", "from"=>"atual_total", "render_value"=>null,],

            ["field_out"=>"criado_por", "from"=>"criado_por", "render_value"=>null],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por", "render_value"=>null],
            ["field_out"=>"criado_em", "from"=>"criado_em", "render_value"=>null],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em", "render_value"=>null],

            ["field_out"=>"forecast_anterior", "from"=>"forecast_anterior", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"jan_orcado", "from"=>"jan_orcado", "render_value"=>function($matriz,$value){                
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"fev_orcado", "from"=>"fev_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"mar_orcado", "from"=>"mar_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"abr_orcado", "from"=>"abr_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"mai_orcado", "from"=>"mai_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"jun_orcado", "from"=>"jun_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"jul_orcado", "from"=>"jul_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"ago_orcado", "from"=>"ago_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"set_orcado", "from"=>"set_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"out_orcado", "from"=>"out_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"nov_orcado", "from"=>"nov_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"dez_orcado", "from"=>"dez_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },]
        ];
    }

    public function getColumnsBaseFuncionario(){
        return $columns_base=[
            ["field_out"=>"parent", "from"=>"turma_id", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null],
            ["field_out"=>"des_turma_trab", "from"=>"des_turma_trab", "render_value"=>function() { return "-"; } ],
            ["field_out"=>"des_turno_trab", "from"=>"des_turno_trab", "render_value"=>function() { return "-"; } ],
            ["field_out"=>"turma","from"=>"turma","render_value"=>function() { return "-"; }],
            ["field_out"=>"turno","from"=>"turno","render_value"=>function() { return "-"; }],
            ["field_out"=>"nome_funcionario", "from"=>"nome_funcionario", "render_value"=>function() { return "-"; }],
            ["field_out"=>"description_funcionario", "from"=>"description_funcionario", "render_value"=>function() { return "-"; }],//
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null],
            ["field_out"=>"qtd_func_lot", "from"=>"atual_total", "render_value"=>null,],
            ["field_out"=>"forecast_anterior", "from"=>"forecast_total", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },], 
            ["field_out"=>"jan_orcado", "from"=>"t_event_jan", "render_value"=>function($row_data, $value){                
                return intval($value);
            },],
            ["field_out"=>"fev_orcado", "from"=>"t_event_fev", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"mar_orcado", "from"=>"t_event_mar","render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"abr_orcado", "from"=>"t_event_abr", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"mai_orcado", "from"=>"t_event_mai", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"jun_orcado", "from"=>"t_event_jun","render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"jul_orcado", "from"=>"t_event_jul", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"ago_orcado", "from"=>"t_event_ago", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"set_orcado", "from"=>"t_event_set", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"out_orcado", "from"=>"t_event_out", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"nov_orcado", "from"=>"t_event_nov", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"dez_orcado", "from"=>"t_event_dez","render_value"=>function($row_data, $value){
                return intval($value);
            },],
        ];     
    }
    public function getColumnsChildrenFuncionario(){
        return $columns_children=[
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id", "render_value"=>null],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"type", "from"=>"type", "render_value"=>null],
            ["field_out"=>"des_turma_trab", "from"=>"des_turma_trab", "render_value"=>function($row_data,$value,$matrix){
                return (is_null($value))? $row_data['nome_funcionario'] : $row_data['des_turma_trab'];
            }],
            ["field_out"=>"funcionario", "from"=>"nome_funcionario", "render_value"=>null],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null],//
            ["field_out"=>"description_funcionario", "from"=>"description_funcionario", "render_value"=>null],//
            // ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null],//
            ["field_out"=>"des_turno_trab", "from"=>"des_turno_trab", "render_value"=>null],
            ["field_out"=>"turma","from"=>"turma","render_value"=>null],
            ["field_out"=>"turno","from"=>"turno","render_value"=>null],
            ["field_out"=>"lotacao_responsavel", "from"=>"lotacao_responsavel", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],
            ["field_out"=>"func_id", "from"=>"func_id", "render_value"=>null],
            ["field_out"=>"parent","from"=>"parent","render_value"=>null],
            ["field_out"=>"qtd_func_lot", "from"=>"atual_total", "render_value"=>function() { return "-"; },],

            ["field_out"=>"criado_por", "from"=>"criado_por", "render_value"=>null],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por", "render_value"=>null],
            ["field_out"=>"criado_em", "from"=>"criado_em", "render_value"=>null],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em", "render_value"=>null],

            ["field_out"=>"forecast_anterior", "from"=>"forecast_anterior", "render_value"=>function($row_data, $value){
                return '-';
            },],
            ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                return '-';
            },],
            ["field_out"=>"jan_orcado", "from"=>"jan_orcado", "render_value"=>function($matriz,$value){                
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"fev_orcado", "from"=>"fev_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"mar_orcado", "from"=>"mar_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"abr_orcado", "from"=>"abr_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"mai_orcado", "from"=>"mai_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"jun_orcado", "from"=>"jun_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"jul_orcado", "from"=>"jul_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"ago_orcado", "from"=>"ago_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"set_orcado", "from"=>"set_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"out_orcado", "from"=>"out_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"nov_orcado", "from"=>"nov_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },],
            ["field_out"=>"dez_orcado", "from"=>"dez_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):0;
            },]
        ];
    }

    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['tipo_table','periodo','funcionario_id', 'orc_id','orc_turma_id','func_id' ,'lotacao_id','cargo_id','parent','id' ,'lotacao_responsavel','orcamento_id','type','des_cargo_basic','des_turma_basic','des_turno_basic','nome_funcionario','turma_or_func','ccusto_id', 'funcionario', 'des_turma_trab', 'des_turno_trab', 'qtd_func_lot', 'forecast_anterior', 'description_funcionario', 'turma', 'turno', 'orcado_anterior'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] )); 
        $meses = [];
        foreach($filtered as $key => $value){
            $meses[$key] = (is_string($value)) ? intval($value) : $value;
            
        }
        
        return $filtered;
    }
    public function dataFilterFerias($data){
        $array_orcamento=['jan_orcado', 'fev_orcado', 'mar_orcado','abr_orcado','mai_orcado', 'jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado','tbl_origem','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','origem_id','id','parent','des_cargo_basic','des_cargo_basic','des_turma_basic','des_turno_basic','nome_funcionario'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

 
    public function orcFuncCargo($orcamento_id,$func_id){
        $orc_func = new OrcFuncionario();

        $orc_func = OrcFuncionario::where('orc_id', $orc_func['orcamento_id'] = $orcamento_id)->where('funcionario_id', $orc_func['funcionario_id'] = $func_id)->first();

       // $cargo = $orc_func['orc_cargo_id'];
       // $turma = $orc_func['orc_turma_id'];
       // $lotacao = $orc_func['orc_lotacao_id'];
       
       $funcionario = json_encode($orc_func);

        return $funcionario;
    }

}