<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoOrcHoraExtra as RepoOrcHoraExtra;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento as RepoCalcOrcamento;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\OrcHoraExtra;
use App\Modules\Natureza51\Repositories\RepoHeadcountHraExtra;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;


class ForecastHoraExtraController extends OrcamentoController
{
     public function __construct(){
		//$this->setCodTela('HEHC');
        $this->repository = new RepoHeadcountHraExtra();
        parent::__construct();
    } 

    public function orcHeInsert($orcId,\Illuminate\Http\Request $request){
    	// dd($request->all());
    	$r=$request->all();
		$form_data=$this->getRepositoryOrModel()->putOrcamentoIdOnData($r['items'][0], $orcId);

        $evento_id= isset($form_data['id']) ? intval($form_data['id']) : 0;
		
		$ja_existe=$this->getRepositoryOrModel()->getModelEntity()->where(['orcamento_id'=>$orcId,'evento_id'=>$evento_id])
			->first();

		if(!empty($ja_existe)){
			$retorno["status"] = "error";
			$retorno["msg"] = 'A opção selecionada já existe.';
			$retorno['submsg'] = 'Falha ao inserir. Erro 131220190814';
			goto saida;
		} 

		$orcamento = $this->getRepositoryOrModel()->getOrcInstanceNew()->find($orcId);

		if($this->getRepositoryOrModel()->setOrcamento($orcamento)->canEdit()==false){//Se o usuario não tiver a pemissão
			$retorno["status"] = "error";
			$retorno["msg"]='Não é possível cadastrar esta Hora Extra pois o mesmo não permite.';
			$retorno['submsg']='Falha ao inserir. Erro 131220191114';
			goto saida;
		}
		//dd($orc_event);
		$orc_event=array(
			'orcamento_id'=>$form_data['orcamento_id'],
			'evento_id'=>$form_data['id']
		);

		if(!$this->getRepositoryOrModel()->createOrc($orc_event)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro:111220191024';
            goto saida;
        }


        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);  
         //dd($retorno);
	}
	public function insert(\Illuminate\Http\Request $data){
		$this->setCodTela('FHE');
		$this->podeAcessar('inserir',true,$this->getCodTela());
		$repo_he = new RepoHeadcountHraExtra();
		$form_data = $data->all();
		
		if($this->canCRUDForecast($form_data['lotacao_id'], $form_data['orc_id'], $form_data['periodo'], $form_data['tipo_table']) === false){
            $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201513';
            $retorno['submsg'] = 'Erro';
            $retorno['status'] = 'error';
            return $this->retornoJsonDefault($retorno);
		}
		
		$meses = ['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];
		for($i = 0; $i < count($meses); $i++){
			if( !array_key_exists($meses[$i], $form_data) ){
				$form_data[$meses[$i]] = 0;
			}
		}
		$retorno = $repo_he->insertHraExtra($form_data);
		if($retorno['status'] == 'error'){
			return $this->retornoJsonDefault($retorno, 500);
		}
		return $retorno;
	}

	public function populaOrcHoraExtra($orc_id){
       
        if(! $this->getRepositoryOrModel()->populaOrcHoraExtra($orc_id)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['status']='error';
            $retorno['submsg']='Falha ao inserir o registro. Erro:060420201047';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Sucesso";
        $retorno["submsg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
       
    }

	public function deleteHe(Request $request){
		$this->setCodTela('FHE');
		$this->podeAcessar('deletar',true,$this->getCodTela());
		
		$repo_calc_orcamento = new RepoCalcOrcamento();
		$retorno = $this->getArrayRetornoDefault();
		
		$dados = $request->all();
		
		if($this->canCRUDForecast($dados['lotacao_id'], $dados['orc_id'], $dados['periodo'], $dados['tipo_table']) === false){
            $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201639';
            $retorno['submsg'] = 'Erro';
            $retorno['status'] = 'error';
            return $this->retornoJsonDefault($retorno);
		}

        DB::beginTransaction();
        try {
    
            $deletou = $this->getRepository()->delete($dados['id']); 
            if($this->deleteDiarioBordo($dados['id'], 'tbl_headcount_hra_extra') === false){
				$this->setError("Falha ao deletar Diário de Bordo. Erro: 230320211041");
				return false;
			}
            if(!$deletou){
                return false;
			}
			$retorno = array('msg'=>'Registro deletado com sucesso!','status'=>'success');
            
            $deletou_calc = $repo_calc_orcamento->getModelInstance()->where(['origem_id'=>$dados['id'], 'tbl_origem'=>'tbl_headcount_hra_extra'])->delete();
        
            if($deletou_calc == false){
                $this->setError([$repo_calc_orcamento->getErrosFlatted(),'Erro: 180920201450']);
                DB::rollBack();
                return false;        
            }
            DB::commit();

        } catch (\Exception $e) {
			DB::rollBack();
			abort(500,'Falha ao deletar registro. Erro: 180920201450ct. ');       
		}
		
		return  $retorno;
    
    }
 
    public function lista($orc_id){
    	$tbl_evento = new Eventos();
		
    	$rep_horaextra=$this->getRepository()->getModelEntity();

    	$select=$rep_horaextra
    	->leftJoin($tbl_evento->getTable(),$rep_horaextra->getColunaAlias('evento_id'),$tbl_evento->getColunaAlias('id'))
    	->select('orcamento_id','evento_id',$tbl_evento->getColunaAlias('des_event'),$tbl_evento->getColunaAlias('cdn_event'))
    	->orderBy('cdn_event')->toSql();
    	
    	return $select;
    }

    public function eventosInsert($orc_id){
        
        $tb_headcount_hra_extra= $this->getRepository()->getModelEntity();

        $tb_eventos = new Eventos();
		$tb_orc_hora_extra = new OrcHoraExtra();
		
		// DB::enableQueryLog();

		$select = $tb_headcount_hra_extra
        ->join($tb_orc_hora_extra->getTable(),
        $tb_headcount_hra_extra->getColunaAlias('evento_id'),$tb_orc_hora_extra->getColunaAlias('id'))
        ->join($tb_eventos->getTable(),
        $tb_orc_hora_extra->getColunaAlias('evento_id'),$tb_eventos->getColunaAlias('id'))
        ->select($tb_eventos->getColunaAlias('id'),
		$tb_eventos->getColunaAlias('des_event'),
		DB::raw("CONCAT({$tb_eventos->getColunaAlias('cdn_event')}, ' - ', {$tb_eventos->getColunaAlias('des_event')}) as description")
		)
        ->distinct()
		->where($tb_headcount_hra_extra->getColunaAlias('orc_id'),$orc_id)
		->where($tb_headcount_hra_extra->getColunaAlias('tipo_table'),'F')
		->get()->toArray();
		
		// dd(DB::getQueryLog());

        return new Response(json_encode($select) , 200);
    }
 

}