<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoFuncionario as RepoFuncionario;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

use Excel;


class FuncionarioController extends Natureza51Ctrl
{
    public function __construct(){
        parent::__construct();
        $this->setCodTela('FUNC');
        $this->repository=new RepoFuncionario();
    }

    public function listar(){ 
        // dd("Caiu no listar normal");
        // $this->podeAcessar('listar',true,$this->getCodTela()); 

        if(($this->hasPermissionByTelas($this->getCodTela(),'listar') !== true) && ($this->hasPermissionByTelas('HOME','preencher_headcount') !== true)){
            abort(403, 'Você não tem permissão para acessar este página. Erro cod: 301120201750');
        }

        $data =  $this->getRepository()->listar(true);
        /*$retorno = [];

        foreach ($data as $dt) {
       
            $dt['created_by_nome'] = $dt['created_by'] != null ? $this->getNomeByUsuario($dt['created_by']): ' - ';
            $dt['updated_by_nome'] = $dt['updated_by'] != null ? $this->getNomeByUsuario($dt['updated_by']): ' - ';
            $dt['description_created_at'] = $dt['created_at'] != null ? $this->formataData($dt, 'created_at') : '-';
            $dt['description_updated_at'] = $dt['updated_at'] != null ? $this->formataData($dt, 'updated_at') : '-';
            array_push($retorno, $dt);

            }
            // dd("data", $data);

        return new Response(json_encode($retorno) , 200); -> DESABILITADO*/
        return $data;
        // return   $this->getRepository()->listar(true);
    }

    public function listarComSalarios($cod_tela = null){ 
        $this->podeAcessar('listar',true,($cod_tela) ? $cod_tela : $this->getCodTela());

        $data =  $this->getRepository()->listar(true);
        /*$retorno = [];

        foreach ($data as $dt) {
       
            $dt['created_by_nome'] = $dt['created_by'] != null ? $this->getNomeByUsuario($dt['created_by']): ' - ';
            $dt['updated_by_nome'] = $dt['updated_by'] != null ? $this->getNomeByUsuario($dt['updated_by']): ' - ';
            $dt['description_created_at'] = $dt['created_at'] != null ? $this->formataData($dt, 'created_at') : '-';
            $dt['description_updated_at'] = $dt['updated_at'] != null ? $this->formataData($dt, 'updated_at') : '-';
            array_push($retorno, $dt);

            }
        return new Response(json_encode($retorno) , 200);*/
        return $data;
        // return   $this->getRepository()->listar(true);
    }

    public function insert(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        
        $retorno=$this->getArrayRetornoDefault();
        $obj=$this->getRepository()->insert($request->all());
        
        if(!$obj){
            $retorno['status']='error';
            $retorno['submsg']='Erro';
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            goto saida;
        }
        $retorno['status']='success';
        $retorno['msg']='Registro inserido com sucesso!';
        $retorno['submsg']='Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function downloadExcelAux($type)
    {
        $this->podeAcessar('exportar',true,$this->getCodTela());
        $filename="Funcionario";
        $array = json_decode($_POST['array_imprimir']);    

        for ($i=0; $i < count($array) ; $i++) { 
            
            //geral
            unset($array[$i]->grupo_empresarial_id);
            unset($array[$i]->usuario_dominio);
            unset($array[$i]->numero_dias_senha);
            unset($array[$i]->api_token);
            
            //comum a todos os cadastros
            unset($array[$i]->id);
            unset($array[$i]->empresa_id);
            unset($array[$i]->created_at);
            unset($array[$i]->updated_at);
            unset($array[$i]->user_id);
            unset($array[$i]->created_by);
            unset($array[$i]->updated_by);

            //funcionario
            unset($array[$i]->tp_func);
            unset($array[$i]->endereco_id);
            unset($array[$i]->plano_lotac_id);
            unset($array[$i]->ccusto_id);
            unset($array[$i]->turma_id);
            unset($array[$i]->lotacao_id);
            unset($array[$i]->cargo_id);
            unset($array[$i]->tb_ams_vip);
            unset($array[$i]->vip_dir_exec);
            unset($array[$i]->dat_demis_func);
            unset($array[$i]->is_demitido);
            unset($array[$i]->tp_estabi);
            unset($array[$i]->pt_admissao);
            unset($array[$i]->pt_inclusao);
            unset($array[$i]->pt_alteracao);
            unset($array[$i]->pt_total);
            unset($array[$i]->origem);
            unset($array[$i]->cod_afast);
            unset($array[$i]->desc_reg_funcionario);
            unset($array[$i]->nivel_hier);
            unset($array[$i]->recebe_pericul);
            unset($array[$i]->recebe_insal);
            unset($array[$i]->func_sindlz);
            unset($array[$i]->desc_matricula_func_cargo);

        }
        $colunas = array_keys( (array) $array[0]);

        $colunas = $this->formatHeaders($colunas);
                
        if (! in_array($type, ['xls', 'csv','xlsx'])) {
            $type = 'xlsx';
        }
        $fn = $filename.'-'.date('Y-m-d_H-i-s');

        if(is_null($array))   
        $array =  (is_null($array)) ? [] : $array;


        $export = new ExportData($array, $colunas);

        $header_file=[  "Content-Type"=>"application/vnd.ms-excel; charset=utf-8",
                        "Content-Disposition"=>"attachment; filename=abc.xls",
                        "Expires"=>"0", 
                        "Cache-Control"=>"must-revalidate, post-check=0, pre-check=0",
                        "Cache-Control"=>"private"
                     ];

        return Excel::download($export, $fn.'.'.$type ,null, $header_file );
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Funcionario', ['email_gestor','email','nivel_hier','vip_dir_exec','tp_func','endereco_id','plano_lotac_id','ccusto_id','turma_id','lotacao_id','recebe_pericul','recebe_insal','func_sindlz','cargo_id','niver_hier','tb_ams_vip','vip_dir_ini','dt_estabi_ini','dt_estabi_fim','dat_demis_func','is_demitido','tp_estabi','pt_admissao','pt_inclusao','pt_alteracao','pt_total','origem','cod_afast','base_fgts','pne','des_unid_lotac','desc_reg_funcionario','desc_matricula_func_cargo','get_plano_lotacao','cdn_funcionario', 'nome_funcionario', 'num_reg_func','dat_nascimento', 'dat_admis_func','dt_estab_ini','descr_afast','dt_afast_ini','dt_afast_fim', 'dt_ent_cargo', 'des_cargo_basic', 'cod_cargo_basic', 'des_ccusto', 'cod_ccusto', 'des_turma_trab', 'nome funcionario', 'cdn funcionario', 'num reg func', 'dat admis func', 'dt estabi ini', 'des_turma_trab']);
    }
 


    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("description_updated_at", "Atualizado em", $colunas[$i]);
            $colunas[$i] = str_replace("description_created_at", "Criado em", $colunas[$i]);
     
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);

            // $colunas[$i] = str_replace("des_origem_despesa", "Origem da despesa", $colunas[$i]);
            // $colunas[$i] = str_replace("conta_contabil", "Conta contábil", $colunas[$i]);
            // $colunas[$i] = str_replace("desc_evento", "Evento", $colunas[$i]);
            // $colunas[$i] = str_replace("valor_referencia", "Valor de referência", $colunas[$i]);
            $colunas[$i] = str_replace("tipo", "Tipo", $colunas[$i]);
            $colunas[$i] = str_replace("des turno trab", "Turno", $colunas[$i]);
            $colunas[$i] = str_replace("salario", "Salário", $colunas[$i]);
            $colunas[$i] = str_replace("description lotacao", "Lotação", $colunas[$i]);
            $colunas[$i] = str_replace("description turma", "Turma", $colunas[$i]);
            $colunas[$i] = str_replace("description cargo", "Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("desc ccusto", "Centro de custo", $colunas[$i]);
            $colunas[$i] = str_replace("description dat nasc", "Data nascimento", $colunas[$i]);
            $colunas[$i] = str_replace("description dat admis func", "Data admissão", $colunas[$i]);
            $colunas[$i] = str_replace("description dt estabi ini", "Início estabilidade", $colunas[$i]);
            $colunas[$i] = str_replace("description dt estabi fim", "Fim estabilidade", $colunas[$i]);
            $colunas[$i] = str_replace("des origem", "Origem", $colunas[$i]);
            $colunas[$i] = str_replace("description", "Nome funcionário", $colunas[$i]);
            $colunas[$i] = str_replace("cpf", "CPF", $colunas[$i]);


            
            $colunas[$i] = str_replace("created by nome", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("updated by nome", "Atualizado por", $colunas[$i]);
         

        }
        return $colunas;
    }
    
    public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }

    public function listarOrcFuncionario($orc_id){
        $resp = $this->getRepository()->listarOrcFuncionario($orc_id);
        return $resp;
    }

    public function listarAlternativo(){
        $decrypted = json_decode(safeDecrypt(request()->bearerToken()),true);
        $resp = $this->getRepository()->listarFuncionariosUsuarios($decrypted['token']['func_data']['cdn_funcionario']);
        return $resp;
    }
}