<?php

namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoGradeSalarial as RepoGradeSalarial;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;

class GradeSalarialController extends Natureza51Ctrl
{
    public function __construct(){
        $this->repository=new RepoGradeSalarial();
        $this->setCodTela('GS');
        parent::__construct();

    }

    public function listar(){
        $data = DB::select("SELECT * from tbl_grade_salarial where exists(select id from tbl_cargo where ativo = 1 and left(cod_cargo_basic,2)=cod_grade and cod_grade <> 1) order by cod_grade asc ");
        $dados = [];
        foreach ($data as $item) {
            if(array_key_exists('created_by', $item)){
                $item->created_by_nome = $this->getNomeByUsuario($item->created_by);
                $item->updated_by_nome = $this->getNomeByUsuario($item->updated_by);
            }
            array_push($dados, $item);
        }
        
        return new Response(json_encode($dados), 200);
    }

   
}
 

?>