<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoModeloRelatorio as RepoModeloRelatorio;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcResultadosCalc;
use Illuminate\Http\Response;
use Illuminate\Http\Request;
use DB;
use Rap2hpoutre\FastExcel\FastExcel;


class GraficoWaterfallController extends Natureza51Ctrl
{
    
    public function __construct(){
        $this->repository=new RepoModeloRelatorio();
        parent::__construct();
        $this->setCodTela('GRAF_WATER');
    }
    
    
    public function loadOrcamentos(){
        $data_user = $this->getUserFromCurrentGuard();

        $this->podeAcessar('gerar_grafico',true,$this->getCodTela());
        $repo_orcamento = new RepoOrcamento();
        $orcamentos = $repo_orcamento->getModelEntity()
        ->where([
             ['status_orc', '!=', $repo_orcamento->getStatusExcluido()]
         ])
         ->orderBy('id','DESC');

         if ($data_user->tipo != 3) {
            $orcamentos->where([                
                ['mostrar_orcamento', '=', 0]
            ]);
        }       
        
        $orc = $orcamentos->get()->toArray();
        

        return new Response(json_encode($orc));
    }

    public function gerarWaterfall(Request $request){
        $this->podeAcessar('gerar_grafico',true,$this->getCodTela());
        $repo_resultados_calc = new RepoOrcResultadosCalc();
        $data_request = $request->all();

        $retorno = $this->getArrayRetornoDefault();
        $result = $repo_resultados_calc->gerarWaterfall($data_request['orcamento_a'], $data_request['orcamento_b'], $data_request['tipo_orcamento_a'], $data_request['tipo_orcamento_b'], $data_request['escala'], $data_request['val_min']);

        if($result === false){
            $retorno['msg']=$repo_resultados_calc->getErrosFlatted();
            $retorno['submsg']='Falha ao buscar as informações para o ráfico. Erro: 071020201901';
            goto saida;
        }

        $colors = [];

        foreach (array_values($result) as $item) {
            if(!is_array($item)){
                $color = $item < 0 ? 'red' : 'green';
            }
            else{
                $color = $item[0] > $item[1] ? 'red' : 'blue';
            }
            array_push($colors, $color);
        }
        // dd( $result);
        $retorno['colors'] = $colors;
        $retorno['labels'] = array_keys($result);
        $retorno['dados'] = [
            [
                'data'=>array_values($result),
                'label'=>''
            ]
        ];
        $retorno['status'] = 'success';
        saida:
        return new Response(json_encode($retorno), 200);
    }

}