<?php

namespace App\Modules\Natureza51\Http\Controllers;

// use App\Modules\Natureza51\Repositories\RepoHeadcount as RepoHeadcount;
use App\Modules\Natureza51\Entities\OrcamLotCargoEvento;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\OrcEventos;
use App\Modules\Natureza51\Entities\OrcHoraExtra;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\Turma; 
use App\Modules\Natureza51\Entities\OrcTurma; 
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;
use App\Modules\Natureza51\Entities\OrcDemissoesDetalhes;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcHeadcountContratacoes;
use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Repositories\RepoOrcContratacoes as RepoOrcContratacoes;
use App\Modules\Natureza51\Http\Controllers\OrcamentoController;
use App\Modules\Natureza51\Entities\OrcCargo;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento as RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoHeadcount as RepoHeadcount;
use App\Modules\Natureza51\Repositories\RepoOrcamento as RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcCronograma;
use App\Modules\Natureza51\Repositories\RepoOrcLotacao;
use App\Modules\Natureza51\Repositories\RepoAtividades;
use App\Support\TreeTable\AtmTreeTable;
use \App\Core\Traits\ErrorTrait;
use App\Modules\Natureza51\Entities\HeadcountHraExtra;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\Usuario;
use Carbon\Carbon;

class HeadcountController extends OrcamentoController
{
    private $eventos_he;
    private $colum_meses=['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado',
    'jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];

    private $meses_total_eventos=['t_event_jan','t_event_fev','t_event_mar','t_event_abr','t_event_mai',
                                    't_event_jun','t_event_jul','t_event_ago','t_event_set','t_event_out','t_event_nov','t_event_dez'];
    private $eventos_list=[34,35,36];

    public function __construct(){
        $this->setCodTela('HDCT');
        $this->repository=new RepoHeadcount();
        parent::__construct();
    }
        
    public function listarHeadcount($orc_id, $lotacao_id, $tipo_table){        
        // $data = $this->listajson();
        // dd($orc_id,$lotacao_id); 
        // return new Response($data , 200);  
        $this->setCodTela('HDCT');
        
        $this->podeAcessar('listar',true,$this->getCodTela());

        if($tipo_table == 'O'){
            $lotacao_orcamento = DB::select("select * from tbl_orc_lotacao where tipo_table = 'O' and orcamento_id = $orc_id and lotacao_id = (select lotacao_id from tbl_orc_lotacao where id = $lotacao_id) and cc_custo_id = (select cc_custo_id from tbl_orc_lotacao where id = $lotacao_id)");
            if(count($lotacao_orcamento) == 0){
                $retorno['status']="error";
                $retorno['msg']="A lotação informada não existia no orçamento.";
                $retorno['submsg']='Lotação não encontrada. Erro: 110620211106';                        
                // return new Response(json_encode([]) , 200);
                return $this->retornoJsonDefault($retorno);
            }
            $lotacao_id = $lotacao_orcamento[0]->id;

        }
        
        /*$lot_id = OrcLotacao::where('id', $lotacao_id)->where('tipo_table','F')->get()->toArray();
        if(count($lot_id) > 0){
            $lotacao_id = OrcLotacao::where('lotacao_id', $lot_id[0]['lotacao_id'])->where('cc_custo_id', $lot_id[0]['cc_custo_id'])
            ->where('tipo_table', $tipo_table)->where('orcamento_id', $orc_id)->get()->toArray()[0]['id'];
        }*/
        $repo = $this->getRepository()->getModelEntity()::with([
                'getOrcamento'=>function($query){                    
                } 
            ])->where('orc_id', '=', $orc_id)            
            ->first();
            // dd("repoooo", $repo);
        $orc_lotacao = OrcLotacao::find($lotacao_id);
        $orc_lotacao->hc_iniciado = 1;
        $orc_lotacao->save();
        if(!$repo){
            $retorno['status']="error";
            $retorno['msg']="Headcount não encontrado para este orçamento!";
            $retorno['submsg']='Orçamento não encontrado. Erro: 161220201735';                        
            // return new Response(json_encode([]) , 200);
            return $this->retornoJsonDefault($retorno);
        }

        $set_orcamento = $this->getRepository()->setOrcamento($repo->getOrcamento);
        
        if(!$this->getRepository()->isOwn()){
            dd("adicionar mensagem q não tem permissão");
        }


        $tb_orcamLot_cargo_headcount = new OrcamLotCargoHeadcount();        
        $tb_calc_orcamento = new CalcOrcamento();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tb_lotacao = new OrcLotacao();
        $tb_orc_cargo = new OrcCargo(); 
        $tbl_usuario = new Usuario();
        // $forecast_dez_anterior = $this->getForecastAnterior($repo->getOrcamento->id, $orc_lotacao->lotacao_id);


        $data = $tb_lotacao->join($tb_orcamLot_cargo_headcount->getTable(),
        $tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'), $tb_lotacao->getColunaAlias('id'))                            
                            ->join($tb_calc_orcamento->getTable(), $tb_orcamLot_cargo_headcount->getColunaAlias('id'), '=', 
                                DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and 
                                {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orcamLot_cargo_headcount->getTable()}'"))
                            ->join($tb_orc_cargo->getTable(),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
                            ->join($tb_cargo->getTable(),
                                $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))    
                            ->join($tb_centro_custo->getTable(),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id')) 
                            ->join($tb_turma->getTable(),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id'), $tb_turma->getColunaAlias('id'))  
                            ->join($tb_turno->getTable(),
                                    $tb_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('id'))  
                            ->leftJoin(
                                DB::raw("{$tbl_usuario->getTable()} as usuario1"),
                                DB::raw("usuario1.id"),
                                DB::raw("{$tb_orcamLot_cargo_headcount->getColunaAlias('created_by')}")
                            )
                            ->leftJoin(
                                DB::raw("{$tbl_usuario->getTable()} as usuario2"),
                                $tb_calc_orcamento->getColunaAlias('updated_by'),
                                DB::raw("usuario2.id")
                            )
                                ->select(
                                    DB::raw($tb_calc_orcamento->getColunaAlias('id')),
                                    DB::raw($tb_orcamLot_cargo_headcount->getColunaAlias('id').' as id_princ'), 
                                    $tb_orcamLot_cargo_headcount->getColunaAlias('orc_id'), 
                                    $tb_orcamLot_cargo_headcount->getColunaAlias('qtd_func_lot'), 
                                    $tb_orcamLot_cargo_headcount->getColunaAlias('atual_total'), 
                                    $tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'),
                                    $tb_orcamLot_cargo_headcount->getColunaAlias('orcado_anterior'),
                                    $tb_orcamLot_cargo_headcount->getColunaAlias('origem_sistema'),
                                    $tb_orc_cargo->getColunaAlias('cargo_id'), 
                                    $tb_cargo->getColunaAlias('cod_cargo_basic'), 
                                    $tb_cargo->getColunaAlias('des_cargo_basic'),
                                    $tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id'), 
                                    $tb_centro_custo->getColunaAlias('cod_ccusto'), 
                                    $tb_turma->getColunaAlias('cdn_turma_trab'), 
                                    $tb_turma->getColunaAlias('des_turma_trab'), 
                                    $tb_turno->getColunaAlias('cdn_turno_trab'),
                                    $tb_turno->getColunaAlias('des_turno_trab'),
                                    $tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id'),

                                    // DB::raw($forecast_dez_anterior.' as forecast_anterior'), 
                                    $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_anterior'),
                                    $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_total'),

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jan_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_jan"),
                                    $tb_calc_orcamento->getColunaAlias('jan_orcado'),

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('fev_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_fev"),
                                    $tb_calc_orcamento->getColunaAlias('fev_orcado'), 

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mar_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_mar, 
                                    {$tb_calc_orcamento->getColunaAlias('mar_orcado')}"), 

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('abr_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_abr, 
                                    {$tb_calc_orcamento->getColunaAlias('abr_orcado')}"), 

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mai_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_mai, 
                                    {$tb_calc_orcamento->getColunaAlias('mai_orcado')}"), 

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jun_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_jun, 
                                    {$tb_calc_orcamento->getColunaAlias('jun_orcado')}"), 

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jul_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_jul, 
                                    {$tb_calc_orcamento->getColunaAlias('jul_orcado')}"), 

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('ago_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_ago, 
                                    {$tb_calc_orcamento->getColunaAlias('ago_orcado')}"), 

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('set_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_set, 
                                    {$tb_calc_orcamento->getColunaAlias('set_orcado')}"), 

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('out_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_out, 
                                    {$tb_calc_orcamento->getColunaAlias('out_orcado')}"),

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('nov_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_nov, 
                                    {$tb_calc_orcamento->getColunaAlias('nov_orcado')}"), 
                                    
                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('dez_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_dez, 
                                    {$tb_calc_orcamento->getColunaAlias('dez_orcado')}"),

                                    DB::raw("CASE WHEN {$tb_orcamLot_cargo_headcount->getColunaAlias('created_at')} IS NOT NULL THEN format({$tb_orcamLot_cargo_headcount->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
                                    DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

                                    DB::raw("CASE WHEN {$tb_calc_orcamento->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tb_calc_orcamento->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
                                    DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
                                )
                                ->orderByRaw("{$tb_centro_custo->getColunaAlias('cod_ccusto')}, {$tb_cargo->getColunaAlias('cod_cargo_basic')}, 
                                                {$tb_turma->getColunaAlias('cdn_turma_trab')}")   
                                    ->where([
                                        [$tb_orcamLot_cargo_headcount->getColunaAlias('orc_id'),$orc_id],
                                        [$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'),$lotacao_id],
                                        [$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table'),$tipo_table]
                                    ])
                                    ->get()
                                    ->toArray();


                                    // dd("testeee",$data);
                                    //  dd("pivooooo",$this->pivo($data));
                                     return new Response(json_encode($this->montaTreetable($this->pivo($data))) , 200);
    } 

    public function listarHeadcountAba($orc_id,$lotacao_id, $tipo_table){        

        $this->setCodTela('HDCT');
        $this->podeAcessar('listar',true,$this->getCodTela());
        
        $repo = $this->getRepository()->getModelEntity()::with([
                'getOrcamento'=>function($query){                    
                } 
            ])->where('orc_id', '=', $orc_id)            
        ->first();
        $orc_lotacao = OrcLotacao::find($lotacao_id);
        $orc_lotacao->hc_iniciado = 1;
        $orc_lotacao->save();
        if(!$repo){
            return "Orçamento não encontrado";
        }

        $set_orcamento = $this->getRepository()->setOrcamento($repo->getOrcamento);
        if(!$this->getRepository()->isOwn()){
            dd("adicionar mensagem q não tem permissão");
        }
        // $forecast_dez_anterior = $this->getForecastAnterior($repo->getOrcamento->id, $orc_lotacao->lotacao_id);
        $data = DB::select("
        select tbl_calc_orcamento.id, tbl_orc_lot_carg_headcount.id as id_princ, 
        [tbl_orc_lot_carg_headcount].[orc_id], 
        [tbl_orc_lot_carg_headcount].[qtd_func_lot], 
        [tbl_orc_lot_carg_headcount].[atual_total], 
        [tbl_orc_lot_carg_headcount].[lotacao_id], 
        [tbl_orc_lot_carg_headcount].[orcado_anterior], 
        [tbl_orc_cargo].[cargo_id], [tbl_cargo].[cod_cargo_basic], 
        [tbl_cargo].[des_cargo_basic], [tbl_orc_lot_carg_headcount].[ccusto_id], 
        [tbl_ccusto].[cod_ccusto], [tbl_orc_turma].[cdn_turma_trab], 
        [tbl_orc_turma].[des_turma_trab], [tbl_turno].[cdn_turno_trab], 
        [tbl_turno].[des_turno_trab], [tbl_orc_lot_carg_headcount].[orc_turma_id],
         [tbl_orc_lot_carg_headcount].[forecast_anterior], [tbl_orc_lot_carg_headcount].[forecast_total], 
         SUM(tbl_calc_orcamento.jan_orcado) OVER(partition by 
                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                        tbl_orc_cargo.cargo_id, tbl_orc_lot_carg_headcount.tipo_table) t_headcount_jan, [tbl_calc_orcamento].[jan_orcado], 
        SUM(tbl_calc_orcamento.fev_orcado) OVER(partition by 
                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                        tbl_orc_cargo.cargo_id, tbl_orc_lot_carg_headcount.tipo_table) t_headcount_fev, [tbl_calc_orcamento].[fev_orcado], 
        SUM(tbl_calc_orcamento.mar_orcado) OVER(partition by 
                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                        tbl_orc_cargo.cargo_id, tbl_orc_lot_carg_headcount.tipo_table) t_headcount_mar, 
                                        tbl_calc_orcamento.mar_orcado, 
        SUM(tbl_calc_orcamento.abr_orcado) OVER(partition by 
                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                        tbl_orc_cargo.cargo_id, tbl_orc_lot_carg_headcount.tipo_table) t_headcount_abr, 
                                        tbl_calc_orcamento.abr_orcado, 
        SUM(tbl_calc_orcamento.mai_orcado) OVER(partition by 
                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                        tbl_orc_cargo.cargo_id, tbl_orc_lot_carg_headcount.tipo_table) t_headcount_mai, 
                                        tbl_calc_orcamento.mai_orcado, 
        SUM(tbl_calc_orcamento.jun_orcado) OVER(partition by 
                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                        tbl_orc_cargo.cargo_id, tbl_orc_lot_carg_headcount.tipo_table) t_headcount_jun, 
                                        tbl_calc_orcamento.jun_orcado, 
        SUM(tbl_calc_orcamento.jul_orcado) OVER(partition by 
                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                        tbl_orc_cargo.cargo_id, tbl_orc_lot_carg_headcount.tipo_table) t_headcount_jul, 
                                        tbl_calc_orcamento.jul_orcado, 
        SUM(tbl_calc_orcamento.ago_orcado) OVER(partition by 
                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                        tbl_orc_cargo.cargo_id, tbl_orc_lot_carg_headcount.tipo_table) t_headcount_ago, 
                                        tbl_calc_orcamento.ago_orcado, 
        SUM(tbl_calc_orcamento.set_orcado) OVER(partition by 
                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                        tbl_orc_cargo.cargo_id, tbl_orc_lot_carg_headcount.tipo_table) t_headcount_set, 
                                        tbl_calc_orcamento.set_orcado, 
        SUM(tbl_calc_orcamento.out_orcado) OVER(partition by 
                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                        tbl_orc_cargo.cargo_id, tbl_orc_lot_carg_headcount.tipo_table) t_headcount_out, 
                                        tbl_calc_orcamento.out_orcado, 
        SUM(tbl_calc_orcamento.nov_orcado) OVER(partition by 
                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                        tbl_orc_cargo.cargo_id, tbl_orc_lot_carg_headcount.tipo_table) t_headcount_nov, 
                                        tbl_calc_orcamento.nov_orcado, 
        SUM(tbl_calc_orcamento.dez_orcado) OVER(partition by 
                                        tbl_orc_lot_carg_headcount.ccusto_id, 
                                        tbl_orc_lot_carg_headcount.lotacao_id,
                                        tbl_orc_cargo.cargo_id, tbl_orc_lot_carg_headcount.tipo_table) t_headcount_dez, 
                                        tbl_calc_orcamento.dez_orcado,

        CASE WHEN [tbl_orc_lot_carg_headcount].created_at IS NOT NULL THEN format([tbl_orc_lot_carg_headcount].created_at, 'dd/MM/yyyy') ELSE '-' END as criado_em,
        CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por,

        CASE WHEN [tbl_calc_orcamento].updated_at IS NOT NULL THEN format([tbl_calc_orcamento].updated_at, 'dd/MM/yyyy') ELSE '-' END as atualizado_em,
        CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por

        from [tbl_orc_lotacao] inner join [tbl_orc_lot_carg_headcount] on [tbl_orc_lot_carg_headcount].[lotacao_id] = [tbl_orc_lotacao].[id] 
        
        inner join [tbl_calc_orcamento] on [tbl_orc_lot_carg_headcount].[id] = tbl_calc_orcamento.origem_id and 
            tbl_calc_orcamento.tbl_origem = 'tbl_orc_lot_carg_headcount' 
            
        inner join [tbl_orc_cargo] on [tbl_orc_lot_carg_headcount].[orc_cargo_id] = [tbl_orc_cargo].[id] 
        inner join [tbl_cargo] on [tbl_orc_cargo].[cargo_id] = [tbl_cargo].[id] 
        inner join [tbl_ccusto] on [tbl_orc_lot_carg_headcount].[ccusto_id] = [tbl_ccusto].[id] 
        inner join [tbl_orc_turma] on [tbl_orc_lot_carg_headcount].[orc_turma_id] = [tbl_orc_turma].[id] 
        inner join [tbl_turno] on [tbl_orc_turma].[turno_id] = [tbl_turno].[id] 

        left join institb_usuario as usuario1 on usuario1.id = [tbl_orc_lot_carg_headcount].created_by
        left join institb_usuario as usuario2 on usuario2.id = [tbl_calc_orcamento].updated_by
                                    
        where ([tbl_orc_lot_carg_headcount].[orc_id] = {$orc_id} and [tbl_orc_lot_carg_headcount].[lotacao_id] = {$lotacao_id} and [tbl_orc_lot_carg_headcount].[tipo_table] = '{$tipo_table}' and 
        ([tbl_orc_lot_carg_headcount].qtd_func_lot != 0 or [tbl_orc_lot_carg_headcount].forecast_anterior != 0 or 
        tbl_calc_orcamento.jan_orcado != 0 or tbl_calc_orcamento.fev_orcado != 0 or tbl_calc_orcamento.mar_orcado != 0 or 
        tbl_calc_orcamento.abr_orcado != 0 or tbl_calc_orcamento.mai_orcado != 0 or tbl_calc_orcamento.jun_orcado != 0 or 
        tbl_calc_orcamento.jul_orcado != 0 or tbl_calc_orcamento.ago_orcado != 0 or tbl_calc_orcamento.set_orcado != 0 or 
        tbl_calc_orcamento.out_orcado != 0 or tbl_calc_orcamento.nov_orcado != 0 or tbl_calc_orcamento.dez_orcado != 0)) 
    
        order by tbl_ccusto.cod_ccusto, tbl_cargo.cod_cargo_basic, tbl_orc_turma.cdn_turma_trab
        ");

        $dados = [];
        for($i = 0; $i < count($data); $i++){
            $dados[$i] = (array)$data[$i];
        }
        
        return new Response(json_encode($this->montaTreetable($this->pivo($dados))) , 200);
    } 
    public function getForecastAnterior($orc_id, $lotacao_id){
        return $this->getRepository()->getForecastAnterior($orc_id, $lotacao_id);
    }

    public function listarHeadcountHE($orc_id,$lotacao_id, $tipo_table){        
        
        $this->getTagByTb('horaExtra');
        $this->podeAcessar('listar',true,$this->getCodTela());

        $repo = $this->getRepository()->getModelEntity()::with([
                'getOrcamento'=>function($query){                    
                } 
            ])->where('orc_id', '=', $orc_id)            
            ->first();

        if(!$repo){
            return "Orçamento não encontrado";
        }

        $set_orcamento = $this->getRepository()->setOrcamento($repo->getOrcamento);
        
        if(!$this->getRepository()->isOwn()){
            dd("adicionar mensagem q não tem permissão");
        }
               
       
        $tb_orcam_lot_cargo_evento = new HeadcountHraExtra();
        // $tb_orcamLot_cargo_headcount = new OrcamLotCargoHeadcount();
        $tb_orc_hora_extra = new OrcHoraExtra();
        $tb_calc_orcamento = new CalcOrcamento();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_orc_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tb_turma = new Turma();
        $tb_evento = new Eventos();
        $tb_lotacao = new OrcLotacao();
        $tb_orc_cargo = new OrcCargo();
        $tbl_usuario = new Usuario();

        $alias_calc_orcamento = 'coh';
        $tb_alias = $tb_calc_orcamento->getTable();       
        $tb_alias = $tb_alias . " AS {$alias_calc_orcamento}";
        // DB::enableQueryLog();
        $data = $tb_lotacao->join($tb_orcam_lot_cargo_evento->getTable(),
        $tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id'), $tb_lotacao->getColunaAlias('id'))
                            // ->join($tb_orc_hora_extra->getTable(),$tb_orc_hora_extra->getColunaAlias('id'), '=' ,
                            // DB::raw("{$tb_orcam_lot_cargo_evento->getColunaAlias('evento_id')} and 
                            // {$tb_orc_hora_extra->getColunaAlias('orcamento_id')} = {$tb_orcam_lot_cargo_evento->getColunaAlias('orc_id')}"))                            
                            ->leftJoin($tb_calc_orcamento->getTable(), $tb_orcam_lot_cargo_evento->getColunaAlias('id'), '=',                            
                            DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and 
                            {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orcam_lot_cargo_evento->getTable()}'"))                           
                            ->join($tb_orc_cargo->getTable(),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
                            ->join($tb_cargo->getTable(),
                                $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))    
                            ->join($tb_centro_custo->getTable(),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id')) 
                            ->join($tb_orc_turma->getTable(),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('orc_turma_id'), $tb_orc_turma->getColunaAlias('id'))
                            ->join($tb_turno->getTable(),
                                $tb_orc_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('id'))  
                            ->join($tb_turma->getTable(),
                                $tb_orc_turma->getColunaAlias('turma_id'), $tb_turma->getColunaAlias('id'))   
                            ->join($tb_orc_hora_extra->getTable(),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('evento_id'), $tb_orc_hora_extra->getColunaAlias('id')) 
                            ->join($tb_evento->getTable(),
                                $tb_orc_hora_extra->getColunaAlias('evento_id'), $tb_evento->getColunaAlias('id')) 
                            ->leftJoin(
                                DB::raw("{$tbl_usuario->getTable()} as usuario1"),
                                DB::raw("usuario1.id"),
                                DB::raw("{$tb_orcam_lot_cargo_evento->getColunaAlias('created_by')}")
                            )
                            ->leftJoin(
                                DB::raw("{$tbl_usuario->getTable()} as usuario2"),
                                $tb_calc_orcamento->getColunaAlias('updated_by'),
                                DB::raw("usuario2.id")
                            )
                            ->select(
                                $tb_orcam_lot_cargo_evento->getColunaAlias('id'),
                                DB::raw("{$tb_calc_orcamento->getColunaAlias('id')} as calc_orc_id"),
                                DB::raw("{$tb_orcam_lot_cargo_evento->getColunaAlias('evento_id')}"),
                                DB::raw("{$tb_evento->getColunaAlias('cdn_event')}"),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('orc_id'),$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id'),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('evento_id'), $tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id'), 
                                $tb_cargo->getColunaAlias('cod_cargo_basic'), $tb_cargo->getColunaAlias('des_cargo_basic'),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('cod_ccusto'),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('orc_turma_id'),  
                                $tb_turma->getColunaAlias('cdn_turma_trab'),                              
                                $tb_turma->getColunaAlias('des_turma_trab'),  
                                $tb_turno->getColunaAlias('cdn_turno_trab'),
                                $tb_turno->getColunaAlias('des_turno_trab'),
                                DB::raw("CONCAT({$tb_turma->getColunaAlias('cdn_turma_trab')}, ' - ', {$tb_turma->getColunaAlias('des_turma_trab')}) turma"),
                                DB::raw("CONCAT({$tb_turno->getColunaAlias('cdn_turno_trab')}, ' - ', {$tb_turno->getColunaAlias('des_turno_trab')}) turno"),
                                DB::raw("CONCAT({$tb_evento->getColunaAlias('cdn_event')}, ' - ', {$tb_evento->getColunaAlias('des_event')}) evento"),


                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jan_orcado')}) 
                                OVER(
                                    partition by    {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},
                                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},
                                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')}) t_event_jan, 
                                {$tb_calc_orcamento->getColunaAlias('jan_orcado')}") ,

                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('fev_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')}) t_event_fev, 
                                {$tb_calc_orcamento->getColunaAlias('fev_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mar_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')},  
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')}) t_event_mar, 
                                {$tb_calc_orcamento->getColunaAlias('mar_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('abr_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')}) t_event_abr, 
                                {$tb_calc_orcamento->getColunaAlias('abr_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mai_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')}) t_event_mai, 
                                {$tb_calc_orcamento->getColunaAlias('mai_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jun_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')}) t_event_jun, 
                                {$tb_calc_orcamento->getColunaAlias('jun_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jul_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')}) t_event_jul, 
                                {$tb_calc_orcamento->getColunaAlias('jul_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('ago_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')}) t_event_ago, 
                                {$tb_calc_orcamento->getColunaAlias('ago_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('set_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')}) t_event_set, 
                                {$tb_calc_orcamento->getColunaAlias('set_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('out_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')}) t_event_out, 
                                {$tb_calc_orcamento->getColunaAlias('out_orcado')}"),
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('nov_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')}) t_event_nov, 
                                {$tb_calc_orcamento->getColunaAlias('nov_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('dez_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')},
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')}) t_event_dez, 
                                {$tb_calc_orcamento->getColunaAlias('dez_orcado')}"),

                                DB::raw("CASE WHEN {$tb_orcam_lot_cargo_evento->getColunaAlias('created_at')} IS NOT NULL THEN format({$tb_orcam_lot_cargo_evento->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
                                DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

                                DB::raw("CASE WHEN {$tb_calc_orcamento->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tb_calc_orcamento->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
                                DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
                            )
                            ->orderByRaw("{$tb_centro_custo->getColunaAlias('cod_ccusto')}, {$tb_cargo->getColunaAlias('cod_cargo_basic')}")//, {$tb_turma->getColunaAlias('cdn_turma_trab')}
                            ->where(
                                [
                                    [$tb_orcam_lot_cargo_evento->getColunaAlias('orc_id'),$orc_id],
                                    [$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id'),$lotacao_id],
                                    [$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table'),$tipo_table]                                    
                                ]
                            ) ->get()
                            ->toArray();
                            // dd(DB::getQueryLog());

                            // dd($this->pivoHE($data));
                            
                                    // dd("testeee",$data);
                                    //  dd("testeee",$this->ex($this->pivo($data)));
        return new Response(json_encode($this->montaTreetableHE($this->pivoHE($data))) , 200);
    }

    public function listarDemissoes($orc_id,$lotacao_id,$ccusto_id, $tipo_table){

        $this->getTagByTb('demissoes');

        $this->podeAcessar('listar',true,$this->getCodTela());
        $repo = $this->getRepository()->getModelEntity()::with([
            'getOrcamento'=>function($query){                    
            } 
        ])->where('orc_id', '=', $orc_id)            
        ->first();

        if(!$repo){
            return "Orçamento não encontrado";
        }

        $set_orcamento = $this->getRepository()->setOrcamento($repo->getOrcamento);
        
        if(!$this->getRepository()->isOwn()){
            dd("adicionar mensagem q não tem permissão");
        }
        // dd('sikdnsinsidns',$orc_id,$lotacao_id,$ccusto_id);
        $tb_orcamLot_cargo_headcount = new OrcamLotCargoHeadcount();
        $tb_orc_headcount_demissoes = new OrcHeadcountDemissoes();
        $tb_funcionario = new Funcionario();
        $tb_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_orc_cargo = new OrcCargo();
        $tb_calc_orcamento = new CalcOrcamento();
        $tbl_usuario = new Usuario();

        // DB::enableQueryLog();

        
        $data = $tb_orc_headcount_demissoes->leftJoin($tb_funcionario->getTable(),
                                $tb_funcionario->getColunaAlias('id'), $tb_orc_headcount_demissoes->getColunaAlias('func_id')) 
                            ->leftJoin($tb_turma->getTable(),
                                $tb_orc_headcount_demissoes->getColunaAlias('orc_turma_id'), $tb_turma->getColunaAlias('id'))
                            ->leftJoin($tb_turno->getTable(),
                                    $tb_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('id'))  
                            ->leftJoin($tb_orc_cargo->getTable(),
                                $tb_orc_headcount_demissoes->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
                            ->leftJoin($tb_cargo->getTable(),
                                $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))    
                            ->leftJoin($tb_centro_custo->getTable(),
                                $tb_orc_headcount_demissoes->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id')) 
                            ->leftJoin($tb_calc_orcamento->getTable(), $tb_orc_headcount_demissoes->getColunaAlias('id'), '=',                            
                                DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} 
                                and {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orc_headcount_demissoes->getTable()}' 
                                and {$tb_orc_headcount_demissoes->getColunaAlias('tipo')} = 1
                            "))                            
                            ->leftJoin(
                                $tb_orcamLot_cargo_headcount->getTable(),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'),'=',
    
                                DB::raw("{$tb_orc_headcount_demissoes->getColunaAlias('lotacao_id')} 
                                and {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_cargo_id')} = {$tb_orc_headcount_demissoes->getColunaAlias('orc_cargo_id')}
                                and {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id')} = {$tb_orc_headcount_demissoes->getColunaAlias('orc_turma_id')}
                                and {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')} = {$tb_orc_headcount_demissoes->getColunaAlias('ccusto_id')}
                                and {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')} = {$tb_orc_headcount_demissoes->getColunaAlias('tipo_table')}")
                            )
                            ->leftJoin( 
                                DB::raw("
                                (select		
                                    orc_d.orc_cargo_id ,
                                    SUM(CASE 		 
                                        WHEN orc_d.tipo = 2 and orc_d.mes = 1 THEN 1
                                        WHEN orc_d.tipo = 3 and orc_d.mes = 1 THEN ISNULL(orc_d.qtde_pessoas, 0)
                                        WHEN orc_d.tipo = 1 THEN ISNULL(co.jan_orcado, 0)
                                        ELSE 0
                                    END) t_headcount_jan,
                                    SUM(CASE 		  
                                        WHEN orc_d.tipo = 2 and orc_d.mes = 2 THEN 1
                                        WHEN orc_d.tipo = 3 and orc_d.mes = 2 THEN ISNULL(orc_d.qtde_pessoas, 0)
                                        WHEN orc_d.tipo = 1 THEN ISNULL(co.fev_orcado, 0)
                                        ELSE 0		  
                                    END) t_headcount_fev,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 3 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 3 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN ISNULL(co.mar_orcado, 0)
                                    ELSE 0
                                    END) t_headcount_mar,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 4 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 4 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN ISNULL(co.abr_orcado, 0)
                                    ELSE 0 
                                    END) t_headcount_abr,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 5 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 5 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN ISNULL(co.mai_orcado, 0)
                                    ELSE 0 
                                    END) t_headcount_mai,
                                SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 6 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 6 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN ISNULL(co.jun_orcado, 0)
                                    ELSE 0 
                                    END) t_headcount_jun,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 7 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 7 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN ISNULL(co.jul_orcado, 0)
                                    ELSE 0 
                                    END) t_headcount_jul,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 8 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 8 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN ISNULL(co.ago_orcado, 0)
                                    ELSE 0 
                                    END) t_headcount_ago,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 9 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 9 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN ISNULL(co.set_orcado, 0)
                                    ELSE 0 
                                    END) t_headcount_set,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 10 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 10 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN ISNULL(co.out_orcado, 0)
                                    ELSE 0 
                                    END) t_headcount_out,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 11 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 11 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN co.nov_orcado
                                    ELSE 0
                                    END) t_headcount_nov,
                                    SUM(CASE 
                                    WHEN orc_d.tipo = 2 and orc_d.mes = 12 THEN 1
                                    WHEN orc_d.tipo = 3 and orc_d.mes = 12 THEN orc_d.qtde_pessoas
                                    WHEN orc_d.tipo = 1 THEN co.dez_orcado
                                    ELSE 0
                                    END) t_headcount_dez	
                                FROM [tbl_orc_headcount_demissoes] orc_d
                                left join tbl_funcionario f on f.id = orc_d.func_id
                                left join tbl_orc_turma t on t.id = orc_d.orc_turma_id
                                left join tbl_turno tu on tu.id = t.turno_id 
                                left join tbl_orc_cargo oc on oc.id = orc_d.orc_cargo_id
                                left join tbl_cargo c on c.id = oc.cargo_id
                                left join tbl_ccusto cc on cc.id = orc_d.ccusto_id
                                left join tbl_calc_orcamento co on co.origem_id = orc_d.id and co.tbl_origem = 'tbl_orc_headcount_demissoes'
                                left join tbl_orc_lot_carg_headcount hc on hc.lotacao_id = orc_d.lotacao_id and hc.orc_cargo_id = orc_d.orc_cargo_id
                                and hc.orc_turma_id = orc_d.orc_turma_id and hc.ccusto_id = orc_d.ccusto_id and orc_d.tipo_table = hc.tipo_table
                                where orc_d.orcamento_id = {$orc_id}
                                and orc_d.lotacao_id = {$lotacao_id}
                                and orc_d.tipo_table = '{$tipo_table}'
                                group by orc_d.orc_cargo_id
                                ) totais
                                "), 'totais.orc_cargo_id', '=' ,"{$tb_orc_headcount_demissoes->getColunaAlias('orc_cargo_id')}"
                            )
                            ->leftJoin(
                                DB::raw("{$tbl_usuario->getTable()} as usuario1"),
                                DB::raw("usuario1.id"),
                                DB::raw("{$tb_orc_headcount_demissoes->getColunaAlias('created_by')}")
                            )
                            ->leftJoin(
                                DB::raw("{$tbl_usuario->getTable()} as usuario2"),
                                $tb_calc_orcamento->getColunaAlias('updated_by'),
                                DB::raw("usuario2.id")
                            )
                            ->select(                                
                                DB::raw("{$tb_orc_headcount_demissoes->getColunaAlias('id')} as headcount_demissoes_id"),
                                $tb_calc_orcamento->getColunaAlias('origem_id'),
                                $tb_orc_headcount_demissoes->getColunaAlias('orcamento_id'),
                                $tb_centro_custo->getColunaAlias('cod_ccusto'),
                                $tb_cargo->getColunaAlias('cod_cargo_basic'),
                                $tb_turma->getColunaAlias('cdn_turma_trab'), 
                                $tb_turma->getColunaAlias('des_turma_trab'), 
                                $tb_turno->getColunaAlias('cdn_turno_trab'),
                                $tb_turno->getColunaAlias('des_turno_trab'),
                                $tb_orc_headcount_demissoes->getColunaAlias('ccusto_id'),                                    
                                $tb_orc_cargo->getColunaAlias('cargo_id'),                                    
                                $tb_cargo->getColunaAlias('des_cargo_basic'),
                                
                                $tb_orcamLot_cargo_headcount->getColunaAlias('qtd_func_lot'), 
                                $tb_orcamLot_cargo_headcount->getColunaAlias('atual_total'),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('orcado_anterior'),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_anterior'),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_total'),

                                $tb_orc_headcount_demissoes->getColunaAlias('lotacao_id'),
                                $tb_orc_headcount_demissoes->getColunaAlias('orc_turma_id'),
                                $tb_orc_headcount_demissoes->getColunaAlias('func_id'), 
                                $tb_orc_headcount_demissoes->getColunaAlias('orc_cargo_id'), 
                                $tb_orc_headcount_demissoes->getColunaAlias('qtde_pessoas'), 
                                $tb_orc_headcount_demissoes->getColunaAlias('tempo_casa'),                                    
                                $tb_funcionario->getColunaAlias('cdn_funcionario'), 
                                $tb_funcionario->getColunaAlias('nome_funcionario'), 
                                $tb_orc_headcount_demissoes->getColunaAlias('tipo'),                                   
                                $tb_orc_headcount_demissoes->getColunaAlias('mes'),
                                $tb_calc_orcamento->getColunaAlias('jan_orcado'),
                                $tb_calc_orcamento->getColunaAlias('fev_orcado'),
                                $tb_calc_orcamento->getColunaAlias('mar_orcado'),
                                $tb_calc_orcamento->getColunaAlias('abr_orcado'),
                                $tb_calc_orcamento->getColunaAlias('mai_orcado'),
                                $tb_calc_orcamento->getColunaAlias('jun_orcado'),
                                $tb_calc_orcamento->getColunaAlias('jul_orcado'),
                                $tb_calc_orcamento->getColunaAlias('ago_orcado'),
                                $tb_calc_orcamento->getColunaAlias('set_orcado'),
                                $tb_calc_orcamento->getColunaAlias('out_orcado'),
                                $tb_calc_orcamento->getColunaAlias('nov_orcado'),
                                $tb_calc_orcamento->getColunaAlias('dez_orcado'),
                                DB::raw("totais.t_headcount_jan,
                                totais.t_headcount_fev,
                                totais.t_headcount_mar,
                                totais.t_headcount_abr,
                                totais.t_headcount_mai,
                                totais.t_headcount_jun,
                                totais.t_headcount_jul,
                                totais.t_headcount_ago,
                                totais.t_headcount_set,
                                totais.t_headcount_out,
                                totais.t_headcount_nov,
                                totais.t_headcount_dez"),

                                DB::raw("CASE WHEN {$tb_orc_headcount_demissoes->getColunaAlias('created_at')} IS NOT NULL THEN format({$tb_orc_headcount_demissoes->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
                                DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

                                DB::raw("CASE WHEN {$tb_calc_orcamento->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tb_calc_orcamento->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
                                DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")

                            ) 
                            ->where([
                                [ $tb_orc_headcount_demissoes->getColunaAlias('orcamento_id'),$orc_id],
                                [$tb_orc_headcount_demissoes->getColunaAlias('lotacao_id'),$lotacao_id],
                                [$tb_orc_headcount_demissoes->getColunaAlias('tipo_table'),$tipo_table]
                            ])
                            ->get()
                            ->toArray();

            return new Response(json_encode($this->montaTreetableDemissoes($this->pivoDemissoes($data))) , 200);
    }

    public function listarContratacoes($orcamento_id , $lotacao_id , $ccusto_id, $tipo_table){
        $this->setCodTela('CONT');
        $this->podeAcessar('listar',true,$this->getCodTela());
        $repo = $this->getRepository()->getModelEntity()::with([
            'getOrcamento'=>function($query){                    
            } 
        ])->where('orc_id', '=', $orcamento_id)            
        ->first();

        if(!$repo){
            return "Orçamento não encontrado";
        }

        $set_orcamento = $this->getRepository()->setOrcamento($repo->getOrcamento);
        
        if(!$this->getRepository()->isOwn()){
            dd("adicionar mensagem q não tem permissão");
        }

        $tb_orcamLot_cargo_headcount = new OrcamLotCargoHeadcount();

        // $data = $this->listajson();
        // return new Response($data , 200);        
        $tb_orcam_headcount_contratacoes = new OrcHeadcountContratacoes();        
        $tb_calc_orcamento = new CalcOrcamento();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tb_lotacao = new OrcLotacao();
        $tb_orc_cargo = new OrcCargo();
        $tbl_usuario = new Usuario();

        $query = $tb_lotacao->join($tb_orcam_headcount_contratacoes->getTable(),
        $tb_orcam_headcount_contratacoes->getColunaAlias('lotacao_id'), $tb_lotacao->getColunaAlias('id'))                            
                            ->leftJoin($tb_calc_orcamento->getTable(), $tb_orcam_headcount_contratacoes->getColunaAlias('id'), '=', 
                                DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and 
                                {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orcam_headcount_contratacoes->getTable()}'"))
                            ->join($tb_orc_cargo->getTable(),
                                $tb_orcam_headcount_contratacoes->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
                            ->join($tb_cargo->getTable(),
                                $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))    
                            ->join($tb_centro_custo->getTable(),
                                $tb_orcam_headcount_contratacoes->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id')) 
                            ->join($tb_turma->getTable(),
                                $tb_orcam_headcount_contratacoes->getColunaAlias('orc_turma_id'), $tb_turma->getColunaAlias('id'))  
                            ->join($tb_turno->getTable(),
                                $tb_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('id'))  

                            ->leftJoin(
                                $tb_orcamLot_cargo_headcount->getTable(),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'),'=',
    
                                DB::raw("{$tb_orcam_headcount_contratacoes->getColunaAlias('lotacao_id')} 
                                and {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_cargo_id')} = {$tb_orcam_headcount_contratacoes->getColunaAlias('orc_cargo_id')}
                                and {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id')} = {$tb_orcam_headcount_contratacoes->getColunaAlias('orc_turma_id')}
                                and {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')} = {$tb_orcam_headcount_contratacoes->getColunaAlias('tipo_table')}")
                            )
                            ->leftJoin(
                                DB::raw("{$tbl_usuario->getTable()} as usuario1"),
                                DB::raw("usuario1.id"),
                                DB::raw("{$tb_orcam_headcount_contratacoes->getColunaAlias('created_by')}")
                            )
                            ->leftJoin(
                                DB::raw("{$tbl_usuario->getTable()} as usuario2"),
                                $tb_calc_orcamento->getColunaAlias('updated_by'),
                                DB::raw("usuario2.id")
                            )
                            ->select(
                                $tb_calc_orcamento->getColunaAlias('id'),
                                $tb_orcam_headcount_contratacoes->getColunaAlias('orcamento_id'), $tb_orcam_headcount_contratacoes->getColunaAlias('lotacao_id'),
                                $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('cod_cargo_basic'), 
                                $tb_cargo->getColunaAlias('des_cargo_basic'),$tb_orcam_headcount_contratacoes->getColunaAlias('ccusto_id'), 
                                $tb_centro_custo->getColunaAlias('cod_ccusto'), 
                                
                                DB::raw("CONCAT({$tb_turma->getColunaAlias('cdn_turma_trab')}, ' - ', {$tb_turma->getColunaAlias('des_turma_trab')}) as des_turma_trab"),
                                DB::raw("CONCAT({$tb_turno->getColunaAlias('cdn_turno_trab')}, ' - ', {$tb_turno->getColunaAlias('des_turno_trab')}) as des_turno_trab"),

                                $tb_orcamLot_cargo_headcount->getColunaAlias('qtd_func_lot'),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('atual_total'),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('orcado_anterior'),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_anterior'),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_total'),
                                $tb_calc_orcamento->getColunaAlias('jan_orcado'),                                    
                                $tb_calc_orcamento->getColunaAlias('fev_orcado'), 
                                $tb_calc_orcamento->getColunaAlias('mar_orcado'),                                    
                                $tb_calc_orcamento->getColunaAlias('abr_orcado'),                                    
                                $tb_calc_orcamento->getColunaAlias('mai_orcado'), 
                                $tb_calc_orcamento->getColunaAlias('jun_orcado'),                                    
                                $tb_calc_orcamento->getColunaAlias('jul_orcado'), 
                                $tb_calc_orcamento->getColunaAlias('ago_orcado'), 
                                $tb_calc_orcamento->getColunaAlias('set_orcado'),                                   
                                $tb_calc_orcamento->getColunaAlias('out_orcado'),                                   
                                $tb_calc_orcamento->getColunaAlias('nov_orcado'), 
                                $tb_calc_orcamento->getColunaAlias('dez_orcado'),
                                $tb_orcam_headcount_contratacoes->getColunaAlias('orc_turma_id'),
                                DB::raw("{$tb_orcam_headcount_contratacoes->getColunaAlias('id')} as id_princ"),


                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jan_orcado')}) OVER(partition by 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                {$tb_orc_cargo->getColunaAlias('cargo_id')},
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')}) t_headcount_jan"),

                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('fev_orcado')}) OVER(partition by 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                {$tb_orc_cargo->getColunaAlias('cargo_id')},
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')}) t_headcount_fev"),

                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mar_orcado')}) OVER(partition by 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                {$tb_orc_cargo->getColunaAlias('cargo_id')},
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')}) t_headcount_mar"), 

                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('abr_orcado')}) OVER(partition by 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                {$tb_orc_cargo->getColunaAlias('cargo_id')},
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')}) t_headcount_abr"), 

                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mai_orcado')}) OVER(partition by 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                {$tb_orc_cargo->getColunaAlias('cargo_id')},
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')}) t_headcount_mai"), 

                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jun_orcado')}) OVER(partition by 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                {$tb_orc_cargo->getColunaAlias('cargo_id')},
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')}) t_headcount_jun"), 

                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jul_orcado')}) OVER(partition by 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                {$tb_orc_cargo->getColunaAlias('cargo_id')},
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')}) t_headcount_jul"), 

                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('ago_orcado')}) OVER(partition by 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                {$tb_orc_cargo->getColunaAlias('cargo_id')},
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')}) t_headcount_ago"), 

                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('set_orcado')}) OVER(partition by 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                {$tb_orc_cargo->getColunaAlias('cargo_id')},
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')}) t_headcount_set"), 

                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('out_orcado')}) OVER(partition by 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                {$tb_orc_cargo->getColunaAlias('cargo_id')},
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')}) t_headcount_out"),

                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('nov_orcado')}) OVER(partition by 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                {$tb_orc_cargo->getColunaAlias('cargo_id')},
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')}) t_headcount_nov"), 
                                
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('dez_orcado')}) OVER(partition by 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                {$tb_orc_cargo->getColunaAlias('cargo_id')},
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')}) t_headcount_dez"),

                                DB::raw("CASE WHEN {$tb_orcam_headcount_contratacoes->getColunaAlias('created_at')} IS NOT NULL THEN format({$tb_orcam_headcount_contratacoes->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
                                DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

                                DB::raw("CASE WHEN {$tb_calc_orcamento->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tb_calc_orcamento->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
                                DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
                            )
                            ->orderByRaw("{$tb_centro_custo->getColunaAlias('cod_ccusto')}, {$tb_cargo->getColunaAlias('cod_cargo_basic')}, 
                                            {$tb_turma->getColunaAlias('cdn_turma_trab')}");

    
        if(!is_null($orcamento_id)){
            $query->where($tb_orcam_headcount_contratacoes->getTable().'.orcamento_id', $orcamento_id);
        }

        if(!is_null($lotacao_id)){
            $query->where($tb_orcam_headcount_contratacoes->getTable().'.lotacao_id', $lotacao_id);
        }
        /** DESCOMENTAR MAIS PRA FRENTE 08/04/2020 */
        // if(!is_null($ccusto_id)){
        //     $query->where($tb_orcam_headcount_contratacoes->getTable().'.ccusto_id', $ccusto_id);
        // }

        if(!is_null($tipo_table)){
            $query->where($tb_orcam_headcount_contratacoes->getColunaAlias('tipo_table'), $tipo_table);
        }

        $data = $query->get()
        ->toArray();
       
                                    // dd("bancvo",($data));
                                    //  dd("pivooooo",$this->montaTreetableContratacoes($this->pivoContratacoes($data)));
        
        return new Response(json_encode($this->montaTreetableContratacoes($this->pivoContratacoes($data))) , 200);
    }

    public function pivo($dados){
        $meses_orcado=$this->getColumMeses();        
        // $eventos_meses = [13,14,15,16];
        $retorno=[];
        $primary_key=['ccusto_id','cargo_id','orc_turma_id', 'lotacao_id'];
       
        $merge_meses_evento=[];
        $meses_orcados_clear=[];        
        
        $dados_rest = [];
        foreach($dados as $key => $value){
            
            $value=(array)$value;
            $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
            $ja_foi=array_keys($retorno);
            
            if(in_array($keys_values, $ja_foi)===false){                
                $aux=Arr::except($value,$meses_orcado);   
                $retorno[$keys_values]=$aux;

            }
            foreach($meses_orcado as $j=>$w){                     
                $retorno[$keys_values][$w]=$value[$w];
            }
        }
        // dd("pivooo", $retorno);
        return $retorno;
    }

    public function pivoContratacoes($dados){
        $meses_orcado=$this->getColumMeses();        
        // $eventos_meses = [13,14,15,16];
        $retorno=[];
        $primary_key=['ccusto_id','cargo_id','orc_turma_id', 'lotacao_id'];
       
        $merge_meses_evento=[];
        $meses_orcados_clear=[];        
        
        $dados_rest = [];
        foreach($dados as $key => $value){
            
            $value=(array)$value;
            $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
            $ja_foi=array_keys($retorno);
            
            if(in_array($keys_values, $ja_foi)===false){                
                $aux=Arr::except($value,$meses_orcado);   
                $retorno[$keys_values]=$aux;

            }
            foreach($meses_orcado as $j=>$w){                     
                $retorno[$keys_values][$w]=$value[$w];
            }
        }

        return $retorno;
    }

    function getIdByTIpo($dados){
       return $dados['headcount_demissoes_id'];
        
    }

    public function pivoDemissoes($dados){
        // dd("pivooo",$dados);
        $pivot_meses=$this->pivotColumns();
        $pivot_meses = $pivot_meses->mes_abreviado; 
        $retorno=[];
        // $primary_key=['cod_ccusto','cod_cargo_basic','cdn_turma_trab'];
        $primary_key=['ccusto_id','cargo_id','orc_turma_id', 'lotacao_id'];
        $except=['funcionario_id', 'qtde_pessoas', 'tempo_casa', 'cdn_funcionario', 'mes', 'cdn_funcionario', 'nome_funcionario', 'tipo'];        
     
        $merge_meses_evento=[];
        $meses_orcados_clear=[];        
        
        $dados_rest = [];
        $meses = [];
        $i=0;
        foreach($dados as $key => $value){
            // dd("tipo 1",  $retorno[$keys_values][$w.'_orcado']);
             $value=(array)$value;
             $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
             $ja_foi=array_keys($retorno);
             
             if(in_array($keys_values, $ja_foi)===false){ 
                              
                $aux=Arr::except($value,$except);   
                $retorno[$keys_values]=$aux;

             }
            
            foreach($pivot_meses as $j=>$w){                            
                
                if($value['tipo'] == '1'){
                    if(is_array($retorno[$keys_values][$w.'_orcado'])==false){
                        $retorno[$keys_values][$w.'_orcado']=[];
                    }   
                    if($value[$w.'_orcado'] == 0){
                        $value[$w.'_orcado'] = null;
                    }
                    $retorno[$keys_values][$w.'_orcado'][]= ['value'=>intval($value[$w.'_orcado']), 'tipo'=>$value['tipo'], 'id'=>$this->getIdByTIpo($value), 'mes'=>$w.'_orcado'];
                  
                    continue;
                }
              

                if(($value['mes']-1) == $j){                      

                    if($value['tipo'] == 2){
                        $retorno[$keys_values][$w.'_orcado'][]= ['value'=>$value['nome_funcionario'], 'tipo'=>$value['tipo'], 'id'=>$this->getIdByTIpo($value), 'mes'=>$w.'_orcado'];
                        continue;
                    }

                    if($value['tipo'] == 3){
                        $retorno[$keys_values][$w.'_orcado'][]= ['value'=>"Qtd. Pessoas: ".$value['qtde_pessoas'] ." - Tempo Casa: ". $value['tempo_casa'], 'tipo'=>$value['tipo'], 'id'=>$this->getIdByTIpo($value), 'mes'=>$w.'_orcado', 'qtd_pessoas' => $value['qtde_pessoas'] ] ;
                        continue;
                    }
                    
                    // if($value['nome_funcionario'] == 0 
                    //     && $value['qtde_pessoas'] > 0 && $value['tempo_casa'] > 0 ){

                    //     $retorno[$keys_values][$w.'_orcado'][]= ['value'=>$value['qtde_pessoas'] ."-". $value['tempo_casa'], 'tipo'=>$value['tipo'], 'id'=>$this->getIdByTIpo($value)];
                    // }else{                        
                    //     $retorno[$keys_values][$w.'_orcado'][]= $value['nome_funcionario'];// array_merge($retorno[$keys_values],$meses);                                                                         
                    // }
                    
                                       
                }
                 
            }
            
            
        }        
        
        // dd("021220191714",$retorno);
        return $retorno;
    }

    public function updated(Request $request, $tipo_table){  
        $form_data = $request->all();
        if($tipo_table == 'F' && $form_data['tb'] == 'horaExtra'){
            $this->setCodTela('FHE');
        }
        else{
            $this->getTagByTb($form_data['tb']);   
        }
        
        $this->podeAcessar('editar',true,$this->getCodTela());
        // DB::enableQueryLog();
        // dd($tipo_table);
        $repo_calc_orcamento=new RepoCalcOrcamento();
        $retorno=$this->getArrayRetornoDefault();
        // $this->getRepository()->clearError();

        //$form_data = $request->all();   ^^^^ali
        // if($form_data['tb']=="horaExtra"){
        //     // $meses = convertDecimalEn(Arr::except($form_data,['id', 'orc_cargo_id', 'orc_turma_id',
        //     // 'orc_id', 'lotacao_id', 'ccusto_id', 'calc_orc_id', 'cod_ccusto', 'cod_cargo_basic', 'des_cargo_basic', 'atual', 'turno', 'turma']));
            
        //     $meses = convertDecimalEn(Arr::only($form_data,['jan', 'fev', 'mar',
        //     'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez']));

        //     dd($meses);
            
        //     $form_data = array_merge($form_data,$meses);
        // }
        // else{
            $meses = convertDecimalEn(Arr::only($form_data,['jan', 'fev', 'mar',
            'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez']));

            $form_data['jan'] = $meses['jan'];
            $form_data['fev'] = $meses['fev'];
            $form_data['mar'] = $meses['mar'];
            $form_data['abr'] = $meses['abr'];
            $form_data['mai'] = $meses['mai'];
            $form_data['jun'] = $meses['jun'];
            $form_data['jul'] = $meses['jul'];
            $form_data['ago'] = $meses['ago'];
            $form_data['set'] = $meses['set'];
            $form_data['out'] = $meses['out'];
            $form_data['nov'] = $meses['nov'];
            $form_data['dez'] = $meses['dez'];
        // }

        if($form_data['tb'] == "headcount"){
            $retorno = $this->getRepository()->updateHeadcount($form_data,$tipo_table);
            goto saida;
        }   
        
        if($form_data['tb'] == "contratacoes"){
            $this->setRepository(new RepoOrcContratacoes);
            $retorno = $this->getRepository()->updateContratacoes($form_data);
            goto saida;   
        }
        
        if($form_data['tb'] == "demissoes"){
            $tb_orc_headcount_demissoes = new OrcHeadcountDemissoes();
            $tb_calc_orcamento = new CalcOrcamento();
           
            $where = [
                'origem_id' => $form_data['demissoes_id'],
                'tbl_origem' => $tb_orc_headcount_demissoes->getTable()
            ];
                        
            if($form_data['tipo_demissoes'] == 1){                
               
                if(! $tb_calc_orcamento->where($where)
                ->update([$form_data['mes_orcado'] => null])){  
                    $retorno['msg'] = $this->getErrosFlatted();
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 051220192050';
                    goto saida;               
                }

                $demissao = $tb_orc_headcount_demissoes->find($form_data['demissoes_id']);

                if(!$demissao){  
                    $retorno['msg'] =  "Demissão não encontrada!";
                    $retorno['submsg']='Falha ao atualizar do registro. Erro: 051220192051';
                    goto saida;               
                }   

                $mes = 1;
                               
            }else{
                $demissao = $tb_orc_headcount_demissoes->where('id', '=', $form_data['demissoes_id'])->first();

                if(!$demissao->delete()){  
                    $retorno['msg'] = $this->getErrosFlatted();
                    $retorno['submsg']='Falha ao atualizar do registro. Erro: 051220192051';
                    goto saida;               
                }     
                $mes = $demissao->mes;
                    
            }    
            
            $repoHeadcount = new RepoHeadcount();
            // dd("CAAAAAAI");
            if(!$repoHeadcount->calcHeadcount($demissao->orcamento_id, $demissao->lotacao_id, $mes)){
                $retorno['status']="error";
                $retorno['msg']=$repoHeadcount->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro: 290420201147';                        
                $hasErro = true;
                abort(500, $retorno['msg']);
                return false;
            }
                    
        } 
     
        if($form_data['tb'] == "horaExtra"){
            if(array_key_exists('tipo_table', $form_data) && array_key_exists('periodo', $form_data)){
                if($this->canCRUDForecast($form_data['lotacao_id'], $form_data['orc_id'], $form_data['periodo'], $form_data['tipo_table']) === false){
                    $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201513';
                    $retorno['submsg'] = 'Erro';
                    $retorno['status'] = 'error';
                    return $this->retornoJsonDefault($retorno);
                }
            }

            $model_tbl_calc_orcamento=new CalcOrcamento();

            $result_calc=$model_tbl_calc_orcamento->find($form_data['calc_orc_id']);
            
            DB::update("UPDATE tbl_headcount_hra_extra set updated_at = ?, updated_by = ? where id = ?", [$this->fillModificadoEm(), $this->fillModificadoPor(), $form_data['id']]);
            
            $data_update = [];
            $meses=['jan', 'fev', 'mar', 'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez'];
            foreach ($meses as $mes) {
                $data_update[$mes.'_orcado'] = $form_data[$mes];
            }
            $data_update['updated_at'] = $this->fillModificadoEm();
            $data_update['updated_by'] = $this->fillModificadoPor();
            
            if(! $result_calc->update($data_update)){               
                $retorno['msg'] = 'Falha ao atualizar o registro.';//$val->getErrosFlatted();
                $retorno['submsg'] = 'Falha ao atualizar o registro. Erro: 220720202101';
                goto saida;
            }         
            
            // $data = $this->dataUpdateHoraExtra($form_data);
             
            // foreach($data['result_calc'] as $val){
                
            //         if(($event_id=array_search($val->origem_id, $data['combine']))===false){
            //             continue;
            //         }
               
            // if(! $val->update($data['eventos_r'][$event_id])){               
            //         $retorno['msg']=$val->getErrosFlatted();
            //         $retorno['submsg']='Falha ao fazer update do registro. Erro: 181120191158';
            //         goto saida;
            //     }         
            // }  
        }        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        saida:       
        
        return $this->retornoJsonDefault($retorno); 
    } 
    
    // public function getUpdate($data, $id){  
    //     $retorno=$this->getArrayRetornoDefault();
    //     $this->clearError();
    //     $repo_calc_orcamento=new RepoCalcOrcamento();  
       
    //     if(! $repo_calc_orcamento->update($data, $id)){  
    //             $this->setError($repo_calc_orcamento->getErrosFlatted());                
    //             return false;               
    //         }
            
    //     return true;       
    // }

    public function dataUpdateHoraExtra($form_data){
       
        $tb_orcam_lot_cargo_evento = new OrcamLotCargoEvento();
        $model_tbl_calc_orcamento=new CalcOrcamento();
        $tb_orc_hora_extra = new OrcHoraExtra();
        
        $array_orcamento=['cod_ccusto','cod_cargo_basic', 'des_cargo_basic', 
        'atual', 'turno', 'turma', 'tb', 'id', 'orc_turma_id', 'orc_id', 'orc_cargo_id', 
        'lotacao_id', 'ccusto_id', 'calc_orc_id'];
        $meses=['jan', 'fev', 'mar', 'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez'];
        $filtered = Arr::except($form_data, array_merge($array_orcamento,$meses, ['_token'] ));
        
        $moth_keys=[];
        $evento_keys=[];
        $mes_atual="";
        $evento_atual=0;
        $meses_r=[];
        $eventos_r=[];
        $orc_turma_id=$form_data['orc_turma_id'];
        $orc_id=$form_data['orc_id'];
        
        foreach($filtered as $chave=>$valor){
            $mes_evento_id=explode('-', $chave);
       
            $mes_atual=$mes_evento_id[0]."_orcado"; 
                        
            $evento_atual=$mes_evento_id[1]; 
            
            if(!in_array($evento_atual, $evento_keys)){
                $evento_keys[]=$evento_atual;
                $eventos_r[$evento_atual]=[];
            }

            $eventos_r[$evento_atual][$mes_atual]=$valor;
        }
       
        $resultado=$tb_orcam_lot_cargo_evento->join($tb_orc_hora_extra->getTable(),
        $tb_orc_hora_extra->getColunaAlias('id'), $tb_orcam_lot_cargo_evento->getColunaAlias('evento_id'))        
        ->where('orc_id','=',$orc_id)
         ->where('orc_turma_id','=', $orc_turma_id) 
         ->whereIn($tb_orc_hora_extra->getColunaAlias('evento_id'),array_keys($eventos_r))
         ->select($tb_orcam_lot_cargo_evento->getColunaAlias('id'), $tb_orc_hora_extra->getColunaAlias('evento_id'))
            ->get()
            ->toArray();
            
        $combine=array_combine(array_column($resultado, 'evento_id'), array_column($resultado, 'id'));
        // dd("dataUpdateHoraExtra", $combine);
        $result_calc=$model_tbl_calc_orcamento
                    ->where('tbl_origem', '=', $tb_orcam_lot_cargo_evento->getTable())
                    ->whereIn('origem_id', $combine)
                    ->get();
                       
        $mergeResult = [];
        $mergeResult['combine'] = $combine;
        $mergeResult['result_calc']= $result_calc;
        $mergeResult['eventos_r'] = $eventos_r;
        
        return $mergeResult;
    }

    public function dataUpdateHeadcount($data){
        $array_orcamento=['cod_ccusto','cod_cargo_basic', 'des_cargo_basic', 'atual', 'turno', 'turma', 'id' ,'tb'];
        $meses=['jan', 'fev', 'mar', 'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez'];
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
        $mes_atual="";
        $meses_headcount=[];
        
        foreach($filtered as $chave=>$valor){            
            $mes_atual=$chave."_orcado";                 
            $meses_headcount[$mes_atual]=$valor;   
        }

        return $meses_headcount;
    }

    public function montaTreetable($data){
        
        $pivot_colunas=$this->pivotColumns();
        $col_meses=$pivot_colunas->merged;
        $col_set_meses=[];
        $col_meses_parent=[];
        // $row_data: Valores da linha atual
        // * $value: valor da coluna atual ou um valor informado pelo usuario, 
        // * matrix: matriz com todas as linhas(Nao processadas ainda)
        foreach($col_meses as $j=>$mes){
            $col_set_meses[]= ["field_out"=>$j,"from"=>$j, "render_value"=>null,];
            $col_meses_parent[]=["field_out"=>$j,  "from"=>'t_event-'.$j, 
            "field_out_render_func"=>function($row_data,$value, $matrix){

            }];
        }
        $column_fixeds=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"qtd_func_lot", "from"=>"atual_total", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],
            // ["field_out"=>"atual_total", "from"=>"atual_total", "render_value"=>null,],
            ["field_out"=>"turno", "render_value"=>function(){ return "-";},],
            ["field_out"=>"turma", "render_value"=>function(){ return "-";},],
            ["field_out"=>"origem_sistema", "from"=>"origem_sistema", "render_value"=>null,],
            ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                // return ($value) ? intval($value) : $value;
                return is_null($value) ? 0 : $value;
            },],
            ["field_out"=>"forecast_anterior", "from"=>"forecast_total", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"jan", "from"=>"t_headcount_jan", "render_value"=>function($row_data, $value){

                return intval($value);
                //  number_format($value,2,',', '.');
            },],
            ["field_out"=>"fev", "from"=>"t_headcount_fev", "render_value"=>function($row_data, $value){
                return intval($value);
                // number_format($value,2,',', '.');
            },],
            ["field_out"=>"mar", "from"=>"t_headcount_mar","render_value"=>function($row_data, $value){
                return intval($value);
                // return number_format($value,2,',', '.');
            },],
            ["field_out"=>"abr", "from"=>"t_headcount_abr", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"mai", "from"=>"t_headcount_mai", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"jun", "from"=>"t_headcount_jun","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"jul", "from"=>"t_headcount_jul", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"ago", "from"=>"t_headcount_ago", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"set", "from"=>"t_headcount_set", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"out", "from"=>"t_headcount_out", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"nov", "from"=>"t_headcount_nov", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"dez", "from"=>"t_headcount_dez","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);
            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,]
            
        ];

        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "render_value"=>function(){ return "";},],
            ["field_out"=>"cod_cargo_basic","render_value"=>function(){ return "";},],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "render_value"=>function(){ return "";},],
            ["field_out"=>"atual", "render_value"=>function(){ return "";},],
            ["field_out"=>"qtd_func_lot", "from"=>"qtd_func_lot", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],
            // ["field_out"=>"atual_total", "from"=>"atual_total", "render_value"=>function($row_data, $value){
            //     return '-';
            // },],
            ["field_out"=>"turno", "from"=>"des_turno_trab", "render_value"=>function($row_data, $value){
                return $row_data['cdn_turno_trab'].' - '.$row_data['des_turno_trab'];
            },],

            ["field_out"=>"turma", "from"=>"des_turma_trab", "render_value"=>function($row_data, $value){
                return $row_data['cdn_turma_trab'].' - '.$row_data['des_turma_trab'];
            },],
            ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                return '';//($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"forecast_anterior", "from"=>"forecast_anterior", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },],            
            ["field_out"=>"jan", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"fev", "from"=>"fev_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"mar", "from"=>"mar_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"abr", "from"=>"abr_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"mai", "from"=>"mai_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"jun", "from"=>"jun_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"jul", "from"=>"jul_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"ago", "from"=>"ago_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"set", "from"=>"set_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"out", "from"=>"out_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"nov", "from"=>"nov_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"dez", "from"=>"dez_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"criado_por", "from"=>"criado_por", "render_value"=>null],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por", "render_value"=>null],
            ["field_out"=>"criado_em", "from"=>"criado_em", "render_value"=>null],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em", "render_value"=>null],

            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"origem_sistema", "from"=>"origem_sistema", "render_value"=>null,]

        ];

        // $columns_base=array_merge($column_fixeds, $col_meses_parent); 
        // $columns_children=array_merge($column_fixeds_children, $col_set_meses); 
        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
            "keys"=>['ccusto_id', 'cargo_id', 'lotacao_id'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children"=>["columns"=>$columns_children,
                    "keys"=>['ccusto_id', 'cargo_id','orc_turma_id', 'lotacao_id'],
                    "filter_data"=>['cod_ccusto'=>function($value){
                        return !is_null($value);
                    }],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result=($value['ccusto_id']== $parent_data['ccusto_id'] && 
                            $value['cargo_id']== $parent_data['cargo_id']&&
                            // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                            $value['lotacao_id']== $parent_data['lotacao_id']);
                        
                            return $result;
                    },
                    // "children"=>["is_recursive"=>true]

                ]
            ];
                 
        $controller=new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
        
    }

    public function montaTreetableContratacoes($data){
        
        $pivot_colunas=$this->pivotColumns();
        $col_meses=$pivot_colunas->merged;
        $col_set_meses=[];
        $col_meses_parent=[];
        // $row_data: Valores da linha atual
        // * $value: valor da coluna atual ou um valor informado pelo usuario, 
        // * matrix: matriz com todas as linhas(Nao processadas ainda)
        foreach($col_meses as $j=>$mes){
            $col_set_meses[]= ["field_out"=>$j,"from"=>$j, "render_value"=>null,];
            $col_meses_parent[]=["field_out"=>$j,  "from"=>'t_event-'.$j, 
            "field_out_render_func"=>function($row_data,$value, $matrix){

            }];
        }
        
        $column_fixeds=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"atual", "from"=>"qtd_func_lot", "render_value"=>null,],
            ["field_out"=>"turno", "render_value"=>function(){ return "-";},],
            ["field_out"=>"turma", "render_value"=>function(){ return "-";},],
            ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                return '0';//($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"forecast_anterior", "from"=>"forecast_total", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"jan", "from"=>"t_headcount_jan", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"fev", "from"=>"t_headcount_fev", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"mar", "from"=>"t_headcount_mar","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"abr", "from"=>"t_headcount_abr", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"mai", "from"=>"t_headcount_mai", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"jun", "from"=>"t_headcount_jun","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"jul", "from"=>"t_headcount_jul", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"ago", "from"=>"t_headcount_ago", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"set", "from"=>"t_headcount_set", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"out", "from"=>"t_headcount_out", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"nov", "from"=>"t_headcount_nov", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"dez", "from"=>"t_headcount_dez","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,]
            
        ];

        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "render_value"=>function(){ return "";},],
            ["field_out"=>"cod_cargo_basic","render_value"=>function(){ return "";},],
            ["field_out"=>"des_cargo_basic", "render_value"=>function(){ return "";},],
            ["field_out"=>"atual", "render_value"=>function(){ return "";},],
            ["field_out"=>"turno", "from"=>"des_turno_trab", "render_value"=>null,],
            ["field_out"=>"turma", "from"=>"des_turma_trab", "render_value"=>null,],

            ["field_out"=>"criado_por", "from"=>"criado_por", "render_value"=>null],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por", "render_value"=>null],
            ["field_out"=>"criado_em", "from"=>"criado_em", "render_value"=>null],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em", "render_value"=>null],

            ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },],
            ["field_out"=>"forecast_anterior", "from"=>"forecast_anterior", "render_value"=>function($row_data, $value){
                return ($value != '-') ? intval($value) : $value;
            },], 
            ["field_out"=>"jan", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"fev", "from"=>"fev_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"mar", "from"=>"mar_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"abr", "from"=>"abr_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"mai", "from"=>"mai_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"jun", "from"=>"jun_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"jul", "from"=>"jul_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"ago", "from"=>"ago_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"set", "from"=>"set_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"out", "from"=>"out_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"nov", "from"=>"nov_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"dez", "from"=>"dez_orcado", "render_value"=>function($row_data, $value){
                // return number_format($value,2,',', '.');
                return intval($value);

            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,]
        ];

        // $columns_base=array_merge($column_fixeds, $col_meses_parent); 
        // $columns_children=array_merge($column_fixeds_children, $col_set_meses); 
        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
            "keys"=>['ccusto_id', 'cargo_id', 'lotacao_id'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children"=>["columns"=>$columns_children,
                    "keys"=>['ccusto_id', 'cargo_id','orc_turma_id', 'lotacao_id'],
                    "filter_data"=>['cod_ccusto'=>function($value){
                        return !is_null($value);
                    }],
                    'parent_filter'=> function($value, $parent_data){
                        $result = ($value['ccusto_id'] == $parent_data['ccusto_id'] &&
                        $value['cargo_id'] == $parent_data['cargo_id'] &&
                        // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                        $value['lotacao_id'] == $parent_data['lotacao_id']);
                        
                            return $result;
                    },
                    // "children"=>["is_recursive"=>true]

                ]
            ];
                 
        $controller=new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
        
    }
    
    public function mergeMesAcaoBTN($value){
        return $value;
        $mes_value = "";
                    if(!is_array($value)){
                      return   $value;
                    }
                   
                    foreach($value as $key => $data){
                        
                        if(is_null($data)){
                            continue;
                        }                           
                       
                         $mes_value .= '<button type="button" class="btnexcluidd" >'. $data['value'].'</button><br><br>';  
                        // $mes_value .= '<button pButton type="button" class="ui-button-info" (click)="excluirROWWW('.$data['id'].','.$data['tipo'].') "value="'. $data['value'].'"></button>.<br>';                       
                        
                    }
                  return $mes_value;
    }

    public function montaTreetableDemissoes($data){
          
        $pivot_colunas=$this->pivotColumns();
        $col_meses=$pivot_colunas->merged;
        $col_set_meses=[];
        $col_meses_parent=[];
        // $row_data: Valores da linha atual
        // * $value: valor da coluna atual ou um valor informado pelo usuario, 
        // * matrix: matriz com todas as linhas(Nao processadas ainda)
        // foreach($col_meses as $j=>$mes){
        //     $col_set_meses[]= ["field_out"=>$j,"from"=>$j, "render_value"=>null,];
        //     $col_meses_parent[]=["field_out"=>$j,  "from"=>'t_event-'.$j, 
        //     "field_out_render_func"=>function($row_data,$value, $matrix){

        //     }];
        // }        
            
            $column_fixeds=[                 
                ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
                ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
                ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],                
                ["field_out"=>"Jan", "render_value"=>function(){ return "";},],
                ["field_out"=>"Fev", "render_value"=>function(){ return "";},],
                ["field_out"=>"Mar", "render_value"=>function(){ return "";},],
                ["field_out"=>"Abr", "render_value"=>function(){ return "";},],
                ["field_out"=>"Mai", "render_value"=>function(){ return "";},],
                ["field_out"=>"Jun", "render_value"=>function(){ return "";},],
                ["field_out"=>"Jul", "render_value"=>function(){ return "";},],
                ["field_out"=>"Ago", "render_value"=>function(){ return "";},],
                ["field_out"=>"Set", "render_value"=>function(){ return "";},],
                ["field_out"=>"Out", "render_value"=>function(){ return "";},],
                ["field_out"=>"Nov", "render_value"=>function(){ return "";},],
                ["field_out"=>"Dez", "render_value"=>function(){ return "";},],
                ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
                ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
                ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
                ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
                ["field_out"=>"turma", "render_value"=>function($row_data, $value){ 
                    return "-";
                },],
                ["field_out"=>"turno", "render_value"=>function(){ return "-";},],
                ["field_out"=>"qtd_func_lot", "from"=>"atual_total", "render_value"=>null,],
                ["field_out"=>"forecast_anterior", "from"=>"forecast_total", "render_value"=>function($row_data, $value){
                    return ($value != '-') ? intval($value) : $value;
                },],["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                    return ($value != '-') ? intval($value) : $value;
                    // return '0';//($value != '-') ? intval($value) : $value;
                },],                    
                ["field_out"=>"Jan", "from"=>"t_headcount_jan", "render_value"=>function($row_data, $value){
                    return intval($value);
                    if (!$row_data['jan_orcado']){
                        return intval($value);
                    }

                    $total = 0;

                    foreach($row_data['jan_orcado'] as $value){
                        if($value['tipo'] == 2 ) {
                            $total = $total + 1;
                        }
                        elseif($value['tipo'] == 3) {
                            $total = $total + $value['qtd_pessoas'];
                        }
                        elseif($value['tipo'] == 1) {
                            $total = $total + $value['value'];                            
                        }                        
                    }   
                    
                    return $total;                    
                    //  number_format($value,2,',', '.');
                },],
                ["field_out"=>"Fev", "from"=>"t_headcount_fev", "render_value"=>function($row_data, $value){
                    return intval($value);
                    if (!$row_data['jan_orcado']){
                        return intval($value);
                    }
                    $total = 0;
                    foreach($row_data['fev_orcado'] as $value){
                        if($value['tipo'] == 2 ) {
                            $total = $total + 1;
                        }
                        elseif($value['tipo'] == 3) {
                            $total = $total + $value['qtd_pessoas'];
                        }
                        elseif($value['tipo'] == 1) {
                            $total = $total + $value['value'];                            
                        }                        
                    }   
                    
                    return $total;
                    // number_format($value,2,',', '.');
                },],
                ["field_out"=>"Mar", "from"=>"t_headcount_mar","render_value"=>function($row_data, $value){
                    return intval($value);
                    if (!$row_data['jan_orcado']){
                        return intval($value);
                    }
                    $total = 0;
                    foreach($row_data['mar_orcado'] as $value){
                        if($value['tipo'] == 2 ) {
                            $total = $total + 1;
                        }
                        elseif($value['tipo'] == 3) {
                            $total = $total + $value['qtd_pessoas'];
                        }
                        elseif($value['tipo'] == 1) {
                            $total = $total + $value['value'];                            
                        }                        
                    }   
                    
                    return $total;
                    // return number_format($value,2,',', '.');
                },],
                ["field_out"=>"Abr", "from"=>"t_headcount_abr", "render_value"=>function($row_data, $value){
                    return intval($value);
                    if (!$row_data['jan_orcado']){
                        return intval($value);
                    }
                    // return number_format($value,2,',', '.');
                    $total = 0;
                    foreach($row_data['abr_orcado'] as $value){
                        if($value['tipo'] == 2 ) {
                            $total = $total + 1;
                        }
                        elseif($value['tipo'] == 3) {
                            $total = $total + $value['qtd_pessoas'];
                        }
                        elseif($value['tipo'] == 1) {
                            $total = $total + $value['value'];                            
                        }                        
                    }   
                    
                    return $total;
                },],
                ["field_out"=>"Mai", "from"=>"t_headcount_mai", "render_value"=>function($row_data, $value){
                    return intval($value);
                    // return number_format($value,2,',', '.');
                    if (!$row_data['jan_orcado']){
                        return intval($value);
                    }
                    $total = 0;
                   
                    foreach($row_data['mai_orcado'] as $value){
                        if($value['tipo'] == 2 ) {
                            $total = $total + 1;
                        }
                        elseif($value['tipo'] == 3) {
                            $total = $total + $value['qtd_pessoas'];
                        }
                        elseif($value['tipo'] == 1) {
                            $total = $total + $value['value'];                            
                        }                        
                    }   
                    
                    return $total;
                },],
                ["field_out"=>"Jun", "from"=>"t_headcount_jun","render_value"=>function($row_data, $value){
                    return intval($value);
                    // return number_format($value,2,',', '.');
                    if (!$row_data['jan_orcado']){
                        return intval($value);
                    }
                    $total = 0;
                    foreach($row_data['jun_orcado'] as $value){
                        if($value['tipo'] == 2 ) {
                            $total = $total + 1;
                        }
                        elseif($value['tipo'] == 3) {
                            $total = $total + $value['qtd_pessoas'];
                        }
                        elseif($value['tipo'] == 1) {
                            $total = $total + $value['value'];                            
                        }                        
                    }   
                    
                    return $total;
                },],
                ["field_out"=>"Jul", "from"=>"t_headcount_jul", "render_value"=>function($row_data, $value){
                    return intval($value);
                    // return number_format($value,2,',', '.');
                    if (!$row_data['jan_orcado']){
                        return intval($value);
                    }
                    $total = 0;
                    foreach($row_data['jul_orcado'] as $value){
                        if($value['tipo'] == 2 ) {
                            $total = $total + 1;
                        }
                        elseif($value['tipo'] == 3) {
                            $total = $total + $value['qtd_pessoas'];
                        }
                        elseif($value['tipo'] == 1) {
                            $total = $total + $value['value'];                            
                        }                        
                    }   
                    
                    return $total;
                },],
                ["field_out"=>"Ago", "from"=>"t_headcount_ago", "render_value"=>function($row_data, $value){
                    return intval($value);
                    // return number_format($value,2,',', '.');
                    if (!$row_data['ago_orcado']){
                        return intval($value);
                    }
                    $total = 0;
                    foreach($row_data['ago_orcado'] as $value){
                        if($value['tipo'] == 2 ) {
                            $total = $total + 1;
                        }
                        elseif($value['tipo'] == 3) {
                            $total = $total + $value['qtd_pessoas'];
                        }
                        elseif($value['tipo'] == 1) {
                            $total = $total + $value['value'];                            
                        }                        
                    }   
                    
                    return $total;
                },],
                ["field_out"=>"Set", "from"=>"t_headcount_set", "render_value"=>function($row_data, $value){
                    return intval($value);
                    // return number_format($value,2,',', '.');
                    if (!$row_data['set_orcado']){
                        return intval($value);
                    }
                    $total = 0;
                    foreach($row_data['set_orcado'] as $value){
                        if($value['tipo'] == 2 ) {
                            $total = $total + 1;
                        }
                        elseif($value['tipo'] == 3) {
                            $total = $total + $value['qtd_pessoas'];
                        }
                        elseif($value['tipo'] == 1) {
                            $total = $total + $value['value'];                            
                        }                        
                    }   
                    
                    return $total;
                },],
                ["field_out"=>"Out", "from"=>"t_headcount_out", "render_value"=>function($row_data, $value){
                    return intval($value);
                    // return number_format($value,2,',', '.');
                    if (!$row_data['out_orcado']){
                        return intval($value);
                    }
                    $total = 0;
                    foreach($row_data['out_orcado'] as $value){
                        if($value['tipo'] == 2 ) {
                            $total = $total + 1;
                        }
                        elseif($value['tipo'] == 3) {
                            $total = $total + $value['qtd_pessoas'];
                        }
                        elseif($value['tipo'] == 1) {
                            $total = $total + $value['value'];                            
                        }                        
                    }   
                    
                    return $total;
                },],
                ["field_out"=>"Nov", "from"=>"t_headcount_nov", "render_value"=>function($row_data, $value){
                    return intval($value);
                    // return number_format($value,2,',', '.');
                    if (!$row_data['nov_orcado']){
                        return intval($value);
                    }
                    $total = 0;
                    foreach($row_data['nov_orcado'] as $value){
                        if($value['tipo'] == 2 ) {
                            $total = $total + 1;
                        }
                        elseif($value['tipo'] == 3) {
                            $total = $total + $value['qtd_pessoas'];
                        }
                        elseif($value['tipo'] == 1) {
                            $total = $total + $value['value'];                            
                        }                        
                    }   
                    
                    return $total;
                },],
                ["field_out"=>"Dez", "from"=>"t_headcount_dez","render_value"=>function($row_data, $value){
                    return intval($value);
                    // return number_format($value,2,',', '.');
                    if (!$row_data['dez_orcado']){
                        return intval($value);
                    }
                    $total = 0;
                    foreach($row_data['dez_orcado'] as $value){
                        if($value['tipo'] == 2 ) {
                            $total = $total + 1;
                        }
                        elseif($value['tipo'] == 3) {
                            $total = $total + $value['qtd_pessoas'];
                        }
                        elseif($value['tipo'] == 1) {
                            $total = $total + $value['value'];                            
                        }                        
                    }   
                    
                    return $total;
                },]           
                
                
            ];
    
            $column_fixeds_children=[                 
                ["field_out"=>"cod_ccusto", "render_value"=>function(){ return "";},],
                ["field_out"=>"cod_cargo_basic","render_value"=>function(){ return "";},],
                ["field_out"=>"des_cargo_basic", "render_value"=>function(){ return "";},],
                ["field_out"=>"qtd_func_lot", "from"=>"atual_total", "render_value"=>null,],

                ["field_out"=>"criado_por", "from"=>"criado_por", "render_value"=>null],
                ["field_out"=>"atualizado_por", "from"=>"atualizado_por", "render_value"=>null],
                ["field_out"=>"criado_em", "from"=>"criado_em", "render_value"=>null],
                ["field_out"=>"atualizado_em", "from"=>"atualizado_em", "render_value"=>null],
                
                ["field_out"=>"forecast_anterior", "from"=>"forecast_anterior", "render_value"=>function($row_data, $value){
                    return ($value != '-') ? intval($value) : $value;
                },],
                ["field_out"=>"turma", "from"=>"des_turma_trab", "render_value"=>function($row_data, $value){
                    return $row_data['cdn_turma_trab'].' - '.$row_data['des_turma_trab'];
                },],

                ["field_out"=>"turno", "from"=>"des_turno_trab", "render_value"=>function($row_data, $value){
                    return $row_data['cdn_turno_trab'].' - '.$row_data['des_turno_trab'];
                },],
                ["field_out"=>"orcado_anterior", "from"=>"orcado_anterior", "render_value"=>function($row_data, $value){
                    return ($value != '-') ? intval($value) : $value;
                },],                 
                ["field_out"=>"Jan", "from"=>"jan_orcado", "render_value"=>function($row_data, $value, $matrix){ 
                    return $this->mergeMesAcaoBTN($value);                     
                },],
                ["field_out"=>"Fev", "from"=>"fev_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"Mar", "from"=>"mar_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"Abr", "from"=>"abr_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"Mai", "from"=>"mai_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"Jun", "from"=>"jun_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"Jul", "from"=>"jul_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"Ago", "from"=>"ago_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"Set", "from"=>"set_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"Out", "from"=>"out_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"Nov", "from"=>"nov_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"Dez", "from"=>"dez_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
                ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
                ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
                ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,]
                ];
    
            // $columns_base=array_merge($column_fixeds, $col_meses_parent); 
            // $columns_children=array_merge($column_fixeds_children, $col_set_meses); 
            $columns_base=$column_fixeds; 
            $columns_children=$column_fixeds_children; 
            //  dd($columns_base);
            $settings=["columns"=>$columns_base,
                // "keys"=>['cod_ccusto', 'cod_cargo_basic'],
                "keys"=>['ccusto_id', 'cargo_id', 'lotacao_id'],
                // "filter_data"=>['parent_id'=>function($value){
                //         return is_null($value);
                //     }    
                // ],            
                "children"=>["columns"=>$columns_children,
                        // "keys"=>['cod_ccusto', 'cod_cargo_basic','cdn_turma_trab','headcount_demissoes_id'],
                        
                        "keys"=>['ccusto_id', 'cargo_id','orc_turma_id', 'lotacao_id'],
                        "filter_data"=>['cod_ccusto'=>function($value){
                            return !is_null($value);
                        }],
                        'parent_filter'=> function($value, $parent_data){ 
                                $result=($value['ccusto_id']== $parent_data['ccusto_id'] && 
                                $value['cargo_id']== $parent_data['cargo_id']&&
                                // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                                $value['lotacao_id']== $parent_data['lotacao_id']);
                            
                                return $result;
                        },
                    ]
                ];
               
            $controller=new AtmTreeTable($settings, $data);            

            return ['data'=>$controller->render()];  
    }    
    
    private function setEventosList($value){
        $this->eventos_list=$value;
        return $this;
    }

    function getColumMesesTotal(){ return $this->meses_total_eventos; }
   
    function getColumMeses(){ return $this->colum_meses; }

    function getEventosList(){ 
        return $this->getEventOfHour(); 
    }

    function pivotColumns(){
        $meses_orcado =$this->getColumMeses() ;
        $eventos_meses = $this->getEventosList();        
        $retorno=[];
        
        $merge_meses_evento=[];
        $meses_orcados_clear=[];
        foreach($meses_orcado as $key => $value){
            
            $var = explode("_",$value);
            $meses_orcados_clear[]=$var[0];
            foreach($eventos_meses as $key_ev =>$value_ev){
                // $merge_meses_evento[$var[0]."-".$value_ev->evento_id] = "";
                $merge_meses_evento[$var[0]."-".$value_ev->getEventos->cdn_event] = "";
            }
        }
        return  (object)['merged'=>$merge_meses_evento, 'mes_abreviado'=>$meses_orcados_clear];
    }

    public function pivoHE($dados){
        // dd("aquiii",$dados);
        $retorno=[];
        // $primary_key=['cod_ccusto','cod_cargo_basic','cdn_turma_trab','id'];
        $primary_key=['cod_ccusto','cod_cargo_basic','id'];
        $pivot_meses=$this->pivotColumns();
        $meses_orcado=$this->getColumMeses();
        $meses_total_eventos=$this->getColumMesesTotal();
        $merge_meses_evento=$pivot_meses->merged;
        $t_eventos=array_combine(array_map(function($current){
           return 't_event-'.$current;
        }, array_keys($merge_meses_evento)), $merge_meses_evento);
        $meses_orcados_clear=$pivot_meses->mes_abreviado;
        $dados_rest = [];
        // dd("treeeeeeeee",$pivot_meses);
        foreach($dados as $key => $value){
            $value=(array)$value;
            $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
            $ja_foi=array_keys($retorno);
            if(in_array($keys_values, $ja_foi)===false){
                   $aux=Arr::except($value,array_merge($meses_orcado, $meses_total_eventos));
                   $retorno[$keys_values]=array_merge($aux,$merge_meses_evento, $t_eventos);                  

            }
            foreach($meses_total_eventos as $total){
                $retorno[$keys_values][$total]=$value[$total];                
            }
            foreach($meses_orcado as $meses){
                $retorno[$keys_values][$meses]=$value[$meses];                
            }
            
            foreach($meses_orcado as $j=>$w){   
                unset($retorno[$keys_values][$meses_orcados_clear[$j]]);
                $retorno[$keys_values][$meses_orcados_clear[$j]."-".$value['cdn_event']]=$value[$w];                
                $retorno[$keys_values]['t_event-'.$meses_orcados_clear[$j]."-".$value['cdn_event']]=$value['t_event_'.$meses_orcados_clear[$j]];
                
            }
        }
        return $retorno;
    }  

    public function montaTreetableHE($data){   
        
        $pivot_colunas=$this->pivotColumns();
        $column_events = $this->pivotColumns();

        $col_meses=$pivot_colunas->merged;
        $col_set_meses=[];
        $col_meses_parent=[];
         
        foreach($col_meses as $j=>$mes){
            $col_set_meses[]= ["field_out"=>$j,"from"=>$j, "render_value"=>function($row_data,$value){
                return intval($value);
            }]; 
            $col_meses_parent[]=["field_out"=>$j,  "from"=>'t_event-'.$j,"render_value"=>function($row_data,$value){
                return intval($value);
            }]; 
        }
        
        $column_fixeds=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null,],
            // ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cdn_event", "from"=>"cdn_event", "render_value"=>function(){ return "-";},],

            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"calc_orc_id", "from"=>"calc_orc_id", "render_value"=>null,],
            ["field_out"=>"atual", "render_value"=>function(){ return "266";},],
            ["field_out"=>"turno","from"=>"turno", "render_value"=>function(){ return "-";},],
            ["field_out"=>"turma","from"=>"turma", "render_value"=>function(){ return "-";},],
            ["field_out"=>"evento","from"=>"evento", "render_value"=>function(){ return "-";},],

            ["field_out"=>"jan", "from"=>"t_event_jan", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"fev", "from"=>"t_event_fev", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"mar", "from"=>"t_event_mar", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"abr", "from"=>"t_event_abr", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"mai", "from"=>"t_event_mai", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"jun", "from"=>"t_event_jun", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"jul", "from"=>"t_event_jul", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"ago", "from"=>"t_event_ago", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"set", "from"=>"t_event_set", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"out", "from"=>"t_event_out", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"nov", "from"=>"t_event_nov", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"dez", "from"=>"t_event_dez", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
        ];
        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null,],
            // ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"calc_orc_id", "from"=>"calc_orc_id", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "render_value"=>function(){ return "";},],
            ["field_out"=>"atual", "render_value"=>function(){ return "266";},],
            ["field_out"=>"turno",  "from"=>"turno", "render_value"=>null,],
            ["field_out"=>"turma", "from"=>"turma", "render_value"=>null,],
            ["field_out"=>"evento", "from"=>"evento", "render_value"=>null,],

            ["field_out"=>"criado_por", "from"=>"criado_por", "render_value"=>null],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por", "render_value"=>null],
            ["field_out"=>"criado_em", "from"=>"criado_em", "render_value"=>null],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em", "render_value"=>null],

            ["field_out"=>"jan", "from"=>"jan_orcado", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"fev", "from"=>"fev_orcado", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"mar", "from"=>"mar_orcado", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"abr", "from"=>"abr_orcado", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"mai", "from"=>"mai_orcado", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"jun", "from"=>"jun_orcado", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"jul", "from"=>"jul_orcado", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"ago", "from"=>"ago_orcado", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"set", "from"=>"set_orcado", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"out", "from"=>"out_orcado", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"nov", "from"=>"nov_orcado", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            ["field_out"=>"dez", "from"=>"dez_orcado", "render_value"=>function($row_data,$value){
                return number_format($value,2,',', '.');
            },],
            // ["field_out"=>"jan", "from"=>"jan_orcado", "render_value"=>function($row_data,$value){
            //     return number_format($value,2,',', '.');
            // }],
            // ["field_out"=>"fev", "from"=>"fev_orcado", "render_value"=>function($row_data,$value){
            //     return number_format($value,2,',', '.');
            // }],
            // ["field_out"=>"mar", "from"=>"mar_orcado", "render_value"=>function($row_data,$value){
            //     return number_format($value,2,',', '.');
            // }],
            // ["field_out"=>"abr", "from"=>"abr_orcado", "render_value"=>function($row_data,$value){
            //     return number_format($value,2,',', '.');
            // }],
            // ["field_out"=>"mai", "from"=>"mai_orcado", "render_value"=>function($row_data,$value){
            //     return number_format($value,2,',', '.');
            // }],
            // ["field_out"=>"jun", "from"=>"jun_orcado", "render_value"=>function($row_data,$value){
            //     return number_format($value,2,',', '.');
            // }],
            // ["field_out"=>"jul", "from"=>"jul_orcado", "render_value"=>function($row_data,$value){
            //     return number_format($value,2,',', '.');
            // }],
            // ["field_out"=>"ago", "from"=>"ago_orcado", "render_value"=>function($row_data,$value){
            //     return number_format($value,2,',', '.');
            // }],
            // ["field_out"=>"set", "from"=>"set_orcado", "render_value"=>function($row_data,$value){
            //     return number_format($value,2,',', '.');
            // }],
            // ["field_out"=>"out", "from"=>"out_orcado", "render_value"=>function($row_data,$value){
            //     return number_format($value,2,',', '.');
            // }],
            // ["field_out"=>"nov", "from"=>"nov_orcado", "render_value"=>function($row_data,$value){
            //     return number_format($value,2,',', '.');
            // }],
            // ["field_out"=>"dez", "from"=>"dez_orcado", "render_value"=>function($row_data,$value){
            //     return number_format($value,2,',', '.');
            // }],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"cdn_event", "from"=>"cdn_event", "render_value"=>null,],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
        ];
        foreach($column_events->merged as $colunas => $value){
            $column_fixeds_children[] = ["field_out"=>$colunas, "from"=>$colunas, "render_value"=>null,];
        }
        // dd($col_meses_parent);

        $columns_base=array_merge($column_fixeds, $col_meses_parent); 
        $columns_children=array_merge($column_fixeds_children, $col_set_meses); 
        //  dd($columns_base);
        $settings=["columns"=>$columns_base,
            "keys"=>['cod_cargo_basic'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],             
            "children"=>["columns"=>$columns_children,
                    "keys"=>['id'],
                    "filter_data"=>['calc_orc_id'=>function($value){
                        return !is_null($value);
                        }],
                    'parent_filter'=> function($value, $parent_data){  
                        // dd($parent_data['id']);                          
                            return /*$value['cod_ccusto']== $parent_data['cod_ccusto'] && */
                            $value['cod_cargo_basic']== $parent_data['cod_cargo_basic']/* &&
                            $value['cdn_turma_trab']== $parent_data['cdn_turma_trab'] && $value['id']==$parent_data['calc_orc_id'] */;
                    }
                ]
            ];
             
        $controller=new AtmTreeTable($settings, $data);
        //dd("treeeeeeeeeTTTTTTTTTTTTTTTTTTTTTTTTTTTTT",['data'=>$controller->render()]);
       return ['data'=>$controller->render()]; 
    }  

    public function insert(Request $request){
        $this->setCodTela('HDCT');
        $this->podeAcessar('inserir',true,$this->getCodTela());

        $data_request = $request->all();

        return $this->retornoJsonDefault($this->getRepository()->createHeadcount($data_request));
    }
 
    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['funcionario_id', 'orc_id', 'lotacao_ancestral_id','lotacao_corrente_id','cargo_ancestral_id', 'cargo_corrente_id','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','evento_id','origem_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

    public function dataFilterHeadCount($data){
        $array_orcamento=['jan_orcado', 'fev_orcado', 'mar_orcado','abr_orcado','mai_orcado', 'jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado','tbl_origem','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','origem_id','id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

    public function deleteHeadForm(Request $request){
        $this->setCodTela('HDCT');
        $this->podeAcessar('deletar',true,$this->getCodTela());

        $retorno = $this->getRepository()->deleteHeadcount(array('id'=>$request->all()['id'],'id_princ'=>$request->all()['id_princ']));
        return $retorno;
    }

    public function finishedForecast(Request $request){
        dd($request->all());
    }

    public function calcHeadcount($orc_id, $lotacao_id){

        dd($this->getRepository()->calcHeadcount($orc_id, $lotacao_id));

    }
    
    public function updateForecastTotal(Request $request){
        $retorno=$this->getArrayRetornoDefault();
        $form_data=$request->all();
       
        if(!$this->getRepository()->updateForecastTotal($form_data)){
            $retorno['msg']='Falha ao atualizar o registro. Erro: 040520201505';
            $retorno['submsg']=$this->getRepository()->getErrosFlatted();
            goto saida;
        }

        $retorno['msg']='Registro atualizado com sucesso!';
        $retorno['submsg']='Sucesso';
        $retorno['status']='success';
            
        saida:
        return $this->retornoJsonDefault($retorno); 
    }

    public function updateDistribution(Request $request){
        set_time_limit(360);
        $this->setCodTela('HDCT');
        $this->podeAcessar('distribuicao', true, $this->getCodTela());
        $data_request = $request->all();
        $retorno = $this->getArrayRetornoDefault();

        // $mes_ini = 1;
        DB::beginTransaction();
        if (!$this->getRepository()->updateValues($data_request['itens'], $data_request['field'])) {
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg'] = 'Falha ao atualizar o registro. Erro: 060520201053';
            DB::rollBack();
            goto saida;
        }

        if (!$this->getRepository()->calcHeadcount($data_request['itens'][0]['orc_id'], $data_request['itens'][0]['lotacao_id'])) {
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg'] = 'Falha ao calcular o headcount. Erro: 150720202145';
            DB::rollBack();
            goto saida;
        }
        /*$result = null;
        foreach($data_request['itens'] as $value){
            for ($i = $mes_ini; $i <= 12 ; $i++) { 
                $result = $this->getRepository()->validaDistribuicao($i, $value);
                
                if( $result === false){
                    $retorno['msg'] = "Forecast Inicial incorreto. A distribuição dos valores iria assumir um valor negativo. Por favor, verifique as Transferências/Promoções e Demissões";
                    $retorno['status'] = 'error';
                    DB::rollBack();
                    goto saida;
                }
            }
        }*/

        $resp = $this->validaValoresNegativos($data_request['itens'][0]['orc_id'], $data_request['itens'][0]['lotacao_id']);
        
        if($resp != null || (is_array($resp) == true && count($resp) > 0)){
            $retorno['msg'] = "Forecast Inicial incorreto. A distribuição dos valores iria assumir um valor negativo. Por favor, verifique as Transferências/Promoções e Demissões";
            $retorno['status'] = 'error';
            DB::rollBack();
            goto saida;
        }
        $retorno['msg'] = 'Distribuição realizada com sucesso!';
        $retorno['status'] = 'success';
        DB::commit();
            
        saida:
        return $this->retornoJsonDefault($retorno); 
    }

    public function canFillHeadcount($orc_id, $lotac_id){

        if($this->getUserFromCurrentGuard()->tipo == 3){
            return 'true';
        }

        $repo_orc_cronograma = new RepoOrcCronograma();
        $repo_atividades = new RepoAtividades();
        
        $cronogramas = $repo_orc_cronograma->getModelEntity()->with([
            'getAtividade'=>function($query){
                return $query->where('title','Preenchimento do Orçamento');
            }
        ])->where('orcamento_id', $orc_id)->get()->toArray();
        if(!$cronogramas){
            return 'false';
        }
        if(count($cronogramas)==0){
            return 'false';
        }
        
        $today = Carbon::now();
        $default_orc = null;

        foreach ($cronogramas as $cronograma){
            if(is_null($cronograma['get_atividade'])){
                continue;
            }
            if(is_null($cronograma['orc_lotacao_id'])){
                $default_orc = $cronograma;
                continue;
            }
            if($cronograma['orc_lotacao_id'] == $lotac_id && $cronograma['tipo_table'] == 'O'){
                return ($today->between(Carbon::parse($cronograma['start_date'])->startOfDay(), Carbon::parse($cronograma['end_date'])->endOfDay())) ? 'true' : 'false';
            }
        }


        if(!$default_orc){
            return 'false';
        }

        return ($today->between(Carbon::parse($default_orc['start_date'])->startOfDay(), Carbon::parse($default_orc['end_date'])->endOfDay())) ? 'true' : 'false';

    }

    public function getTagByTb($tbl){
        if($tbl == 'demissoes'){
            $this->setCodTela('DEM');
        }
        elseif($tbl == 'contratacoes'){
            $this->setCodTela('CONT');
        }
        elseif($tbl == 'horaExtra'){
            $this->setCodTela('HEHC');
        }
    }


    public function loadTotalFuncCargoTurma($orc_id, $cargo_id,$turma_id){
        return $this->getRepository()->loadTotalFuncCargoTurma($orc_id, $cargo_id,$turma_id);
    }
    public function funcionarioAfastados($orc_id,$lotacao_id){
        
        $select = DB::select("
            select 
            count(func.id) as qtd_afastados
            
            from [tbl_funcionario] as func
            join [tbl_orc_lotacao] as lot on func.lotacao_id = lot.lotacao_id and lot.orcamento_id = {$orc_id} and lot.id = {$lotacao_id}
            where dt_afast_ini <= GETDATE() and dt_afast_fim >= GETDATE()
        ");

        $qtd = count($select) > 0 ? $select[0]->qtd_afastados : 0;
        return $qtd;
    }

    public function canCrudHeadcount($orc_id){
        $select = DB::select("SELECT * from tbl_orc_movto_status_ccusto where tipo_table = 'F' and orc_lotacao_id in (select id from tbl_orc_lotacao where orcamento_id = $orc_id and tipo_table = 'F')");
        
        if(count($select) > 0){
            return 'false';
        }
        else{
            return 'true';
        }
    }

    public function loadShowReabrir($orc_id, $lotacao_id, $tipo_table){
        $repo_orc_lotacao = new RepoOrcLotacao();
        $retorno = $this->getArrayRetornoDefault();

        $user = $this->getUserFromCurrentGuard();
        if($user->tipo != 3){
            $retorno['show_reabrir']=false;
            goto saida;
        }

        $array_status = $tipo_table == 'O' ? [
            $repo_orc_lotacao->getStatusLotEnviado(),
            $repo_orc_lotacao->getStatusLotConferido(),
            $repo_orc_lotacao->getStatusLotCalculado(),
            $repo_orc_lotacao->getStatusLotCalculadoLiberado()
        ] : [
            $repo_orc_lotacao->getStatusLotEnviadoFCST(),
            $repo_orc_lotacao->getStatusLotConferidoFCST(),
            $repo_orc_lotacao->getStatusLotCalculadoFCST(),
            $repo_orc_lotacao->getStatusLotCalculadoLiberadoFCST()            
        ];

        $lotacao = $repo_orc_lotacao->getModelEntity()->find($lotacao_id);

        if(!in_array($lotacao->status, $array_status)){
            $retorno['show_reabrir']=false;
            goto saida;            
        }

        $headcounts = DB::select("
        SELECT a.id from tbl_orc_lot_carg_headcount a
        join tbl_calc_orcamento b on b.origem_id = a.id and b.tbl_origem = 'tbl_orc_lot_carg_headcount'
        where a.lotacao_id = $lotacao_id and a.tipo_table = '$tipo_table' and 
        (b.jan_orcado <> 0 OR
        b.fev_orcado <> 0 OR
        b.mar_orcado <> 0 OR
        b.abr_orcado <> 0 OR
        b.mai_orcado <> 0 OR
        b.jun_orcado <> 0 OR
        b.jul_orcado <> 0 OR
        b.ago_orcado <> 0 OR
        b.set_orcado <> 0 OR
        b.out_orcado <> 0 OR
        b.nov_orcado <> 0 OR
        b.dez_orcado <> 0)");

        // if(count($headcounts) > 0){
        //     $retorno['show_reabrir']=false;
        //     goto saida;            
        // }
        
        $retorno['show_reabrir']=true;
        saida:
        $retorno['submsg']='Sucesso';
        $retorno['status']='success';
    
        return $this->retornoJsonDefault($retorno); 
    }
}
 