<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Http\Controllers\OrcamentoController;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoHeadcountDemissoes as RepoHeadcountDemissoes;
use App\Support\TreeTable\AtmTreeTable;
use App\Modules\Natureza51\Entities\OrcFuncionario;


class HeadcountDemissoesController extends OrcamentoController
{
    use \App\Core\Traits\ErrorTrait;
    
    public function __construct(){
        
        $this->repository=new RepoHeadcountDemissoes();
        $this->setCodTela('DEM');
        parent::__construct();
    }

    public function insert(Request $data){
        $this->setCodTela('DEM');
        $this->podeAcessar('inserir',true,$this->getCodTela());

        $a = $this->retornoJsonDefault($this->getRepository()->created($data->all()));
        return $a;
     
    }
    
    public function validaInsert(Request $data){     

        $a = $this->retornoJsonDefault($this->getRepository()->orcFuncCargo($data->all()));
        return $a;
     
    }



    public function deleteAll(Request $request){
        $this->setCodTela('DEM');
        $this->podeAcessar('deletar',true,$this->getCodTela());
        $rqst = $request->all();
        unset($rqst['_token']);       
        return  $this->getRepository()->deleteAll($rqst);
    }

    
    public function orcFuncCargo($orcamento_id, $func_id, $periodo = null, $tipo_table = 'O'){
        $orc_func = new OrcFuncionario();

        $orc_func = OrcFuncionario::where('orc_id', $orc_func['orcamento_id'] = $orcamento_id)->where('funcionario_id', $orc_func['funcionario_id'] = $func_id)
        ->where('tipo_table', $tipo_table);

        if($tipo_table == 'F'){
            $orc_func = $orc_func->where('periodo', $periodo)->first();;
        }
        else{
            $orc_func = $orc_func->whereNull('periodo')->first();
        }
       // $cargo = $orc_func['orc_cargo_id'];
       // $turma = $orc_func['orc_turma_id'];
       // $lotacao = $orc_func['orc_lotacao_id'];
       
        $funcionario = json_encode($orc_func);

        return $funcionario;
    }
} 