<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoOrcHoraExtra as RepoOrcHoraExtra;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento as RepoCalcOrcamento;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\OrcHoraExtra;
use App\Modules\Natureza51\Repositories\RepoHeadcountHraExtra;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Http\Response;


class HeadcountHraExtraController extends Natureza51Ctrl
{
     public function __construct(){
		$this->setCodTela('HEHC');
        $this->repository=new RepoHeadcountHraExtra();
        parent::__construct();
    } 

    public function orcHeInsert($orcId,\Illuminate\Http\Request $request){
    	// dd($request->all());
    	$r=$request->all();
		$form_data=$this->getRepositoryOrModel()->putOrcamentoIdOnData($r['items'][0], $orcId);

        $evento_id= isset($form_data['id']) ? intval($form_data['id']) : 0;
		
		$ja_existe=$this->getRepositoryOrModel()->getModelEntity()->where(['orcamento_id'=>$orcId,'evento_id'=>$evento_id])
			->first();

		if(!empty($ja_existe)){
			$retorno["status"]="error";
			$retorno["msg"]='A opção selecionada já existe.';
			$retorno['submsg']='Falha ao inserir. Erro 131220190814';
			goto saida;
		} 

		$orcamento=$this->getRepositoryOrModel()->getOrcInstanceNew()->find($orcId);

		if($this->getRepositoryOrModel()->setOrcamento($orcamento)->canEdit()==false){//Se o usuario não tiver a pemissão
			$retorno["status"]="error";
			$retorno["msg"]='Não é possível cadastrar esta Hora Extra pois o mesmo não permite.';
			$retorno['submsg']='Falha ao inserir. Erro 131220191114';
			goto saida;
		}
		//dd($orc_event);
		$orc_event=array(
			'orcamento_id'=>$form_data['orcamento_id'],
			'evento_id'=>$form_data['id']
		);

		if(!$this->getRepositoryOrModel()->createOrc($orc_event)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro:111220191024';
            goto saida;
        }


        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);  
         //dd($retorno);
	}
	public function insert(\Illuminate\Http\Request $data){
		$this->setCodTela('HEHC');
		$this->podeAcessar('inserir',true,$this->getCodTela());

		$form_data = $data->all();
		//dd($form_data);
		$retorno = $this->getRepository()->insertHraExtra($form_data);
		if($retorno['status']=='error'){
			return $this->retornoJsonDefault($retorno,500);
		}
		return $retorno;
	}

	public function populaOrcHoraExtra($orc_id){
       
        if(! $this->getRepositoryOrModel()->populaOrcHoraExtra($orc_id)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['status']='error';
            $retorno['submsg']='Falha ao inserir o registro. Erro:060420201047';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Sucesso";
        $retorno["submsg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
       
    }

	public function deleteHe(Request $request){
		$this->setCodTela('HEHC');
		
		$this->podeAcessar('deletar',true,$this->getCodTela());
        $repo_calc_orcamento = new RepoCalcOrcamento();
		$retorno = $this->getArrayRetornoDefault();
		$data = $request->all();

        DB::beginTransaction();
        try {
    
            $deletou = $this->getRepository()->delete($request->all()['id']); 
            
            if(!$deletou){
                return false;
			}
			$retorno = array('msg'=>'Registro deletado com sucesso!','status'=>'success');
            
            $deletou_calc = $repo_calc_orcamento->getModelInstance()->where(['origem_id'=>$data['id'], 'tbl_origem'=>$this->getRepositoryOrModel()->getModelEntity()->getTable()])->delete();
        
            if($deletou_calc==false){
                $this->setError([$repo_calc_orcamento->getErrosFlatted(),'Erro: 021220191908']);
                DB::rollBack();
                return false;
            }
			$repo_orc = new RepoOrcamento();
			if($repo_orc->deleteDiarioBordo($request->all()['id'], 'tbl_headcount_hra_extra') === false){
				$this->setError("Falha ao deletar Diário de Bordo. Erro: 220320211626");
				DB::rollBack();
                return false;
			}
            DB::commit();

        } catch (\Exception $e) {
			DB::rollBack();
			abort(500,'Falha ao deletar registro. Erro: 220720201016.');       
		}
		
		return  $retorno;
    
    }
 
    public function lista($orc_id){
    	$tbl_evento = new Eventos();
		
    	$rep_horaextra=$this->getRepository()->getModelEntity();

    	$select=$rep_horaextra
    	->leftJoin($tbl_evento->getTable(),$rep_horaextra->getColunaAlias('evento_id'),$tbl_evento->getColunaAlias('id'))
    	->select('orcamento_id','evento_id',$tbl_evento->getColunaAlias('des_event'),$tbl_evento->getColunaAlias('cdn_event'))
    	->orderBy('cdn_event')->toSql();
    	
    	return $select;
    }

    public function eventosInsert($orc_id, $periodo = null, $tipo_table = 'O'){
        
        $tb_headcount_hra_extra= $this->getRepository()->getModelEntity();

        $tb_eventos = new Eventos();
		$tb_orc_hora_extra = new OrcHoraExtra();
		
		// DB::enableQueryLog();

		$query = $tb_headcount_hra_extra
        ->join($tb_orc_hora_extra->getTable(),
        	$tb_headcount_hra_extra->getColunaAlias('evento_id'),$tb_orc_hora_extra->getColunaAlias('id'))
        ->join($tb_eventos->getTable(),
        	$tb_orc_hora_extra->getColunaAlias('evento_id'),$tb_eventos->getColunaAlias('id'))
        ->select($tb_eventos->getColunaAlias('id'),
			$tb_eventos->getColunaAlias('des_event'),
			DB::raw("CONCAT({$tb_eventos->getColunaAlias('cdn_event')}, ' - ', {$tb_eventos->getColunaAlias('des_event')}) as description")
		)
        ->distinct()
		->where($tb_headcount_hra_extra->getColunaAlias('orc_id'),$orc_id)
		->where($tb_headcount_hra_extra->getColunaAlias('tipo_table'),$tipo_table);
		
		$select = null;
		if($tipo_table == 'F'){
			$select = $query->where($tb_headcount_hra_extra->getColunaAlias('tipo_table'), $periodo)->get()->toArray();
		}
		else{
			$select = $query->whereNull($tb_headcount_hra_extra->getColunaAlias('tipo_table'))->get()->toArray();
		}
		// dd(DB::getQueryLog());

        return new Response(json_encode($select) , 200);
    }
 

}
