<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Entities\OrcamLotCargoEvento;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\Turma;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcTurma;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;
use App\Support\TreeTable\AtmTreeTable;

class HeadcountListaController extends Natureza51Ctrl
{
    private $colum_meses=['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado',
    'jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];

    private $meses_total_eventos=['t_event_jan','t_event_fev','t_event_mar','t_event_abr','t_event_mai',
                                    't_event_jun','t_event_jul','t_event_ago','t_event_set','t_event_out','t_event_nov','t_event_dez'];
    private $eventos_list=[34,35,36];

    public function listarOrc($orcamento_id){


        // dd('nkljkjdsngkjrdhugfd');

        // $data = $this->listajson();
        // return new Response($data , 200);

        $tb_orcam_lot_cargo_evento = new OrcamLotCargoEvento();
        $tb_orcamLot_cargo_headcount = new OrcamLotCargoHeadcount();
        $tb_eventos = new Eventos();
        $tb_calc_orcamento = new CalcOrcamento();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_turma = new OrcTurma();
        $tb_lotacao = new Lotacao();
        $tb_orc_cargo = new OrcCargo();
        $alias_calc_orcamento = 'coh';
        $tb_alias = $tb_calc_orcamento->getTable();       
        $tb_alias = $tb_alias . " AS {$alias_calc_orcamento}";
        
        $data = $tb_lotacao->join($tb_orcam_lot_cargo_evento->getTable(),
        $tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id'), $tb_lotacao->getColunaAlias('id'))                                
                            ->join($tb_orcamLot_cargo_headcount->getTable(), 
                            $tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id') , '=',                            
                            DB::raw("{$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')} and 
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('orc_id')} = {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_id')} and  
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')} = {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_cargo_id')} and
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')} = {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')} and 
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('orc_turma_id')} = {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id')} and 
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table')} = {$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table')} "
                                )
                            )
                            ->join($tb_eventos->getTable(),$tb_eventos->getColunaAlias('id'), $tb_orcam_lot_cargo_evento->getColunaAlias('evento_id'))
                            ->leftJoin($tb_calc_orcamento->getTable(), $tb_orcam_lot_cargo_evento->getColunaAlias('id'), '=',                            
                            DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orcam_lot_cargo_evento->getTable()}'"))
                            ->leftJoin($tb_alias, $tb_orcamLot_cargo_headcount->getColunaAlias('id'), '=', 
                                DB::raw("{$alias_calc_orcamento}.origem_id and {$alias_calc_orcamento}.tbl_origem = '{$tb_orcamLot_cargo_headcount->getTable()}'"))
                            ->join($tb_orc_cargo->getTable(),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
                            ->join($tb_cargo->getTable(),
                                $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))    
                            ->join($tb_centro_custo->getTable(),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id')) 
                            ->join($tb_turma->getTable(),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('orc_turma_id'), $tb_turma->getColunaAlias('id')) 
                            ->select(
                                DB::raw("{$tb_eventos->getColunaAlias('id')} as evento_id"),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('orc_id'),$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id'),$tb_orcam_lot_cargo_evento->getColunaAlias('evento_id'),
                                $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('cod_cargo_basic'), 
                                $tb_cargo->getColunaAlias('des_cargo_basic'),$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('cod_ccusto'),
                                $tb_turma->getColunaAlias('cdn_turma_trab'), 
                                DB::raw("{$alias_calc_orcamento}.jan_orcado as jan_orcado_headcount"),
                                DB::raw("{$alias_calc_orcamento}.fev_orcado as fev_orcado_headcount"),
                                DB::raw("{$alias_calc_orcamento}.mar_orcado as mar_orcado_headcount"),
                                DB::raw("{$alias_calc_orcamento}.abr_orcado as abr_orcado_headcount"),
                                DB::raw("{$alias_calc_orcamento}.mai_orcado as mai_orcado_headcount"),
                                DB::raw("{$alias_calc_orcamento}.jun_orcado as jun_orcado_headcount"),
                                DB::raw("{$alias_calc_orcamento}.jul_orcado as jul_orcado_headcount"),
                                DB::raw("{$alias_calc_orcamento}.ago_orcado as ago_orcado_headcount"),
                                DB::raw("{$alias_calc_orcamento}.set_orcado as set_orcado_headcount"),
                                DB::raw("{$alias_calc_orcamento}.out_orcado as out_orcado_headcount"),
                                DB::raw("{$alias_calc_orcamento}.nov_orcado as nov_orcado_headcount"),
                                DB::raw("{$alias_calc_orcamento}.dez_orcado as dez_orcado_headcount"),

                                DB::raw("SUM({$alias_calc_orcamento}.jan_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_headcount_jan"),

                                DB::raw("SUM({$alias_calc_orcamento}.fev_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_headcount_fev"),

                                DB::raw("SUM({$alias_calc_orcamento}.mar_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_headcount_mar"),

                                DB::raw("SUM({$alias_calc_orcamento}.abr_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_headcount_abr"),

                                DB::raw("SUM({$alias_calc_orcamento}.mai_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_headcount_mai"),

                                DB::raw("SUM({$alias_calc_orcamento}.jun_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_headcount_jun"),

                                DB::raw("SUM({$alias_calc_orcamento}.jul_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_headcount_jul"),

                                DB::raw("SUM({$alias_calc_orcamento}.ago_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_headcount_ago"),

                                DB::raw("SUM({$alias_calc_orcamento}.set_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_headcount_set"),

                                DB::raw("SUM({$alias_calc_orcamento}.out_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_headcount_out"),

                                DB::raw("SUM({$alias_calc_orcamento}.nov_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_headcount_nov"),

                                DB::raw("SUM({$alias_calc_orcamento}.dez_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_headcount_dez"),

                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jan_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_jan, {$tb_calc_orcamento->getColunaAlias('jan_orcado')}") ,
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('fev_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_fev, {$tb_calc_orcamento->getColunaAlias('fev_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mar_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')},  
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_mar, {$tb_calc_orcamento->getColunaAlias('mar_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('abr_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_abr, {$tb_calc_orcamento->getColunaAlias('abr_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mai_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_mai, {$tb_calc_orcamento->getColunaAlias('mai_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jun_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_jun, {$tb_calc_orcamento->getColunaAlias('jun_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jul_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_jul, {$tb_calc_orcamento->getColunaAlias('jul_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('ago_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_ago, {$tb_calc_orcamento->getColunaAlias('ago_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('set_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_set, {$tb_calc_orcamento->getColunaAlias('set_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('out_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_out, {$tb_calc_orcamento->getColunaAlias('out_orcado')}"),
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('nov_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_nov, {$tb_calc_orcamento->getColunaAlias('nov_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('dez_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_dez, {$tb_calc_orcamento->getColunaAlias('dez_orcado')}")
                            )
                            ->orderByRaw("{$tb_centro_custo->getColunaAlias('cod_ccusto')}, 
                            {$tb_cargo->getColunaAlias('cod_cargo_basic')}, {$tb_turma->getColunaAlias('cdn_turma_trab')}")
                            ->where([
                                [$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table'), 'O'],
                                [$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table'), 'O']
                            ])
                            ->get()
                            ->toArray();
                                    // dd("listaaaaaaaaaaaaaaaaaaaa",$data);
                                    //  dd("testeee",$this->ex($this->pivo($data)));
        return new Response(json_encode($this->montaTreetableLista($this->pivo($data))) , 200);
    }
    
    public function listar(){


            // $data = $this->listajson();
            // return new Response($data , 200);

            $tb_orcam_lot_cargo_evento = new OrcamLotCargoEvento();
            $tb_orcamLot_cargo_headcount = new OrcamLotCargoHeadcount();
            $tb_eventos = new Eventos();
            $tb_calc_orcamento = new CalcOrcamento();
            $tb_cargo = new Cargo();
            $tb_centro_custo = new CentroCusto();
            $tb_turma = new OrcTurma();
            $tb_lotacao = new Lotacao();
            $tb_orc_cargo = new OrcCargo();
            $alias_calc_orcamento = 'coh';
            $tb_alias = $tb_calc_orcamento->getTable();       
            $tb_alias = $tb_alias . " AS {$alias_calc_orcamento}";
            
            $data = $tb_lotacao->join($tb_orcam_lot_cargo_evento->getTable(),
            $tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id'), $tb_lotacao->getColunaAlias('id'))                                
                                ->join($tb_orcamLot_cargo_headcount->getTable(), 
                                $tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id') , '=',                            
                                DB::raw("{$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')} and 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('orc_id')} = {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_id')} and  
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')} = {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_cargo_id')} and
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')} = {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')} and 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('orc_turma_id')} = {$tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id')} ")
                                )
                                ->join($tb_eventos->getTable(),$tb_eventos->getColunaAlias('id'), $tb_orcam_lot_cargo_evento->getColunaAlias('evento_id'))
                                ->leftJoin($tb_calc_orcamento->getTable(), $tb_orcam_lot_cargo_evento->getColunaAlias('id'), '=',                            
                                DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orcam_lot_cargo_evento->getTable()}'"))
                                ->leftJoin($tb_alias, $tb_orcamLot_cargo_headcount->getColunaAlias('id'), '=', 
                                    DB::raw("{$alias_calc_orcamento}.origem_id and {$alias_calc_orcamento}.tbl_origem = '{$tb_orcamLot_cargo_headcount->getTable()}'"))
                                ->join($tb_orc_cargo->getTable(),
                                    $tb_orcamLot_cargo_headcount->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
                                ->join($tb_cargo->getTable(),
                                    $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))    
                                ->join($tb_centro_custo->getTable(),
                                    $tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id')) 
                                ->join($tb_turma->getTable(),
                                    $tb_orcam_lot_cargo_evento->getColunaAlias('orc_turma_id'), $tb_turma->getColunaAlias('id')) 
                                ->select(
                                    DB::raw("{$tb_eventos->getColunaAlias('id')} as evento_id"),
                                    $tb_orcam_lot_cargo_evento->getColunaAlias('orc_id'),$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id'),$tb_orcam_lot_cargo_evento->getColunaAlias('evento_id'),
                                    $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('cod_cargo_basic'), 
                                    $tb_cargo->getColunaAlias('des_cargo_basic'),$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('cod_ccusto'),
                                    $tb_turma->getColunaAlias('cdn_turma_trab'), 
                                    DB::raw("{$alias_calc_orcamento}.jan_orcado as jan_orcado_headcount"),
                                    DB::raw("{$alias_calc_orcamento}.fev_orcado as fev_orcado_headcount"),
                                    DB::raw("{$alias_calc_orcamento}.mar_orcado as mar_orcado_headcount"),
                                    DB::raw("{$alias_calc_orcamento}.abr_orcado as abr_orcado_headcount"),
                                    DB::raw("{$alias_calc_orcamento}.mai_orcado as mai_orcado_headcount"),
                                    DB::raw("{$alias_calc_orcamento}.jun_orcado as jun_orcado_headcount"),
                                    DB::raw("{$alias_calc_orcamento}.jul_orcado as jul_orcado_headcount"),
                                    DB::raw("{$alias_calc_orcamento}.ago_orcado as ago_orcado_headcount"),
                                    DB::raw("{$alias_calc_orcamento}.set_orcado as set_orcado_headcount"),
                                    DB::raw("{$alias_calc_orcamento}.out_orcado as out_orcado_headcount"),
                                    DB::raw("{$alias_calc_orcamento}.nov_orcado as nov_orcado_headcount"),
                                    DB::raw("{$alias_calc_orcamento}.dez_orcado as dez_orcado_headcount"),

                                    DB::raw("SUM({$alias_calc_orcamento}.jan_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_headcount_jan"),

                                    DB::raw("SUM({$alias_calc_orcamento}.fev_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_headcount_fev"),

                                    DB::raw("SUM({$alias_calc_orcamento}.mar_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_headcount_mar"),

                                    DB::raw("SUM({$alias_calc_orcamento}.abr_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_headcount_abr"),

                                    DB::raw("SUM({$alias_calc_orcamento}.mai_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_headcount_mai"),

                                    DB::raw("SUM({$alias_calc_orcamento}.jun_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_headcount_jun"),

                                    DB::raw("SUM({$alias_calc_orcamento}.jul_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_headcount_jul"),

                                    DB::raw("SUM({$alias_calc_orcamento}.ago_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_headcount_ago"),

                                    DB::raw("SUM({$alias_calc_orcamento}.set_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_headcount_set"),

                                    DB::raw("SUM({$alias_calc_orcamento}.out_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_headcount_out"),

                                    DB::raw("SUM({$alias_calc_orcamento}.nov_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_headcount_nov"),

                                    DB::raw("SUM({$alias_calc_orcamento}.dez_orcado) OVER(partition by {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_headcount_dez"),

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jan_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_event_jan, {$tb_calc_orcamento->getColunaAlias('jan_orcado')}") ,
                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('fev_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_event_fev, {$tb_calc_orcamento->getColunaAlias('fev_orcado')}"), 
                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mar_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')},  
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_event_mar, {$tb_calc_orcamento->getColunaAlias('mar_orcado')}"), 
                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('abr_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_event_abr, {$tb_calc_orcamento->getColunaAlias('abr_orcado')}"), 
                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mai_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_event_mai, {$tb_calc_orcamento->getColunaAlias('mai_orcado')}"), 
                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jun_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_event_jun, {$tb_calc_orcamento->getColunaAlias('jun_orcado')}"), 
                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jul_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_event_jul, {$tb_calc_orcamento->getColunaAlias('jul_orcado')}"), 
                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('ago_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_event_ago, {$tb_calc_orcamento->getColunaAlias('ago_orcado')}"), 
                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('set_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_event_set, {$tb_calc_orcamento->getColunaAlias('set_orcado')}"), 
                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('out_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_event_out, {$tb_calc_orcamento->getColunaAlias('out_orcado')}"),
                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('nov_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_event_nov, {$tb_calc_orcamento->getColunaAlias('nov_orcado')}"), 
                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('dez_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orc_cargo->getColunaAlias('cargo_id')}, 
                                    {$tb_eventos->getColunaAlias('id')}) t_event_dez, {$tb_calc_orcamento->getColunaAlias('dez_orcado')}")
                                )
                                ->orderByRaw("{$tb_centro_custo->getColunaAlias('cod_ccusto')}, {$tb_cargo->getColunaAlias('cod_cargo_basic')}, {$tb_turma->getColunaAlias('cdn_turma_trab')}")
                                ->where([
                                    [$tb_orcam_lot_cargo_evento.'.orcamento_id', $orcamento_id],
                                    [$tb_orcamLot_cargo_headcount.'.orcamento_id', $orcamento_id],
                                ])   
                                ->get()
                                        ->toArray();
                                        // dd("listaaaaaaaaaaaaaaaaaaaa",$data);
                                        //  dd("testeee",$this->ex($this->pivo($data)));
            return new Response(json_encode($this->montaTreetableLista($this->pivo($data))) , 200);
        }
                
        private function setEventosList($value){
            $this->eventos_list=$value;
            return $this;
        }
        function getColumMesesTotal(){ return $this->meses_total_eventos; }
        function getColumMeses(){ return $this->colum_meses; }
        function getEventosList(){ return $this->eventos_list; }
        function pivotColumns(){
            $meses_orcado =$this->getColumMeses() ;
            $eventos_meses = $this->getEventosList();
            $retorno=[];
            
            $merge_meses_evento=[];
            $meses_orcados_clear=[];
            foreach($meses_orcado as $key => $value){
                
                $var = explode("_",$value);
                $meses_orcados_clear[]=$var[0];

                foreach($eventos_meses as $key_ev =>$value_ev){
                    $merge_meses_evento[$var[0]."-".$value_ev] = "";
                }
            }
            return  (object)['merged'=>$merge_meses_evento, 'mes_abreviado'=>$meses_orcados_clear];
        }
        public function pivo($dados){
        
            $retorno=[];
            $primary_key=['cod_ccusto','cod_cargo_basic','cdn_turma_trab'];
            $pivot_meses=$this->pivotColumns();
            $meses_orcado=$this->getColumMeses();
            $meses_total_eventos=$this->getColumMesesTotal();
            $merge_meses_evento=$pivot_meses->merged;
            $t_eventos=array_combine(array_map(function($current){
            return 't_event-'.$current;
            }, array_keys($merge_meses_evento)), $merge_meses_evento);
        
            $meses_orcados_clear=$pivot_meses->mes_abreviado;
            $dados_rest = [];
            foreach($dados as $key => $value){
                $value=(array)$value;
                $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
                $ja_foi=array_keys($retorno);
                if(in_array($keys_values, $ja_foi)===false){
                    $aux=Arr::except($value,array_merge($meses_orcado, $meses_total_eventos));
                    $retorno[$keys_values]=array_merge($aux,$merge_meses_evento, $t_eventos);                  

                }
                foreach($meses_orcado as $j=>$w){               
                    $retorno[$keys_values][$meses_orcados_clear[$j]."-".$value['evento_id']]=$value[$w];
                    $retorno[$keys_values]['t_event-'.$meses_orcados_clear[$j]."-".$value['evento_id']]=$value['t_event_'.$meses_orcados_clear[$j]];
                }
            }
            return $retorno;
        }

        public function montaTreetableLista($data){      
            // dd('dsdasd',$data);
            $pivot_colunas=$this->pivotColumns();
            $col_meses=$pivot_colunas->merged;
            $col_set_meses=[];
            $col_meses_parent=[];
            
            foreach($col_meses as $j=>$mes){
                $col_set_meses[]= ["field_out"=>$j,"from"=>$j, "render_value"=>null,];
                $col_meses_parent[]=["field_out"=>$j,  "from"=>'t_event-'.$j, ];
            }
            
            $column_fixeds=[ 
                ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
                ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
                ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
                ["field_out"=>"atual", "render_value"=>function(){ return "266";},],
                ["field_out"=>"turno", "render_value"=>function(){ return "-";},],
                ["field_out"=>"turma", "render_value"=>function(){ return "-";},],
                ["field_out"=>"jan", "from"=>"t_headcount_jan", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"fev", "from"=>"t_headcount_fev", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"mar", "from"=>"t_headcount_mar", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"abr", "from"=>"t_headcount_abr", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"mai", "from"=>"t_headcount_mai", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"jun", "from"=>"t_headcount_jun", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"jul", "from"=>"t_headcount_jul", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"ago", "from"=>"t_headcount_ago", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"set", "from"=>"t_headcount_set", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"out", "from"=>"t_headcount_out", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"nov", "from"=>"t_headcount_nov", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"dez", "from"=>"t_headcount_dez", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
            
                
            ];
                // dd("bnnnnnnnnnn");
            $column_fixeds_children=[ 
                ["field_out"=>"cod_ccusto", "render_value"=>function(){ return "";},],
                ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
                ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
                ["field_out"=>"atual", "render_value"=>function(){ return "266";},],
                ["field_out"=>"turno", "render_value"=>function(){ return "26";},],
                ["field_out"=>"turma", "from"=>"cdn_turma_trab", "render_value"=>null,],
                ["field_out"=>"jan", "from"=>"jan_orcado_headcount", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"fev", "from"=>"fev_orcado_headcount", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"mar", "from"=>"mar_orcado_headcount", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"abr", "from"=>"abr_orcado_headcount", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"mai", "from"=>"mai_orcado_headcount", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"jun", "from"=>"jun_orcado_headcount", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"jul", "from"=>"jul_orcado_headcount", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"ago", "from"=>"ago_orcado_headcount", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"set", "from"=>"set_orcado_headcount", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"out", "from"=>"out_orcado_headcount", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"nov", "from"=>"nov_orcado_headcount", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
                ["field_out"=>"dez", "from"=>"dez_orcado_headcount", "render_value"=>function($rowData, $value){
                    return number_format($value, 2, '.','');},
                ],
            ];


            $columns_base=array_merge($column_fixeds, $col_meses_parent); 
            $columns_children=array_merge($column_fixeds_children, $col_set_meses); 
            //  dd($columns_base);
            $settings=["columns"=>$columns_base,
                "keys"=>['cod_ccusto', 'cod_cargo_basic'],
                // "filter_data"=>['parent_id'=>function($value){
                //         return is_null($value);
                //     }    
                // ],            
                "children"=>["columns"=>$columns_children,
                        "keys"=>['cod_ccusto', 'cod_cargo_basic','cdn_turma_trab'],
                        // "filter_data"=>['parent_id'=>function($value){
                        //     return !is_null($value);
                        //     }],
                        'parent_filter'=> function($value, $parent_data){                            
                                return $value['cod_ccusto']== $parent_data['cod_ccusto'] && 
                                $value['cod_cargo_basic']== $parent_data['cod_cargo_basic']&&
                                $value['cdn_turma_trab']== $parent_data['cdn_turma_trab'];
                        }
                    ]
                ];
                
            $controller=new AtmTreeTable($settings, $data);

        return ['data'=>$controller->render()]; 
        }
    }