<?php
namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoHeadcountResumo as RepoHeadcountResumo;
use Illuminate\Http\Response;
use Rap2hpoutre\FastExcel\FastExcel;

class HeadcountResumoController extends OrcamentoController {

    public function __construct(){
        $this->setCodTela('RTHC');
        $this->repository=new RepoHeadcountResumo();
        parent::__construct();
    }

    public function resHorasExtras($orc_id, $lotacao_id, $tipo_table, $periodo){
        $tipo_table == 'O' ? $this->setCodTela('RTHC') : $this->setCodTela('FRT');
        $this->podeAcessar('listar',true,$this->getCodTela());
        return $this->getRepository()->resHorasExtras($orc_id, $lotacao_id, $tipo_table, $periodo);
    }
    public function resFerias($orc_id, $lotacao_id, $tipo_table, $periodo){
        $tipo_table == 'O' ? $this->setCodTela('RTHC') : $this->setCodTela('FRT');
        $this->podeAcessar('listar',true,$this->getCodTela());
        return $this->getRepository()->resFerias($orc_id, $lotacao_id, $tipo_table, $periodo);
    }
    public function resContratacoes($orc_id, $lotacao_id, $tipo_table, $periodo){
        $tipo_table == 'O' ? $this->setCodTela('RTHC') : $this->setCodTela('FRT');
        $this->podeAcessar('listar',true,$this->getCodTela());
        return $this->getRepository()->resContratacoes($orc_id, $lotacao_id, $tipo_table, $periodo);
    }
    public function resDemissoes($orc_id, $lotacao_id, $tipo_table, $periodo){
        $tipo_table == 'O' ? $this->setCodTela('RTHC') : $this->setCodTela('FRT');
        $this->podeAcessar('listar',true,$this->getCodTela());
        return $this->getRepository()->resDemissoes($orc_id, $lotacao_id, $tipo_table, $periodo);
    }

    public function resJovemAprendiz($orc_id,$lotacao_id){
        $this->setCodTela('RTHC');
        $this->podeAcessar('listar',true,$this->getCodTela());
        return $this->getRepository()->resJovemAprendiz($orc_id,$lotacao_id);
    }

    public function resPcd($orc_id, $lotacao_id, $periodo = null, $tipo_table){
        $tipo_table == 'O' ? $this->setCodTela('RTHC') : $this->setCodTela('FRT');
        $this->podeAcessar('listar',true,$this->getCodTela());
        return $this->getRepository()->resPcd($orc_id, $lotacao_id, $tipo_table, $periodo);
    }

    public function resumoAll($orc_id, $lotacao_id, $tipo_table, $periodo){
        $tipo_table == 'O' ? $this->setCodTela('RTHC') : $this->setCodTela('FRT');
        $this->podeAcessar('listar',true,$this->getCodTela());

        //return new Response(json_encode($this->getRepository()->resumoAll($orc_id,$lotacao_id)), 200);
        return $this->getRepository()->resumoAll($orc_id, $lotacao_id, $tipo_table, $periodo);
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        
        return parent::downloadExcel($type, $filename, ['id_princ','turno', 'atual','cod_cargo_basic', 'des_cargo_basic','orc_id', 'orc_turma_id', 'ccusto_id', 'cargo_id', 'lotacao_id','can_fill_hc', 'can_calc_hc', 'can_release_hc', 'can_reopen_hc', 'can_confer_hc']);
    }
    
    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("lotacao", "Lotação", $colunas[$i]);
            $colunas[$i] = str_replace("cod ccusto", "C. custo", $colunas[$i]);
            $colunas[$i] = str_replace("status", "Status", $colunas[$i]);
            $colunas[$i] = str_replace("cargo", "Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("turma", "Turma", $colunas[$i]);

            $colunas[$i] = str_replace("jan", "Janeiro", $colunas[$i]);
            $colunas[$i] = str_replace("fev", "Fevereiro", $colunas[$i]);
            $colunas[$i] = str_replace("mar", "Março", $colunas[$i]);
            $colunas[$i] = str_replace("abr", "Abril", $colunas[$i]);
            $colunas[$i] = str_replace("mai", "Maio", $colunas[$i]);
            $colunas[$i] = str_replace("jun", "Junho", $colunas[$i]);
            $colunas[$i] = str_replace("jul", "Julho", $colunas[$i]);
            $colunas[$i] = str_replace("ago", "Agosto", $colunas[$i]);
            $colunas[$i] = str_replace("set", "Setembro", $colunas[$i]);
            $colunas[$i] = str_replace("out", "Outubro", $colunas[$i]);
            $colunas[$i] = str_replace("nov", "Novembro", $colunas[$i]);
            $colunas[$i] = str_replace("dez", "Dezembro", $colunas[$i]);

            $colunas[$i] = str_replace("tot contratacoes", "Total contratações", $colunas[$i]);
            $colunas[$i] = str_replace("tot demissoes", "Total demissões", $colunas[$i]);
            $colunas[$i] = str_replace("tot promocoes", "Total promoções", $colunas[$i]);
            $colunas[$i] = str_replace("nro jovem aprendiz Cargo", "Nro. jovem aprendiz", $colunas[$i]);
            $colunas[$i] = str_replace("nro pcd Cargo", "Nro. PCD", $colunas[$i]);

            $colunas[$i] = str_replace("qtd func lot", "Qtde funcionários lotação", $colunas[$i]);
            $colunas[$i] = str_replace("vlr maximo", "Valor máximo", $colunas[$i]);

        }
        return $colunas;
    }

} 