<?php
namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoHistorico as RepoHistorico;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Http\Request as Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;


class HistoricoController extends OrcamentoController{
    public function __construct(){
		// $this->setCodTela('OHE');
	    $this->repository = new RepoHistorico();
        parent::__construct();
    }

    public function loadPremissas($orc_id, $periodo = null, $tipo_table = 'O'){
        $this->setCodTela('HISTPREM');
        $this->podeAcessar('listar', true, $this->getCodTela(), 'LISTAR');
        return $this->repository->loadPremissas($orc_id, $periodo, $tipo_table);
    }

    public function loadParametros($orc_id, $periodo = null, $tipo_table = 'O'){
        $this->setCodTela('HISTPARAM');
        $this->podeAcessar('listar', true, $this->getCodTela(), 'LISTAR');
        return $this->repository->loadParametros($orc_id, $periodo, $tipo_table);
    }

    public function loadParametroNaturezaEvento($orc_id, $periodo = null, $tipo_table = 'O'){
        $this->setCodTela('HISTPARAMNATEVT');
        $this->podeAcessar('listar', true, $this->getCodTela(), ['LISTAR']);
        return $this->treeTable($this->repository->loadParametroNaturezaEvento($orc_id, $periodo, $tipo_table));
    }

    public function treeTable($dados){
        $pais = [
            ["field_out" => "conta_contabil", "from" => "conta_contabil", "render_value" => null],
            ["field_out" => "evento", "from" => "evento", "render_value" => null],
            ["field_out" => "handle_arguments", "handle_arguments" => "parent", "render_value" => null],
            ["field_out" => "ordem_execucao", "from" => "ordem_execucao", "render_value" => null],
            ["field_out" => "base_recisao", "from" => "base_recisao", "render_value" => null],
            ["field_out" => "evento_principal_id", "from" => "evento_principal_id", "render_value" => null],
            ["field_out" => "cta_contabil_id", "from" => "cta_contabil_id", "render_value" => null]
        ];
        $filhos = [
            ["field_out" => "evento_adicional_id", "from" => "evento_adicional_id", "render_value" => null],
            ["field_out" => "evento_adicional", "from" => "evento_adicional", "render_value" => null],
            ["field_out" => "evento_principal_id", "from" => "evento_principal_id", "render_value" => null],
            ["field_out" => "cta_contabil_id", "from" => "cta_contabil_id", "render_value" => null]
        ];

        $settings = [
            "columns" => $pais,
            "keys" => ['evento_principal_id', 'cta_contabil_id'],
            // "filter_data" => [],
            "children" => [
                "columns" => $filhos,
                "keys" => ['evento_principal_id', 'cta_contabil_id', 'evento_adicional_id'],
                "filter_data" => [
                    'evento_principal_id'=>function($value){
                        return !is_null($value);
                    },
                    'cta_contabil_id'=>function($value){
                        return !is_null($value);
                    },
                    'evento_adicional_id'=>function($value){
                        return !is_null($value);
                    }
                ],
                'parent_filter' => function ($value, $parent_data) {
                    $condicao2 = ($value['evento_principal_id'] == $parent_data['evento_principal_id']);
                    $condicao3 = ($value['cta_contabil_id'] == $parent_data['cta_contabil_id']);
                    return $condicao2 && $condicao3;
                },
            ]
        ];
        $controller = new AtmTreeTable($settings, $dados);
        return $controller->render();
    }
}