<?php
namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoImportacao;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;



class ImportacaoController extends Natureza51Ctrl
{
    protected $lotacoes = null;
    
    public function __construct(){
        $this->repository=new RepoImportacao();
        parent::__construct();
    } 

    public function inserted(Request $request, $orc_id, $lotacao_id, $tbl_name, $periodo, $tipo_table){
        
        $form_data = $request->all();
        
        $chave = array_key_first($form_data);
        $decrypted = json_decode(safeDecrypt(request()->bearerToken()),true);
        
        if(array_key_exists($chave,$form_data)){
            $retorno = $this->getRepository()->inserted($form_data, $orc_id, $lotacao_id, $tbl_name, $tipo_table, $periodo, $decrypted['token']['empresa_id']);
            if(!$retorno){
                $return = array('status'=>'warning','msg'=>$this->getRepository()->getErrosFlatted());
                return $this->retornoJsonDefault($return,400);    
            }
            return array('status'=>'success','msg'=>'Registros importados com sucesso!');
        }
        return array('status'=>'error','msg'=>'Não foi possível encontrar a chave '.$chave);
    }

    public function teste(){
        $sql = $this->doQuery(409,'l.id');
    if(is_null($this->lotacoes)){
        $lot = DB::select($sql);
        $this->lotacoes = $lot;
    }else{
        // dd('sakasidhsa');
   
        $sql = $this->doQuery($this->lotacoes[0]->seq);
        $childrens =  DB::select($sql);

        foreach ($childrens as $key => $value) {
           
             array_push($this->lotacoes, $value);
            //  dd('dsaddsadsa',$this->lotacoes);

             $sql = $this->doQuery($value->seq);
             $netos = DB::select($sql);
            //  dd($netos);
            $this->getChildrens($netos);
            
            
        }


        goto saida;
    }

    $this->teste();

    saida:
    return $this->lotacoes;
    // return $aa;
    }


    public function getChildrens($netos){ 
        // dd('$caiu');
        for ($i=0; $i < count($netos); $i++) { 
            array_push($this->lotacoes,$netos[$i]);
            
            // dd("sdasdas",$netos);

            $sql = $this->doQuery($netos[$i]->seq);
            $z =  DB::select($sql);
            
            if(!empty($z)){
                array_push($this->lotacoes,$z[0]);
            }
           

        }
    }

    public function doQuery($value,$form_field='epl.seq_pai'){


        $sql = "SELECT 
        plu.id,
        plu.seq_ud,
        plu.limite,
        plu.lotacao_id,
        l.unid_lotac,
        l.des_unid_lotac,
        plt.id,
        epl.seq,
        epl.seq_pai,
        plt.cod_tipo,
        plt.des_tipo
   
        FROM
            (
            SELECT MAX(id) id FROM tbl_plano_lotac WHERE ativo=1 ) pl
            --JOIN TABELA PLANO LOTACAO X PLANO LOTACAO TIPO
            INNER JOIN
            tbl_plano_lotac_tipo plt ON pl.id=plt.plano_lotac_id
            
            --JOIN TABELA PLANO LOTAÇÃO TIPO X PLANO LOTAÇÃO UNID
            INNER JOIN 
                tbl_plano_lotac_unid plu
            ON plt.id=plu.plano_lotac_tipo_id 
            
            --JOIN TABELA LOTACAO X PLANO LOTACAO UNID
            INNER JOIN
                tbl_lotacao l ON l.id=plu.lotacao_id
            
            --JOIN TABELA LOTACAO X ESTRUTURA_PLANO_LOTAC AND  ESTRUTURA_PLANO_LOTAC X PLANO_LOTAC.
            INNER JOIN 
            tbl_estrutura_plano_lotac epl ON l.id =epl.lotacao_id and epl.plano_lotacao_id = pl.id
        where $form_field=$value";

        return $sql;


    }
    
    
} 