<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoIntegracao as RepoIntegracao;
use Illuminate\Http\Request;

class IntegracaoController extends Natureza51Ctrl
{
    public function __construct(){
        $this->repository = new RepoIntegracao();
        $this->setCodTela('INTEGR');
        parent::__construct();
    }

    public function listarIntegracao($layout = null, $periodo = 60){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $resp = $this->getRepository()->listarIntegracao($layout, $periodo);

        return $resp;
    }
    public function listarLayout(){
        return $this->getRepository()->listarLayouts();
    }

    public function reenviar($id_fila){
        $this->podeAcessar('reenviar_integracao',true,$this->getCodTela());
        $resp = $this->getRepository()->reenviar($id_fila);
        $retorno = [];
        
        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
        }
        else{
            $retorno['status'] = 'success';
            $retorno['submsg'] = 'Sucesso';
            $retorno['msg'] = 'Atualização concluída com sucesso!';
        }

        return $this->retornoJsonDefault($retorno);
    }
    public function inutilizar($id_fila){
        $this->podeAcessar('inutilizar_integracao',true,$this->getCodTela());
        $resp = $this->getRepository()->inutilizar($id_fila);
        $retorno = [];
        
        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
        }
        else{
            $retorno['status'] = 'success';
            $retorno['submsg'] = 'Sucesso';
            $retorno['msg'] = 'Atualização concluída com sucesso!';
        }

        return $this->retornoJsonDefault($retorno);
    }
    public function integrar($id_layout){
        $this->podeAcessar('integrar',true,$this->getCodTela());
        set_time_limit(700);
        
        $decrypted = json_decode(safeDecrypt(request()->bearerToken()), true);
        $resp = $this->getRepository()->integrar($id_layout, $decrypted['token']['email'], $decrypted['token']['func_data']['nome_funcionario']);
        $retorno = [];
        
        if($resp === false){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
        }
        else{
            if($resp === 'uo'){
                $retorno['status'] = 'success';
                $retorno['submsg'] = 'Sucesso';
                $retorno['msg'] = 'A Integração foi iniciada!';
            }
            else{
                $retorno['status'] = 'success';
                $retorno['submsg'] = 'Sucesso';
                $retorno['msg'] = 'Atualização concluída com sucesso!';
            }
        }

        return $this->retornoJsonDefault($retorno);
    }
    public function listarSequencia(){
        $resp = $this->getRepository()->listarSequencia();
        return $resp;
    }
    public function updateSequencia(Request $request){
        $this->podeAcessar('sequencia',true,$this->getCodTela());
        $dados = $request->all();
        $resp = $this->getRepository()->updateSequencia($dados);
        $retorno = [];
        
        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
        }
        else{
            $retorno['status'] = 'success';
            $retorno['submsg'] = 'Sucesso';
            $retorno['msg'] = 'Atualização concluída com sucesso!';
        }

        return $this->retornoJsonDefault($retorno);
    }
    public function executaIntegracoes(){
        $decrypted = json_decode(safeDecrypt(request()->bearerToken()), true);
        // $arquivo = fopen("teste_aaaaa.txt", "a+");
        // fwrite($arquivo, "data: ".date("d-m-Y H:i:s"));
        // fclose($arquivo);
        $this->getRepository()->executaIntegracoes($decrypted['token']['email'], $decrypted['token']['func_data']['nome_funcionario']);

        $retorno['msg'] = "A Integração foi iniciada!";// Você receberá um e-mail quando o processo for finalizado.
        $retorno['status'] = "success";
        $retorno['submsg'] = "Sucesso";

        return $retorno;
    }
}