<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoLotacaoCCusto as RepoLotacaoCCusto;
use App\Modules\Natureza51\Repositories\RepoOrcLotacao;
use App\Modules\Natureza51\Entities\LotacaoCCusto;
use DB;

class LotacaoCCustoController extends Natureza51Ctrl
{
     public function __construct(){
        $this->repository=new RepoLotacaoCCusto();
        parent::__construct();
    }

    public function listar(){
        $retorno = $this->getRepository()->listar();
        return $retorno;
    }

    public function loadLotacoesForaOrcamento($orc_id, $tipo_table = 'O', $periodo = null){

        $repo_orc_lotacao = new RepoOrcLotacao();
        $tbl_orc_lotacao = $repo_orc_lotacao->getModelEntity()->getTable();
        $tbl_lotacao_ccusto = $this->getRepository()->getModelEntity()->getTable();

        $dados = $this->getRepository()->getModelEntity()->with(['getLotacao', 'getCentroCusto'])
        ->whereNotExists(function($query)use($tbl_orc_lotacao, $tbl_lotacao_ccusto, $orc_id, $tipo_table, $periodo)
            {
                $where_periodo = $tipo_table == 'F' ? " $tbl_orc_lotacao.periodo = '$periodo' " : " $tbl_orc_lotacao.periodo IS NULL ";
                $query->select(DB::raw(1))
                      ->from($tbl_orc_lotacao)
                      ->whereRaw("$tbl_orc_lotacao.lotacao_id = $tbl_lotacao_ccusto.lotacao_id and 
                                  $tbl_orc_lotacao.cc_custo_id = $tbl_lotacao_ccusto.ccusto_id and 
                                  $tbl_orc_lotacao.orcamento_id = $orc_id and
                                  $tbl_orc_lotacao.tipo_table = '$tipo_table' and
                                  $where_periodo
                                ");
            })
        ->get()->toArray();

        for ($i=0; $i < count($dados); $i++) { 
            $dados[$i]['desc_lotacao_ccusto'] = $dados[$i]['get_centro_custo']['cod_ccusto'] . ' - '. $dados[$i]['get_lotacao']['unid_lotac'] . ' - '. $dados[$i]['get_lotacao']['des_unid_lotac'];
            unset($dados[$i]['get_centro_custo']);
            unset($dados[$i]['get_lotacao']);
        }

        return $dados;

    }

    
}
