<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoMenu as RepoMenu;
use Illuminate\Http\Request;

class MenuController extends Natureza51Ctrl
{
    public function __construct(){
        $this->setCodTela('MENU');
        $this->repository=new RepoMenu();
        parent::__construct();
    }
    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
     return   $this->getRepository()->listar();
    }
    public function insert(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $retorno = $this->getArrayRetornoDefault();
        $obj = $this->getRepository()->insert($request);
        
        if(!$obj){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            goto saida;
        }
        
        $retorno['status'] = 'success';
        $retorno['msg'] = 'Registro inserido com sucesso!';
        $retorno['submsg'] = 'Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function updateMenu(Request $request){
        $dados = $request->all();
        
        $resp = $this->getRepository()->updateMenu($dados);

        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            return $this->retornoJsonDefault($retorno);
        }
        
        $retorno['status'] = 'success';
        $retorno['msg'] = 'Registro inserido com sucesso!';
        $retorno['submsg'] = 'Sucesso';

        return $this->retornoJsonDefault($retorno);
    }
   
    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Empresas', ['id','empresa_id','status','created_at','user_id','updated_at','created_by','updated_by']);
    }
}