<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoMenuItem as RepoMenuItem;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class MenuItemController extends Natureza51Ctrl
{
    public function __construct(){
        $this->setCodTela('MENU');
        $this->repository=new RepoMenuItem();
        parent::__construct();
    }
    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        return   $this->getRepository()->listar();
    }
    
    public function listaItem(){     
        $this->podeAcessar('listar',true,$this->getCodTela());   
        return   $this->getRepository()->listaItem();
    }

    public function insert(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $retorno=$this->getArrayRetornoDefault();
        
        $obj=$this->getRepository()->insert($request);
        
        if(!$obj){
            $retorno['status']='error';
            $retorno['submsg']='Erro';
            $retorno['msg']='Falha ao inserir registro!';
            goto saida;
        }
        $retorno['status']='success';
        $retorno['msg']='Registro inserido com sucesso!';
        $retorno['submsg']='Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function apiMenu($menu_item){
       $result= $this->getRepository()->getModelEntity()->with('getMenu')->find($menu_item);
       $item=$result->orderBy('sequencia', 'asc')->get()->toArray();
       $retorno=$result->getMenu()->first()->toArray();
       $retorno['itens']=$item;
       return  new Response(json_encode($retorno), 200);
    }
}