<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoModeloRelatorio as RepoModeloRelatorio;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoModeloRelatorioOrcamento;
use App\Modules\Natureza51\Repositories\RepoModeloRelatorioComparacao;
use App\Modules\Natureza51\Repositories\RepoOrcResultadosCalc;
use App\Modules\Natureza51\Repositories\RepoOrcLotacao;
use App\Modules\Natureza51\Repositories\RepoLotacao;
use Illuminate\Http\Response;
use Illuminate\Http\Request;
use DB;
use Rap2hpoutre\FastExcel\FastExcel;


class ModeloRelatorioController extends Natureza51Ctrl
{
    
    protected $array_tipos = ['Orçado'=> 1,'Realizado'=> 2, 'Forecast'=> 3];

    public function __construct(){
        $this->repository=new RepoModeloRelatorio();
        parent::__construct();
        $this->setCodTela('MOD_REL');
    }
    
    public function loadOrcamentos(){
        $data_user = $this->getUserFromCurrentGuard();

        $this->podeAcessar('inserir',true,$this->getCodTela());
        $repo_orcamento = new RepoOrcamento();
        
        DB::enableQueryLog();
        $orcamentos = $repo_orcamento->getModelEntity()
        ->where([
             ['status_orc', '!=', $repo_orcamento->getStatusExcluido()]
         ]);

         if ($data_user->tipo != 3) {
            $orcamentos->where([                
                ['mostrar_orcamento', '=', 0]
            ]);
        }       
        
        $orcs = $orcamentos->orderBy('id','DESC')->get()->toArray();

        return new Response(json_encode($orcs));
    }

    public function insert(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $repo_modelo_relatorio_orcamento = new RepoModeloRelatorioOrcamento();
        $repo_modelo_relatorio_comparacao = new RepoModeloRelatorioComparacao();
        
        $retorno = $this->getArrayRetornoDefault();
        $form_data = $request->all();

        DB::beginTransaction();

        $modelo_relatorio = $this->getRepositoryOrModel()->create($form_data);

        if(!$modelo_relatorio){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro: 210920201813';
            DB::rollBack();
            goto saida;
        }
        
        foreach ($form_data['orcamentos'] as $orcamento) {
            $form_data_orcamento = [
                'orcamento_id'=>$orcamento['id'],
                'modelo_relatorio_id'=>$modelo_relatorio->id,
                'tipo'=>$this->array_tipos[$orcamento['tipo']],
                'periodo'=>$orcamento['periodo'],
            ];
            if(!$repo_modelo_relatorio_orcamento->create($form_data_orcamento)){
                $retorno['msg']=$repo_modelo_relatorio_orcamento->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro: 210920201823';
                DB::rollBack();
                goto saida;
            }
        }

        foreach ($form_data['comparacoes'] as $comparacao) {

            $modelo_relatorio_orcamento_origem = $repo_modelo_relatorio_orcamento->getModelEntity()->where('modelo_relatorio_id', $modelo_relatorio->id)->where('orcamento_id', $comparacao['orc_origem_id'])->where('tipo', $this->array_tipos[$comparacao['tipo_orc_origem']])->first();
            $modelo_relatorio_orcamento_destino = $repo_modelo_relatorio_orcamento->getModelEntity()->where('modelo_relatorio_id', $modelo_relatorio->id)->where('orcamento_id', $comparacao['orc_destino_id'])->where('tipo', $this->array_tipos[$comparacao['tipo_orc_destino']])->first();

            $form_data_comparacao = [
                'modelo_relatorio_id'=>$modelo_relatorio->id,
                'modelo_relatorio_orcamento_origem_id'=>$modelo_relatorio_orcamento_origem->id,
                'modelo_relatorio_orcamento_destino_id'=>$modelo_relatorio_orcamento_destino->id,
                'campo_comparar_origem'=>$comparacao['campo_origem'],
                'campo_comparar_destino'=>$comparacao['campo_destino']
            ];
            if(!$repo_modelo_relatorio_comparacao->create($form_data_comparacao)){
                $retorno['msg']=$repo_modelo_relatorio_comparacao->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro: 210920201825';
                DB::rollBack();
                goto saida;
            }
        }

        DB::commit();
        $retorno['msg']='Registro inserido com sucesso!';
        $retorno['submsg']='Sucesso';
        $retorno['status']='success';
        
        saida:
         return $this->retornoJsonDefault($retorno); 
    }
    
    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $retorno = $this->getArrayRetornoDefault();
        $modelos = $this->getRepositoryOrModel()->listar();

        if($modelos === false){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao listar os modelos. Erro: 220920200755';
            goto saida;
        }

        $retorno = $modelos;
        saida:
        return new Response(json_encode($retorno), 200);
    }    

    public function loadData($id){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $retorno = $this->getArrayRetornoDefault();
        $modelos = $this->getRepositoryOrModel()->listar($id);

        if($modelos === false){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao encontrar os dados. Erro: 161120201643';
            goto saida;
        }

        if(count($modelos) <= 0){
            $retorno['msg']='Registro não encontrado';
            $retorno['submsg']='Falha ao encontrar os dados. Erro: 161120201648';
            goto saida;            
        }


        $retorno = $modelos[0];
        saida:
        return new Response(json_encode($retorno), 200);        
    }

    public function delete(Request $request){
        $this->podeAcessar('deletar',true,$this->getCodTela());

        $repo_modelo_relatorio_orcamento = new RepoModeloRelatorioOrcamento();
        $repo_modelo_relatorio_comparacao = new RepoModeloRelatorioComparacao();

        $retorno=$this->getArrayRetornoDefault();
        $form_data=$request->all(); 


        if(!isset($form_data['id'])){
            $retorno['msg']='Registro não encontrado';
            $retorno['submsg']='Falha ao deletar o registro. Erro: 190920191839';
            goto saida;
        }
        
        DB::beginTransaction();

        if(!$repo_modelo_relatorio_comparacao->deleteFromModeloRelatorio($form_data['id'])){
            $retorno['msg']= $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Atualize a página e tente novamente. Erro: 260820191038.';
            DB::rollBack();
            goto saida;
        }               

        if(!$repo_modelo_relatorio_orcamento->deleteFromModeloRelatorio($form_data['id'])){
            $retorno['msg']= $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Atualize a página e tente novamente. Erro: 260820191038.';
            DB::rollBack();
            goto saida;
        }

        if(!$this->getRepositoryOrModel()->delete($form_data['id'])){
            $retorno['msg']= $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Atualize a página e tente novamente. Erro: 260820191038.';
            DB::rollBack();
            goto saida;
        }
        
        DB::commit();
        $retorno["status"]="success";
        $retorno["msg"]="Registro excluído com sucesso!";
        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function gerarRelatorio(Request $request, $modelo_id){
        set_time_limit(700);
        $this->podeAcessar('gerar_relatorio',true,$this->getCodTela());

        $data_request = $request->all();

        $retorno = $this->getArrayRetornoDefault();
        $escala = count($data_request['escalas_selecionadas']) > 0 ? $data_request['escalas_selecionadas'][0]['value'] : 1;
        $result = $this->getRepositoryOrModel()->gerarRelatorio($modelo_id, false, 0, 10, $data_request['lotacoes_selecionadas'], $data_request['naturezas_selecionadas'], $escala);
        
        if($result === false){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao listar os modelos. Erro: 220920201539';
            goto saida;
        }


        $info = $this->getRepositoryOrModel()->getModeloInfo($modelo_id);

        if($info === false){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao listar os modelos. Erro: 240920200721';
            goto saida;
        }

        $quantidade_registros = $this->getRepositoryOrModel()->getTotalRegistros($modelo_id, $data_request['lotacoes_selecionadas'], $data_request['naturezas_selecionadas']);
        
        if($quantidade_registros === false){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao listar os modelos. Erro: 240920201023';
            goto saida;
        }


        $retorno['total_registros'] = $quantidade_registros;
        $retorno['dados'] = $result;
        $retorno['info'] = $info;
        $retorno['status'] = 'success';
        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function loadRelatorioData(Request $request, $modelo_id, $offset, $rows){
        $this->podeAcessar('gerar_relatorio',true,$this->getCodTela());
        $data_request = $request->all();
        
        $retorno = $this->getArrayRetornoDefault();
        $escala = count($data_request['escalas_selecionadas']) > 0 ? $data_request['escalas_selecionadas'][0]['value'] : 1;
        $result = $this->getRepositoryOrModel()->gerarRelatorio($modelo_id,false, $offset, $rows, $data_request['lotacoes_selecionadas'], $data_request['naturezas_selecionadas'], $escala);

        if($result === false){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao listar os modelos. Erro: 220920201539';
            goto saida;
        }
        
        $retorno = $result;
        saida:
        return new Response(json_encode($retorno), 200);
    }
    public function exportRelatorio($modelo_id, $type){
        // dd('jknaskjdfnsajkdkajsd');
        $retorno = $this->getArrayRetornoDefault();
        $dados = $this->getRepositoryOrModel()->gerarRelatorioFormat($modelo_id);
        // dd($dados);

        // array_unshift($dados, ["Gerado em: "=> date('d-m-Y')]);
        // dd($dados);
        $list = collect($dados);
        // dd('chegou no exportar', $list);

            //  C:/Users/insti/Documents/Projetos/Desenvolvimento/MRN/natureza51/Documentos/Relatórios/
        $var = (new FastExcel($list))->export('Relatorio.csv');
        $filename = 'Relatorio'.date('d-m-Y');
       
        
        // abre o arquivo colocando o ponteiro de escrita no final 
        $arquivo = file_get_contents('Relatorio.csv'); 
        $arquivo = mb_convert_encoding("sep=,\n Gerado em: ".date('d/m/Y H:i').",\n".$arquivo, 'utf-16');

        // $arquivo = mb_convert_encoding("sep=,\n".$arquivo, mb_detect_encoding($arquivo));
        // dd($arquivo);



        file_put_contents('Relatorio.csv', $arquivo);

        
        // $href = "https://api2.mrn.com.br:8180/backend_natureza51/public/Relatorio.csv";
        // $href = "https://apps2.mrn.com.br:8180/backend_natureza51/homologacao/public/Relatorio.csv";

        $href_base = array_key_exists('BACKEND_URL',$env) ? $env['BACKEND_URL'] : env("BACKEND_URL", "http://191.23.83.141:9280/natureza51_atualizacao/public/")
        $href = $href_base . "Relatorio.csv";


        return '
            <body onafterprint="funcao()">
                <a hidden id="tag_a" href="'.$href.'" download="Relatorio.csv">Baixar arquivo</a>
            </body>
            <script type="text/javascript">
                window.onload = function baixar(){
                    let tag = document.getElementById(\'tag_a\');
                    tag.click();
                    setTimeout(()=>{
                        window.close();
                    }, 3000)
                };
            </script>
        ';
        

        return '<a href="C:/Users/insti/Documents/Projetos/Desenvolvimento/MRN/natureza51/Documentos/Relatórios/Relatorio.csv" download="'.$filename.'.csv">Baixar arquivo</a>';
        // return '<a href="https://apps2.mrn.com.br:8180/backend_natureza51/producao/public/ResultadosCalc.csv" download="'.$filename.'.csv">Baixar arquivo</a>';
        
        return '
            <a id="baixar_planilha" href="http://127.0.0.1/mrn-natureza-51/mrn-natureza-51/public/'.$filename.'.csv" style="background-color: #009688>Baixar arquivo</a>
            <script type="text/javascript">
                let tag_a = document.getElementById(\'baixar_planilha\');
                tag_a.click();
            </script>
        ';
    }

    public function loadFiltroData($modelo_id){
        $this->podeAcessar('gerar_relatorio',true,$this->getCodTela());
        $repo_orc_resultados_calc = new RepoOrcResultadosCalc();
        $repo_orc_lotacao = new RepoOrcLotacao();
        $repo_lotacao = new RepoLotacao();
        $retorno = $this->getArrayRetornoDefault();

        $modelo = $this->getRepository()->getModelEntity()->find($modelo_id);

        if ($modelo->tipo == 2) {
            $naturezas = [];
        }else{
            $naturezas = $repo_orc_resultados_calc->getModelEntity()->select(DB::raw("natureza_hash_id as header"))->distinct()->get()->toArray();
            
            if($naturezas === false){
                $retorno['msg']=$repo_orc_resultados_calc->getErrosFlatted();
                $retorno['submsg']='Falha ao listar as naturezas. Erro: 250920201156';
                goto saida;
            }
        }

        $orcamentos_id = $this->getRepository()->getOrcamentosIdsFromModelo($modelo_id);

        if($orcamentos_id === false){
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao listar lotações. Erro: 250920201456';
            goto saida;
        }
        $lotacoes = [];
        $plans_lotac_diffs = [];
        foreach ($orcamentos_id as $orc_id) {
            $cod_plano_lotac = $this->getParamByOrc($orc_id, $this->getCodPlanLotac());
            if(!in_array($cod_plano_lotac, $plans_lotac_diffs)){
                array_push($plans_lotac_diffs, $cod_plano_lotac);
                $tbl_orc_lotacao_controller = new OrcLotacaoController();
                $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id);
                $dados = json_decode(json_encode($dados),true);
                foreach ($dados as $lotacao) {
                    $lot_inserir = [
                        'header' => $lotacao['description'],
                        'id' => $lotacao['id']
                    ];
                    array_push($lotacoes, $lot_inserir);
                }
            }
        }
        
        if($lotacoes === false){
            $retorno['msg']=$repo_orc_lotacao->getErrosFlatted();
            $retorno['submsg']='Falha ao listar as lotações. Erro: 250920201338';
            goto saida;
        }

        $retorno = [];
        $retorno['naturezas'] = $naturezas;
        $retorno['lotacoes'] = $lotacoes;
        saida:
        return new Response(json_encode($retorno), 200);
    }
    
    public function loadChartData( Request $request, $modelo_id){        
        $this->podeAcessar('gerar_relatorio',true,$this->getCodTela());
        $retorno = $this->getArrayRetornoDefault();
        $data_request = $request->all();

        $escala = count($data_request['escalas_selecionadas']) > 0 ? $data_request['escalas_selecionadas'][0]['value'] : 1;
        $dados = $this->getRepository()->getDataChart($modelo_id, $data_request['lotacoes_selecionadas'], $data_request['naturezas_selecionadas'], $escala);
        
        if($dados === false){
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao listar os dados do gráfico. Erro: 280920201500';
            goto saida;
        }
        $labels = $this->getRepository()->getModeloColumns($modelo_id);
        
        if($labels === false){
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao listar os dados do modelo. Erro: 280920201624';
            goto saida;
        }
        // foreach($dados as $dado){
        //     foreach($dado['data'] as $item){
        //         $item = floatVal($item);
        //     }
        // }
        $retorno = [];
        $retorno['dados'] = $dados;
        $retorno['labels'] = $labels;
        saida:
        return new Response(json_encode($retorno), 200);
    }

    public function update(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $repo_modelo_relatorio_orcamento = new RepoModeloRelatorioOrcamento();
        $repo_modelo_relatorio_comparacao = new RepoModeloRelatorioComparacao();
        
        $retorno = $this->getArrayRetornoDefault();
        $form_data = $request->all();

        DB::beginTransaction();

        $modelo_relatorio = $this->getRepositoryOrModel()->update($form_data, $form_data['id']);

        if(!$modelo_relatorio){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao atualizar o registro. Erro: 171120201036';
            DB::rollBack();
            goto saida;
        }

        $repo_modelo_relatorio_comparacao->getModelEntity()->where('modelo_relatorio_id', $form_data['id'])->delete();
        $repo_modelo_relatorio_orcamento->getModelEntity()->where('modelo_relatorio_id', $form_data['id'])->delete();

        foreach ($form_data['orcamentos'] as $orcamento) {
            $is_old = array_key_exists('orcamento_id', $orcamento);
            $form_data_orcamento = [
                'orcamento_id'=>$is_old ? $orcamento['orcamento_id'] : $orcamento['id'],
                'modelo_relatorio_id'=>$form_data['id'],
                'tipo'=>$orcamento['tipo'],
                'periodo'=>$orcamento['periodo'],
            ];
            if(!$repo_modelo_relatorio_orcamento->create($form_data_orcamento)){
                $retorno['msg']=$repo_modelo_relatorio_orcamento->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro: 171120201059';
                DB::rollBack();
                goto saida;
            }
        }

        foreach ($form_data['comparacoes'] as $comparacao) {

            $modelo_relatorio_orcamento_origem = $repo_modelo_relatorio_orcamento->getModelEntity()->where('modelo_relatorio_id', $form_data['id'])->where('orcamento_id', $comparacao['orc_origem_id'])->where('tipo', $comparacao['tipo_orc_origem'])->first();
            $modelo_relatorio_orcamento_destino = $repo_modelo_relatorio_orcamento->getModelEntity()->where('modelo_relatorio_id', $form_data['id'])->where('orcamento_id', $comparacao['orc_destino_id'])->where('tipo', $comparacao['tipo_orc_destino'])->first();

            if(!$modelo_relatorio_orcamento_origem){
                $retorno['msg']="Não foi encontrardo '". $comparacao['descricao_orcamento_origem']. "' entre os orçamentos selecionados." ;
                $retorno['submsg']='Falha ao atualizar o registro. Erro: 181120201342';
                DB::rollBack();
                goto saida;
            }

            if(!$modelo_relatorio_orcamento_destino){
                $retorno['msg']="Não foi encontrardo '". $comparacao['descricao_orcamento_destino']. "' entre os orçamentos selecionados." ;
                $retorno['submsg']='Falha ao atualizar o registro. Erro: 181120201342';
                DB::rollBack();
                goto saida;
            }

            $form_data_comparacao = [
                'modelo_relatorio_id'=>$form_data['id'],
                'modelo_relatorio_orcamento_origem_id'=>$modelo_relatorio_orcamento_origem->id,
                'modelo_relatorio_orcamento_destino_id'=>$modelo_relatorio_orcamento_destino->id,
                'campo_comparar_origem'=>$comparacao['campo_comparar_origem'],
                'campo_comparar_destino'=>$comparacao['campo_comparar_destino']
            ];
            if(!$repo_modelo_relatorio_comparacao->create($form_data_comparacao)){
                $retorno['msg']=$repo_modelo_relatorio_comparacao->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro: 181120201341';
                DB::rollBack();
                goto saida;
            }
        }

        DB::commit();
        $retorno['msg']='Registro inserido com sucesso!';
        $retorno['submsg']='Sucesso';
        $retorno['status']='success';
        
        saida:
         return $this->retornoJsonDefault($retorno); 
    }
}