<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoModuloPermissoes as RepoModuloPermissoes;
use Illuminate\Http\Request;
use Excel;

class ModuloPermissoesController extends Natureza51Ctrl
{
    public function __construct(){
        $this->setCodTela('MP');
        $this->repository=new RepoModuloPermissoes();
        parent::__construct();
    }
    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        return $this->getRepository()->listarAll();
    }
    public function inserirValidado(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $data = $request->all();
        $retorno = $this->getArrayRetornoDefault();
        $result = $this->getRepository()->inserir($data);

        if(!$result){
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            goto saida;
        }

        $retorno['msg'] = 'Registro inserido com sucesso!';
        $retorno['status'] = 'success';
        $retorno['submsg'] = 'Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno);

    }
    public function update(Request $request){
        $this->podeAcessar('editar',true,$this->getCodTela());
        $data = $request->all();

        if(!$this->getRepository()->updateModuloP($data)){
            $retorno['submsg'] = 'Erro';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['status'] = 'error';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }
    

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Permissoes-modulos', ['descricao_modulo', 'descricao_modulo', 'description_tags', 'modulo', 'status', 'tag', 'tag_id', 'modulo_id']);
    }


    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("descricao", "acao", $colunas[$i]);
            $colunas[$i] = str_replace("description modulo", "modulo", $colunas[$i]);
        }
        return $colunas;
    }
}