<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoModulos as RepoModulos;
use Illuminate\Http\Request;

class ModulosController extends Natureza51Ctrl
{
    public function __construct(){
        $this->setCodTela('MOD');
        $this->repository=new RepoModulos();
        parent::__construct();
    }
    public function update(Request $request){
        $this->podeAcessar('editar',true,$this->getCodTela());
        $dados = $request->all();
        $retorno = $this->getArrayRetornoDefault();

        $result = $this->getRepository()->updateModulo($dados,$dados['id'],"id");
        if(!$result){
            $retorno['status']='error';
            $retorno['submsg']=$this->getRepository()->getErrosFlatted();;
            $retorno['msg']='Falha ao atualizar registro!';
            goto saida;
        }
        $retorno['status']='success';
        $retorno['msg']='Registro atualizado com sucesso!';
        $retorno['submsg']='Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno);
        
    }
    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        return $this->getRepository()->listarAll();
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Modulos', ['status','created_at','user_id','updated_at','created_by','updated_by','empresa_id','description','id']);
    }


    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("Status", "status", $colunas[$i]);
        }
        return $colunas;
    }
}