<?php

namespace App\Modules\Natureza51\Http\Controllers;
use Excel;

use App\Modules\Natureza51\Repositories\RepoModulosEmpresa as RepoModulosEmpresa;
use Illuminate\Http\Request;

class ModulosEmpresaController extends Natureza51Ctrl
{
    public function __construct(){
        $this->repository=new RepoModulosEmpresa();
        $this->setCodTela('ME');
        parent::__construct();
    }
    public function insertModulo(Request $request){

        $this->podeAcessar('inserir',true,$this->getCodTela());
        
        $data = $request->all();

        for($i = 0; $i < count($data['empresa_id']); $i++){
            $select = $this->getRepository()->getModelEntity()->select()
        ->where([
            [$this->getRepository()->getModelEntity()->getColunaAlias('empresa_id'),'=',$data['empresa_id'][$i]],
            [$this->getRepository()->getModelEntity()->getColunaAlias('modulo_id'),'=',$data['modulo_id']]
            ])->get()->toArray();

            if(count($select) > 0){
                $retorno['submsg'] = 'Erro';
                $retorno['msg'] = ($i+1).'ª opção selecionada já foi cadastrada.<br> Erro:170420200825';
                $retorno['status'] = 'error';
                goto saida;
            }
        }

        for($i = 0; $i < count($data['empresa_id']); $i++){
            $dados = array(
                'id'=>'', 
                'modulo_id'=>$data['modulo_id'],
                'empresa_id'=>$data['empresa_id'][$i],
                'created_at'=>$data['created_at'],
                'user_id'=>$data['user_id']
            );
            if(!$this->getRepository()->insertModuloEmpresa($dados)){
                $retorno['submsg'] = 'Erro';
                $retorno['msg'] = $this->getRepository()->getErrosFlatted();
                $retorno['status'] = 'error';
                goto saida;
            }
        }

        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function listarAll(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        return $this->getRepository()->listarAll();
    }
    public function updateDados(Request $request){

        $this->podeAcessar('editar',true,$this->getCodTela());

        $data = $request->all();

        if(!$this->getRepository()->updateDados($data)){
            $retorno['submsg'] = 'Erro';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['status'] = 'error';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function downloadExcelAux($type)
    {
        $this->podeAcessar('exportar',true,$this->getCodTela());
        $filename="ModuloEmpresa";
        $array = json_decode($_POST['array_imprimir']);    

        for ($i=0; $i < count($array) ; $i++) { 
            
            //geral
            unset($array[$i]->grupo_empresarial_id);
            unset($array[$i]->usuario_dominio);
            unset($array[$i]->numero_dias_senha);
            unset($array[$i]->api_token);
            
            //comum a todos os cadastros
            unset($array[$i]->id);
            unset($array[$i]->empresa_id);
            unset($array[$i]->user_id);
            unset($array[$i]->id_grupo);
            unset($array[$i]->id_filial);
            unset($array[$i]->id_grupo_acesso);
            unset($array[$i]->id_permissao);
            unset($array[$i]->id_grupo_empresarial);
            unset($array[$i]->modulo_id);
            unset($array[$i]->tag_id);
            unset($array[$i]->status);
            unset($array[$i]->description_modulo);
            unset($array[$i]->description_empresa);
            unset($array[$i]->created_at);
            unset($array[$i]->cdn_empresa);



            // unset($array[$i]->updated_by);





        }
        $colunas = array_keys( (array) $array[0]);

        $colunas = $this->formatHeaders($colunas);
                
        if (! in_array($type, ['xls', 'csv','xlsx'])) {
            $type = 'xlsx';
        }
        $fn = $filename.'-'.date('Y-m-d_H-i-s');

        if(is_null($array))   
        $array =  (is_null($array)) ? [] : $array;


        $export = new ExportData($array, $colunas);

        $header_file=[  "Content-Type"=>"application/vnd.ms-excel; charset=utf-8",
                        "Content-Disposition"=>"attachment; filename=abc.xls",
                        "Expires"=>"0", 
                        "Cache-Control"=>"must-revalidate, post-check=0, pre-check=0",
                        "Cache-Control"=>"private"
                     ];

        return Excel::download($export, $fn.'.'.$type ,null, $header_file );
    }
}
