<?php
namespace App\Modules\Natureza51\Http\Controllers;
ini_set('memory_limit', '1024M');
use App\Core\Http\Controllers\Controller;
use Maatwebsite\Excel\Events\BeforeSheet;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromArray;

use PhpOffice\PhpSpreadsheet\Cell\Cell;
use Maatwebsite\Excel\Concerns\ToModel;
use PhpOffice\PhpSpreadsheet\Cell\DataType;

use PhpOffice\PhpSpreadsheet\Cell\DefaultValueBinder;
use Maatwebsite\Excel\Concerns\WithCustomValueBinder;

use App\Invoice;
use Excel;
use Maatwebsite\Excel\Facades\Excel as excel_;
use SebastianBergmann\Exporter\Exporter;

class Natureza51Ctrl extends Controller
{   
    public $dados = null;
    //MÉTODOS PARA EXPORTAÇÃO PARA EXCEL

    public function downloadExcel($type, $filename, $fieldsDeleteModel = [])
    {
        set_time_limit(700);
        $array = [];
        if($this->dados != null){
            $array = $this->dados;//$this->arrayToObject($this->dados);
        }
        else{
            $array = json_decode($_POST['array_imprimir']);
        }

        
        // dd($filename);
        
        if(count($fieldsDeleteModel) > 0){
            for ($i = 0; $i < count($array) ; $i++) { 

                $fieldsDeleteDefault = ['grupo_empresarial_id','usuario_dominio', 'numero_dias_senha', 'api_token', 'id', 'empresa_id',
                                        'created_at', 'updated_at', 'user_id', 'created_by', 'updated_by' 
                ];

                $fieldsDelete = array_merge($fieldsDeleteDefault, $fieldsDeleteModel);
                
                foreach ($fieldsDelete as $field) {
                    unset($array[$i]->$field);
                }

                // unset($array[$i]->grupo_empresarial_id);
                // unset($array[$i]->usuario_dominio);
                // unset($array[$i]->numero_dias_senha);
                // unset($array[$i]->api_token);
                
                // //comum a todos os cadastros
                // unset($array[$i]->id);
                // unset($array[$i]->empresa_id);
                // unset($array[$i]->created_at);
                // unset($array[$i]->updated_at);
                // unset($array[$i]->user_id);
                // unset($array[$i]->created_by);
                // unset($array[$i]->updated_by);

            }
        }
        $colunas = array_keys( (array) $array[0]);

        $colunas = $this->formatHeaders($colunas);
        
        if (! in_array($type, ['xls', 'csv','xlsx'])) {
            $type = 'xlsx';
        }
        $fn = $filename.'-'.date('Y-m-d_H-i-s');

        if(is_null($array))   
        $array =  (is_null($array)) ? [] : $array;
        
        $export = new ExportData($array, $colunas);

        $header_file=[  "Content-Type"=>"application/vnd.ms-excel; charset=utf-8",
                        "Content-Disposition"=>"attachment; filename=abc.xls",
                        "Expires"=>"0", 
                        "Cache-Control"=>"must-revalidate, post-check=0, pre-check=0",
                        "Cache-Control"=>"private"
                     ];
        
        
        return Excel::download($export, $fn.'.'.$type ,null, $header_file );
    }

    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
        }
        return $colunas;
    }
    public function bindValue(Cell $cell, $value)
    {
        if (is_numeric($value)) {
            $cell->setValueExplicit($value, DataType::TYPE_STRING);

            return true;
        }

        return parent::bindValue($cell, $value);
    }

    //MÉTODOS PARA IMPORTAÇÃO

    public function importExport(){
        return view('importExport');
    }
    public function arrayToObject($dado){
        $array = [];
        if(array_key_exists('_token', $dado)){
            unset($dado['_token']);
        }
        for($i = 0; $i < count($dado); $i++){
            array_push($array, (object) $dado[$i]);
        }
        return $array;
    }
    public function importExcel(Request $request){
        $request->validate([
            'import_file' => 'required'
        ]);
 
        $path = $request->file('import_file')->getRealPath();
        $data = Excel::load($path)->get();
 
        if($data->count()){
            foreach ($data as $key => $value) {
                $arr[] = ['title' => $value->title, 'description' => $value->description];
            }
 
            if(!empty($arr)){
                Item::insert($arr);
            }
        }
 
        return back()->with('success', 'Insert Record successfully.');
    }


    
   
   
}

class ExportData extends DefaultValueBinder implements FromArray, WithHeadings, ShouldAutoSize, WithCustomValueBinder{
    protected $data;
    protected $colunas;
    public function __construct(array $invoices, array $colunas){
        $this->data = $invoices;
        $this->colunas = $colunas;
    }
    use Exportable;

    public function getData(){
        return $this->data;
    }
    public function setData($data2){
        $this->data = $data2;
    }
    
    public function getColunas(){
        return $this->colunas;
    }
    public function setColunas($colunas){
        $this->colunas = $colunas;
    }

    public function array(): array
    {
        return $this->getData();
    }

    public function headings(): array
    {
        return $this->getColunas();
    }

    public function bindValue(Cell $cell, $value)
    {
        
        if (is_numeric($value)) {
            $cell->setValueExplicit($value, DataType::TYPE_NUMERIC);

            return true;
        }

        // else return default behavior
        return parent::bindValue($cell, $value);
    }
}