<?php

namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoNaturezaEvento as RepoNaturezaEvento;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

use Excel;

class NaturezaEventoController extends Natureza51Ctrl
{
    public function __construct(){
        $this->setCodTela('NE');
        $this->repository = new RepoNaturezaEvento();
        parent::__construct();
    }
    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $data = $this->getRepository()->listarAll();

        // for ($i=0; $i < count($data); $i++) { 
            // $data[$i]['des_abre_ccusto'] = $data[$i]['abre_ccusto'] == 1 ? 'Sim' : 'Não';
            // $data[$i]['created_by_nome'] =  $data[$i]['created_by'] != null ? $this->getNomeByUsuario($data['created_by']): ' - ';
            // $data[$i]['updated_by_nome'] =  $data[$i]['updated_by'] != null ? $this->getNomeByUsuario($data['updated_by']): ' - ';
            // $data[$i]['description_created_at'] =  $data[$i]['created_at'] != null ? $this->formataData($data['created_at']) : '-';
            // $data[$i]['description_updated_at'] =  $data[$i]['updated_at'] != null ? $this->formataData($data['updated_at']) : '-';
        // }
// dd("data", $data);
        $retorno = [];

        foreach ($data as $dt) {
            $dt['des_abre_ccusto'] = $dt['abre_ccusto'] == 1 ? 'Sim' : 'Não';
            $dt['des_base_recisao'] = $dt['base_recisao'] == 1 ? 'Sim' : 'Não';

            $dt['des_base_calc_orcamento'] = $dt['base_calc_orcamento'] == 1 ? 'Sim' : 'Não';

           
            $dt['created_by_nome'] = $dt['created_by'] != null ? $this->getNomeByUsuario($dt['created_by']): ' - ';
            $dt['updated_by_nome'] = $dt['updated_by'] != null ? $this->getNomeByUsuario($dt['updated_by']): ' - ';
            $dt['description_created_at'] = $dt['created_at'] != null ? $this->formataData($dt, 'created_at') : '-';
            $dt['description_updated_at'] = $dt['updated_at'] != null ? $this->formataData($dt, 'updated_at') : '-';
            array_push($retorno, $dt);
            } 
      

            //return new Response(json_encode($retorno) , 200);
            return $retorno;

        // return $data;
    } 
    public function insert(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $retorno=$this->getArrayRetornoDefault();
        $dados = $request->all();
        $resp = $this->getRepository()->insert($dados);

        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            goto saida;
        }

        $retorno['status']='success';
        $retorno['msg']='Registro inserido com sucesso!';
        $retorno['submsg']='Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function update(Request $request){
        $this->podeAcessar('editar',true,$this->getCodTela());
        $dados = $request->all();
        $resp = $this->getRepository()->updateCtaEvento($dados);
        $retorno=$this->getArrayRetornoDefault();

        if(!$resp){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            goto saida;
        }

        $retorno['status']='success';
        $retorno['msg']='Registro atualizado com sucesso!';
        $retorno['submsg']='Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno);
    }


    public function downloadExcelAux($type)
    {
        $this->podeAcessar('exportar',true,$this->getCodTela());
        $filename="natureza-evento";
        $array = json_decode($_POST['array_imprimir']);    

        for ($i=0; $i < count($array) ; $i++) { 
            
            //geral
            unset($array[$i]->grupo_empresarial_id);
            unset($array[$i]->usuario_dominio);
            unset($array[$i]->numero_dias_senha);
            unset($array[$i]->api_token);
            
            //comum a todos os cadastros
            unset($array[$i]->id);
            unset($array[$i]->empresa_id);
            unset($array[$i]->id_grupo);
            unset($array[$i]->id_filial);
            unset($array[$i]->id_grupo_acesso);
            unset($array[$i]->id_permissao);
            unset($array[$i]->id_grupo_empresarial);
            unset($array[$i]->cta_contabil_id);
            unset($array[$i]->eventos_id);
            unset($array[$i]->abre_ccusto);
            unset($array[$i]->debito_credito);
            unset($array[$i]->cdn_event);
            unset($array[$i]->inc_liquido);
            unset($array[$i]->tipo_evento_id);
            // unset($array[$i]->des_event);
            // unset($array[$i]->des_cta_ctbl);
            unset($array[$i]->description_evento);
            unset($array[$i]->description_cta);
            unset($array[$i]->description);
            unset($array[$i]->cod_cta_ctbl);



            unset($array[$i]->cos_cta_ctbl);







            unset($array[$i]->updated_at);
            unset($array[$i]->created_at);
            unset($array[$i]->user_id);







        }
        $colunas = array_keys( (array) $array[0]);

        $colunas = $this->formatHeaders($colunas);
                
        if (! in_array($type, ['xls', 'csv','xlsx'])) {
            $type = 'xlsx';
        }
        $fn = $filename.'-'.date('Y-m-d_H-i-s');

        if(is_null($array))   
        $array =  (is_null($array)) ? [] : $array;


        $export = new ExportData($array, $colunas);

        $header_file=[  "Content-Type"=>"application/vnd.ms-excel; charset=utf-8",
                        "Content-Disposition"=>"attachment; filename=abc.xls",
                        "Expires"=>"0", 
                        "Cache-Control"=>"must-revalidate, post-check=0, pre-check=0",
                        "Cache-Control"=>"private"
                     ];

        return Excel::download($export, $fn.'.'.$type ,null, $header_file );
    }


    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        $this->podeAcessar('exportar',true,$this->getCodTela());
        return parent::downloadExcel($type, 'Natureza evento', ['base_recisao','updates_by', 'created_by', 'multiplica', 'desc_cta_ctbl', 'cta_contabil_id', 'eventos_id', 'debito_credito', 'cdn_event', 'des_event', 'inc_liquido', 'tipo_evento_id', 'cod_cta_ctb', 'description', 'abre_ccusto', 'cod_cta_ctbl', 'base_calc_orcamento']);
    }

    
    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 

            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("description cta", "Conta contábil", $colunas[$i]);
            $colunas[$i] = str_replace("description evento", "Evento", $colunas[$i]);
            $colunas[$i] = str_replace("des abre ccusto", "Abre centro custo", $colunas[$i]);
            $colunas[$i] = str_replace("des base calc orcamento", "Base para cálculo do orçamento", $colunas[$i]);
            $colunas[$i] = str_replace("des base recisao", "Base para recisão", $colunas[$i]);

            $colunas[$i] = str_replace("created by nome", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("description created at", "Criado em", $colunas[$i]);
            $colunas[$i] = str_replace("updated by nome", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("description updated at", "Atualizado em", $colunas[$i]);
        }
        return $colunas;
    }

    
    public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }
}