<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Entities\CalcIndice;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\OrcSalarioFuncionario;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcFuncionario;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Repositories\RepoCalcIndice;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento as RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoAumentosSalariaisForecast as RepoAumentosSalariaisForecast;
use Excel;

class OrcAumentosSalariaisForecastController extends OrcamentoController
{
    use \App\Core\Traits\ErrorTrait;

    public function __construct(){
        parent::__construct();
        //$this->setCodTela('OSF');
        $this->repository = new RepoAumentosSalariaisForecast();
    }  

    public function insert(Request $request){
        $this->setCodTela('FAS');
        $this->podeAcessar('inserir',true,$this->getCodTela());

        $form_data = $request->all();

        if($this->canCRUDForecast($form_data['lotacao_id'], $form_data['orc_id'], $form_data['periodo'], $form_data['tipo_table']) === false){
            $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201606';
            $retorno['submsg'] = 'Erro';
            $retorno['status'] = 'error';
            return $this->retornoJsonDefault($retorno);
        }

        $decrypted = json_decode(safeDecrypt(request()->bearerToken())); 
        $empresa_id = (($decrypted->token->empresa_id));
        $form_data['empresa_id'] = $empresa_id;
        
        // if($form_data['tipo_meses'] == 0){
        //     $retorno['status'] = 'warning';
        //     $retorno['submsg'] = 'Selecione um Tipo.';
        //     $retorno['msg'] = 'Atenção';
        //     goto saida;
        // }
        $form_data['lotacao_responsavel_id'] = 806;
        $form_data['tipo'] = 1;
        $this->getMeses($form_data['meses_orcado']);

        if(!mesesValidacao($form_data['meses_orcado'])){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            $retorno['msg'] = 'Os salários inseridos não podem diminuir ao longo dos meses. Erro: 160920200953';
            goto saida;
        }
        
        if(!$this->getRepositoryOrModel()->createOrcLotFuncionario($form_data)){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            goto saida;
        }

        $retorno["submsg"] = "Sucesso";
        $retorno["status"] = "success";
        $retorno["msg"] = "Cadastro realizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function getMeses(&$meses){
        
        $mes = ['jan_orcado', 'fev_orcado', 'mar_orcado', 'abr_orcado', 'mai_orcado', 'jun_orcado', 'jul_orcado', 'ago_orcado', 'set_orcado', 'out_orcado', 'nov_orcado', 'dez_orcado'];
        for($i = 0; $i < 12; $i++){
            if(!array_key_exists($mes[$i], $meses)){
                $meses[$mes[$i]] = 0;
            }
            else{
                monetarioVirgula($meses[$mes[$i]]);
            }
        }
    }
    public function update(Request $request){  
        $this->setCodTela('FAS');
        $this->podeAcessar('editar',true,$this->getCodTela());
        
        $repo_calc_orcamento = new RepoCalcOrcamento();
        $this->clearError();

        $form_data = $request->all();
        
        if($this->canCRUDForecast($form_data['lotacao_id'], $form_data['orc_id'], $form_data['periodo'], $form_data['tipo_table']) === false){
            $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201600';
            $retorno['submsg'] = 'Erro';
            $retorno['status'] = 'error';
            return $this->retornoJsonDefault($retorno);
        }

        $meses = Arr::only($form_data, ['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado',
        'ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);
        
        $meses_indice = ['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado',
        'ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];

        for($i = 0; $i < 12; $i++){
            monetarioVirgula($form_data[$meses_indice[$i]]);
        }
        
        if(!mesesValidacao(convertDecimalEn($meses))){
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            $retorno['submsg'] = 'Os salários inseridos não podem diminuir ao longo dos meses. Erro: 160920201109';
            goto saida;
        }else{
            unset($form_data['_token']);
            $id = $form_data['calc_id'];
            $calc = Arr::except($form_data, ['id','calc_id']);
            
            if(! $repo_calc_orcamento->update($calc, $id)){                  
                $retorno["status"] = "error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted().' Erro: 160920201113';
                $retorno['submsg'] = 'Erro';
                goto saida;               
            }

            DB::update("UPDATE tbl_orc_salario_funcionario SET updated_at = ?, updated_by = ? where id = ?", [$this->fillModificadoEm(), $this->fillModificadoPor(), $form_data['id']]);
        } 
        
        $retorno['submsg'] = 'Sucesso';
        $retorno["status"] = "success";
        $retorno["msg"] = "Registro atualizado com sucesso!";
        saida:       
     
        return $this->retornoJsonDefault($retorno); 
    } 
    
    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['funcionario_id', 'orc_cargo_id', 'lotacao_responsavel_id','funcionario_id','salario', 'nome_funcionario', 'cdn_funcionario', 'cargo_id', 
        'des_cargo_basic', 'cod_cargo_basic' ,'ccusto_id', 'des_ccusto', 'cod_ccusto', 'orc_sal_func_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

    public function dataFilterSalarioFuncionario($data){
        $array_orcamento=['funcionario_id','salario', 'nome_funcionario', 'cdn_funcionario', 'cargo_id', 
        'des_cargo_basic', 'cod_cargo_basic' ,'ccusto_id', 'des_ccusto', 'cod_ccusto', 'orc_sal_func_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
        //fhjfghdfgdfgdf ddddddddd
        //dd("dataUpdate", $filtered);
        return $filtered;
    }

    public function delete(Request $request){
        $this->setCodTela('FAS');
        $this->podeAcessar('deletar',true,$this->getCodTela());

        $data = $request->all();

        if($this->canCRUDForecast($data['lotacao_id'], $data['orc_id'], $data['periodo'], $data['tipo_table']) === false){
            $retorno['msg'] = 'Impossível fazer operação. A lotação foi enviada. Erro: 031220201602';
            $retorno['submsg'] = 'Erro';
            $retorno['status'] = 'error';
            return $this->retornoJsonDefault($retorno);
        }

        $resp = $this->getRepository()->deleteForecast($data);

        if(!$resp){
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
        }
        
        $retorno['status'] = 'success';
        $retorno['msg'] = 'Registro deletado com sucesso!';
        $retorno['submsg'] = 'Sucesso';
        saida:
        return $retorno;
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
       

        return parent::downloadExcel($type, 'SalarioFuncionario', ['cod_ccusto','des_ccusto','orc_sal_func_id','calc_orcamento_id','ccusto_id','cargo_id', 'cargo_id','identificador','salario','funcionario_id', 'orc_cargo_id', 'orc_id']);
    }

    public function formatHeaders($colunas){ 
        for ($i=0; $i < count($colunas) ; $i++) { 
            // dd(json_decode($_POST['array_imprimir']));
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("nome funcionario", "Funcionário", $colunas[$i]);
            $colunas[$i] = str_replace("cdn funcionario", "Cód. funcionário", $colunas[$i]);
            $colunas[$i] = str_replace("des cargo basic", "Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("cod cargo basic", "Cód. Cargo", $colunas[$i]);




            $colunas[$i] = str_replace("jan orcado", "Janeiro", $colunas[$i]);
            $colunas[$i] = str_replace("fev orcado", "Fevereiro", $colunas[$i]);
            $colunas[$i] = str_replace("mar orcado", "Março", $colunas[$i]);
            $colunas[$i] = str_replace("abr orcado", "Abril", $colunas[$i]);
            $colunas[$i] = str_replace("mai orcado", "Maio", $colunas[$i]);
            $colunas[$i] = str_replace("jun orcado", "Junho", $colunas[$i]);
            $colunas[$i] = str_replace("jul orcado", "Julho", $colunas[$i]);
            $colunas[$i] = str_replace("ago orcado", "Agosto", $colunas[$i]);
            $colunas[$i] = str_replace("set orcado", "Setembro", $colunas[$i]);
            $colunas[$i] = str_replace("out orcado", "Outubro", $colunas[$i]);
            $colunas[$i] = str_replace("nov orcado", "Novembro", $colunas[$i]);
            $colunas[$i] = str_replace("dez orcado", "Dezembro", $colunas[$i]);


        }
        return $colunas;
    }
    public function deleteAllFuncionario($orc_id){
        $resp = $this->getRepository()->deleteAll($orc_id);
        if(!$resp){
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            goto saida;
        }
        
        $retorno["status"] = "success";
        $retorno["submsg"] = "Sucesso";
        $retorno["msg"] = "Registros deletados com successo!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function orcFuncCargo($orcamento_id,$func_id){
        $orc_func = new OrcFuncionario();

        $orc_func = OrcFuncionario::where('orcamento_id', $orc_func['orcamento_id'] = $orcamento_id)->where('funcionario_id', $orc_func['funcionario_id'] = $func_id)->first();

        $funcionario = json_encode($orc_func);
        return $funcionario;
    }

    public function listarByCapacity($orc_id, $lotacao_id, $periodo, $tipo_table){
        $this->setCodTela('FAS');
        $this->podeAcessar('listar',true,$this->getCodTela());

        $decrypted = json_decode(safeDecrypt(request()->bearerToken()));
        $empresa_id = (($decrypted->token->empresa_id));
        $tb_orc_lotacao = new OrcLotacao(); 
        $tb_orc_salario_funcionario = new OrcSalarioFuncionario();        
        $tb_calc_orcamento = new CalcOrcamento();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_orc_cargo = new OrcCargo();
        $tb_funcionario = new Funcionario();
        $tbl_usuario = new Usuario();
        $tbl_of = new OrcFuncionario();
        
        $func_id = $this->getFuncionarioByCod($decrypted->token->func_data->cdn_funcionario);
        
        $data = $tb_orc_salario_funcionario
        ->leftJoin($tb_calc_orcamento->getTable(), $tb_orc_salario_funcionario->getColunaAlias('id'), '=', 
            DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and 
            {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orc_salario_funcionario->getTable()}'"))

        ->join($tb_orc_lotacao->getTable(),
            $tb_orc_salario_funcionario->getColunaAlias('lotacao_id'), $tb_orc_lotacao->getColunaAlias('id'))

        ->leftJoin($tb_orc_cargo->getTable(),
            $tb_orc_salario_funcionario->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))  

        ->leftJoin($tb_funcionario->getTable(),
            $tb_orc_salario_funcionario->getColunaAlias('funcionario_id'), $tb_funcionario->getColunaAlias('id')) 

        ->leftJoin($tb_cargo->getTable(),
            $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))  

        ->leftJoin($tb_centro_custo->getTable(),
            $tb_funcionario->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id'))  

        ->leftJoin($tbl_of->getTable(), $tb_orc_salario_funcionario->getColunaAlias('funcionario_id'), DB::raw(" {$tbl_of->getColunaAlias('funcionario_id')} and {$tbl_of->getColunaAlias('orcamento_id')} = {$orc_id}
            and {$tbl_of->getColunaAlias('tipo_table')} = '{$tipo_table}' and {$tbl_of->getColunaAlias('periodo')} = '{$periodo}'"))
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$tb_orc_salario_funcionario->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $tb_calc_orcamento->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )
        ->select(
            DB::raw("{$tb_orc_salario_funcionario->getColunaAlias('id')} 'orc_sal_func_id'"),
            DB::raw("{$tb_calc_orcamento->getColunaAlias('id')} 'calc_orcamento_id'"),
            $tb_orc_salario_funcionario->getColunaAlias('orc_id'),
            $tb_centro_custo->getColunaAlias('cod_ccusto'),
            $tb_centro_custo->getColunaAlias('des_ccusto'),
            $tb_funcionario->getColunaAlias('ccusto_id'),
            $tb_cargo->getColunaAlias('cod_cargo_basic'),
            $tb_cargo->getColunaAlias('des_cargo_basic'),
            DB::raw("{$tb_cargo->getColunaAlias('salario')} as salario_atual"),
            $tb_orc_cargo->getColunaAlias('cargo_id'),
            $tb_funcionario->getColunaAlias('cdn_funcionario'),
            $tb_funcionario->getColunaAlias('nome_funcionario'),
            $tb_funcionario->getColunaAlias('salario'),
            $tb_orc_salario_funcionario->getColunaAlias('orc_cargo_id'),
            $tb_orc_salario_funcionario->getColunaAlias('id'),
            $tbl_of->getColunaAlias('salario_forecast'),
           
        DB::raw("CONCAT({$tb_cargo->getColunaAlias('cod_cargo_basic')}, ' - ', 
            {$tb_cargo->getColunaAlias('des_cargo_basic')}) AS cargo"),
            DB::raw("CONCAT({$tb_funcionario->getColunaAlias('cdn_funcionario')}, ' - ', 
            {$tb_funcionario->getColunaAlias('nome_funcionario')}) AS funcionario"),

            $tb_orc_salario_funcionario->getColunaAlias('funcionario_id'),
            $tb_calc_orcamento->getColunaAlias('jan_orcado'),                                    
            $tb_calc_orcamento->getColunaAlias('fev_orcado'),                                     
            $tb_calc_orcamento->getColunaAlias('mar_orcado'),                                    
            $tb_calc_orcamento->getColunaAlias('abr_orcado'),                                    
            $tb_calc_orcamento->getColunaAlias('mai_orcado'),
            $tb_calc_orcamento->getColunaAlias('jun_orcado'), 
            $tb_calc_orcamento->getColunaAlias('jul_orcado'), 
            $tb_calc_orcamento->getColunaAlias('ago_orcado'),
            $tb_calc_orcamento->getColunaAlias('set_orcado'), 
            $tb_calc_orcamento->getColunaAlias('out_orcado'),
            $tb_calc_orcamento->getColunaAlias('nov_orcado'), 
            $tb_calc_orcamento->getColunaAlias('dez_orcado'),

            DB::raw("CASE WHEN {$tb_orc_salario_funcionario->getColunaAlias('created_at')} IS NOT NULL THEN format({$tb_orc_salario_funcionario->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_data"),// HH:mm
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

            DB::raw("CASE WHEN {$tb_calc_orcamento->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tb_calc_orcamento->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_data"),
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")
        )
        ->where($tb_orc_salario_funcionario->getColunaAlias('orc_id'),$orc_id)
        ->where($tb_orc_salario_funcionario->getColunaAlias('lotacao_id'),$lotacao_id)
        ->where($tb_orc_salario_funcionario->getColunaAlias('tipo'), 1)
        ->where($tb_orc_salario_funcionario->getColunaAlias('tipo_table'), $tipo_table)
        ->where($tb_orc_salario_funcionario->getColunaAlias('periodo'), $periodo);
        
        if($decrypted->token->tipo_user == 4){
            $data = $data->where($tb_orc_salario_funcionario->getColunaAlias('funcionario_id'), '!=', $func_id);
        }
        $data = $data->get()->toArray();
        
        for($i = 0; $i < count($data); $i++){
            $data[$i]['identificador'] = "2";
        }
        $sal_func = new OrcSalarioFuncionarioController();
        return json_encode($sal_func->renderTreeTableList($data));
    }

    public function getFuncionarioByCod($cod){
        $select = DB::select("SELECT * from tbl_funcionario where cdn_funcionario = {$cod}");
        return count($select) > 0 ? $select[0]->id : 0;
    }
}