<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcBeneficio as RepoOrcBeneficio;
use App\Modules\Natureza51\Repositories\RepoOrcLotCargoBeneficio as RepoOrcLotCargoBeneficio;
use App\Modules\Natureza51\Repositories\RepoOrcLotFuncionarioBeneficio as RepoOrcLotFuncionarioBeneficio;
use App\Modules\Natureza51\Repositories\RepoOrcScriptCalculos;
use App\Modules\Natureza51\Entities\Beneficio;
use App\Modules\Natureza51\Entities\CalcIndice;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use Illuminate\Http\Request as Request;
use Illuminate\Http\Response;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class OrcBeneficiosController extends OrcamentoController
{
    public function __construct(){
        $this->setRepository(new RepoOrcBeneficio());
        $this->setCodTela('OBEN');
        parent::__construct();
    } 

    public function inserir(Request $request, $id=null) {
        
        $this->podeAcessar('inserir',true,$this->getCodTela());

        $form_data = $this->getRepositoryOrModel()->putOrcamentoIdOnData($request->all(),$id);
        $decrypted = json_decode(safeDecrypt(request()->bearerToken()),true);

        $beneficio = new Beneficio();

        /*if($form_data['tipo_meses']==0){
            $retorno['status']='warning';
            $retorno['submsg']='Selecione um Tipo.';
            $retorno['msg']='Atenção';
            goto saida;
        }*/

        // $tbl_calc_orc = new CalcOrcamento();
        // $tbl_calc_ind = new CalcIndice();
        
        // $select = [];
        // $y=0;
        
        // $select = $beneficio->select(DB::raw('id as beneficio_id'))->whereIn(
        //             'evento_id', $form_data['evento_id']
        //         )
        //         ->get()->toArray(); 
        $beneficio_id = $beneficio->select(DB::raw('id as beneficio_id'))->where([
            ['evento_id','=', $form_data['evento_id']],
            ['empresa_id','=', $decrypted['token']['empresa_id']]
        ])
        ->first();  
        //ver esta validação
        if(!$beneficio_id){
            $retorno['msg']="Evento não cadastrado para este Benefício!";
            $retorno['submsg']='Falha ao inserir o registro. Erro:131220191907';
            $retorno['status']='error';
            goto saida;
        }

        
        // $meses = $form_data['meses_orcado'];
        
        // if(!mesesValidacao(convertDecimalEn($meses))){
        //     $retorno['status']='error';
        //     $retorno['msg']='Os salários inseridos não podem diminuir ao longo dos meses.';
        //     $retorno['submsg']='Os salários inseridos não podem diminuir ao longo dos meses. Erro: 200320201325';
        //     goto saida;
        // }
        $form_data['beneficio_id'] = $beneficio_id->beneficio_id;

       
        $inserir = $this->getRepository()->createOrcBeneficio($form_data, $form_data['periodo'], $form_data['tipo_table']);
        if(!$inserir){
            $retorno['status']='error';
            $retorno['msg']= $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir registro. Erro: 200320201325';
            goto saida;
        }
        
        // $inserir = $this->getRepository()->insereCalcBeneficio($form_data);
        // if(!$inserir){
        //     $retorno['status']='error';
        //     $retorno['msg']='Falha ao inserir registro.';
        //     $retorno['submsg']='Falha ao inserir registro. Erro: 050520201015';
        //     goto saida;
        // }

        // for($i = 0; $i<count($form_data['evento_id']); $i++){

        //     $beneficio = $this->getRepository()->getModelEntity()->select()->where([
        //         [$this->getRepository()->getModelEntity()->getColunaAlias('orcamento_id'),'=',$form_data['orcamento_id']],
        //         [$this->getRepository()->getModelEntity()->getColunaAlias('beneficio_id'),'=',$select[$i]['beneficio_id']],
        //         [$this->getRepository()->getModelEntity()->getColunaAlias('evento_id'),'=',$form_data['evento_id'][$i]]
        //     ])->get()->toArray();
            
        //     if(count($beneficio)>0){
                
        //         $select_calc_orc = $tbl_calc_orc->select()->where([
        //             [$tbl_calc_orc->getColunaAlias('origem_id'),'=',$beneficio[0]['id']],
        //             [$tbl_calc_orc->getColunaAlias('tbl_origem'),'=',$this->getRepository()->getModelEntity()->getTable()]
        //         ])->get()->toArray();
    
        //         if($form_data['tipo_meses']==2)
        //         {
                    
        //             if(count($select_calc_orc)>0)
        //             {
        //                 $retorno['status'] = 'error';
        //                 $retorno['msg'] = ($i+1)."º Evento já existente em valor absoluto. Erro: 140420201518";
        //                 goto saida;
        //             }
        //         }
        //         else if($form_data['tipo_meses']==1)
        //         {
        //             $select_calc_ind = $tbl_calc_ind->select()->where([
        //                 [$tbl_calc_ind->getColunaAlias('origem_id'),'=',$beneficio[0]['id']],
        //                 [$tbl_calc_ind->getColunaAlias('tbl_origem'),'=',$this->getRepository()->getModelEntity()->getTable()]
        //             ])->get()->toArray();
                    
        //             if(count($select_calc_ind)>0)
        //             {
        //                 $retorno['status'] = 'error';
        //                 $retorno['msg'] = ($i+1)."º Evento já existente em índice.  Erro: 1404202015018";
        //                 goto saida;
        //             }
                    
        //         }
        //     }
        // }
        
    //     for($i=0;$i<count($select);$i++){
        
    //         $dados = array("evento_id" => $form_data['evento_id'][$i],"beneficio_id" => $select[$i]['beneficio_id'], "empresa_id"=>$form_data['empresa_id'],
    //     "tipo_calc"=>$form_data['tipo_calc'],"vlr_movto"=>$form_data['vlr_movto'],"vlr_depend"=>$form_data['vlr_depend'],"tipo_meses"=>$form_data['tipo_meses'],
    // "meses_orcado"=>$form_data['meses_orcado'],"orcamento_id"=>$form_data['orcamento_id']);

           
    //         if(! $this->getRepositoryOrModel()->createOrcBeneficio(($dados))){
    //             $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
    //             $retorno['submsg']='Falha ao inserir o registro. Erro:301120191630';
    //             $retorno['status']='error';
    //             goto saida;
    //         } 
    //     }
        
        
        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);        
    }    

    public function list($id, $periodo = null, $tipo_table = 'O'){ 
        
        $this->podeAcessar('listar',true,$this->getCodTela());

        $dados=$this->getRepositoryOrModel()->listar($id, $periodo, $tipo_table);
        return $this->renderTreeTableList($dados);
    } 

    public function listarIndices($orc_id, $periodo = null, $tipo_table = 'O'){

        $this->podeAcessar('listar',true,$this->getCodTela());

        $dados = $this->getRepositoryOrModel()->listarIndice($orc_id, $periodo, $tipo_table);

        return $this->treeTableIndice($dados);
    }

    public function listEvent($orc_id, $periodo = null, $tipo_table = 'O'){

        $this->podeAcessar('listar',true,$this->getCodTela());

        $dados=$this->getRepositoryOrModel()->listaEventos($orc_id, $periodo, $tipo_table);
        return $dados;
    }
    
    public function deletar(Request $request, $id) {

        $this->podeAcessar('deletar',true,$this->getCodTela());

        $form_data=$request->all();
        
        if($form_data['identificador'] == 1){
            if(! $this->getRepositoryOrModel()->deleteBeneficioIndice($form_data)){
                $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg']='Falha ao deletar o registro. Erro:050420202007';
                goto saida;
            }
        }
        else{
            if(! $this->getRepositoryOrModel()->deleteOrcBeneficio($form_data)){
                $retorno["status"] = "error";
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg'] = 'Falha ao deletar o registro. Erro:141220191400';
                goto saida;
            }
        }
        
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);      
        
    }

    public function updateBeneficio(Request $request, $id) {
        
        $this->podeAcessar('editar',true,$this->getCodTela());

        $form_data=$request->all();
        //dd($form_data);
        /* $meses=Arr::only($form_data,['jan_orcado','fev_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado',
        / 'ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);

         $meses_indice = Arr::only($form_data,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice','jul_indice','agost_indice','set_indice','out_indice','nov_indice','dez_indice']);
        */
        if($form_data['identificador'] == "1"){
            // if(!mesesNull($meses_indice,1)){
            //     $retorno['status']='error';
            //     $retorno['msg']='Por favor, insira valores nos campos de índices.';
            //     $retorno['submsg']='Erro';
            //     goto saida;
            // }
            // if(!validacaoIndice(convertDecimalEn($meses_indice))){
            //     $retorno['status']='error';
            //     $retorno['msg']='Os índices inseridos não podem diminuir ao longo dos meses.';
            //     $retorno['submsg']='Os índices inseridos não podem diminuir ao longo dos meses. Erro: 060420201219';
            //     goto saida;
            // }
            // else{
                if(!$this->getRepositoryOrModel()->updateBeneficioIndice($form_data)){
                    $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                    $retorno['submsg']='Falha ao atualizazr o registro. Erro:050420202004';
                    goto saida;
                }
            // }
        }
        else{
            // if(!mesesNull($meses_indice,2)){
            //     $retorno['status']='error';
            //     $retorno['msg']='Por favor, insira valores nos campos de índices.';
            //     $retorno['submsg']='Erro';
            //     goto saida;
            // }
            // if(!mesesValidacao(convertDecimalEn($meses))){
            //     $retorno['status']='error';
            //     $retorno['msg']='Os salários inseridos não podem diminuir ao longo dos meses.';
            //     $retorno['submsg']='Os salários inseridos não podem diminuir ao longo dos meses. Erro: 200320201325';
            //     goto saida;
            // }
            // else{
                if(! $this->getRepositoryOrModel()->updateOrcBeneficio($form_data)){
                    $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                    $retorno['submsg']='Falha ao atualizar o registro. Erro:161220191635';
                    goto saida;
            //    }
            }
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);      
        
    }

    public function distribuir(Request $request){
        $dados = $request->all();
        
        if($dados['distribuicao'] == 1){
            $resp2 = $this->getRepository()->inserirBeneficioCargoIndice($dados, $dados['periodo'], $dados['tipo_table']);
            if(!$resp2){
                $retorno['status'] = 'error';
                $retorno['msg'] = $this->getRepository()->getErrosFlatted();
                $retorno['submsg'] = 'Erro';
                goto saida;
            }
        }
        else{
            $resp = $this->getRepository()->inserirBeneficioFuncionarioIndice($dados, $dados['periodo'], $dados['tipo_table']);
            if(!$resp){
                $retorno['status'] = 'error';
                $retorno['msg'] = $this->getRepository()->getErrosFlatted();
                $retorno['submsg'] = 'Erro';
                goto saida;
            }
        }
       
        $retorno["status"]="success";
        $retorno["msg"]="Registro distribuído com sucesso!";
        $retorno['submsg'] = 'Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno); 
    }
    public function treeTableIndice($dados){
        $columns_base=[ 
            ["field_out"=>"id", "from"=>"id"],
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id"],
            ["field_out"=>"beneficio_id", "from"=>"beneficio_id"],
            ["field_out"=>"evento_id", "from"=>"evento_id"], 
            ["field_out"=>"description", "from"=>"description"],
            ["field_out"=>"des_exclusivo_admissao", "from"=>"exclusivo_admissao", "render_value"=>function($row_data, $value){
                return $row_data['exclusivo_admissao'] == 1 ? 'Sim' : 'Não';
            }],
            ["field_out"=>"description_cta_ctb", "from"=>"description_cta_ctb"],
            ["field_out"=>"cta_ctb_id", "from"=>"cta_ctb_id"],
            ["field_out"=>"tipo_calc", "from"=>"tipo_calc"], 
            ["field_out"=>"vlr_movto", "from"=>"vlr_movto","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }], 
            ["field_out"=>"vlr_depend", "from"=>"vlr_depend"], 
            ["field_out"=>"des_event", "from"=>"des_event"], 
            ["field_out"=>"formula", "from"=>"formula"], 
            ["field_out"=>"empresa_id", "from"=>"empresa_id"], 
            ["field_out"=>"calc_indice_id", "from"=>"calc_indice_id"], 
            ["field_out"=>"origem_id", "from"=>"origem_id"], 
            ["field_out"=>"tbl_origem", "from"=>"tbl_origem"], 
            ["field_out"=>"identificador", "from"=>"identificador"],
            ["field_out"=>"exclusivo_admissao", "from"=>"exclusivo_admissao"],
            ["field_out"=>"des_exclusivo_admissao", "from"=>"des_exclusivo_admissao"],
            ["field_out"=>"des_origem_beneficio", "from"=>"des_origem_beneficio"],
            ["field_out"=>"origem_beneficio", "from"=>"origem_beneficio"],
            ["field_out"=>"salario_corte", "from"=>"salario_corte", "render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            }],
            ["field_out"=>"vlr_maximo", "from"=>"vlr_maximo","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],

            ["field_out"=>"grade_maximo", "from"=>"grade_maximo","render_value"=>function($row_data, $value){
                return $value ? $value : '-';
            }],

            ["field_out"=>"criado_por", "from"=>"criado_por"],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por"],

            ["field_out"=>"atualizado_data", "from"=>"updated_at","render_value"=>function($rowData,$value){
                return formataData($value);
            }],
            ["field_out"=>"criado_data", "from"=>"created_at","render_value"=>function($rowData,$value){
                return formataData($value);
            }],

            ["field_out"=>"des_tipo_calc", "from"=>"des_tipo_calc"],
            ["field_out"=>"des_tipo_acesso", "from"=>"des_tipo_acesso"],
            
            ["field_out"=>"jan_indice", "from"=>"jan_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],
               ["field_out"=>"fev_indice", "from"=>"fev_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],
               ["field_out"=>"marc_indice", "from"=>"marc_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
               ["field_out"=>"abril_indice", "from"=>"abril_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }], 
               ["field_out"=>"maio_indice", "from"=>"maio_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
               ["field_out"=>"jun_indice", "from"=>"jun_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
               ["field_out"=>"jul_indice", "from"=>"jul_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
               ["field_out"=>"agost_indice", "from"=>"agost_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
               ["field_out"=>"set_indice", "from"=>"set_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],    
               ["field_out"=>"out_indice", "from"=>"out_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],    
               ["field_out"=>"nov_indice", "from"=>"nov_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],    
               ["field_out"=>"dez_indice", "from"=>"dez_indice","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }]
       ];
        
        
       $settings=["columns"=>$columns_base,
               "keys"=>['id'] 
           ];    
           
       $controller=new AtmTreeTable($settings, $dados);
       
     return $controller->render();
    }
    
   public function renderTreeTableList($dados){
    //dd($dados);
    $columns_base=[ 
        ["field_out"=>"id", "from"=>"id"],
        ["field_out"=>"orcamento_id", "from"=>"orcamento_id"],
        ["field_out"=>"beneficio_id", "from"=>"beneficio_id"],
        ["field_out"=>"evento_id", "from"=>"evento_id"], 
        ["field_out"=>"description", "from"=>"description"], 
        ["field_out"=>"description_cta_ctb", "from"=>"description_cta_ctb"],
        ["field_out"=>"cta_ctb_id", "from"=>"cta_ctb_id"],
        ["field_out"=>"tipo_calc", "from"=>"tipo_calc"], 
        ["field_out"=>"vlr_movto", "from"=>"vlr_movto","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }], 
        ["field_out"=>"vlr_depend", "from"=>"vlr_depend"], 
        ["field_out"=>"des_event", "from"=>"des_event"], 
        ["field_out"=>"formula", "from"=>"formula"], 
        ["field_out"=>"empresa_id", "from"=>"empresa_id"], 
        ["field_out"=>"calc_orcamento_id", "from"=>"calc_orcamento_id"], 
        ["field_out"=>"origem_id", "from"=>"origem_id"], 
        ["field_out"=>"tbl_origem", "from"=>"tbl_origem"], 
        ["field_out"=>"identificador", "from"=>"identificador"],
        ["field_out"=>"exclusivo_admissao", "from"=>"exclusivo_admissao"],

        ["field_out"=>"des_exclusivo_admissao", "from"=>"exclusivo_admissao", "render_value"=>function($row_data, $value){
            return $row_data['exclusivo_admissao'] == 1 ? 'Sim' : 'Não';
        }],

        ["field_out"=>"des_exclusivo_admissao", "from"=>"des_exclusivo_admissao"],
        ["field_out"=>"des_origem_beneficio", "from"=>"des_origem_beneficio"],
        ["field_out"=>"origem_beneficio", "from"=>"origem_beneficio"],
        ["field_out"=>"salario_corte", "from"=>"salario_corte", "render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],
        ["field_out"=>"vlr_maximo", "from"=>"vlr_maximo","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],

        ["field_out"=>"grade_maximo", "from"=>"grade_maximo","render_value"=>function($row_data, $value){
            return $value ? $value : '-';
        }],

        ["field_out"=>"des_tipo_calc", "from"=>"des_tipo_calc"],
        ["field_out"=>"des_tipo_acesso", "from"=>"des_tipo_acesso"],

        ["field_out"=>"criado_por", "from"=>"criado_por"],
        ["field_out"=>"atualizado_por", "from"=>"atualizado_por"],

        ["field_out"=>"atualizado_data", "from"=>"updated_at","render_value"=>function($rowData,$value){
            return formataData($value);
        }],
        ["field_out"=>"criado_data", "from"=>"created_at","render_value"=>function($rowData,$value){
            return formataData($value);
        }],

        ["field_out"=>"jan_orcado", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],
        ["field_out"=>"fev_orcado", "from"=>"fev_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],
        ["field_out"=>"mar_orcado", "from"=>"mar_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],     
        ["field_out"=>"abr_orcado", "from"=>"abr_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }], 
        ["field_out"=>"mai_orcado", "from"=>"mai_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],     
        ["field_out"=>"jun_orcado", "from"=>"jun_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],     
        ["field_out"=>"jul_orcado", "from"=>"jul_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],     
        ["field_out"=>"ago_orcado", "from"=>"ago_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],     
        ["field_out"=>"set_orcado", "from"=>"set_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],    
        ["field_out"=>"out_orcado", "from"=>"out_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],    
        ["field_out"=>"nov_orcado", "from"=>"nov_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],    
        ["field_out"=>"dez_orcado", "from"=>"dez_orcado","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }]
   ];
    
    
    $settings=["columns"=>$columns_base,
    "keys"=>['id'] 
    ];    

    $controller=new AtmTreeTable($settings, $dados);

    return $controller->render();
 }

    public function downloadExcelBeneficioAbsoluto($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'BeneficioAbsoluto',['exclusivo_admissao','des_origem_beneficio','origem_beneficio','criado_por','atualizado_por','atualizado_data','criado_data','orcamento_id','beneficio_id','evento_id','cta_ctb_id','tipo_calc','vlr_movto','vlr_depend','formula','calc_orcamento_id','origem_id','tbl_origem','identificador','des_event']);
    }
    public function downloadExcelBeneficioIndice($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'BeneficioIndice',['exclusivo_admissao','des_origem_beneficio','origem_beneficio','criado_por','atualizado_por','atualizado_data','criado_data','orcamento_id','beneficio_id','evento_id','cta_ctb_id','tipo_calc','vlr_movto','vlr_depend','formula','calc_orcamento_id','origem_id','tbl_origem','identificador','des_event','calc_indice_id']);
    }

    public function formatHeaders($colunas){ 
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("description cta ctb", "Conta contábil", $colunas[$i]);

            $colunas[$i] = str_replace("description", "Evento", $colunas[$i]);
            $colunas[$i] = str_replace("vlr maximo", "Valor máximo", $colunas[$i]);
            $colunas[$i] = str_replace("des tipo acesso", "Tipo acesso", $colunas[$i]);
            $colunas[$i] = str_replace("des tipo calc", "Tipo cálculo", $colunas[$i]);



            $colunas[$i] = str_replace("jan orcado", "Janeiro", $colunas[$i]);
            $colunas[$i] = str_replace("fev orcado", "Fevereiro", $colunas[$i]);
            $colunas[$i] = str_replace("mar orcado", "Março", $colunas[$i]);
            $colunas[$i] = str_replace("abr orcado", "Abril", $colunas[$i]);
            $colunas[$i] = str_replace("mai orcado", "Maio", $colunas[$i]);
            $colunas[$i] = str_replace("jun orcado", "Junho", $colunas[$i]);
            $colunas[$i] = str_replace("jul orcado", "Julho", $colunas[$i]);
            $colunas[$i] = str_replace("ago orcado", "Agosto", $colunas[$i]);
            $colunas[$i] = str_replace("set orcado", "Setembro", $colunas[$i]);
            $colunas[$i] = str_replace("out orcado", "Outubro", $colunas[$i]);
            $colunas[$i] = str_replace("nov orcado", "Novembro", $colunas[$i]);
            $colunas[$i] = str_replace("dez orcado", "Dezembro", $colunas[$i]);

            $colunas[$i] = str_replace("jan indice", "Janeiro", $colunas[$i]);
            $colunas[$i] = str_replace("fev indice", "Fevereiro", $colunas[$i]);
            $colunas[$i] = str_replace("marc indice", "Março", $colunas[$i]);
            $colunas[$i] = str_replace("abril indice", "Abril", $colunas[$i]);
            $colunas[$i] = str_replace("maio indice", "Maio", $colunas[$i]);
            $colunas[$i] = str_replace("jun indice", "Junho", $colunas[$i]);
            $colunas[$i] = str_replace("jul indice", "Julho", $colunas[$i]);
            $colunas[$i] = str_replace("agost indice", "Agosto", $colunas[$i]);
            $colunas[$i] = str_replace("set indice", "Setembro", $colunas[$i]);
            $colunas[$i] = str_replace("out indice", "Outubro", $colunas[$i]);
            $colunas[$i] = str_replace("nov indice", "Novembro", $colunas[$i]);
            $colunas[$i] = str_replace("dez indice", "Dezembro", $colunas[$i]);
            $colunas[$i] = str_replace("des", "", $colunas[$i]);


        }
        return $colunas;
    }
    
    public function repopulateBeneficio($orc_id, Request $request){       
        
        $dado = $request->all();

        if($dado['tipo'] == 0){
            $msg = '';
            /* REPOPULAR INCREMENTAL*/
            $resp = $this->getRepositoryOrModel()->atualizaOrcBeneficio($orc_id, $dado['periodo'], $dado['tipo_table']);
            if($resp === false){
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg'] = 'Erro';
                $retorno['status'] = 'error';
                goto saida;
            }
            if($resp == 'warning'){
                $msg = $this->getRepositoryOrModel()->getErrosFlatted().'<br>';
                $retorno['msg'] = $msg;
                $retorno['submsg'] = 'Atenção';
                $retorno['status'] = 'warning';
            }

            $resp_3 = $this->getRepositoryOrModel()->atualizaOrcBeneficioFuncionario($orc_id, $dado['periodo'], $dado['tipo_table']);
            if($resp_3 === false){
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg'] = 'Erro';
                $retorno['status'] = 'error';
                goto saida;
            }
            if($resp_3 == 'warning'){
                $msg = $msg.$this->getRepositoryOrModel()->getErrosFlatted().'<br>';
                $retorno['msg'] = $msg;
                $retorno['submsg'] = 'Atenção';
                $retorno['status'] = 'warning';
            }

            $resp_2 = $this->getRepositoryOrModel()->atualizaOrcBeneficioCargo($orc_id, $dado['periodo'], $dado['tipo_table']);
            if($resp_2 === false){
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg'] = 'Erro';
                $retorno['status'] = 'error';
                goto saida;
            }
            if($resp_2 == 'warning'){
                $msg = $msg.$this->getRepositoryOrModel()->getErrosFlatted().'<br>';
                $retorno['msg'] = $msg;
                $retorno['submsg'] = 'Atenção';
                $retorno['status'] = 'warning';
            }

            if($resp == 'warning' || $resp_2 == 'warning' || $resp_2 == 'warning'){
                $retorno['status'] = 'warning';
                $retorno['submsg'] = 'Atenção';
                $retorno['msg'] = $msg;
                goto saida;
            }
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted() != "" ? $retorno['msg'] : "Registro(s) inserido(s) com sucesso!";
            $retorno['submsg'] = $this->getRepositoryOrModel()->getErrosFlatted() != "" ? $retorno['submsg'] : "Sucesso";
            $retorno['status'] = $this->getRepositoryOrModel()->getErrosFlatted() != "" ? $retorno['status'] : "error";
            goto saida;
        }

        /* ---------------------------------------------------------------------------------------------- */

        $retorno_ben = $this->sp_int_orc_beneficio($orc_id, $dado['periodo'], $dado['tipo_table']);
        
        if($retorno_ben["status"]=="error"){
            $retorno['msg']="Ocorreu uma falha ao repopular tela Benefício!";
            $retorno['submsg']='Falha ao inserir o registro. Erro:270820201023';
            $retorno['status']='error';
            goto saida;
        }

        $retorno_func = $this->insert_orc_beneficio_funcionario($orc_id, $dado['periodo'], $dado['tipo_table']);

        if($retorno_func["status"]=="error"){
            $retorno['msg']="Ocorreu uma falha ao repopular tela Benefício Funcionario!"."<br>".$retorno_func['msg'];
            $retorno['submsg']='Falha ao inserir o registro. Erro:270820201024';
            $retorno['status']='error';
            goto saida;
        }

        $retorno_cargo = $this->insertOrcBeneficioCargoSP($orc_id, $dado['periodo'], $dado['tipo_table']);
           
        if($retorno_cargo["status"]=="error"){
            $retorno['msg']="Ocorreu uma falha ao repopular tela Benefício cargo!";
            $retorno['submsg']='Falha ao inserir o registro. Erro:270820201025';
            $retorno['status']='error';
            goto saida;
        }

        if($dado['tipo_table'] == 'F'){
            $retorno_cargo_calc = $this->insertOrcBeneficioCargoSPCalculo($orc_id, $dado['periodo'], $dado['tipo_table']);

            if($retorno_cargo_calc["status"]=="error"){
                $retorno['msg']="Ocorreu uma falha ao repopular tela Benefício cargo calc!";
                $retorno['submsg']='Falha ao inserir o registro. Erro:270820201026';
                $retorno['status']='error';
                goto saida;
            }

            $retorno_cargo_ind = $this->insertOrcBeneficioCargoSPIndice($orc_id, $dado['periodo'], $dado['tipo_table']);

            if($retorno_cargo_ind["status"]=="error"){
                $retorno['msg']="Ocorreu uma falha ao repopular tela Benefício cargo ind!";
                $retorno['submsg']='Falha ao inserir o registro. Erro:270820201027';
                $retorno['status']='error';
                goto saida;
            }
        }

        

        $query = $this->getRepository()->getModelEntity()::select("beneficio_id")
            ->where('orcamento_id',$orc_id)
            ->where('tipo_table',$dado['tipo_table']);

        $beneficio_ids = [];

        if($dado['tipo_table'] == 'F'){
            $beneficio_ids = $query->where('periodo', $dado['periodo'])->get()->toArray();
        }
        else{
            $beneficio_ids = $query->whereNull('periodo')->get()->toArray();
        }

        if(!empty($beneficio_ids)){
            foreach($beneficio_ids as $beneficio_id){
                $resp = $this->sp_hnd_beneficio_mov_contabil($orc_id, $beneficio_id['beneficio_id']);
                
                 if($resp["status"]=="error"){
                    $retorno['msg']="Ocorreu uma falha ao repopular tela Benefício cargo ind!";
                    $retorno['submsg']='Falha ao inserir o registro. Erro:270820201027';
                    $retorno['status']='error';
                    goto saida;
                }
            }            
        }
                        
        
                
        $retorno["status"]="success";
        $retorno["msg"]="Tabelas repopuladas com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);  
    }

    public function sp_int_orc_beneficio($orc_id, $periodo = null, $tipo_table = 'O'){
        $value  = 'Falha ao inserir registros na tela Benefícios! Erro: 260820201826';
        $usuario_id = $this->fillModificadoPor();
        DB::beginTransaction();

        try {

            if($tipo_table == 'F'){
                $sql="EXEC sp_int_orc_beneficio_forecast :orc_id, :periodo, :tipo_table, :usuario_id";

                $stmt=DB::getPdo()->prepare($sql);
    
                $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
                $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
                $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
                // dd("aquiiii", $stmt, $orc_id);
                if(!$stmt->execute()){
                    $retorno["status"]="error";
                    $retorno['msg'] = $value;
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 221220201435 | sp_int_orc_beneficio_forecast';
                    goto saida;
                }
            }
            else{
                $sql = "EXEC sp_int_orc_beneficio :orc_id, :usuario_id";

                $stmt = DB::getPdo()->prepare($sql);

                $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
                
                if(!$stmt->execute()){
                    $retorno["status"] = "error";
                    $retorno['msg'] = $value;
                    $retorno['submsg'] = 'Falha ao atualizar registro. Erro: 260820201826 | sp_int_orc_beneficio';
                    goto saida;
                }
            }
            
            $retorno["status"] = "success";
            $retorno["msg"] = " Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"] = "error";
            $retorno['msg'] = $e;
            $retorno['submsg'] = 'Falha ao fazer inserir registro. Erro: 260820201826 - ' . 'sp_int_orc_beneficio';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function insert_orc_beneficio_funcionario($orc_id, $periodo = null, $tipo_table = 'O'){
        $value  = 'Falha ao inserir registros na tela Benefício Funcionário! Erro: 270820201018';
        $usuario_id = $this->fillModificadoPor();
        DB::beginTransaction();

        try {

            if($tipo_table == 'F'){
                $sql="EXEC insert_orc_beneficio_funcionario_forecast :orc_id, :periodo, :tipo_table, :usuario_id";

                $stmt=DB::getPdo()->prepare($sql);
                $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
                $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
                $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );

                if(!$stmt->execute()){
                    $retorno["status"]="error";
                    $retorno['msg'] = $value;//$this->setError($value);
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 221220201434 | insert_orc_beneficio_funcionario_forecast';
                    goto saida;
                }
            }
            else{
                $sql="EXEC insert_orc_beneficio_funcionario :orc_id, :usuario_id";

                $stmt = DB::getPdo()->prepare($sql);
                $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT);
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT);

                if(!$stmt->execute()){
                    $retorno["status"]="error";
                    $retorno['msg'] = $value;//$this->setError($value);
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 270820201018 | insert_orc_beneficio_funcionario';
                    goto saida;
                }
            }
            

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $value.' - '.$e;//$this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 270820201018ct - ' . 'insert_orc_beneficio_funcionario';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function insertOrcBeneficioCargoSP($orc_id, $periodo = null, $tipo_table = 'O'){
        $value  = 'Falha ao inserir registros em Benefícios! Erro: 180620200937';
        $usuario_id = $this->fillModificadoPor();

        set_time_limit(700);
        DB::beginTransaction();

        try {

            if($tipo_table == 'F'){
                $sql="EXEC insert_orc_beneficio_lotacao_cargo_forecast :id_orc, :periodo, :tipo_table, :usuario_id";

                $stmt=DB::getPdo()->prepare($sql);
                $stmt->bindParam(':id_orc', $orc_id, \PDO::PARAM_INT );
                $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
                $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );

                if(!$stmt->execute()){
                    $retorno["status"]="error";
                    $retorno['msg'] = $value;//$this->setError($value);
                    $retorno['submsg']='Falha ao inserir registro. Erro: 221220201528 | insert_orc_beneficio_lotacao_cargo_forecast';
                    goto saida;
                }
            }
            else{
                $sql="EXEC insert_orc_beneficio_lotacao_cargo :id_orc, :usuario_id";

                $stmt=DB::getPdo()->prepare($sql);
                $stmt->bindParam(':id_orc', $orc_id, \PDO::PARAM_INT );
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );

                if(!$stmt->execute()){
                    $retorno["status"]="error";
                    $retorno['msg'] = $value;//$this->setError($value);
                    $retorno['submsg']='Falha ao inserir registro. Erro: 180620200938 | insert_orc_beneficio_lotacao_cargo';
                    goto saida;
                }
            }
            
            $retorno["status"]="success";
            $retorno["msg"]=" Registros inserido com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $value;//$this->setError($value);
            $retorno['submsg']='Falha ao inserir registro. Erro: 180620200939 - ' . 'insert_orc_beneficio_lotacao_cargo';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function insertOrcBeneficioCargoSPCalculo($orc_id, $periodo = null, $tipo_table = 'O'){
        $value  = 'Falha ao inserir registros em Benefícios! Erro: 180620200942';
        $usuario_id = $this->fillModificadoPor();

        DB::beginTransaction();

        try {

            if($tipo_table == 'F'){
                
                $sql="EXEC insert_orc_beneficio_lotacao_cargo_calc_forecast :id_orc, :periodo, :tipo_table, :usuario_id";

                $stmt=DB::getPdo()->prepare($sql);
                $stmt->bindParam(':id_orc', $orc_id, \PDO::PARAM_INT );
                $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
                $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );

                if(!$stmt->execute()){
                    $retorno["status"] = "error";
                    $retorno['msg'] = $value;//$this->setError($value);
                    $retorno['submsg'] = 'Falha ao inserir registro. Erro: 221220201529 | insert_orc_beneficio_lotacao_cargo_calc_forecast';
                    goto saida;
                }
            }
            else{
                $sql="EXEC insert_orc_beneficio_lotacao_cargo_calc :id_orc";

                $stmt=DB::getPdo()->prepare($sql);
                $stmt->bindParam(':id_orc', $orc_id, \PDO::PARAM_INT );

                if(!$stmt->execute()){
                    $retorno["status"] = "error";
                    $retorno['msg'] = $value;//$this->setError($value);
                    $retorno['submsg'] = 'Falha ao inserir registro. Erro: 180620200943 | insert_orc_beneficio_lotacao_cargo_calc';
                    goto saida;
                }
            }
            

            $retorno["status"] = "success";
            $retorno["msg"] = " Registros inserido com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $value;//$this->setError($value);
            $retorno['submsg']='Falha ao inserir registro. Erro: 180620200944 - ' . 'insert_orc_beneficio_lotacao_cargo_calc';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function insertOrcBeneficioCargoSPIndice($orc_id, $periodo = null, $tipo_table = 'O'){
        $value  = 'Falha ao inserir registros em Benefícios! Erro: 180620200951';
        $usuario_id = $this->fillCriadoPor();

        DB::beginTransaction();

        try {

            if($tipo_table == 'F'){
                $sql="EXEC insert_orc_beneficio_lotacao_cargo_calc_ind_forecast :id_orc, :periodo, :tipo_table, :usuario_id";

                $stmt=DB::getPdo()->prepare($sql);
                $stmt->bindParam(':id_orc', $orc_id, \PDO::PARAM_INT );
                $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
                $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
    
                if(!$stmt->execute()){
                    $retorno["status"] = "error";
                    $retorno['msg'] = $value;//$this->setError($value);
                    $retorno['submsg'] = 'Falha ao inserir registro. Erro: 180620200943 | insert_orc_beneficio_lotacao_cargo_calc_ind';
                    goto saida;
                }
            }
            else{
                $sql="EXEC insert_orc_beneficio_lotacao_cargo_calc_ind :id_orc";

                $stmt=DB::getPdo()->prepare($sql);
                $stmt->bindParam(':id_orc', $orc_id, \PDO::PARAM_INT );

                if(!$stmt->execute()){
                    $retorno["status"] = "error";
                    $retorno['msg'] = $value;//$this->setError($value);
                    $retorno['submsg'] = 'Falha ao inserir registro. Erro: 180620200943 | insert_orc_beneficio_lotacao_cargo_calc_ind';
                    goto saida;
                }
            }
            

            $retorno["status"] = "success";
            $retorno["msg"] = " Registros inserido com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $value;//$this->setError($value);
            $retorno['submsg']='Falha ao inserir registro. Erro: 180620200944 - ' . 'insert_orc_beneficio_lotacao_cargo_calc_ind';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

    public function sp_hnd_beneficio_mov_contabil($orc_id, $beneficio_id){
        $value  = 'Falha ao inserir registros na tela Benefícios! Erro: 310820200901';
        $usuario_id = $this->fillModificadoPor();

        DB::beginTransaction();

        try {

            $sql="EXEC sp_hnd_beneficio_mov_contabil :orc_id, :beneficio_id, :usuario_id";

            $stmt=DB::getPdo()->prepare($sql);

            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':beneficio_id', $beneficio_id, \PDO::PARAM_INT );
            $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
            // dd("aquiiii", $stmt, $orc_id);
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $value;//$this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 310820200901 | sp_hnd_beneficio_mov_contabil';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"] = "error";
            $retorno['submsg'] = $value;//$this->setError($value);
            $retorno['msg'] = 'Falha ao fazer inserir registro. Erro: 310820200901 - ' . 'sp_hnd_beneficio_mov_contabil - '.$e->getMessage();
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        // dd("insert clone", $retorno);
        return $retorno;
    }

    

} 