<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoOrcBonus as RepoOrcBonus;
use App\Modules\Natureza51\Entities\OrcBonus;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use \App\Core\Traits\ErrorTrait;
use App\Support\TreeTable\AtmTreeTable;
use DB;

class OrcBonusController extends Natureza51Ctrl
{
     public function __construct(){
        $this->repository=new RepoOrcBonus();

        $this->setCodTela('OB');
        parent::__construct();
    }
    // public function listAll($id){

    //     $this->podeAcessar('listar',true,$this->getCodTela());
    //     // dd($id);
    //     $data = $this->getRepository()->listar($id);
        
    //     $cont = count($data);
    //     for ($i=0; $i < $cont ; $i++) { 
    //         // var_dump($data[$i]);

    //         array_push($data,array('parent'=>$data[$i]['grade_salarial'],'grade_salarial'=>null));
    //         // dd("jfgiadfdf", $data);

    //         if($data[$i]['updated_at']!=null){
    //             $data[$i]['atualizado']='Sim';
    //         }else{
    //             $data[$i]['atualizado']='Não';
    //         }

    //     }
    //     // dd($data);
    //     $result_aux = $this->montarTreetable($data);
    //     $result = [];
    //     foreach($result_aux as $parent){
    //         $num_sal_iguais = true;
    //         $num_sal_ant = null;
    //         $porcentagem_iguais = true;
    //         $porcentagem_ant =null;

    //         foreach( $parent['children'] as $child){
                
    //             if($num_sal_ant != $child['data']['num_sal'] && !is_null($num_sal_ant)){
    //                 $num_sal_iguais = false;
                 
    //             }
    //             if($porcentagem_ant != $child['data']['porcentagem'] && !is_null($porcentagem_ant)){
    //                 $porcentagem_iguais = false;
                   
    //             }
    //             $num_sal_ant = $child['data']['num_sal'];
    //             $porcentagem_ant = $child['data']['porcentagem'];

               
    //         }
    //         if($num_sal_iguais){
    //             $parent['data']['num_sal'] = $num_sal_ant;
    //         }
    //         if($porcentagem_iguais){
    //             $parent['data']['porcentagem'] = $porcentagem_ant;
    //         }
    //         array_push($result,$parent);


    //     }
    //     // dd("result", $result);

    //     return $result ;
    // } 


    public function listAll($id, $periodo = null, $tipo_table = 'O'){
        $data = $this->getRepository()->listar($id, $periodo, $tipo_table);   
        $cont = count($data);
        for ($i=0; $i < $cont ; $i++) { 
            $data[$i] = (array) $data[$i];
            $data[(count($data))+$i] = array('parent'=>$data[$i]['grade_sal'],'grade_sal'=>null); 

        }

        return $this->montarTreetable($data);
    }   

    public function getCargoByGrade(Request $request, $orc_id){

        $this->podeAcessar('listar',true,$this->getCodTela());
        
        $all = $request->all();
        unset($all['_token']);

        $data = $this->repository->getCargoByGrade($all, $orc_id);
       

        for ($i=0; $i < count($all); $i++) { 
            $data[(count($data))+$i] = array('parent'=>$all[$i],'grade_salarial'=>null); 
        }
        return $this->montarTreetable($data);
    }
        
    public function montarTreetable($data){
        // dd ($data);
        $column_fixeds=[ 
            ["field_out"=>"parent", "from"=>"parent","render_value"=>null],
            ["field_out"=>"cod_cargo_basic", "from"=>"parent", "render_value"=>null,],

        ];
        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo", "render_value"=>null,],
            ["field_out"=>"grade_sal", "from"=>"parent", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic","from"=>"cargo", "render_value"=>null,],
            ["field_out"=>"num_sal","from"=>"num_sal", "render_value"=>null,],
            ["field_out"=>"porcentagem", "from"=>"porcentagem", "render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],
            ["field_out"=>"lotacao","from"=>"lotacao", "render_value"=>null,],

            ["field_out"=>"criado_por","from"=>"criado_por", "render_value"=>null,],
            ["field_out"=>"criado_em","from"=>"criado_em", "render_value"=>null,],
            ["field_out"=>"atualizado_por","from"=>"atualizado_por", "render_value"=>null,],
            ["field_out"=>"atualizado_em","from"=>"atualizado_em", "render_value"=>null,],
        ];
        $settings=["columns"=>$column_fixeds,
        "keys"=>['parent'],
        "filter_data"=>['grade_sal'=>function($value){
            return is_null($value);
        }],                        
        "children"=>["columns"=>$column_fixeds_children,
                "keys"=>['grade_sal','id'],
                "filter_data"=>['parent'=>function($value){
                    return is_null($value);
                 }],
                'parent_filter'=> function($value, $parent_data){                            
                        return $value['grade_sal']== $parent_data['parent'] ;
                },
            ] 
        ];
        $controller=new AtmTreeTable($settings, $data);
        return $controller->render();
    }

    public function insertBonus(Request $request, $orc_id){   
        
        $this->podeAcessar('inserir',true,$this->getCodTela());

        $form_data = $request->all();
        $tipo_table = $form_data['tipo_table'];
        $periodo = $form_data['periodo'];

        $num_sal = $form_data['num_salarial'];
        $cargos_excessoes = $form_data['cargos_excessoes'];
        $cargos_excessoes_ids = array_column($cargos_excessoes, 'cargo_id');
        $lotacoes = $form_data['lotacoes'];
        $orc_lotacao_ids = array_column($lotacoes, 'id');
        $grades = $form_data['grades'];
        $porcentagem = $form_data['porcentagem'];

        if(count($orc_lotacao_ids) == 0){ 
            $retorno["status"]="error";
            $retorno['msg'] = "Selecione as lotações para continuar.";
            $retorno['submsg']='Falha ao fazer insert do registro. Erro: 240520202257';
            goto saida;               
        }

        if(count($grades) == 0){ 
            $retorno["status"]="error";
            $retorno['msg'] = "Selecione os grades salariais para continuar.";
            $retorno['submsg']='Falha ao fazer insert do registro. Erro: 240520202257';
            goto saida;               
        }

        $lotacs = '';
        foreach ($orc_lotacao_ids as $orcs) {
            $lotacs = $lotacs . $orcs . ',';
        }
        $lotacs = substr($lotacs,0, strlen($lotacs)-1);

        $grades_condition = '';
        foreach ($grades as $grade) {
            $grades_condition = $grades_condition . " c.cod_cargo_basic LIKE '$grade%' OR";
        }
        $grades_condition = substr($grades_condition,0, strlen($grades_condition)-2);

        if(count($cargos_excessoes_ids) > 0){
            $cargs_exc_condition = 'and c.id not in(';
            foreach ($cargos_excessoes_ids as $id) {
                $cargs_exc_condition = $cargs_exc_condition . $id . ',';
            }
            $cargs_exc_condition = substr($cargs_exc_condition,0, strlen($cargs_exc_condition)-1);
            $cargs_exc_condition = $cargs_exc_condition . ')';
        }
        else{
            $cargs_exc_condition = '';
        }

        $condicao[0] = $tipo_table == 'F' ? " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo = '{$periodo}' " : " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo is null ";
        $condicao[1] = $tipo_table == 'F' ? " and oc.tipo_table = '{$tipo_table}' and oc.periodo = '{$periodo}' " : " and oc.tipo_table = '{$tipo_table}' and oc.periodo is null ";

        $data = DB::select("SELECT
            oc.id as cargo_id,
            ocas.lotacao_id as lotacao_id,
            ocas.ccusto_id as ccusto_id
            from tbl_orc_cargos_area_sal as ocas
            inner join tbl_orc_cargo oc on oc.id = ocas.cargo_id {$condicao[1]}
            inner join tbl_cargo c on c.id = oc.cargo_id
            where ocas.orcamento_id = $orc_id {$condicao[0]}
            and ocas.lotacao_id in ($lotacs)
            $cargs_exc_condition
            and ($grades_condition)
        ");
        $data_insert = [];


 
        foreach ($data as $item) {            
            $data_compare = [  
                'orc_id'    =>$orc_id,
                'cargo_id'  =>$item->cargo_id,
                'orc_lot_id'=>$item->lotacao_id,
                'ccusto_id'=>$item->ccusto_id,
                'tipo_table'=>$tipo_table
            ];
            if($tipo_table == 'F'){
                $data_compare['periodo'] = $periodo;
            }
            $existe = OrcBonus::where($data_compare)->get();
            if(count($existe) != 0){
                continue;
            }
            $data_aux = array_merge($data_compare, [
                'num_sal'   =>$num_sal,
                'porcentagem'  =>$porcentagem
            ]);

            array_push($data_insert,$data_aux);

        }
        $data_inserir =[];

        $has_error = false;
        DB::transaction(function () use ($data_insert, $data_inserir, &$retorno) {
            $j=0;
            for($i=0; $i < count($data_insert); $i++){
                $j++;
                $data_insert[$i]['created_at'] = $this->fillCriadoEm();
                $data_insert[$i]['created_by'] = $this->fillCriadoPor();
                $data_insert[$i]['user_id'] = $this->fillCriadoPor();
                $data_insert[$i]['empresa_id'] = $this->fillCodEmpresa();
                array_push($data_inserir,$data_insert[$i]);
    
    
                /*if($j==300 || $i==count($data_insert)-1){
                    if(!OrcBonus::insert($data_inserir)){ 
                        $retorno["status"]="error";
                        $retorno['msg'] = "Falha ao inserir Bônus";
                        $retorno['submsg']='Falha ao fazer insert do registro. Erro: 220520200031';
                        $has_error = true;
                        abort (500,"Falha ao inserir Bônus");        
                    }
                    $data_inserir = [];
                    $j=0;
                    
                }*/
            }

            $dados_chunk = array_chunk($data_inserir, 50);

            for($i = 0; $i < count($dados_chunk); $i++){
                if(!OrcBonus::insert($dados_chunk[$i])){ 
                    $retorno["status"]="error";
                    $retorno['msg'] = "Falha ao inserir Bônus";
                    $retorno['submsg']='Falha ao fazer insert do registro. Erro: 220520200031';
                    $has_error = true;
                    abort (500,"Falha ao inserir Bônus");        
                }
            }

        });    
        if($has_error){
            goto saida;
        }

        $retorno["status"]="success";
        $retorno["msg"]="Registro inserido com sucesso!";
        saida:       
      
        return $this->retornoJsonDefault($retorno); 
    } 

    public function updateBonus(Request $request, $orc_id){  
        
        $this->podeAcessar('editar',true,$this->getCodTela());

        $data = $request->all();
        unset($data['_token']);
        //dd($data);
        if(!$this->getRepository()->updateBonus($orc_id, $data)){                  
            $retorno["status"]="error";
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer update do registro. Erro: 271120191600';
            goto saida;               
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        saida:       
     
        return $this->retornoJsonDefault($retorno); 
    } 
 
    public function deleteBonus(Request $request,$orc_id){  
        
        $this->podeAcessar('deletar',true,$this->getCodTela());

        $data = $request->all();

        if(!$this->getRepository()->deleteBonus($orc_id,$data)){                  
            $retorno["status"]="error";
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer delete do registro. Erro: 271120191600';
            goto saida;               
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        saida:       
      
        return $this->retornoJsonDefault($retorno); 
    } 

    public function dataFilterBonus($data){
        $array_orcamento=['des_cargo_basic', 'cod_cargo_basic', '_token','grade_salarial','mai_orcado', 'jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado','tbl_origem','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','origem_id','id'];
        
        $filtered = Arr::except($data, $array_orcamento);  
               
        return $filtered;
    }
    
public function deleteBonusSeveral(Request $request,$orc_id){  
  
    $data = $request->all();
    unset($data['_token']);  
    
   for($i=0; $i<count($data);$i++){
       
        if(!$this->getRepository()->deleteBonus($orc_id,$data[$i])){                  
            $retorno["status"]="error";
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer delete do registro. Erro: 290520201550';
            goto saida;               
        } 
   }

    
    $retorno["status"]="success";
    $retorno["msg"]="Registro deletado com sucesso!";
    saida:       
  
    return $this->retornoJsonDefault($retorno); 
} 

public function getCargosExcessao(Request $request, $orc_id){
    $grades = $request->all()['grades'];
    $lotacoes = $request->all()['lotacoes'];
    $tipo_table = $request->all()['tipo_table'];
    $periodo = $request->all()['periodo'];
    
    $orc_lotacao_ids = array_column($lotacoes, 'id');
    $lotacs = '';
    foreach ($orc_lotacao_ids as $orcs) {
        $lotacs = $lotacs . $orcs . ',';
    }
    $lotacs = substr($lotacs,0, strlen($lotacs)-1);
    $grades_condition = '';
    foreach ($grades as $grade) {
        $grades_condition = $grades_condition . " c.cod_cargo_basic LIKE '$grade%' OR";
    }
    $grades_condition = substr($grades_condition,0, strlen($grades_condition)-2);

    $condicao[0] = $tipo_table == 'F' ? " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo = '{$periodo}'" : " and ocas.tipo_table = '{$tipo_table}' and ocas.periodo is null";
    $condicao[1] = $tipo_table == 'F' ? " and oc.tipo_table = '{$tipo_table}' and oc.periodo = '{$periodo}'" : " and oc.tipo_table = '{$tipo_table}' and oc.periodo is null";
    
    $data = DB::select("SELECT
        DISTINCT(c.id) as cargo_id, 
        c.des_cargo_basic, 
        c.cod_cargo_basic,
        CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as description 
        from tbl_orc_cargos_area_sal as ocas
        inner join tbl_orc_cargo oc on oc.id = ocas.cargo_id".$condicao[1]."
        inner join tbl_cargo c on c.id = oc.cargo_id
        where ocas.orcamento_id = $orc_id".$condicao[0]."
        and ocas.lotacao_id in ($lotacs)
        and ($grades_condition)"
    );

    return $data;
}

public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
       

    return parent::downloadExcel($type, 'Bonus', ['Cód Cargo','grade_sal','criado_por','criado_em','atualizado_por','atualizado_em']);
}

public function formatHeaders($colunas){ 
    for ($i=0; $i < count($colunas) ; $i++) { 
//       
        $colunas[$i] = str_replace("_", " ", $colunas[$i]);
        $colunas[$i] = str_replace("cod cargo basic", "Cód. Cargo", $colunas[$i]);
        $colunas[$i] = str_replace("des cargo basic", "Cargo", $colunas[$i]);
        $colunas[$i] = str_replace("porcentagem", "Porcentagem", $colunas[$i]);
        $colunas[$i] = str_replace("num sal", "Núm. Salarial", $colunas[$i]);
        $colunas[$i] = str_replace("lotacao", "Lotação", $colunas[$i]);



       

        }
        return $colunas;
    }

    public function populaBonusHeadcount(Request $request){
        set_time_limit(1200);
        $dados = $request->all();
        $orc_id = $dados['orc_id'];

        if($dados['tipo'] == 0){
            $resp = $this->getRepository()->atualizaBonus($orc_id, $dados['periodo'], $dados['tipo_table']);
            if($resp === false){
                $retorno["status"] = "error";
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg'] = 'Erro';
                goto saida;
            }
            if($resp === 'warning'){
                $retorno["status"] = "warning";
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg'] = 'Atenção';
                goto saida;
            }
            $retorno["status"] = $this->getRepositoryOrModel()->getErrosFlatted() != '' ? $retorno["status"] : "success";
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted() != '' ? $retorno['msg'] : "Registro(s) inserido(s) com sucesso!";
            $retorno['submsg'] = $this->getRepositoryOrModel()->getErrosFlatted() != '' ? $retorno['submsg'] : 'Sucesso!';
            goto saida;
        }

        $value  = 'Falha ao inserir registros na tela Bônus! Erro: 070120210951';
        $usuario_id = $this->fillModificadoPor();

        DB::beginTransaction();

        try {

            if($dados['tipo_table'] == 'F'){
                $sql="EXEC sp_hnd_atualiza_headcount_bonus_forecast :p_orcamento_id, :periodo, :tipo_table, :usuario_id";

                $stmt=DB::getPdo()->prepare($sql);
                $stmt->bindParam(':p_orcamento_id', $orc_id, \PDO::PARAM_INT );
                $stmt->bindParam(':periodo', $dados['periodo'], \PDO::PARAM_STR );
                $stmt->bindParam(':tipo_table', $dados['tipo_table'], \PDO::PARAM_STR );
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
                
                if(!$stmt->execute()){
                    $retorno["status"]="error";
                    $retorno['msg'] = $this->setError($value);
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 070120210951 | sp_hnd_atualiza_headcount_bonus_forecast';
                    goto saida;
                }
            }
            else{
                $sql="EXEC sp_hnd_atualiza_headcount_bonus :p_orcamento_id, :usuario_id";

                $stmt=DB::getPdo()->prepare($sql);
                $stmt->bindParam(':p_orcamento_id', $orc_id, \PDO::PARAM_INT );
                $stmt->bindParam(':usuario_id', $usuario_id, \PDO::PARAM_INT );
                
                if(!$stmt->execute()){
                    $retorno["status"]="error";
                    $retorno['msg'] = $this->setError($value);
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 020920201146 | sp_hnd_atualiza_headcount_bonus';
                    goto saida;
                }
            }
            

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao atualizar registro. Erro: 020920201146ct - '.$dados['tipo_table'].' - '. 'sp_hnd_atualiza_headcount_bonus';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        return $retorno;
    }

} 
