<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Entities\CalcIndice;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcCargo as RepoOrcCargo;
// use Symfony\Component\HttpFoundation\Request;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Http\Response;
use App\Support\TreeTable\AtmTreeTable;
use Excel;
use App\Modules\Natureza51\Repositories\RepoOrcScriptCalculos;
use Illuminate\Support\Facades\DB;

class OrcCargoSalController extends OrcamentoController
{
    
    public function __construct(){
        $this->setRepository(new RepoOrcCargo());
        $this->setCodTela('OSC');
        parent::__construct();
    }
    public function listarAll($orc_id, $periodo = null, $tipo_table = 'O'){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $result = $this->getRepository()->listAll($orc_id, $periodo, $tipo_table);
        
        if($result === false){
            $retorno = $this->getArrayRetornoDefault();
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg'] = 'Falha ao inserir o registro. Erro: 051220190952.';
            
            return $this->retornoJsonDefault($retorno);
        }
        $dados = $result->toArray();
        for($i = 0; $i < count($dados); $i++){
            $dados[$i]['identificador'] = "2";
        }
        
        return new Response(json_encode($this->renderTreeTable($dados)));
    }
    public function listarIndice($orc_id){

        $this->podeAcessar('listar',true,$this->getCodTela()); 

        $dados = $this->getRepository()->listarIndices($orc_id);

        return new Response(json_encode($this->treeTableIndice($dados)));
    }
    public function inserir(Request $request,$id=null) {
        $this->podeAcessar('inserir',true,$this->getCodTela());

        $form_data=$this->getRepositoryOrModel()->putOrcamentoIdOnData($request->all(),$id);
		
        if(!mesesValidacao(($form_data['meses_orcado']))){
            $retorno['status']='error';
            $retorno['submsg']='Os salários inseridos não podem diminuir ao longo dos meses.';
            $retorno['msg']='Erro';
            goto saida;
        }
        
        if(! $this->getRepositoryOrModel()->createOrc($form_data)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['status']='error';
            $retorno['submsg']='Falha ao inserir o registro. Erro:301120191630';
            goto saida;
        }
    
        $retorno["status"]="success";
        $retorno["msg"]="Sucesso";
        $retorno["submsg"]="Cadastro realizado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);
        
    }

    public function updateOrcCargo(\Illuminate\Http\Request $request, $id) {

        $this->podeAcessar('editar',true,$this->getCodTela());

        $form_data=$request->all();

        $meses=Arr::only($form_data,['jan_orcado','fev_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado',
        'ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);

        // $meses_indice = Arr::only($form_data,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice','jul_indice','agost_indice','set_indice','out_indice','nov_indice','dez_indice']);
        
        if($form_data['identificador'] == 1){
            // if(!validacaoIndice(convertDecimalEn($meses_indice))){
            //     $retorno['status']='error';
            //     $retorno['submsg']='Os índices inseridos não podem diminuir ao longo dos meses.';
            //     $retorno['msg']='Erro';
            //     goto saida;
            // }else{
                if(!$this->getRepositoryOrModel()->updateOrcCargoIndice($form_data)){
                    $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                    $retorno['submsg']='Falha ao deletar o registro. Erro:030420201248';
                    goto saida;
                }
            // } 
        }else{
            if(!mesesValidacao(convertDecimalEn($meses))){
                $retorno['status']='error';
                $retorno['submsg']='Os salários inseridos não podem diminuir ao longo dos meses.';
                $retorno['msg']='Erro';
                goto saida;
            }else{
                if(! $this->getRepositoryOrModel()->updateOrc($form_data)){
                    $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                    $retorno['submsg']='Falha ao deletar o registro. Erro:060120201744';
                    goto saida;
                }
            }

        }
        
        
        $retorno["status"]="success";
        $retorno['msg']="Sucesso";
        $retorno["submsg"]="Registro atualizado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);      
        
    }    

    public function deleteOrcCargo(\Illuminate\Http\Request $request, $id) {

        $this->podeAcessar('deletar',true,$this->getCodTela());

        $form_data=$request->all();
               
        if($form_data['identificador']==1){
            if(!$this->getRepositoryOrModel()->deleteOrcIndice($form_data,$id)){
                $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg']='Falha ao deletar o registro. Erro:030420201437';
                goto saida;
            }
        }else{
            if(! $this->getRepositoryOrModel()->deleteOrcCargo($form_data)){
                $retorno['status'] = 'error';
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg'] = 'Falha ao deletar o registro. Erro:060120201744';
                goto saida;
            }
        }
        
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);      
        
    }    
    
    private function renderTreeTable($dados){
         $columns_base=[ 
            ["field_out"=>"id"],
            ["field_out"=>"id_calc", "from"=>"id_calc"],            

            ["field_out"=>"cargo_id"],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic"],            
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic"],
            ["field_out"=>"orcamento_id"],
            ["field_out"=>"sal_base", "from"=>"sal_base", "render_value"=>null,],
            ["field_out"=>"sal_max", "from"=>"sal_max", "render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],
            ["field_out"=>"sal_med", "from"=>"sal_med"],
            ["field_out"=>"sal_min", "from"=>"sal_min", "render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],      
            ["field_out"=>"data_calc", "from"=>"data_calc",],
            ["field_out"=>"identificador", "from"=>"identificador",],
            ["field_out"=>"criado_por", "from"=>"criado_por",],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por",],

            ["field_out"=>"atualizado_data", "from"=>"atualizado_data",],
            ["field_out"=>"criado_data", "from"=>"criado_data",],

            ['field_out'=>'jan_orcado',"from"=>'jan_orcado',"render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],
            ['field_out'=>'fev_orcado',"from"=>'fev_orcado',"render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],
            ['field_out'=>'mar_orcado',"from"=>'mar_orcado',"render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],
            ['field_out'=>'abr_orcado',"from"=>'abr_orcado',"render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],
            ['field_out'=>'mai_orcado',"from"=>'mai_orcado',"render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],
            ['field_out'=>'jun_orcado',"from"=>'jun_orcado',"render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],
            ['field_out'=>'jul_orcado',"from"=>'jul_orcado',"render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],
            ['field_out'=>'ago_orcado',"from"=>'ago_orcado',"render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],
            ['field_out'=>'set_orcado',"from"=>'set_orcado',"render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],
            ['field_out'=>'out_orcado',"from"=>'out_orcado',"render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],
            ['field_out'=>'nov_orcado',"from"=>'nov_orcado',"render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],
            ['field_out'=>'dez_orcado',"from"=>'dez_orcado',"render_value"=>function($row_data, $value){
                return number_format($value,4,',', '.');
            }],

        ];
        $settings=["columns"=>$columns_base,
                "keys"=>['id' ] 
            ];    
         
        $controller=new AtmTreeTable($settings, $dados);
        
      return $controller->render();
    }

    private function treeTableIndice($dados){
        $columns_base=[ 
           ["field_out"=>"id"],
           ["field_out"=>"id_calc", "from"=>"id_calc"],            

           ["field_out"=>"cargo_id"],
           ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic"],            
           ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic"],
           ["field_out"=>"orcamento_id"],
           ["field_out"=>"sal_base", "from"=>"sal_base", "render_value"=>null,],
           ["field_out"=>"sal_max", "from"=>"sal_max", "render_value"=>null,],
           ["field_out"=>"sal_med", "from"=>"sal_med"],
           ["field_out"=>"sal_min", "from"=>"sal_min" ],      
           ["field_out"=>"data_calc", "from"=>"data_calc",],
           ["field_out"=>"identificador", "from"=>"identificador",],
           ["field_out"=>"jan_indice", "from"=>"jan_indice","render_value"=>function($row_data, $value){
            return number_format($value,4,',', '.');
        }],
           ["field_out"=>"fev_indice", "from"=>"fev_indice","render_value"=>function($row_data, $value){
            return number_format($value,4,',', '.');
        }],
           ["field_out"=>"marc_indice", "from"=>"marc_indice","render_value"=>function($row_data, $value){
            return number_format($value,4,',', '.');
        }],     
           ["field_out"=>"abril_indice", "from"=>"abril_indice","render_value"=>function($row_data, $value){
            return number_format($value,4,',', '.');
        }], 
           ["field_out"=>"maio_indice", "from"=>"maio_indice","render_value"=>function($row_data, $value){
            return number_format($value,4,',', '.');
        }],     
           ["field_out"=>"jun_indice", "from"=>"jun_indice","render_value"=>function($row_data, $value){
            return number_format($value,4,',', '.');
        }],     
           ["field_out"=>"jul_indice", "from"=>"jul_indice","render_value"=>function($row_data, $value){
            return number_format($value,4,',', '.');
        }],     
           ["field_out"=>"agost_indice", "from"=>"agost_indice","render_value"=>function($row_data, $value){
            return number_format($value,4,',', '.');
        }],     
           ["field_out"=>"set_indice", "from"=>"set_indice","render_value"=>function($row_data, $value){
            return number_format($value,4,',', '.');
        }],    
           ["field_out"=>"out_indice", "from"=>"out_indice","render_value"=>function($row_data, $value){
            return number_format($value,4,',', '.');
        }],    
           ["field_out"=>"nov_indice", "from"=>"nov_indice","render_value"=>function($row_data, $value){
            return number_format($value,4,',', '.');
        }],    
           ["field_out"=>"dez_indice", "from"=>"dez_indice","render_value"=>function($row_data, $value){
            return number_format($value,4,',', '.');
        }]

       ];
       $settings=["columns"=>$columns_base,
               "keys"=>['id' ] 
           ];    
        
       $controller=new AtmTreeTable($settings, $dados);
       
     return $controller->render();
   }

    public function listarCargo($orc_id){
        
        
        $result = $this->getRepository()->listarCargo($orc_id);
        
        if($result==false){
            $retorno=$this->getArrayRetornoDefault();
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao listar os cargos. Erro: 051220190952.';
            return $this->retornoJsonDefault($retorno);
        }
        return $result;
    }

    public function listarCargoForecast($orc_id, $periodo){
        $result = $this->getRepository()->listarCargoForecast($orc_id, $periodo);
        
        if($result === false){
            $retorno = $this->getArrayRetornoDefault();
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg'] = 'Falha ao listar os cargos. Erro: 171220200952.';
            return $this->retornoJsonDefault($retorno);
        }
        return $result;
    }

    public function cargoExistenteOrc(){
        $cargo = 12;
        $orc_id = 1;

        $result = $this->getRepository()->cargoExistenteOrc($cargo, $orc_id);

        return $result;
    }

    public function populaSalCargo(Request $request){

        // $this->podeAcessar('atualizar',true,$this->getCodTela());
        $dado = $request->all();
        $orc_id = $dado['orc_id'];

        if($dado['tipo'] == 0){
            $ret = $this->getRepositoryOrModel()->atualizaSalCargo($orc_id, $dado['periodo'], $dado['tipo_table']);

            if($ret === false){
                $retorno['submsg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['status'] = 'error';
                $retorno['msg'] = 'Erro';
                goto saida;
            }
            if($ret === 'warning'){
                $retorno['submsg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['status'] = 'warning';
                $retorno['msg'] = 'Atenção';
                goto saida;
            }
        }
        else if($dado['tipo'] == 2){
            if(!$this->getRepositoryOrModel()->atualizaSalarios($orc_id, $dado['periodo'], $dado['tipo_table'])){
                $retorno['submsg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['status'] = 'error';
                $retorno['msg'] = 'Erro';
                goto saida;
            }
        }
        else{
            $ret = $this->getRepositoryOrModel()->populaSalCargo($orc_id, $dado['periodo'], $dado['tipo_table']);
            if($ret['status'] != "success"){
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['status'] = 'error';
                $retorno['submsg'] = 'Falha ao inserir o registro. Erro:301120191630';
                goto saida;
            }
        }
        
        $retorno["status"] = "success";
        $retorno["msg"] = "Sucesso";
        $retorno["submsg"] = "Atualização realizada com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
       

        return parent::downloadExcel($type, 'SalarioCargo', ['id_calc','Lotação','des_unid_lotac','cargo_id', 'orcamento_id', 'identificador', 'sal_maior', 'sal_med', 'data_calc', 'origem_id', 'lotacao_id','id_calc']);
    } 
    public function formatHeaders($colunas){ 
        for ($i=0; $i < count($colunas) ; $i++) { 
            // dd(json_decode($_POST['array_imprimir']));
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("cod cargo basic", "Cód. Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("des cargo basic", "Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("sal base", "Salário médio", $colunas[$i]);
            $colunas[$i] = str_replace("sal min", "Salário ini.", $colunas[$i]);
            $colunas[$i] = str_replace("sal max", "Salário fim", $colunas[$i]);

            // 'Cargo','Lotação','des_unid_lotac','des_cargo_basic',

            $colunas[$i] = str_replace("criado por", "Criado por", $colunas[$i]);
            $colunas[$i] = str_replace("criado data", "Data criação", $colunas[$i]);
            $colunas[$i] = str_replace("atualizado por", "Atualizado por", $colunas[$i]);
            $colunas[$i] = str_replace("atualizado data", "Data atualização", $colunas[$i]);

            $colunas[$i] = str_replace("jan orcado", "Janeiro", $colunas[$i]);
            $colunas[$i] = str_replace("fev orcado", "Fevereiro", $colunas[$i]);
            $colunas[$i] = str_replace("mar orcado", "Março", $colunas[$i]);
            $colunas[$i] = str_replace("abr orcado", "Abril", $colunas[$i]);
            $colunas[$i] = str_replace("mai orcado", "Maio", $colunas[$i]);
            $colunas[$i] = str_replace("jun orcado", "Junho", $colunas[$i]);
            $colunas[$i] = str_replace("jul orcado", "Julho", $colunas[$i]);
            $colunas[$i] = str_replace("ago orcado", "Agosto", $colunas[$i]);
            $colunas[$i] = str_replace("set orcado", "Setembro", $colunas[$i]);
            $colunas[$i] = str_replace("out orcado", "Outubro", $colunas[$i]);
            $colunas[$i] = str_replace("nov orcado", "Novembro", $colunas[$i]);
            $colunas[$i] = str_replace("dez orcado", "Dezembro", $colunas[$i]);

        }
        return $colunas;
    }
    public function deleteAll($orc_id){
        $resp = $this->getRepository()->deleteAll($orc_id);
        if(!$resp){
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            goto saida;
        }
        
        if($resp === 'warning'){
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['status'] = 'warning';
            $retorno['submsg'] = 'Atenção';
            goto saida;
        }

        $retorno["status"] = "success";
        $retorno["submsg"] = "Sucesso";
        $retorno["msg"] = "Registros deletados com successo!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function deleteAllForecast($orc_id, $periodo, $tipo_table){
        $resp = $this->getRepository()->deleteAll($orc_id, $periodo, $tipo_table);
        if(!$resp){
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['status'] = 'error';
            $retorno['submsg'] = 'Erro';
            goto saida;
        }

        if($resp === 'warning'){
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['status'] = 'warning';
            $retorno['submsg'] = 'Atenção';
            goto saida;
        }
        
        $retorno["status"] = "success";
        $retorno["submsg"] = "Sucesso";
        $retorno["msg"] = "Registros deletados com successo!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function obtSalarioMedio($cargo_id, $lotacao_id){
        
        $lot_id = DB::select("SELECT lotacao_id from tbl_orc_lotacao where id = {$lotacao_id} ")[0]->lotacao_id;
        
        $select = DB::select("SELECT CASE (select count(*) from tbl_funcionario where cargo_id = {$cargo_id} and lotacao_id = {$lot_id})
            when 0 then
                (select salario_min from tbl_cargo where id = {$cargo_id})
            else
                (select avg(func.salario) from tbl_funcionario as func
                    --inner join tbl_orc_cargo as oca on oca.cargo_id = func.cargo_id
                    where func.cargo_id = {$cargo_id} and lotacao_id = {$lot_id}--oca.id = oc.id
                ) end as sal_med
            ");

        if(count($select) > 0 && $select[0]->sal_med != 0){
            $select[0]->sal_med = number_format($select[0]->sal_med, '4', ',', '.');
            return $select;
        }
        else{
            $select = DB::select("SELECT salario_min as sal_med from tbl_cargo where id = ?", [$cargo_id]);
            if(count($select) > 0){
                $select[0]->sal_med = number_format($select[0]->sal_med, '4', ',', '.');
            }
            return count($select) > 0 ? $select : '0';
        }
    }
   
    public function cargosGrade($orc_id, $periodo){
        $decrypted = json_decode(safeDecrypt(request()->bearerToken()),true);
        $cdn_func = $decrypted['token']['func_data']['cdn_funcionario'];
        
        $grade = null;
        if($decrypted['token']['tipo_user'] != 3){
            $grade = DB::select("SELECT left(c.cod_cargo_basic,2) as grade from tbl_funcionario as f
            inner join tbl_cargo as c on c.id = f.cargo_id
            where f.cdn_funcionario = $cdn_func");
        }
        
        $where = '';
        if($grade != null){
            $where = " and LEFT(c.cod_cargo_basic, 2) <= {$grade[0]->grade}";
        }
        
        $dados = DB::select("SELECT c.des_cargo_basic, oc.sal_base, c.salario,
            c.salario_max, c.salario_min, c.cod_cargo_basic, oc.id, oc.cargo_id,
            concat(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as 'description'
            from tbl_orc_cargo as oc
            inner join tbl_cargo as c on c.id = oc.cargo_id
            where orcamento_id = $orc_id and oc.periodo = '{$periodo}' and oc.tipo_table = 'F'".$where);

        return $dados;
    }

    public function listarUltimoPeriodoParamForecast($orc_id){
        $periodo = DB::select("SELECT max(periodo) as periodo from tbl_orc_cargo where orcamento_id = $orc_id and tipo_table = 'F' ");
        $senao = array('periodo'=>0);
        return count($periodo) > 0 ? $periodo : $senao;
    }
}
