<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcCronograma;
use Illuminate\Http\Request as Request;
use Illuminate\Support\Facades\DB;

class OrcCronogramaController extends OrcamentoController
{
    public function __construct(){
        $this->setRepository(new RepoOrcCronograma());
        $this->setCodTela('LA');
        parent::__construct();
    }

    public function list(Request $request){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $orc_id = $request->all()[0];
       return $this->getRepository()->listar($orc_id);
    }

    public function verify(){
        return $this->getRepository()->verifyBudget();
    }

    public function insertAll(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $all = $request->all();
        $retorno = $this->getRepository()->insertCronograma($all);
        
        if(!$retorno){
            $r['status']='error';
            $r['msg']=$this->getRepository()->getErrosFlatted();
            goto saida;
        }
        $r['status']='success';
        $r['msg']='Registro inserido com sucesso!';
        saida:
        return $r;
    }

    public function updateAll(Request $request){
        $this->podeAcessar('editar',true,$this->getCodTela());

        $all = $request->all();
        $r = $this->getArrayRetornoDefault();
        $retorno = $this->getRepository()->updated($all, $all['id']);
        
        if(!$retorno){
            $r['status']='error';
            $r['msg']=$this->getRepository()->getErrosFlatted();
            $r['submsg']='Falha ao atualizar o registro!';
            goto saida;
        }
        $r['status']='success';
        $r['msg']='Registro atualizado com sucesso!';
        saida:
        return $r;
    }

    public function deleteAll(Request $request){
        $this->podeAcessar('deletar',true,$this->getCodTela());
        $all = $request->all();
        $retorno = $this->getRepository()->deleteCronograma($all);
        
        if(!$retorno){
            $r['status']='error';
            $r['msg']=$this->getRepository()->getErrosFlatted();
            $r['submsg']='Falha ao atualizar registro';
            goto saida;
        }
        $r['status']='success';
        $r['msg']='Registro deletado com sucesso!';
        $r['submsg']='Registro deletado com sucesso!';

        saida:
        return $r;
    }
    public function insertWithLotacao(Request $request){
        $dados = $request->all();
        $retorno = $this->getArrayRetornoDefault();
        // $cont = 0;

        // for($i = 0; $i<count($dados['orc_lotacao_id']); $i++){
        //     $select = $this->getRepository()->getModelEntity()
        //     ->select()
        //     ->where([
        //         [$this->getRepository()->getModelEntity()->getColunaAlias('orc_lotacao_id'),'=',$dados['orc_lotacao_id'][$i]],
        //         [$this->getRepository()->getModelEntity()->getColunaAlias('activity_id'),'=',$dados['activity_id']]
        //     ])->get()->toArray();
            
        //     if(count($select) > 0){
        //         $retorno['status'] = 'error';
        //         $retorno['msg'] = ($i+1).' ª Lotação já foi cadastrada.';
        //         $retorno['submsg'] = 'Erro!';
        //         goto saida;
        //     }
        //     $cont++;
        // }
        // if($cont != count($dados['orc_lotacao_id'])){
        //     $retorno['status'] = 'error';
        //     $retorno['submsg'] = 'Não foi possível inserir o registro!. Erro: 210520201640';
        //     $retorno['msg'] = 'Erro!';
        //     goto saida;
        // }

        for($i = 0; $i < count( $dados['orc_lotacao_id'] ); $i++){

            // if(!$this->getRepositoryOrc()->getRespEstrutura($dados['orcamento_id'],$dados['orc_lotacao_id'][$i])){
            //     $retorno['status'] = 'error';
            //     $retorno['msg'] = 'Impossível acessar a '.($i+1).'ª Lotação selecionada';
            //     $retorno['submsg'] = 'Erro!';
            //     goto saida;
            // }
            if(!$this->getRepositoryOrc()){
                $retorno['status'] = 'error';
                $retorno['msg'] = 'Impossível acessar a '.($i+1).'ª Lotação selecionada';
                $retorno['submsg'] = 'Erro!';
                goto saida;
            }
            $select = [];
            $select = $this->getRepository()->getModelEntity()
            ->select()
            ->where([
                [$this->getRepository()->getModelEntity()->getColunaAlias('orc_lotacao_id'),'=',$dados['orc_lotacao_id'][$i]],
                [$this->getRepository()->getModelEntity()->getColunaAlias('activity_id'),'=',$dados['activity_id']]
            ])->get()->toArray();
                
            $data = array(
                "orcamento_id" => $dados['orcamento_id'],
                "activity_id" => $dados['activity_id'],
                "orc_lotacao_id" => $dados['orc_lotacao_id'][$i],
                "status" => $dados['status'],
                "start_date" => str_replace("/", "-", $dados['start_date']),
                "end_date" => str_replace("/", "-", $dados['end_date']),
                "tipo_table" => $dados['tipo_table']
            );
            if($dados['tipo_table'] == 'F'){
                $data['periodo'] = $dados['periodo'];
            }
            $resp = count($select) == 0 ? $this->getRepository()->insertAtvLotacao($data) : $this->getRepository()->updateAtvLotacao($data, $select[0]['id']);
            
            if(!$resp){
                $retorno['status'] = 'error';
                $retorno['submsg'] = $this->getRepository()->getErrosFlatted();
                $retorno['msg'] = 'Erro!';
                goto saida;
            }
        }
        
       
        $retorno['status']='success';
        $retorno['submsg']='Registro inserido com sucesso!';
        $retorno['msg']='Sucesso';
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function listarLotacaoAtv($orc_id, $periodo = null, $tipo_table = 'O'){
        return $this->getRepository()->listarLotacaoAtividade($orc_id, $periodo, $tipo_table);
    }
} 