<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Entities\CalcIndice;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Despesas;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Repositories\RepoLotacao;
use App\Modules\Natureza51\Repositories\RepoOrcDespesas as RepoOrcDespesas;
use App\Modules\Natureza51\Repositories\RepoOrcLotacao;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class OrcDespesasController extends Natureza51Ctrl{
    public function __construct()
    {
        $this->repository=new RepoOrcDespesas();
        $this->setCodTela('OD');
        return parent::__construct();
    } 
    public function listarDesp($orc_id, $periodo = null, $tipo_table = 'O'){
        $this->podeAcessar('listar',true,$this->getCodTela());
        // $all=$this->getRepository()->getModelEntity()->get()->toArray();
        $all=$this->getRepository()->listar($orc_id, $periodo, $tipo_table);
        //$dados=$this->getRepository()->getDescricao($orc_id,$all);

        $tree=$this->renderTreeTableList($all);
        return new Response(json_encode($tree), 200);
    }
    public function listarIndiceDesp($orc_id){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $decrypted = json_decode(safeDecrypt(request()->bearerToken()),true);

        $indices = $this->getRepository()->listarIndices($orc_id);
        
        return new Response(json_encode($this->treeTableIndice($indices)), 200);
    }
    function treeTableIndice($dados){
        $columns_base=[ 
            ["field_out"=>"id", "from"=>"id"],
            ["field_out"=>"des_unid_lotac", "from"=>"des_unid_lotac"],
            ["field_out"=>"descricao", "from"=>"descricao"],
            ["field_out"=>"despesa_id", "from"=>"despesa_id"],
            ["field_out"=>"orc_lotacao_id", "from"=>"orc_lotacao_id"],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id"],
            ["field_out"=>"valor_referencia", "from"=>"valor_referencia","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            }],
            ["field_out"=>"centro_custo_id", "from"=>"centro_custo_id"],
            ["field_out"=>"orc_id", "from"=>"orc_id"],            
            ["field_out"=>"origem_id", "from"=>"origem_id"], 
            ["field_out"=>"tbl_origem", "from"=>"tbl_origem"],
            ["field_out"=>"identificador", "from"=>"identificador"],
            ["field_out"=>"calc_ind", "from"=>"calc_ind"],

           ["field_out"=>"jan_indice", "from"=>"jan_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],
           ["field_out"=>"fev_indice", "from"=>"fev_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],
           ["field_out"=>"marc_indice", "from"=>"marc_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],     
           ["field_out"=>"abril_indice", "from"=>"abril_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }], 
           ["field_out"=>"maio_indice", "from"=>"maio_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],     
           ["field_out"=>"jun_indice", "from"=>"jun_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],     
           ["field_out"=>"jul_indice", "from"=>"jul_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],     
           ["field_out"=>"agost_indice", "from"=>"agost_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],     
           ["field_out"=>"set_indice", "from"=>"set_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],    
           ["field_out"=>"out_indice", "from"=>"out_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],    
           ["field_out"=>"nov_indice", "from"=>"nov_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }],    
           ["field_out"=>"dez_indice", "from"=>"dez_indice","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
        }]
       ];
        
        
       $settings=["columns"=>$columns_base,
               "keys"=>['id'] 
           ];    
           
       $controller=new AtmTreeTable($settings, $dados);
       
     return $controller->render();
    }
    function renderTreeTableList($dados){
        $columns_base=[ 
            ["field_out"=>"id", "from"=>"id"],
            ["field_out"=>"orc_id", "from"=>"orc_id"],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id"],
            ["field_out"=>"despesa_id", "from"=>"despesa_id"],
            ["field_out"=>"centro_custo_id", "from"=>"centro_custo_id"],

            ["field_out"=>"des_unid_lotac", "from"=>"des_unid_lotac"],
            ["field_out"=>"descricao", "from"=>"descricao"],
            ["field_out"=>"origem_id", "from"=>"origem_id"], 
            ["field_out"=>"tbl_origem", "from"=>"tbl_origem"],
            ["field_out"=>"identificador", "from"=>"identificador"],
            ["field_out"=>"lotacao", "from"=>"lotacao"],

            ["field_out"=>"criado_por", "from"=>"criado_por"],
            ["field_out"=>"criado_em", "from"=>"criado_em"],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por"],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em"],

            ["field_out"=>"calc_orc", "from"=>"calc_orc","render_value"=>null],
            ["field_out"=>"valor_referencia", "from"=>"valor_referencia","render_value"=>function($row_data, $value){
                return number_format($value, 4, ',', '.');
            }],
            ["field_out"=>"jan_orcado", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
                return number_format($value, 4, ',', '.');
            }],
            ["field_out"=>"fev_orcado", "from"=>"fev_orcado","render_value"=>function($row_data, $value){
                return number_format($value, 4, ',', '.');
            }],
            ["field_out"=>"mar_orcado", "from"=>"mar_orcado","render_value"=>function($row_data, $value){
                return number_format($value, 4, ',', '.');
            }],     
            ["field_out"=>"abr_orcado", "from"=>"abr_orcado","render_value"=>function($row_data, $value){
                return number_format($value, 4, ',', '.');
            }], 
            ["field_out"=>"mai_orcado", "from"=>"mai_orcado","render_value"=>function($row_data, $value){
                return number_format($value, 4, ',', '.');
            }],     
            ["field_out"=>"jun_orcado", "from"=>"jun_orcado","render_value"=>function($row_data, $value){
                return number_format($value, 4, ',', '.');
            }],     
            ["field_out"=>"jul_orcado", "from"=>"jul_orcado","render_value"=>function($row_data, $value){
                return number_format($value, 4, ',', '.');
            }],     
            ["field_out"=>"ago_orcado", "from"=>"ago_orcado","render_value"=>function($row_data, $value){
                return number_format($value, 4, ',', '.');
            }],     
            ["field_out"=>"set_orcado", "from"=>"set_orcado","render_value"=>function($row_data, $value){
                return number_format($value, 4, ',', '.');
            }],    
            ["field_out"=>"out_orcado", "from"=>"out_orcado","render_value"=>function($row_data, $value){
                return number_format($value, 4, ',', '.');
            }],    
            ["field_out"=>"nov_orcado", "from"=>"nov_orcado","render_value"=>function($row_data, $value){
                return number_format($value, 4, ',', '.');
            }],    
            ["field_out"=>"dez_orcado", "from"=>"dez_orcado","render_value"=>function($row_data, $value){
                return number_format($value, 4, ',', '.');
            }]
       ];
        
        
       $settings=["columns"=>$columns_base,
               "keys"=>['id'] 
           ];    
           
       $controller=new AtmTreeTable($settings, $dados);
       
     return $controller->render();
    }

    public function insert(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $tbl_calc_orc = new CalcOrcamento();
        // $tbl_calc_ind = new CalcIndice();

        $dados = $request->all();
        
        $retorno = $this->getArrayRetornoDefault();
        //$obj=$this->getRepository()->insertWithMeses($dados);
        // if($dados['tipo_meses']==0){
        //     $retorno['status']='warning';
        //     $retorno['submsg']='Selecione um Tipo.';
        //     $retorno['msg']='Atenção';
        //     goto saida;
        // }

        /*não é usado matheus(22/12/2020)-> $meses=Arr::only($dados,['jan_orcado','fev_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado',
        'ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);*/

        // $meses=Arr::only($dados,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice','jul_indice',
        // 'agost_indice','set_indice','out_indice','nov_indice','dez_indice']);

        // if(!mesesNull($meses,2)){
        //     $retorno['status']='error';
        //     $retorno['msg']='Os salários inseridos não podem diminuir ao longo dos meses.';
        //     $retorno['submsg']='Os salários inseridos não podem diminuir ao longo dos meses. Erro: 230320200925';
        //     goto saida;
        // }

        // não é usado matheus(22/12/2020) -> $cont = 0;

        // for($i = 0; $i<count($dados['despesa_id']); $i++){

            $query = $this->getRepository()->getModelEntity()->select()->where([
                [$this->getRepository()->getModelEntity()->getColunaAlias('orc_id'),'=',$dados['orc_id']],
                [$this->getRepository()->getModelEntity()->getColunaAlias('despesa_id'),'=',$dados['despesa_id']],
                [$this->getRepository()->getModelEntity()->getColunaAlias('centro_custo_id'),'=',$dados['centro_custo_id']],
                [$this->getRepository()->getModelEntity()->getColunaAlias('lotacao_id'),'=',$dados['lotacao_id']],
                [$this->getRepository()->getModelEntity()->getColunaAlias('tipo_table'),'=',$dados['tipo_table']]
            ]);

            $despesas = [];
            if($dados['tipo_table'] == 'F'){
                $despesas = $query->where('periodo', $dados['periodo'])->get()->toArray();
            }
            else{
                $despesas = $query->whereNull('periodo')->get()->toArray();
            }
            

            if(count($despesas)>0){
                
                // $select_calc_orc = $tbl_calc_orc->select()->where([
                //     [$tbl_calc_orc->getColunaAlias('origem_id'),'=',$despesas[0]['id']],
                //     [$tbl_calc_orc->getColunaAlias('tbl_origem'),'=',$this->getRepository()->getModelEntity()->getTable()]
                // ])->get()->toArray();
    
                // if($dados['tipo_meses']==2)
                // {
                    
                    // if(count($select_calc_orc)>0)
                    // {
                        $retorno['msg'] = "Despesa já existente. Erro: 140420201502";
                        goto saida;
                    // }
                //}
         
            }
        // }
         
        // for($i=0;$i<count($dados['despesa_id']);$i++){
        
            $data = array("despesa_id"=>$dados['despesa_id'],"valor_referencia"=>$dados['valor_referencia']);
            
            $obj = $this->getRepository()->insertWithMeses(array_merge($dados,$data));
            if(!$obj){
                $retorno['status']='error';
                $retorno['submsg']='Erro';
                $retorno['msg']=$this->getRepository()->getErrosFlatted();
                goto saida;        
            }
        // }
        $retorno['status']='success';
        $retorno['submsg']='Registro inserido com sucesso!';
        $retorno['msg']='Sucesso';
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function delete(Request $request){
        $this->podeAcessar('deletar',true,$this->getCodTela());
        $data=$request->all();
        $retorno=$this->getArrayRetornoDefault();

        if($data['identificador']==1){
            if(!$this->getRepositoryOrModel()->deleteDespesaIndice($data)){
                $retorno['status']='error';
                $retorno['submsg']='Falha ao excluir registro! erro:020420201555';
                $retorno['msg']=$this->getRepository()->getErrosFlatted();
                goto saida;
            }
        }
        else{
            $obj=$this->getRepository()->deleteDespesa($data);
            
            if(!$obj){
                $retorno['status']='error';
                $retorno['submsg']='Falha ao excluir registro! erro:110220201625';
                $retorno['msg']=$this->getRepository()->getErrosFlatted();
                goto saida;
            }
        }

        $retorno['status']='success';
        $retorno['submsg']='Registro excluido com sucesso!';
        $retorno['msg']='Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function updateDespCalc(Request $request){
        $this->podeAcessar('editar',true,$this->getCodTela());
        $data=$request->all();
        
        $retorno=$this->getArrayRetornoDefault();
        
        /* sem uso - matheus (22/12/2020)
        $meses=Arr::only($data,['jan_orcado','fev_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado',
        'ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);

        $meses_indice = Arr::only($data,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice','jul_indice','agost_indice','set_indice','out_indice','nov_indice','dez_indice']);
        */
        if($data['identificador']=="1"){
            // if(!mesesNull($meses_indice,1)){
            //     $retorno['status']='error';
            //     $retorno['msg']='Por favor, insira valores nos campos de índices.';
            //     $retorno['submsg']='Erro';
            //     goto saida;
            // }
            // if(!validacaoIndice(convertDecimalEn($meses_indice))){
            //     $retorno['status']='error';
            //     $retorno['msg']='Os índices inseridos não podem diminuir ao longo dos meses.';
            //     $retorno['submsg']='Os índices inseridos não podem diminuir ao longo dos meses. Erro: 060420201214';
            //     goto saida;
            // }
            // else{
                if(!$this->getRepository()->updateDespIndice($data)){
                    $retorno['status']='error';
                    $retorno['submsg']='Falha ao atualizar registro. erro: 020420201521!';
                    $retorno['msg']=$this->getRepository()->getErrosFlatted();
                    goto saida;
                }
            // }
            
        }
        else{
            // if(!mesesNull($meses_indice,2)){
            //     $retorno['status']='error';
            //     $retorno['msg']='Por favor, insira valores nos campos de índices.';
            //     $retorno['submsg']='Erro';
            //     goto saida;
            // }
            // if(!mesesValidacao(convertDecimalEn($meses))){
            //     $retorno['status']='error';
            //     $retorno['msg']='Os salários inseridos não podem diminuir ao longo dos meses.';
            //     $retorno['submsg']='Os salários inseridos não podem diminuir ao longo dos meses. Erro: 230320201021';
            //     goto saida;
            // }else
            // {
            $obj=$this->getRepository()->updateDespCalc($data,$data['id'],"id");
                if(!$obj){
                    $retorno['status']='error';
                    $retorno['submsg']='Erro';
                    $retorno['msg']=$this->getRepository()->getErrosFlatted().'Falha ao atualizar registro. erro: 110220201550!';
                    goto saida;
                }
            // }
        }
        $retorno['status']='success';
        $retorno['submsg']='Registro atualizado com sucesso!';
        $retorno['msg']='Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
       

        return parent::downloadExcel($type, 'Despesas', ['orc_id','lotacao_id','despesa_id','centro_custo_id','origem_id','tbl_origem','identificador','calc_orc','criado_por','criado_em','atualizado_por','atualizado_em']);
    }
    
    public function formatHeaders($colunas){ 
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("valor referencia", "Valor de referência", $colunas[$i]);
            $colunas[$i] = str_replace("des unid lotac", "Lotação", $colunas[$i]);
            $colunas[$i] = str_replace("descricao", "Despesa", $colunas[$i]);
            $colunas[$i] = str_replace("jan orcado", "Janeiro", $colunas[$i]);
            $colunas[$i] = str_replace("fev orcado", "Fevereiro", $colunas[$i]);
            $colunas[$i] = str_replace("mar orcado", "Março", $colunas[$i]);
            $colunas[$i] = str_replace("abr orcado", "Abril", $colunas[$i]);
            $colunas[$i] = str_replace("mai orcado", "Maio", $colunas[$i]);
            $colunas[$i] = str_replace("jun orcado", "Junho", $colunas[$i]);
            $colunas[$i] = str_replace("jul orcado", "Julho", $colunas[$i]);
            $colunas[$i] = str_replace("ago orcado", "Agosto", $colunas[$i]);
            $colunas[$i] = str_replace("set orcado", "Setembro", $colunas[$i]);
            $colunas[$i] = str_replace("out orcado", "Outubro", $colunas[$i]);
            $colunas[$i] = str_replace("nov orcado", "Novembro", $colunas[$i]);
            $colunas[$i] = str_replace("dez orcado", "Dezembro", $colunas[$i]);
    
    
        }
        return $colunas;
    }
}