<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoOrcDissidio;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Http\Request;

class OrcDissidioController extends OrcamentoController{
    
    public function __construct(){
        parent::__construct();
        $this->setCodTela('AC');
        $this->repository=new RepoOrcDissidio();
    } 

    public function listarAll($orc_id, $periodo = null, $tipo_table = 'O'){

        $this->podeAcessar('listar',true,$this->getCodTela());

         $list = $this->getRepository()->listar($orc_id, $periodo, $tipo_table);
        //  dd("Lista",$this->montarTreetable($list));
        //  $result = $this->montarTreetable($list);
         $result_aux = $this->montarTreetable($list);
         $result = [];
         foreach($result_aux as $parent){
             $meses = [  'jan_orcado', 'fev_orcado', 'mar_orcado', 'abr_orcado','mai_orcado', 'jun_orcado',
                         'jul_orcado', 'ago_orcado', 'set_orcado', 'out_orcado', 'nov_orcado', 'dez_orcado' ];
             $mesesIguais =[ 'jan_orcado'=>true, 'fev_orcado'=>true, 'mar_orcado'=>true, 'abr_orcado'=>true,
                             'mai_orcado'=>true, 'jun_orcado'=>true, 'jul_orcado'=>true, 'ago_orcado'=>true,
                             'set_orcado'=>true, 'out_orcado'=>true, 'nov_orcado'=>true, 'dez_orcado'=>true
                     ];
             $mesesAnt =[    'jan_orcado'=>null, 'fev_orcado'=>null, 'mar_orcado'=>null, 'abr_orcado'=>null,
                             'mai_orcado'=>null, 'jun_orcado'=>null, 'jul_orcado'=>null, 'ago_orcado'=>null,
                             'set_orcado'=>null, 'out_orcado'=>null, 'nov_orcado'=>null, 'dez_orcado'=>null
                     ];
 
             foreach( $parent['children'] as $child){
                    //    dd("result", $child);

                 foreach ($meses as $mes) {                    
                     if($mesesAnt[$mes] != $child['data'][$mes] && !is_null($mesesAnt[$mes])){
                         $mesesIguais[$mes] = false;                 
                     }
                     $mesesAnt[$mes] = $child['data'][$mes];
                 }        

             }
 
             foreach ($meses as $mes) {   
                 if($mesesIguais[$mes]){
                     $parent['data'][$mes] = $mesesAnt[$mes];
                 }
             }
             
             array_push($result,$parent);
 
 
         }
         // dd("result", $result);
         return $result ;
    }

    public function inserirDissidio(Request $request){

        $this->podeAcessar('inserir',true,$this->getCodTela());

        $all = $request->all();
        $retorno = $this->getRepository()->inserir($all['grades'], $all['orc_id'], $all['meses'], $all['periodo'], $all['tipo_table']);
        return $retorno['status']=='error'?$this->retornoJsonDefault($retorno,500):$retorno;
    }

    public function editarDissidio(Request $request){
        
        $this->podeAcessar('editar',true,$this->getCodTela());

        $all = $request->all();
        $all['updated_at'] = $this->fillModificadoEm();
        $all['updated_by'] = $this->obtIdUsuario();

        $retorno = $this->getRepository()->editar($all);
        return $retorno['status']=='error'?$this->retornoJsonDefault($retorno,500):$retorno;    
    }

    public function deleteDissidio(Request $request){

        $this->podeAcessar('deletar',true,$this->getCodTela());

        $all = $request->all();
        $retorno = $this->getRepository()->deletar($all);
        return $retorno['status']=='error'?$this->retornoJsonDefault($retorno,500):$retorno;    

    }

    public function deleteDissidioAll(Request $request){
        
        $this->podeAcessar('deletar',true,$this->getCodTela());

        $all = $request->all();
        $retorno = $this->getRepository()->deletarAll($all);
        return $retorno['status']=='error'?$this->retornoJsonDefault($retorno,500):$retorno;    

    }

    public function montarTreetable($data){
        // dd ('aaaaaaaaaaaaaaa',$data);
        $column_fixeds=[ 
            ["field_out"=>"grade_salarial", "from"=>"grade_salarial","render_value"=>null],
            ["field_out"=>"criado_por", "from"=>"criado_por","render_value"=>function($rowData,$value){
                return '-';
            }],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por","render_value"=>function($rowData,$value){
                return '-';
            }],

            ["field_out"=>"atualizado_data", "from"=>"updated_at","render_value"=>function($rowData,$value){
                return '-';
            }],
            ["field_out"=>"criado_data", "from"=>"created_at","render_value"=>function($rowData,$value){
                return '-';
            }],
        ];
        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null,],
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id", "render_value"=>null,],
            ["field_out"=>"id_calc_orc", "from"=>"id_calc_orc", "render_value"=>null,],

            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null,],
            ["field_out"=>"grade_salarial", "from"=>"grade_salarial","render_value"=>null],
            ["field_out"=>"description", "from"=>"description","render_value"=>null],

            ["field_out"=>"criado_por", "from"=>"criado_por"],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por"],

            ["field_out"=>"atualizado_data", "from"=>"updated_at","render_value"=>function($rowData,$value){
                return formataData($value);
            }],
            ["field_out"=>"criado_data", "from"=>"created_at","render_value"=>function($rowData,$value){
                return formataData($value);
            }],

            ["field_out"=>"jan_orcado", "from"=>"jan_orcado", "render_value"=>function($rowData,$value){
                return number_format($value,4,',', '.');
            }],
            ["field_out"=>"fev_orcado", "from"=>"fev_orcado", "render_value"=>function($rowData,$value){
                return number_format($value,4,',', '.');
            }],
            ["field_out"=>"mar_orcado", "from"=>"mar_orcado", "render_value"=>function($rowData,$value){
                return number_format($value,4,',', '.');
            }],
            ["field_out"=>"abr_orcado", "from"=>"abr_orcado", "render_value"=>function($rowData,$value){
                return number_format($value,4,',', '.');
            }],
            ["field_out"=>"mai_orcado", "from"=>"mai_orcado", "render_value"=>function($rowData,$value){
                return number_format($value,4,',', '.');
            }],
            ["field_out"=>"jun_orcado", "from"=>"jun_orcado", "render_value"=>function($rowData,$value){
                return number_format($value,4,',', '.');
            }],
            ["field_out"=>"jul_orcado", "from"=>"jul_orcado", "render_value"=>function($rowData,$value){
                return number_format($value,4,',', '.');
            }],
            ["field_out"=>"ago_orcado", "from"=>"ago_orcado", "render_value"=>function($rowData,$value){
                return number_format($value,4,',', '.');
            }],
            ["field_out"=>"set_orcado", "from"=>"set_orcado", "render_value"=>function($rowData,$value){
                return number_format($value,4,',', '.');
            }],
            ["field_out"=>"out_orcado", "from"=>"out_orcado", "render_value"=>function($rowData,$value){
                return number_format($value,4,',', '.');
            }],
            ["field_out"=>"nov_orcado", "from"=>"nov_orcado", "render_value"=>function($rowData,$value){
                return number_format($value,4,',', '.');
            }],
            ["field_out"=>"dez_orcado", "from"=>"dez_orcado", "render_value"=>function($rowData,$value){
                return number_format($value,4,',', '.');
            }]
        ];
        $settings=["columns"=>$column_fixeds,
        "keys"=>['grade_salarial'],
        "filter_data"=>['grade_salarial'=>function($value){
            return !is_null($value);
        }],                        
        "children"=>["columns"=>$column_fixeds_children,
                "keys"=>['id'],
                "filter_data"=>['id'=>function($value){
                    return !is_null($value);
                 }],
                'parent_filter'=> function($value, $parent_data){
                        return $value['grade_salarial'] == $parent_data['grade_salarial'] ;
                },
            ] 
        ];
        $controller=new AtmTreeTable($settings, $data);
        return $controller->render();
    }

    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        return parent::downloadExcel($type, 'AcordoColetivo',['orc_cargo_id', 'orcamento_id', 'id_calc_orc', 'cargo_id', 'cod_cargo_basic', 'des_cargo_basic', 'description', '']);
    }

    public function formatHeaders($colunas){
        for ($i=0; $i < count($colunas) ; $i++) { 
            
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);

            $colunas[$i] = str_replace("cargo", "Cargo", $colunas[$i]);
            $colunas[$i] = str_replace("grade salarial", "GS", $colunas[$i]);


                    $colunas[$i] = str_replace("jan orcado", "Janeiro", $colunas[$i]);
                    $colunas[$i] = str_replace("fev orcado", "Fevereiro", $colunas[$i]);
                    $colunas[$i] = str_replace("mar orcado", "Março", $colunas[$i]);
                    $colunas[$i] = str_replace("abr orcado", "Abril", $colunas[$i]);
                    $colunas[$i] = str_replace("mai orcado", "Maio", $colunas[$i]);
                    $colunas[$i] = str_replace("jun orcado", "Junho", $colunas[$i]);
                    $colunas[$i] = str_replace("jul orcado", "Julho", $colunas[$i]);
                    $colunas[$i] = str_replace("ago orcado", "Agosto", $colunas[$i]);
                    $colunas[$i] = str_replace("set orcado", "Setembro", $colunas[$i]);
                    $colunas[$i] = str_replace("out orcado", "Outubro", $colunas[$i]);
                    $colunas[$i] = str_replace("nov orcado", "Novembro", $colunas[$i]);
                    $colunas[$i] = str_replace("dez orcado", "Dezembro", $colunas[$i]);




        }
        return $colunas;
    }
}





 