<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcEventos;
use App\Modules\Natureza51\Repositories\RepoOrcScriptCalculos;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Entities\OrcEventos;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Empresa;
use App\Modules\Natureza51\Entities\ContaContabilVSEventos;
use App\Modules\Natureza51\Entities\ContaContabil;

use DB;

class OrcEventosController extends OrcamentoController
{
    
   public function __construct(){
        $this->repository=new RepoOrcEventos();
        $this->setCodTela('OCE');
        parent::__construct();
    }
//  ----------------------------------------------- EVENTOS -------------------------------------------------   
    public function listarAll($orc_id, $periodo = null, $tipo_table = 'O'){

        $this->podeAcessar('listar',true,$this->getCodTela());
        
        $result=$this->getRepository()->listarAll($orc_id, $periodo, $tipo_table);
        if($result===false){
            $retorno=$this->getArrayRetornoDefault(); 
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao carregar registros. Erro: 211220190944.';
            
            return $this->retornoJsonDefault($retorno);
        }
        
        return new Response(json_encode($this->renderTreeTable($result)));
    }

    public function updateAll(Request $request){

        $this->podeAcessar('editar',true,$this->getCodTela());

        $all = $request->all();
        
        // $meses=Arr::only($all,['jan_orcado','fev_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado',
        // 'ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);

        
        //dd(mesesValidacao(convertDecimalEn($meses)));
        // if(!mesesValidacao($meses)){
        //     $retorno['status']='error';
        //     $retorno['msg']='Os salários inseridos não podem diminuir ao longo dos meses.';
        //     $retorno['submsg']='Erro';
        //     goto saida;
        // }

        $a = $this->getRepository()->updateAll($all);
        if(!$a){
            $retorno['status']='error';
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            goto saida;
        }
 
        $retorno['status']='success';
        $retorno['msg']='Registro atualizado com sucesso!';

        saida:
        return $retorno;


    }

    public function deleteAll(Request $request){

        $this->podeAcessar('deletar',true,$this->getCodTela());

        $all = $request->all();
        
        $a = $this->getRepository()->deleteAll($all);
        if(!$a){
            $retorno['status']='error';
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            goto saida;
        }
 
        $retorno['status']='success';
        $retorno['msg']='Registro deletado com sucesso!';

        saida:
        return $retorno;
    }

    public function insertAll(Request $request){

        $this->podeAcessar('inserir',true,$this->getCodTela());

        $all = $request->all();
        /*$meses=Arr::only($all,['jan_orcado','fev_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado',
        'ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);*/

        // dd($meses);

        // if(!mesesValidacao(convertDecimalEn($meses))){
        //     $retorno['status']='error';
        //     $retorno['msg']='Os salários inseridos não podem diminuir ao longo dos meses.';
        //     $retorno['submsg']='Erro';
        //     goto saida;
        // }
        $a = $this->getRepository()->insertAll($all);
        if(!$a){
            $retorno['status']='error';
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            goto saida;
        }
 
        $retorno['status']='success';
        $retorno['msg']='Registro inserido com sucesso!';

        saida:
        return $retorno;



    }


    protected function renderTreeTable($dados){
        
        $columns_base=[ 
            ["field_out"=>"id", "from"=>"id"],
            ["field_out"=>"evento_id", "from"=>"evento_id"],
            ["field_out"=>"cdn_event", "from"=>"cdn_event"],
            ["field_out"=>"des_event", "from"=>"des_event"],
            ["field_out"=>"multiplica", "from"=>"multiplica","render_value"=>function($row_data, $value){
                return ($value * 100) - 100;
            }],

            ["field_out"=>"orcamento_id", "from"=>"orcamento_id"],
            ["field_out"=>"inc_liquido", "from"=>"inc_liquido", "render_value"=>null,],
            ["field_out"=>"impr_envel", "from"=>"impr_envel", "render_value"=>null,],
            ["field_out"=>"tipo_acesso", "from"=>"tipo_acesso", "render_value"=>null,],

            ["field_out"=>"criado_por", "from"=>"criado_por"],
            ["field_out"=>"criado_em", "from"=>"criado_em"],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por"],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em"],

            ["field_out"=>"jan_orcado", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],
            ["field_out"=>"fev_orcado", "from"=>"fev_orcado","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],
            ["field_out"=>"mar_orcado", "from"=>"mar_orcado","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
            ["field_out"=>"abr_orcado", "from"=>"abr_orcado","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }], 
            ["field_out"=>"mai_orcado", "from"=>"mai_orcado","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
            ["field_out"=>"jun_orcado", "from"=>"jun_orcado","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
            ["field_out"=>"jul_orcado", "from"=>"jul_orcado","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
            ["field_out"=>"ago_orcado", "from"=>"ago_orcado","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
            ["field_out"=>"set_orcado", "from"=>"set_orcado","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],    
            ["field_out"=>"out_orcado", "from"=>"out_orcado","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],    
            ["field_out"=>"nov_orcado", "from"=>"nov_orcado","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],    
            ["field_out"=>"dez_orcado", "from"=>"dez_orcado","render_value"=>function($row_data, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }]
        ];

         
         
        $settings=["columns"=>$columns_base,
                "keys"=>['id' ] 
            ];    
            
        $controller=new AtmTreeTable($settings, $dados);
        
      return $controller->render();
        
    }

    public function populaEvento($orc_id){

        $this->podeAcessar('atualizar',true,$this->getCodTela());

        if(! $this->getRepositoryOrModel()->populaEvento($orc_id)){             
            $retorno['msg']='Falha ao inserir o registro. Erro:030420201746';
            $retorno['status']='error';
            $retorno['submsg']='Falha ao inserir o registro. Erro:030420201746';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Atualizado com sucesso!";
        $retorno["submsg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $retorno;
       
    }
//  ----------------------------------------------- EVENTOS POR LOTAÇÃO E CARGO---------------------------------  

    // public function insertLotCargo(Request $request, $orc_id){
    //     $form_data = $request->all();
    //     $cargos_excessoes = $form_data['cargos_excessoes'];
    //     $cargos_excessoes_ids = array_column($cargos_excessoes, 'cargo_id');
    //     $lotacoes = $form_data['lotacoes'];
    //     $orc_lotacao_ids = array_column($lotacoes, 'id');
    //     $grades = $form_data['grades'];

    //     if(count($orc_lotacao_ids) == 0){ 
    //         $retorno["status"]="error";
    //         $retorno['msg'] = "Selecione as lotações para continuar.";
    //         $retorno['submsg']='Falha ao fazer insert do registro. Erro: 090620200945';
    //         goto saida;               
    //     }

    //     if(count($grades) == 0){ 
    //         $retorno["status"]="error";
    //         $retorno['msg'] = "Selecione os grades salariais para continuar.";
    //         $retorno['submsg']='Falha ao fazer insert do registro. Erro: 090620200946';
    //         goto saida;               
    //     }

    //     $lotacs = '';
    //     foreach ($orc_lotacao_ids as $orcs) {
    //         $lotacs = $lotacs . $orcs . ',';
    //     }
    //     $lotacs = substr($lotacs,0, strlen($lotacs)-1);

    //     $grades_condition = ``;
    //     foreach ($grades as $grade) {
    //         $grades_condition = $grades_condition . " c.cod_cargo_basic LIKE '$grade%' OR";
    //     }
    //     $grades_condition = substr($grades_condition,0, strlen($grades_condition)-2);

    //     if(count($cargos_excessoes_ids) > 0){
    //         $cargs_exc_condition = 'and c.id not in(';
    //         foreach ($cargos_excessoes_ids as $id) {
    //             $cargs_exc_condition = $cargs_exc_condition . $id . ',';
    //         }
    //         $cargs_exc_condition = substr($cargs_exc_condition,0, strlen($cargs_exc_condition)-1);
    //         $cargs_exc_condition = $cargs_exc_condition . ')';
    //     }
    //     else{
    //         $cargs_exc_condition = '';
    //     }
      
    //     $data = DB::select("
    //         select 
    //         oc.id as cargo_id,
    //         ocas.lotacao_id as lotacao_id
    //         from tbl_orc_cargos_area_sal  ocas
    //         inner join tbl_orc_cargo oc on oc.id = ocas.cargo_id
    //         inner join tbl_cargo c on c.id = oc.cargo_id
    //         where ocas.orcamento_id = $orc_id
    //         and ocas.lotacao_id in ($lotacs)
    //         $cargs_exc_condition
    //         and ($grades_condition)
    //     ");
    
    //     $data_insert = [];

    //     foreach ($data as $item) {            
    //         $data_compare = [  
    //             'orcamento_id'    =>$orc_id,
    //             'orc_cargo_id'  =>$item->cargo_id,
    //             'evento_id' => $item->evento_id,
    //             'lotacao_id' => $item->lotacao_id
    //         ];
    //         $existe = OrcEventos::where($data_compare)->get();
    //         if(count($existe) != 0){
    //             continue;
    //         }

    //         array_push($data_insert,$data_aux);
    //     }

    //     // dd("DADSADASD", $data_insert);
    //     dd("aqui");
    //     if(!OrcEventos::insert($data_insert)){ 
    //         $retorno["status"]="error";
    //         $retorno['msg'] = "Falha ao inserir evento";
    //         $retorno['submsg']='Falha ao fazer insert do registro. Erro: 090620200948';
    //         goto saida;               
    //     }
        
    //     $retorno["status"]="success";
    //     $retorno["msg"]="Registro inserido com sucesso!";
    //     saida:       
    
    //     return $this->retornoJsonDefault($retorno); 

    // }
    // public function updateLotCargo(Request $request,$orc_id){  
            
    //     $data = $request->all();
    //     unset($data['_token']);
    //     if(!$this->getRepository()->updateLotCargo($orc_id,$data)){                  
    //         $retorno["status"]="error";
    //         $retorno['msg'] = $this->getRepository()->getErrosFlatted();
    //         $retorno['submsg']='Falha ao fazer update do registro. Erro: 090620200950';
    //         goto saida;                
    //     }
        
    //     $retorno["status"]="success";
    //     $retorno["msg"]="Registro atualizado com sucesso!";
    //     saida:       
    
    //     return $this->retornoJsonDefault($retorno); 
    // }
    // public function deleteLotCargo(Request $request,$orc_id){  
            
    //     $data = $request->all();

    //     if(!$this->getRepository()->deleteLotCargo($orc_id,$data)){                  
    //         $retorno["status"]="error";
    //         $retorno['msg'] = $this->getRepository()->getErrosFlatted();
    //         $retorno['submsg']='Falha ao fazer delete do registro. Erro: 090620200951';
    //         goto saida;               
    //     }
        
    //     $retorno["status"]="success";
    //     $retorno["msg"]="Registro deletado com sucesso!";
    //     saida:       
    
    //     return $this->retornoJsonDefault($retorno); 
    // } 
    // public function deleteLotCargoSeveral(Request $request,$orc_id){  
                
    //     $data = $request->all(); 
    //     unset($data['_token']); 

    //     for($i=0; $i<count($data);$i++){
            
    //         if(!$this->getRepository()->deleteLotCargo($orc_id,$data[$i])){                  
    //             $retorno["status"]="error";
    //             $retorno['msg'] = $this->getRepository()->getErrosFlatted();
    //             $retorno['submsg']='Falha ao fazer delete do registro. Erro: 090620200957';
    //             goto saida;               
    //         }
    //     }

    //     $retorno["status"]="success";
    //     $retorno["msg"]="Registro deletado com sucesso!";
    //     saida:       

    //     return $this->retornoJsonDefault($retorno); 
    // }  
    // public function listarLotCargo($orc_id){
    //     $data = $this->getRepository()->listarLotCargo($orc_id);   
    //     $cont = count($data);
    //     for ($i=0; $i < $cont ; $i++) { 
    //         $data[$i] = (array) $data[$i];
    //         $data[(count($data))+$i] = array('parent'=>$data[$i]['grade_sal'],'grade_sal'=>null); 

    //     }

    //     return $this->montarTreetable($data);
    // }  
    // public function getCargoByGrade(Request $request, $orc_id){
    //     $all = $request->all();
    //     unset($all['_token']);

    //     $data = $this->repository->getCargoByGrade($all, $orc_id);
        

    //     for ($i=0; $i < count($all); $i++) { 
    //         $data[(count($data))+$i] = array('parent'=>$all[$i],'grade_salarial'=>null); 
    //     }
    //     return $this->montarTreetable($data);
    // }
    // public function getCargosExcessao(Request $request, $orc_id){
    //     $grades = $request->all()['grades'];
    //     $lotacoes = $request->all()['lotacoes'];
    //     $orc_lotacao_ids = array_column($lotacoes, 'id');
    //     $lotacs = '';
    //     foreach ($orc_lotacao_ids as $orcs) {
    //         $lotacs = $lotacs . $orcs . ',';
    //     }
    //     $lotacs = substr($lotacs,0, strlen($lotacs)-1);
    //     $grades_condition = ``;
    //     foreach ($grades as $grade) {
    //         $grades_condition = $grades_condition . " c.cod_cargo_basic LIKE '$grade%' OR";
    //     }
    //     $grades_condition = substr($grades_condition,0, strlen($grades_condition)-2);


    //     $data = DB::select("
    //     select DISTINCT(c.id) as cargo_id, c.des_cargo_basic, c.cod_cargo_basic 
    //     from tbl_orc_cargos_area_sal  ocas
    //     inner join tbl_orc_cargo oc on oc.id = ocas.cargo_id
    //     inner join tbl_cargo c on c.id = oc.cargo_id
    //     where ocas.orcamento_id = $orc_id
    //     and ocas.lotacao_id in ($lotacs)
    //     and ($grades_condition)
    //     ");

    //     return $data;
    // }
    // public function montarTreetable($data){

    //     $column_fixeds=[ 
    //         ["field_out"=>"parent", "from"=>"parent","render_value"=>null],
    //         ["field_out"=>"grade_sal", "from"=>"parent", "render_value"=>null,],
    //     ];
    //     $column_fixeds_children=[ 
    //         ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
    //         ["field_out"=>"cargo", "from"=>"cargo", "render_value"=>null,],
    //         ["field_out"=>"evento", "from"=>"evento", "render_value"=>null,],
    //         ["field_out"=>"grade_sal","from"=>"cod_cargo", "render_value"=>null,],
    //         ["field_out"=>"orc_lotacao_id","from"=>"orc_lotacao_id", "render_value"=>null,],
    //         ["field_out"=>"lotacao","from"=>"lotacao", "render_value"=>null,],
    //     ];


    //     $settings=["columns"=>$column_fixeds,
    //     "keys"=>['parent'],
    //     "filter_data"=>['grade_sal'=>function($value){
    //         return is_null($value);
    //     }],                        
    //     "children"=>["columns"=>$column_fixeds_children,
    //             "keys"=>['grade_sal','id'],
    //             "filter_data"=>['parent'=>function($value){
    //                 return is_null($value);
    //              }],
    //             'parent_filter'=> function($value, $parent_data){      
    //                     return $value['grade_sal']== $parent_data['parent'] ;
    //             },
    //         ] 
    //     ];

    //     $controller=new AtmTreeTable($settings, $data);
    //     return $controller->render();
    // }





    public function downloadExcel($type, $filename, $fieldsDeleteModel = []){
        // dd(json_decode($_POST['array_imprimir']));

  
        return parent::downloadExcel($type, 'Eventos', ['evento_id', 'des_event', 'cdn_event', 'multiplica','orcamento_id','impr_envel','criado_por','criado_em','atualizado_por','atualizado_em', 'inc_liquido']);
        // return parent::downloadExcel($type, 'Eventos', ['evento_id','multiplica','orcamento_id','impr_envel','criado_por','criado_em','atualizado_por','atualizado_em', 'inc_liquido']);
    }

    public function formatHeaders($colunas){ 
        for ($i=0; $i < count($colunas) ; $i++) { 
            $colunas[$i] = str_replace("_", " ", $colunas[$i]);
            $colunas[$i] = str_replace("descricao", "Evento", $colunas[$i]);
            $colunas[$i] = str_replace("des event", "Evento", $colunas[$i]);
            $colunas[$i] = str_replace("description evento", "Evento", $colunas[$i]);
            // $colunas[$i] = str_replace("inc liquido", "Incid. Sal. Liq.", $colunas[$i]);
            $colunas[$i] = str_replace("tipo acesso", "Acesso", $colunas[$i]);
            $colunas[$i] = str_replace("jan orcado", "Janeiro", $colunas[$i]);
            $colunas[$i] = str_replace("fev orcado", "Fevereiro", $colunas[$i]);
            $colunas[$i] = str_replace("mar orcado", "Março", $colunas[$i]);
            $colunas[$i] = str_replace("abr orcado", "Abril", $colunas[$i]);
            $colunas[$i] = str_replace("mai orcado", "Maio", $colunas[$i]);
            $colunas[$i] = str_replace("jun orcado", "Junho", $colunas[$i]);
            $colunas[$i] = str_replace("jul orcado", "Julho", $colunas[$i]);
            $colunas[$i] = str_replace("ago orcado", "Agosto", $colunas[$i]);
            $colunas[$i] = str_replace("set orcado", "Setembro", $colunas[$i]);
            $colunas[$i] = str_replace("out orcado", "Outubro", $colunas[$i]);
            $colunas[$i] = str_replace("nov orcado", "Novembro", $colunas[$i]);
            $colunas[$i] = str_replace("dez orcado", "Dezembro", $colunas[$i]);


        }
        return $colunas;
    }

    public function repopulateEvento(Request $request){
        $dados = $request->all();
        $orc_id = $dados['orc_id'];
        
        if($dados['tipo'] == 0){
            $resp = $this->getRepositoryOrModel()->atualizaOrcEvento($orc_id, $dados['periodo'], $dados['tipo_table']);
            if(!$resp){
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg'] = 'Erro';
                $retorno['status'] = 'error';
                goto saida;
            }
            if($resp === 'warning'){
                $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg'] = 'Atenção';
                $retorno['status'] = 'warning';
                goto saida;
            }
            $retorno['msg'] = $this->getRepositoryOrModel()->getErrosFlatted() == '' ? 'Registro(s) inserido(s) com sucesso!' : $retorno['msg'];
            $retorno['submsg'] = $this->getRepositoryOrModel()->getErrosFlatted() == '' ? 'Sucesso' : $retorno['submsg'];
            $retorno['status'] = $this->getRepositoryOrModel()->getErrosFlatted() == '' ? 'success' : $retorno['status'];
            goto saida;
        }
        
        // $repo_orc_eventos = new RepoOrcEventos();
        $repo_orc_scripts_calculos = new RepoOrcScriptCalculos();
        // $orc_eventos = new OrcEventos();
        // $orc_eventos = $this->getRepository()->getModelEntity();    
        // $eventos = new Eventos();   
        // $empresa = new Empresa();
        // $conta_contabil_vs_eventos = new ContaContabilVSEventos();
        // $conta_contabil = new ContaContabil();

        
        // $entities = [            
        //     'orcEventos' => ['instance' => $orc_eventos],
        //     'empresa' => ['instance' => $empresa],
        //     'contaContabilVSEventos' => ['instance' => $conta_contabil_vs_eventos],
        //     'contaContabil' => ['instance' => $conta_contabil],
        //     'eventos' => ['instance' => $eventos]            
        // ];
        
        // $data_evento = $orc_eventos->where('orcamento_id', $orc_id)->where('tipo_table', $dados['tipo_table'])->select('id');

        // if($dados['tipo_table'] == 'F'){
        //     $data_evento = $data_evento->where('periodo', $dados['periodo']);
        // }
        // $data_evento = $data_evento->get()->toArray();
        
        // $dados_orc_eventos = array_column($data_evento,'id');

        // $dados_orc_eventos = array_column($orc_eventos->where('orcamento_id', $orc_id)->select('id')->get()->toArray(),'id');

        // CalcOrcamento::where('tbl_origem', $orc_eventos->getTable())->whereIn('origem_id', $dados_orc_eventos)->delete();
        
        // CalcIndice::where('tbl_origem', $orc_beneficio->getTable())->whereIn('origem_id', $dados_orc_beneficio)->delete();       
       
        // $orc_eventos->whereIn('id', $dados_orc_eventos)->delete();
        if(!$repo_orc_scripts_calculos->populaOrcEventos(null, $orc_id, $dados['periodo'], $dados['tipo_table'])){
        // $orc_eventos->where('orcamento_id', $orc_id)->delete();
        // if(!$repo_orc_scripts_calculos->populaOrcEventos(null, $orc_id)){
            $retorno['msg']="Ocorreu uma falha ao repopular!";
            $retorno['submsg']='Falha ao inserir o registro. Erro:130720200953';
            $retorno['status']='error';
            goto saida;
        }

                
        $retorno["status"]="success";
        $retorno["msg"]="Tabelas repopuladas com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);  
    }
}
