<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcGestorAlternativo;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Http\Request;

class OrcGestorAlternativoController extends Natureza51Ctrl{
    
    public function __construct(){
        parent::__construct();
        $this->setCodTela('OGA');
        $this->repository = new RepoOrcGestorAlternativo();
    }
    public function listarAlternancia($orc_id, $periodo = null, $tipo_table = 'O'){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $resp = $this->repository->listar($orc_id, $periodo, $tipo_table);
        return $this->treeTable($resp);
    }
    public function inserir(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        $dados = $request->all();
        $resp = $this->repository->novoInserir($dados);

        // $resp = $this->repository->inserir($dados);
        $retorno = [];
        
        if(!$resp){
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg'] = 'Erro';
            $retorno['status'] = 'error';
            return $this->retornoJsonDefault($retorno);
        }
        else{
            $retorno['msg'] = 'Registro inserido com sucesso!';
            $retorno['submsg'] = 'Sucesso';
            $retorno['status'] = 'success';
            return $this->retornoJsonDefault($retorno);
        }
    }
    public function treeTable($dados){
        $colunas_pai = [ 
            ["field_out"=>"id", "from"=>"id"],
            ["field_out"=>"funcionario", "from"=>"funcionario"],
        ];

        $colunas_filhas = [
            ["field_out"=>"id", "from"=>"id"],
            
            ["field_out"=>"lotacao", "from"=>"lotacao"],

            ["field_out"=>"data_inicial_des", "from"=>"data_inicial_des"],
            ["field_out"=>"data_final_des", "from"=>"data_final_des"],

            ["field_out"=>"data_inicial", "from"=>"data_inicial"],
            ["field_out"=>"data_final", "from"=>"data_final"],

            ["field_out"=>"criado_por", "from"=>"criado_por"],
            ["field_out"=>"criado_em", "from"=>"criado_em"],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por"],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em"],

            ["field_out"=>"funcionario_id", "from"=>"funcionario_id"],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id"],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id"]

        ];
        $settings = [
            "columns" => $colunas_pai,
            "keys" => ['funcionario_id'],
            "children" => [
                "columns" => $colunas_filhas,
                "keys" => ['ccusto_id', 'lotacao_id', 'funcionario_id'],
                "filter_data" => [
                    'ccusto_id' => function ($value) {
                        return !is_null($value);
                    },
                    'lotacao_id' => function ($value) {
                        return !is_null($value);
                    },
                    'funcionario_id' => function ($value) {
                        return !is_null($value);
                    }
                ],
                'parent_filter' => function ($value, $parent_data) {
                    return $value['funcionario_id'] == $parent_data['funcionario_id'];
                }
            ]
        ];

        

        $controller = new AtmTreeTable($settings, $dados);
        return $controller->render();
    }
}