<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcLotCargoBeneficio as RepoOrcLotCargoBeneficio;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcLotacaoNaturezaEvento;
use Illuminate\Http\Request as Request;
use Illuminate\Http\Response;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
use Excel;

class OrcLotCargoBeneficioController extends OrcamentoController
{
    public function __construct(){
        $this->setRepository(new RepoOrcLotCargoBeneficio());
        $this->setCodTela('OBLC');
        parent::__construct();
    }
 
    public function inserirBeneficio(Request $request, $id) {

        $this->podeAcessar('inserir',true,$this->getCodTela());
        //dd("xfvx",$request->all(),$id);
        $form_data=$this->getRepositoryOrModel()->putOrcamentoIdOnData($request->all(),$id);
        
        // if($form_data['tipo_meses']==0){
        //     $retorno['status']='warning';
        //     $retorno['submsg']='Selecione um Tipo.';
        //     $retorno['msg']='Atenção';
        //     goto saida;
        // }
        // if(!mesesValidacao(convertDecimalEn($form_data['meses_orcado']))){
        //     $retorno['status']='error';
        //     $retorno['msg']='Os salários inseridos não podem diminuir ao longo dos meses.';
        //     $retorno['submsg']='Os salários inseridos não podem diminuir ao longo dos meses. Erro: 200320201455';
        //     goto saida;
        // }
        
        if(! $this->getRepositoryOrModel()->createOrclotCargoBeneficio($form_data, $id)){
            $retorno['status']='error';
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro:301120191630';
            goto saida;
        }
        

        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);        
    }    

    public function valoresMedios(Request $request, $orc_id, $periodo = null, $tipo_table = 'O'){
        $dados = $request->all();
        $where[0] = $tipo_table == "F" ? " and orf.tipo_table = '{$tipo_table}' and orf.periodo = '{$periodo}' " : " and orf.tipo_table = '{$tipo_table}' ";
        $where[1] = $tipo_table == "F" ? " and obf.tipo_table = '{$tipo_table}' and obf.periodo = '{$periodo}' " : " and obf.tipo_table = '{$tipo_table}' ";
        
        $select = DB::select("SELECT 
                ISNULL(AVG(obf.vlr_movto), 0) 'vlr_movto',
                ISNULL(AVG(co.jan_orcado), 0) jan_orcado,
                ISNULL(AVG(co.fev_orcado), 0) fev_orcado,
                ISNULL(AVG(co.mar_orcado), 0) mar_orcado,
                ISNULL(AVG(co.abr_orcado), 0) abr_orcado,
                ISNULL(AVG(co.mai_orcado), 0) mai_orcado,
                ISNULL(AVG(co.jun_orcado), 0) jun_orcado,
                ISNULL(AVG(co.jul_orcado), 0) jul_orcado,
                ISNULL(AVG(co.ago_orcado), 0) ago_orcado,
                ISNULL(AVG(co.set_orcado), 0) set_orcado,
                ISNULL(AVG(co.out_orcado), 0) out_orcado,
                ISNULL(AVG(co.nov_orcado), 0) nov_orcado,
                ISNULL(AVG(co.dez_orcado), 0) dez_orcado
            from tbl_orc_beneficio_funcionario obf

            join tbl_orc_funcionario orf on orf.funcionario_id = obf.funcionario_id and orf.orcamento_id = obf.orcamento_id {$where[0]}
            join tbl_orc_cargo as oc on oc.id = orf.orc_cargo_id
            join tbl_cargo as c on c.id = oc.cargo_id

            join tbl_calc_orcamento co on co.origem_id = obf.id and co.tbl_origem = 'tbl_orc_beneficio_funcionario'
            join tbl_orc_benef_lot_carg as oblc on oblc.orc_cargo_id = orf.orc_cargo_id and oblc.orc_lotacao_id = obf.orc_lotacao_id and oblc.orc_beneficio_id = obf.orc_beneficio_id

            where obf.orcamento_id = $orc_id and obf.orc_lotacao_id = {$dados['orc_lotacao_id']} and obf.orc_beneficio_id = {$dados['orc_beneficio_id']}
            and c.id = {$dados['orc_cargo_id']} {$where[1]}
        ");

        $dados_ben = DB::select("SELECT * from tbl_orc_beneficio where id = {$dados['orc_beneficio_id']}");
        if($dados_ben[0]->tipo_acesso != 3){
            $zero[0] = array(
                'vlr_movto' => 0, 'jan_orcado' => 0, 'fev_orcado' => 0, 'mar_orcado' => 0, 'abr_orcado' => 0,
                'mai_orcado' => 0, 'jun_orcado' => 0, 'jul_orcado' => 0, 'ago_orcado' => 0,
                'set_orcado' => 0, 'out_orcado' => 0, 'nov_orcado' => 0, 'dez_orcado' => 0
            );
            
            return $zero;
        }

        if(count($select) > 0 && $select[0]->jan_orcado == 0){
            $select = DB::select("SELECT 
                    ISNULL(AVG(obf.vlr_movto), 0) 'vlr_movto',
                    ISNULL(AVG(co.jan_orcado), 0) jan_orcado,
                    ISNULL(AVG(co.fev_orcado), 0) fev_orcado,
                    ISNULL(AVG(co.mar_orcado), 0) mar_orcado,
                    ISNULL(AVG(co.abr_orcado), 0) abr_orcado,
                    ISNULL(AVG(co.mai_orcado), 0) mai_orcado,
                    ISNULL(AVG(co.jun_orcado), 0) jun_orcado,
                    ISNULL(AVG(co.jul_orcado), 0) jul_orcado,
                    ISNULL(AVG(co.ago_orcado), 0) ago_orcado,
                    ISNULL(AVG(co.set_orcado), 0) set_orcado,
                    ISNULL(AVG(co.out_orcado), 0) out_orcado,
                    ISNULL(AVG(co.nov_orcado), 0) nov_orcado,
                    ISNULL(AVG(co.dez_orcado), 0) dez_orcado
                from tbl_orc_beneficio_funcionario obf

                join tbl_orc_funcionario orf on orf.funcionario_id = obf.funcionario_id and orf.orcamento_id = obf.orcamento_id {$where[0]}
                join tbl_orc_cargo as oc on oc.id = orf.orc_cargo_id
                join tbl_cargo as c on c.id = oc.cargo_id

                join tbl_calc_orcamento co on co.origem_id = obf.id and co.tbl_origem = 'tbl_orc_beneficio_funcionario'
                join tbl_orc_benef_lot_carg as oblc on oblc.orc_cargo_id = orf.orc_cargo_id and oblc.orc_lotacao_id = obf.orc_lotacao_id and oblc.orc_beneficio_id = obf.orc_beneficio_id

                where obf.orcamento_id = $orc_id /*and obf.orc_lotacao_id = {$dados['orc_lotacao_id']}*/ and obf.orc_beneficio_id = {$dados['orc_beneficio_id']}
                and c.id = {$dados['orc_cargo_id']} {$where[1]}
                
            ");

            if(count($select) > 0 && $select[0]->jan_orcado == 0){
                $select = DB::select("SELECT 
                        ISNULL(AVG(ob.vlr_movto), 0) 'vlr_movto',
                        ISNULL(AVG(co.jan_orcado), 0) jan_orcado,
                        ISNULL(AVG(co.fev_orcado), 0) fev_orcado,
                        ISNULL(AVG(co.mar_orcado), 0) mar_orcado,
                        ISNULL(AVG(co.abr_orcado), 0) abr_orcado,
                        ISNULL(AVG(co.mai_orcado), 0) mai_orcado,
                        ISNULL(AVG(co.jun_orcado), 0) jun_orcado,
                        ISNULL(AVG(co.jul_orcado), 0) jul_orcado,
                        ISNULL(AVG(co.ago_orcado), 0) ago_orcado,
                        ISNULL(AVG(co.set_orcado), 0) set_orcado,
                        ISNULL(AVG(co.out_orcado), 0) out_orcado,
                        ISNULL(AVG(co.nov_orcado), 0) nov_orcado,
                        ISNULL(AVG(co.dez_orcado), 0) dez_orcado
                    from tbl_orc_beneficio ob
                    
                    -- join tbl_orc_funcionario orf on orf.funcionario_id = obf.funcionario_id and orf.orcamento_id = obf.orcamento_id
                    -- join tbl_calc_orcamento co on co.origem_id = obf.id and co.tbl_origem = 'tbl_orc_beneficio_funcionario'
                    -- join tbl_orc_benef_lot_carg as oblc on oblc.orc_cargo_id = orf.orc_cargo_id and oblc.orc_lotacao_id = obf.orc_lotacao_id and oblc.orc_beneficio_id = obf.orc_beneficio_id
                    
                    join tbl_calc_orcamento co on co.origem_id = ob.id and co.tbl_origem = 'tbl_orc_beneficio'
                    where ob.orcamento_id = {$orc_id} and ob.id = {$dados['orc_beneficio_id']}
                    
                ");
            }
        }

        return $select;
        
    }
    public function list($orcamento_id, $periodo = null, $tipo_table = 'O'){

        $this->podeAcessar('listar',true,$this->getCodTela());

       $form_data = [
        'orcamento_id'=> $orcamento_id
       ];
       //dd("listar",$this->getRepositoryOrModel()->listar($form_data));
       $dados=$this->getRepositoryOrModel()->listar($form_data, $periodo, $tipo_table);
       //dd($this->renderTreeTableList($dados));
       return $this->renderTreeTableList($dados);
    } 

    public function listarIndices($orc_id, $periodo = null, $tipo_table = 'O'){

        $this->podeAcessar('listar',true,$this->getCodTela());

        $dados = $this->getRepositoryOrModel()->listarCargoBeneficioIndice($orc_id, $periodo, $tipo_table);
        //dd($this->treeTableIndice($dados));
        return $this->treeTableIndice($dados);
    }

    public function listEvent(){

        $this->podeAcessar('listar',true,$this->getCodTela());

        return $this->getRepositoryOrModel()->listaEventos();
    }
    
    public function deletar(Request $request, $id) {
        
        $this->podeAcessar('deletar',true,$this->getCodTela());

        $form_data=$request->all();
        
        if($form_data['identificador']==1){
            if(!$this->getRepositoryOrModel()->deleteIndice($form_data)){
                $retorno['status']='error';
                $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg']='Falha ao deletar o registro. Erro:141220191400';
                goto saida;
            }
        }
        else{
            if(! $this->getRepositoryOrModel()->deleteOrclotCargoBeneficio($form_data)){
                $retorno['status']='error';
                $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg']='Falha ao deletar o registro. Erro:141220191400';
                goto saida;
            }
        }

        
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);      
        
    }

    public function updateOrcLotCargoBenef(Request $request, $id) {
        
        $this->podeAcessar('editar',true,$this->getCodTela());

        $form_data = $request->all();

        /* $meses=Arr::only($form_data,['jan_orcado','fev_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado',
        'ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);*/

        // $meses_indice = Arr::only($form_data,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice','jul_indice','agost_indice','set_indice','out_indice','nov_indice','dez_indice']);        

        if($form_data['identificador']==1){
            // if(!validacaoIndice(convertDecimalEn($meses_indice))){
            //     $retorno['status']='error';
            //     $retorno['msg']='Os índices inseridos não podem diminuir ao longo dos meses.';
            //     $retorno['submsg']='Os índices inseridos não podem diminuir ao longo dos meses. Erro: 060420201221';
            //     goto saida;
            // }
            // else{
                if(!$this->getRepositoryOrModel()->updateIndice($form_data)){
                    $retorno['status']='error';
                    $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                    $retorno['submsg']='Falha ao deletar o registro. Erro:060420200940';
                    goto saida;
                }
            // }
        }
        else{
            // if(!mesesValidacao(convertDecimalEn($meses))){
            //     $retorno['status']='error';
            //     $retorno['msg']='Os salários inseridos não podem diminuir ao longo dos meses.';
            //     $retorno['submsg']='Os salários inseridos não podem diminuir ao longo dos meses. Erro: 200320201455';
            //     goto saida;
            // }
            // else{
                if(! $this->getRepositoryOrModel()->updateOrcLotCargoBeneficio($form_data)){
                    $retorno['status']='error';
                    $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                    $retorno['submsg']='Falha ao atualizar o registro. Erro:161220191635';
                    goto saida;
                }
            // }
        }
        
        
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);      
        
    }

    

    function renderTreeTableList($dados){
        //dd($dados);
        $columns_base = [ 
            ["field_out"=>"id", "from"=>"id"],
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id"],
            ["field_out"=>"orc_lotacao_id", "from"=>"orc_lotacao_id"],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id"], 
            ["field_out"=>"orc_beneficio_id", "from"=>"orc_beneficio_id"], 
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id"], 
            ["field_out"=>"tipo_calc", "from"=>"tipo_calc"], 
            ["field_out"=>"vlr_movto", "from"=>"vlr_movto","render_value"=>function($rowData, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }], 
            ["field_out"=>"vlr_depend", "from"=>"vlr_depend"], 
            ["field_out"=>"formula", "from"=>"formula"], 
            ["field_out"=>"origem_id", "from"=>"origem_id"], 
            ["field_out"=>"tbl_origem", "from"=>"tbl_origem"], 
            ["field_out"=>"des_unid_lotac", "from"=>"des_unid_lotac"], 
            ["field_out"=>"event_id", "from"=>"event_id"],
            ["field_out"=>"cdn_event", "from"=>"cdn_event"],
            ["field_out"=>"des_event", "from"=>"des_event"],
            ["field_out"=>"cargo_id", "from"=>"cargo_id"],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic"],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic"],

            ["field_out"=>"description_lotacao", "from"=>"description_lotacao"],
            ["field_out"=>"description_cargo", "from"=>"description_cargo"],
            ["field_out"=>"description_beneficio", "from"=>"description_beneficio"],

            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto"],
            ["field_out"=>"des_ccusto", "from"=>"des_ccusto"],
            ["field_out"=>"identificador", "from"=>"identificador"],
            ["field_out"=>"calc_id", "from"=>"calc_id"],

            ["field_out"=>"description_cta_ctb", "from"=>"description_cta_ctb"],
            ["field_out"=>"cod_cta_ctbl", "from"=>"cod_cta_ctbl"],
            ["field_out"=>"desc_cta_ctbl", "from"=>"desc_cta_ctbl"],

            ["field_out"=>"criado_por", "from"=>"criado_por"],
            ["field_out"=>"criado_em", "from"=>"criado_em"],
            ["field_out"=>"atualizado_por", "from"=>"atualizado_por"],
            ["field_out"=>"atualizado_em", "from"=>"atualizado_em"],

            ["field_out"=>"vlr_maximo", "from"=>"vlr_maximo","render_value"=>function($rowData, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],
            ["field_out"=>"des_tipo_calc", "from"=>"des_tipo_calc"],


            ["field_out"=>"jan_orcado", "from"=>"jan_orcado","render_value"=>function($rowData, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],
            ["field_out"=>"fev_orcado", "from"=>"fev_orcado","render_value"=>function($rowData, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],
            ["field_out"=>"mar_orcado", "from"=>"mar_orcado","render_value"=>function($rowData, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
            ["field_out"=>"abr_orcado", "from"=>"abr_orcado","render_value"=>function($rowData, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }], 
            ["field_out"=>"mai_orcado", "from"=>"mai_orcado","render_value"=>function($rowData, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
            ["field_out"=>"jun_orcado", "from"=>"jun_orcado","render_value"=>function($rowData, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
            ["field_out"=>"jul_orcado", "from"=>"jul_orcado","render_value"=>function($rowData, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
            ["field_out"=>"ago_orcado", "from"=>"ago_orcado","render_value"=>function($rowData, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],     
            ["field_out"=>"set_orcado", "from"=>"set_orcado","render_value"=>function($rowData, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],    
            ["field_out"=>"out_orcado", "from"=>"out_orcado","render_value"=>function($rowData, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],    
            ["field_out"=>"nov_orcado", "from"=>"nov_orcado","render_value"=>function($rowData, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }],    
            ["field_out"=>"dez_orcado", "from"=>"dez_orcado","render_value"=>function($rowData, $value){
                return formataMonetarioQuatro( number_format($value,6,',', '.') );
            }]
       ];
        
        
       $settings=["columns"=>$columns_base,
               "keys"=>['origem_id'] 
           ];    
           
       $controller=new AtmTreeTable($settings, $dados);
       
     return $controller->render();
   }

   function treeTableIndice($dados){
    //dd($dados);
    $columns_base=[ 
        ["field_out"=>"id", "from"=>"id"],
        ["field_out"=>"orcamento_id", "from"=>"orcamento_id"],
        ["field_out"=>"orc_lotacao_id", "from"=>"orc_lotacao_id"],
        ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id"], 
        ["field_out"=>"orc_beneficio_id", "from"=>"orc_beneficio_id"], 
        ["field_out"=>"description", "from"=>"description"], 
        ["field_out"=>"ccusto_id", "from"=>"ccusto_id"], 
        ["field_out"=>"tipo_calc", "from"=>"tipo_calc"], 
        ["field_out"=>"vlr_movto", "from"=>"vlr_movto","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }], 
        ["field_out"=>"vlr_depend", "from"=>"vlr_depend"], 
        ["field_out"=>"formula", "from"=>"formula"], 
        ["field_out"=>"origem_id", "from"=>"origem_id"], 
        ["field_out"=>"tbl_origem", "from"=>"tbl_origem"], 
        ["field_out"=>"des_unid_lotac", "from"=>"des_unid_lotac"], 
        ["field_out"=>"event_id", "from"=>"event_id"],
        ["field_out"=>"cdn_event", "from"=>"cdn_event"],
        ["field_out"=>"des_event", "from"=>"des_event"],
        ["field_out"=>"cargo_id", "from"=>"cargo_id"],
        ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic"],
        ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic"],
        ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto"],
        ["field_out"=>"des_ccusto", "from"=>"des_ccusto"],
        ["field_out"=>"identificador", "from"=>"identificador"],
        ["field_out"=>"calc_indice_id", "from"=>"calc_indice_id"],
        ["field_out"=>"description_cta_ctb", "from"=>"description_cta_ctb"],
        ["field_out"=>"cod_cta_ctbl", "from"=>"cod_cta_ctbl"],
        ["field_out"=>"desc_cta_ctbl", "from"=>"desc_cta_ctbl"],

        ["field_out"=>"description_lotacao", "from"=>"description_lotacao"],
        ["field_out"=>"description_cargo", "from"=>"description_cargo"],
        ["field_out"=>"description_beneficio", "from"=>"description_beneficio"],

        ["field_out"=>"criado_por", "from"=>"criado_por"],
        ["field_out"=>"criado_em", "from"=>"criado_em"],
        ["field_out"=>"atualizado_por", "from"=>"atualizado_por"],
        ["field_out"=>"atualizado_em", "from"=>"atualizado_em"],

        ["field_out"=>"vlr_maximo", "from"=>"vlr_maximo","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],
        ["field_out"=>"des_tipo_calc", "from"=>"des_tipo_calc"],


        ["field_out"=>"jan_indice", "from"=>"jan_indice","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],
           ["field_out"=>"fev_indice", "from"=>"fev_indice","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],
           ["field_out"=>"marc_indice", "from"=>"marc_indice","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],     
           ["field_out"=>"abril_indice", "from"=>"abril_indice","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }], 
           ["field_out"=>"maio_indice", "from"=>"maio_indice","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],     
           ["field_out"=>"jun_indice", "from"=>"jun_indice","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],     
           ["field_out"=>"jul_indice", "from"=>"jul_indice","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],     
           ["field_out"=>"agost_indice", "from"=>"agost_indice","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],     
           ["field_out"=>"set_indice", "from"=>"set_indice","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],    
           ["field_out"=>"out_indice", "from"=>"out_indice","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],    
           ["field_out"=>"nov_indice", "from"=>"nov_indice","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }],    
           ["field_out"=>"dez_indice", "from"=>"dez_indice","render_value"=>function($row_data, $value){
            return formataMonetarioQuatro( number_format($value,6,',', '.') );
        }]
   ];
    
    
   $settings=["columns"=>$columns_base,
           "keys"=>['id'] 
       ];    
       
   $controller=new AtmTreeTable($settings, $dados);
   
 return $controller->render();
}

public function downloadExcelBeneficioLotCargoAbsoluto($type, $orc_id, $fieldsDeleteModel = []){
    $form_data = [
        'orcamento_id'=> $orc_id
    ];
    $this->dados = $this->getRepositoryOrModel()->listar($form_data);
    return parent::downloadExcel($type, 'BeneficioLotCargoAbsoluto',['tbl_origem','des_unid_lotac','event_id','cdn_event','cargo_id','tipo_calc','cod_cargo_basic','des_cargo_basic','ccusto_id','cod_ccusto','des_ccusto','criado_por','criado_em','atualizado_por','atualizado_em','identificador','origem_id','calc_id','orcamento_id','id','orc_lotacao_id','orc_cargo_id','orc_beneficio_id','formula','cod_cta_ctbl','desc_cta_ctbl','cta_ctb_id','valor_deducao','I_sec','responde_orc','cc_custo_id','status','hc_iniciado','has_error_calc','des_event','calc_indice_id','responder_orc', 'des_cta_ctbl','vrl_depend','vlr_depend','description']);
}  



public function downloadExcelBeneficioLotCargoIndice($type, $orc_id, $fieldsDeleteModel = []){
       
    $this->dados = $this->getRepositoryOrModel()->listarCargoBeneficioIndice($orc_id);
    return parent::downloadExcel($type, 'BeneficioLotCargoIndice',['des_event','des_unid_lotac','desc_cta_ctbl','calc_indice_id','identificador','origem_id','orc_lotacao_id', 'orc_cargo_id','orc_beneficio_id', 'cod_cargo_basic','des_cargo_basic', 'ccusto_id','event_id', 'cdn_event', 'cargo_id', 'cod_cta_ctbl', 'des_cta_ctbl', 'formula','vrl_depend','tipo_calc','tbl_origem','vlr_depend','description','orcamento_id','cod_ccusto','des_ccusto','id','criado_por','criado_em','atualizado_em','atualizado_por']);
}

public function formatHeaders($colunas){ 
    for ($i=0; $i < count($colunas) ; $i++) { 
//         dd(json_decode($_POST['array_imprimir']));
        $colunas[$i] = str_replace("_", " ", $colunas[$i]);
        $colunas[$i] = str_replace("description cta ctb", "Conta contábil", $colunas[$i]);
        //$colunas[$i] = str_replace("des event", "Evento", $colunas[$i]);
        $colunas[$i] = str_replace("vlr maximo", "Valor máximo", $colunas[$i]);
        $colunas[$i] = str_replace("vlr movto", "Valor Movimento", $colunas[$i]);
        $colunas[$i] = str_replace("des tipo acesso", "Tipo acesso", $colunas[$i]);
        $colunas[$i] = str_replace("des tipo calc", "Tipo cálculo", $colunas[$i]);
        //$colunas[$i] = str_replace("cod cargo basic", "Cód. Cargo", $colunas[$i]);

        //$colunas[$i] = str_replace("des cargo basic", "Cargo", $colunas[$i]);
        $colunas[$i] = str_replace("description lotacao", "Lotação", $colunas[$i]);
        $colunas[$i] = str_replace("description beneficio", "Benefício", $colunas[$i]);
        $colunas[$i] = str_replace("description cargo", "Cargo", $colunas[$i]);


        $colunas[$i] = str_replace("jan orcado", "Janeiro", $colunas[$i]);
        $colunas[$i] = str_replace("fev orcado", "Fevereiro", $colunas[$i]);
        $colunas[$i] = str_replace("mar orcado", "Março", $colunas[$i]);
        $colunas[$i] = str_replace("abr orcado", "Abril", $colunas[$i]);
        $colunas[$i] = str_replace("mai orcado", "Maio", $colunas[$i]);
        $colunas[$i] = str_replace("jun orcado", "Junho", $colunas[$i]);
        $colunas[$i] = str_replace("jul orcado", "Julho", $colunas[$i]);
        $colunas[$i] = str_replace("ago orcado", "Agosto", $colunas[$i]);
        $colunas[$i] = str_replace("set orcado", "Setembro", $colunas[$i]);
        $colunas[$i] = str_replace("out orcado", "Outubro", $colunas[$i]);
        $colunas[$i] = str_replace("nov orcado", "Novembro", $colunas[$i]);
        $colunas[$i] = str_replace("dez orcado", "Dezembro", $colunas[$i]);

        $colunas[$i] = str_replace("jan indice", "Janeiro", $colunas[$i]);
        $colunas[$i] = str_replace("fev indice", "Fevereiro", $colunas[$i]);
        $colunas[$i] = str_replace("marc indice", "Março", $colunas[$i]);
        $colunas[$i] = str_replace("abril indice", "Abril", $colunas[$i]);
        $colunas[$i] = str_replace("maio indice", "Maio", $colunas[$i]);
        $colunas[$i] = str_replace("jun indice", "Junho", $colunas[$i]);
        $colunas[$i] = str_replace("jul indice", "Julho", $colunas[$i]);
        $colunas[$i] = str_replace("agost indice", "Agosto", $colunas[$i]);
        $colunas[$i] = str_replace("set indice", "Setembro", $colunas[$i]);
        $colunas[$i] = str_replace("out indice", "Outubro", $colunas[$i]);
        $colunas[$i] = str_replace("nov indice", "Novembro", $colunas[$i]);
        $colunas[$i] = str_replace("dez indice", "Dezembro", $colunas[$i]);


    }
    return $colunas;
}

}